/*
 * Decompiled with CFR 0.152.
 */
package test;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class BulkModeTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void bulkMode_rfe10303() throws Exception {
        junit.framework.Assert.assertFalse((String)"expected bulkMode false", (boolean)this.repo.isBulkMode());
        junit.framework.Assert.assertTrue((String)"expected autoCommit true", (boolean)this.conn.isAutoCommit());
        this.repo.setBulkMode(true);
        junit.framework.Assert.assertTrue((String)"expected autoCommit true", (boolean)this.conn.isAutoCommit());
        junit.framework.Assert.assertTrue((String)"expected bulkMode true", (boolean)this.repo.isBulkMode());
        String path1 = "/tutorial/java-vcards.rdf";
        IRI context = this.vf.createIRI("http://example.org#vcards");
        Util.add((RepositoryConnection)this.conn, path1, null, RDFFormat.RDFXML, new Resource[]{context});
        Assert.assertEquals((String)"expected 16 vcard triples", (long)16L, (long)this.conn.size(new Resource[]{context}));
        this.conn.setAutoCommit(false);
        junit.framework.Assert.assertFalse((String)"expected autoCommit false", (boolean)this.conn.isAutoCommit());
        junit.framework.Assert.assertTrue((String)"expected bulkMode true", (boolean)this.repo.isBulkMode());
        String path2 = "/tutorial/java-kennedy.ntriples";
        Util.add((RepositoryConnection)this.conn, path2, null, RDFFormat.NTRIPLES, new Resource[0]);
        Assert.assertEquals((String)"expected 1214 kennedy triples", (long)1214L, (long)this.conn.size(new Resource[]{null}));
        Assert.assertEquals((String)"expected 1230 total triples", (long)1230L, (long)this.conn.size(new Resource[0]));
        this.conn.rollback();
        Assert.assertEquals((String)"expected 0 kennedy triples", (long)0L, (long)this.conn.size(new Resource[]{null}));
        Assert.assertEquals((String)"expected 16 total triples", (long)16L, (long)this.conn.size(new Resource[0]));
    }
}

