/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGTupleQuery;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.AGAbstractTest;
import test.Util;

public class DownloadTest
extends AGAbstractTest {
    private static final String NS = "rm://";
    private static final String TEXT = "gazorpazorp";
    private AGRepositoryConnection conn;
    private File output;
    private String id;
    private AGQuery genericQuery;
    private AGTupleQuery tupleQuery;
    private AGGraphQuery graphQuery;
    private AGBooleanQuery boolQuery;

    @Before
    public void prepare() throws Exception {
        this.conn = this.getConnection();
        URI uri = this.conn.getValueFactory().createURI(NS, TEXT);
        this.conn.add((Resource)uri, uri, (Value)uri, new Resource[0]);
        this.id = Util.getStatementId(this.conn, (Resource)uri, uri, (Value)uri);
        this.genericQuery = (AGQuery)this.conn.prepareQuery(QueryLanguage.SPARQL, "select * { ?s ?p ?o }");
        this.tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "select * { ?s ?p ?o}");
        this.graphQuery = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, "construct { ?s ?p ?o } where { ?s ?p ?o }");
        this.boolQuery = this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK { ?s ?p ?o }");
        this.output = File.createTempFile("java-download-test", ".xyz");
        this.output.deleteOnExit();
    }

    @Test
    public void testDownloadStatementsDefaultFormat() throws Exception {
        this.conn.downloadStatements(this.output, null, null, null, false, new Resource[0]);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsRDFFormat() throws Exception {
        this.conn.downloadStatements(this.output, RDFFormat.RDFXML, null, null, null, false, new Resource[0]);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsMIMEType() throws Exception {
        this.conn.downloadStatements(this.output, RDFFormat.RDFXML.getDefaultMIMEType(), null, null, null, false, new Resource[0]);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsStrDefaultFormat() throws Exception {
        this.conn.downloadStatements(this.output.getAbsolutePath(), null, null, null, false, new Resource[0]);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsStrRDFFormat() throws Exception {
        this.conn.downloadStatements(this.output.getAbsolutePath(), RDFFormat.RDFXML, null, null, null, false, new Resource[0]);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsStrMIMEType() throws Exception {
        this.conn.downloadStatements(this.output.getAbsolutePath(), RDFFormat.RDFXML.getDefaultMIMEType(), null, null, null, false, new Resource[0]);
        this.checkOutput();
    }

    @Test
    public void testStreamStatementsDefaultFormat() throws Exception {
        InputStream stream = this.conn.streamStatements(null, null, null, false, new Resource[0]);
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testStreamStatementsRDFFormat() throws Exception {
        InputStream stream = this.conn.streamStatements(RDFFormat.RDFXML, null, null, null, false, new Resource[0]);
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testStreamStatementsMIMEType() throws Exception {
        InputStream stream = this.conn.streamStatements(RDFFormat.RDFXML.getDefaultMIMEType(), null, null, null, false, new Resource[0]);
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsByIDRDFFormat() throws Exception {
        this.conn.downloadStatements(this.output, RDFFormat.RDFXML, this.id);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsByIDMIMEType() throws Exception {
        this.conn.downloadStatements(this.output, RDFFormat.RDFXML.getDefaultMIMEType(), this.id);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsByIDStrRDFFormat() throws Exception {
        this.conn.downloadStatements(this.output.getAbsolutePath(), RDFFormat.RDFXML, this.id);
        this.checkOutput();
    }

    @Test
    public void testDownloadStatementsByIDStrMIMEType() throws Exception {
        this.conn.downloadStatements(this.output.getAbsolutePath(), RDFFormat.RDFXML.getDefaultMIMEType(), this.id);
        this.checkOutput();
    }

    @Test
    public void testStreamStatementsByIdRDFFormat() throws Exception {
        InputStream stream = this.conn.streamStatements(RDFFormat.RDFXML, new String[]{this.id});
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testStreamStatementsByIdMIMEType() throws Exception {
        InputStream stream = this.conn.streamStatements(RDFFormat.RDFXML.getDefaultMIMEType(), new String[]{this.id});
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testQueryDownload() throws Exception {
        this.genericQuery.download(this.output);
        this.checkOutput();
    }

    @Test
    public void testQueryDownloadStr() throws Exception {
        this.genericQuery.download(this.output.getAbsolutePath());
        this.checkOutput();
    }

    @Test
    public void testQueryDownloadMIMEType() throws Exception {
        this.genericQuery.download(this.output, TupleQueryResultFormat.CSV.getDefaultMIMEType());
        this.checkOutput();
    }

    @Test
    public void testQueryDownloadStrMIMEType() throws Exception {
        this.genericQuery.download(this.output.getAbsolutePath(), TupleQueryResultFormat.CSV.getDefaultMIMEType());
        this.checkOutput();
    }

    @Test
    public void testQueryStream() throws Exception {
        InputStream stream = this.genericQuery.stream();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testQueryStreamMIMEType() throws Exception {
        InputStream stream = this.genericQuery.stream(TupleQueryResultFormat.JSON.getDefaultMIMEType());
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testTupleQueryDownload() throws Exception {
        this.tupleQuery.download(this.output);
        this.checkOutput();
    }

    @Test
    public void testTupleQueryDownloadStr() throws Exception {
        this.tupleQuery.download(this.output.getAbsolutePath());
        this.checkOutput();
    }

    @Test
    public void testTupleQueryDownloadFormat() throws Exception {
        this.tupleQuery.download(this.output, TupleQueryResultFormat.CSV);
        this.checkOutput();
    }

    @Test
    public void testTupleQueryDownloadStrFormat() throws Exception {
        this.tupleQuery.download(this.output.getAbsolutePath(), TupleQueryResultFormat.CSV);
        this.checkOutput();
    }

    @Test
    public void testTupleQueryDownloadMIMEType() throws Exception {
        this.tupleQuery.download(this.output, TupleQueryResultFormat.CSV.getDefaultMIMEType());
        this.checkOutput();
    }

    @Test
    public void testTupleQueryDownloadStrMIMEType() throws Exception {
        this.tupleQuery.download(this.output.getAbsolutePath(), TupleQueryResultFormat.CSV.getDefaultMIMEType());
        this.checkOutput();
    }

    @Test
    public void testTupleQueryStream() throws Exception {
        InputStream stream = this.tupleQuery.stream();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testTupleQueryStreamFormat() throws Exception {
        InputStream stream = this.tupleQuery.stream(TupleQueryResultFormat.CSV);
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testTupleQueryStreamMIMEType() throws Exception {
        InputStream stream = this.tupleQuery.stream(TupleQueryResultFormat.CSV.getDefaultMIMEType());
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testGraphQueryDownload() throws Exception {
        this.graphQuery.download(this.output);
        this.checkOutput();
    }

    @Test
    public void testGraphQueryDownloadStr() throws Exception {
        this.graphQuery.download(this.output.getAbsolutePath());
        this.checkOutput();
    }

    @Test
    public void testGraphQueryDownloadFormat() throws Exception {
        this.graphQuery.download(this.output, RDFFormat.RDFXML);
        this.checkOutput();
    }

    @Test
    public void testGraphQueryDownloadStrFormat() throws Exception {
        this.graphQuery.download(this.output.getAbsolutePath(), RDFFormat.RDFXML);
        this.checkOutput();
    }

    @Test
    public void testGraphQueryDownloadMIMEType() throws Exception {
        this.graphQuery.download(this.output, RDFFormat.RDFXML.getDefaultMIMEType());
        this.checkOutput();
    }

    @Test
    public void testGraphQueryDownloadStrMIMEType() throws Exception {
        this.graphQuery.download(this.output.getAbsolutePath(), RDFFormat.RDFXML.getDefaultMIMEType());
        this.checkOutput();
    }

    @Test
    public void testGraphQueryStream() throws Exception {
        InputStream stream = this.graphQuery.stream();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testGraphQueryStreamFormat() throws Exception {
        InputStream stream = this.graphQuery.stream(RDFFormat.RDFXML);
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testGraphQueryStreamMIMEType() throws Exception {
        InputStream stream = this.graphQuery.stream(RDFFormat.RDFXML.getDefaultMIMEType());
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkOutput();
    }

    @Test
    public void testBooleanQueryDownload() throws Exception {
        this.boolQuery.download(this.output);
        this.checkBoolOutput();
    }

    @Test
    public void testBooleanQueryDownloadStr() throws Exception {
        this.boolQuery.download(this.output.getAbsolutePath());
        this.checkBoolOutput();
    }

    @Test
    public void testBooleanQueryDownloadFormat() throws Exception {
        this.boolQuery.download(this.output, BooleanQueryResultFormat.TEXT);
        this.checkBoolOutput();
    }

    @Test
    public void testBooleanQueryDownloadStrFormat() throws Exception {
        this.boolQuery.download(this.output.getAbsolutePath(), BooleanQueryResultFormat.TEXT);
        this.checkBoolOutput();
    }

    @Test
    public void testBooleanQueryDownloadMIMEType() throws Exception {
        this.boolQuery.download(this.output, BooleanQueryResultFormat.TEXT.getDefaultMIMEType());
        this.checkBoolOutput();
    }

    @Test
    public void testBooleanQueryDownloadStrMIMEType() throws Exception {
        this.boolQuery.download(this.output.getAbsolutePath(), BooleanQueryResultFormat.TEXT.getDefaultMIMEType());
        this.checkBoolOutput();
    }

    @Test
    public void testBooleanQueryStream() throws Exception {
        InputStream stream = this.boolQuery.stream();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkBoolOutput();
    }

    @Test
    public void testBooleanQueryStreamFormat() throws Exception {
        InputStream stream = this.boolQuery.stream(BooleanQueryResultFormat.TEXT);
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkBoolOutput();
    }

    @Test
    public void testBooleanQueryStreamMIMEType() throws Exception {
        InputStream stream = this.boolQuery.stream(BooleanQueryResultFormat.TEXT.getDefaultMIMEType());
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.output);
        this.checkBoolOutput();
    }

    private void checkOutput() throws IOException {
        String data = FileUtils.readFileToString((File)this.output);
        Assert.assertTrue((String)"Output file should contain the test string.", (boolean)data.contains(TEXT));
    }

    private void checkBoolOutput() throws IOException {
        String data = FileUtils.readFileToString((File)this.output).toLowerCase();
        Assert.assertFalse((String)(data + " should look truthy"), (boolean)data.contains("false"));
        Assert.assertFalse((String)(data + " should be healthy"), (boolean)data.contains("cholesterol"));
    }
}

