/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGCatalog;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class DynamicCatalogTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void dynamicCatalogs_rfe10175() throws Exception {
        String catalogID = "dynamicCatalog1";
        String repoID = "repo1";
        AGCatalog catalog = server.createCatalog(catalogID);
        Assert.assertNotNull((String)"missing the expected catalog", (Object)server.getCatalog(catalogID));
        int numCatalogs = server.listCatalogs().size();
        catalog = server.createCatalog(catalogID);
        Assert.assertEquals((String)"expected no change in catalogs", (int)numCatalogs, (int)server.listCatalogs().size());
        catalog.createRepository(repoID);
        Assert.assertTrue((String)"expected repository", (boolean)catalog.hasRepository(repoID));
        catalog.deleteRepository(repoID);
        Assert.assertTrue((String)"unexpected repository", (!catalog.hasRepository(repoID) ? 1 : 0) != 0);
        server.deleteCatalog(catalogID);
        Assert.assertNull((String)"expected catalog to be deleted", (Object)server.getCatalog(catalogID));
        try {
            catalog.hasRepository(repoID);
            Assert.fail((String)"expected catalog not found exception.");
        }
        catch (AGHttpException aGHttpException) {
            // empty catch block
        }
        numCatalogs = server.listCatalogs().size();
        server.deleteCatalog(catalogID);
        Assert.assertEquals((String)"expected no change in catalogs", (int)numCatalogs, (int)server.listCatalogs().size());
        server.createCatalog(catalogID);
        Assert.assertTrue((String)"Expected no repositories in catalog.", (!catalog.hasRepository(repoID) ? 1 : 0) != 0);
        server.deleteCatalog(catalogID);
        Assert.assertNull((String)"expected catalog to be deleted", (Object)server.getCatalog(catalogID));
        server.deleteCatalog("/");
        server.deleteCatalog("blahdiblah");
    }
}

