/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGFormattedNamespace;
import java.util.ArrayList;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class EncodableNamespaceTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void encodableNamespaces_rfe10197() throws Exception {
        int i;
        int i2;
        String NS0 = "http://franz.com/ns0";
        String FORMAT0 = "[a-z][0-9]-[a-f]{3}";
        Assert.assertTrue((String)"expected none", (boolean)this.conn.listEncodableNamespaces().isEmpty());
        this.conn.registerEncodableNamespace(NS0, FORMAT0);
        ArrayList<AGFormattedNamespace> namespaces = this.conn.listEncodableNamespaces();
        Assert.assertEquals((String)"expected one", (int)1, (int)namespaces.size());
        AGFormattedNamespace ns = (AGFormattedNamespace)namespaces.get(0);
        Assert.assertEquals((String)"unexpected prefix", (String)NS0, (String)ns.getNamespace());
        Assert.assertEquals((String)"unexpected format", (String)FORMAT0, (String)ns.getFormat());
        IRI uri = this.vf.generateURI(NS0);
        Assert.assertTrue((String)("expected prefix " + NS0), (boolean)uri.stringValue().startsWith(NS0));
        Assert.assertFalse((String)"expected uniqueness", (boolean)uri.stringValue().equals(this.vf.generateURI(NS0).stringValue()));
        String NS1 = "http://franz.com/ns1";
        String NS2 = "http://franz.com/ns2";
        String NS3 = "http://franz.com/ns3";
        String NS4 = "urn:franz:";
        this.conn.registerEncodableNamespace(NS1, "[0-1]{59}");
        this.conn.registerEncodableNamespace(NS2, "[0-9]{18}");
        try {
            this.conn.registerEncodableNamespace(NS3, "[0-9]{19}");
            Assert.fail((String)"expected exception for format too large.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        this.conn.registerEncodableNamespace(NS4, "[a-z][0-9]-[a-f]{1,3}");
        try {
            this.vf.generateURI(NS4);
            Assert.fail((String)"expected exception for format not fixed size.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        try {
            uri = this.vf.generateURI(NS0);
            this.conn.add((Resource)uri, uri, (Value)uri, new Resource[0]);
            this.conn.registerEncodableNamespace(NS0, "[0-9]{10}");
            Assert.fail((String)"expected exception for attempting reregistration.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        namespaces = new ArrayList<AGFormattedNamespace>();
        for (i2 = 0; i2 < 10000; ++i2) {
            namespaces.add(new AGFormattedNamespace("urn:franz-" + i2 + ":", "[0-1]{3}"));
        }
        this.conn.registerEncodableNamespaces(namespaces);
        Assert.assertEquals((int)10004, (int)this.conn.listEncodableNamespaces().size());
        for (i2 = 0; i2 < 8; ++i2) {
            this.vf.generateURI("urn:franz-1234:");
        }
        try {
            System.out.println(this.vf.generateURI("urn:franz-1234:"));
            Assert.fail((String)"expected exception for no more available id's.");
        }
        catch (RepositoryException i3) {
            // empty catch block
        }
        IRI[] uris = this.vf.generateURIs("urn:franz-9999:", 5);
        Assert.assertEquals((String)"expected 5 URI's", (int)5, (int)uris.length);
        for (i = 0; i < uris.length; ++i) {
        }
        uris = this.vf.generateURIs("urn:franz-9999:", 5);
        Assert.assertEquals((String)"expected 3 URI's", (int)3, (int)uris.length);
        for (i = 0; i < uris.length; ++i) {
        }
        try {
            uris = this.vf.generateURIs("urn:franz-9999:", 5);
            Assert.fail((String)"expected no URI's available");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        this.conn.unregisterEncodableNamespace(NS2);
        Assert.assertEquals((int)10003, (int)this.conn.listEncodableNamespaces().size());
        try {
            this.conn.unregisterEncodableNamespace(NS0);
            Assert.fail((String)"expected namespace in use exception");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        Assert.assertEquals((int)10003, (int)this.conn.listEncodableNamespaces().size());
    }
}

