/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGTupleQuery;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class LiteralAndResourceResultsTest
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testGetTypedResults() throws Exception {
        BNode b = this.vf.createBNode();
        IRI r = this.vf.createIRI("http://r");
        Literal lit = this.vf.createLiteral("42", XMLSchema.INT);
        this.conn.add((Resource)b, r, (Value)lit, new Resource[0]);
        String queryString = "SELECT ?s ?p ?o  WHERE {?s ?p ?o .}";
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TupleQueryResult result = tupleQuery.evaluate();
        this.closeLater(result);
        while (result.hasNext()) {
            BindingSet bindingSet = (BindingSet)result.next();
            BNode s = (BNode)bindingSet.getValue("s");
            Assert.assertEquals((Object)b, (Object)s);
            IRI p = (IRI)bindingSet.getValue("p");
            Assert.assertEquals((Object)r, (Object)p);
            Value o = bindingSet.getValue("o");
            if (!(o instanceof Literal)) continue;
            Literal l = (Literal)o;
            Assert.assertEquals((Object)lit, (Object)l);
            int i = l.intValue();
            Assert.assertEquals((int)42, (int)i);
            IRI dt = l.getDatatype();
            Assert.assertEquals((Object)XMLSchema.INT, (Object)dt);
        }
    }
}

