/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class NQuadsTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void nquads_sesame_rfe10201() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[0]));
        IRI alice = this.vf.createIRI("http://example.org/alice/foaf.rdf");
        Assert.assertEquals((String)"expected size 7", (long)7L, (long)this.conn.size(new Resource[]{alice}));
        IRI bob = this.vf.createIRI("http://example.org/bob/foaf.rdf");
        Assert.assertEquals((String)"expected size 3", (long)3L, (long)this.conn.size(new Resource[]{bob}));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void nquads_jena_rfe10201() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getUnionOfAllGraphs());
        AGModel model = this.closeLater(new AGModel(graph));
        model.read(Util.resourceAsStream("/test/example.nq"), null, "NQUADS");
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)model.size());
        model.write((OutputStream)new FileOutputStream("target/exampleModelWrite.nq"), "NQUADS");
        model.removeAll();
        Assert.assertEquals((String)"expected size 0", (long)0L, (long)model.size());
        model.read((InputStream)new FileInputStream("target/exampleModelWrite.nq"), null, "NQUADS");
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)model.size());
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void sesameAddContextOverridesNQuadsContext() throws Exception {
        IRI bob = this.vf.createIRI("http://example.org/bob/foaf.rdf");
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[]{bob});
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[]{bob}));
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void jenaGraphOverridesNQuadsContext() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getGraph());
        AGModel model = this.closeLater(new AGModel(graph));
        model.read(Util.resourceAsStream("/test/example.nq"), null, "NQUADS");
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)model.size());
    }
}

