/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import java.util.ArrayList;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Categories;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import test.AGAbstractTest;
import test.Stmt;
import test.TestSuites;

public class QuickTests
extends AGAbstractTest {
    public static final String NS = "http://franz.com/test/";

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void bnode() throws Exception {
        Assert.assertEquals((String)"size", (long)0L, (long)this.conn.size(new Resource[0]));
        BNode s = this.vf.createBNode();
        IRI p = this.vf.createIRI(NS, "a");
        Literal o = this.vf.createLiteral("aaa");
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        Assert.assertEquals((String)"size", (long)1L, (long)this.conn.size(new Resource[0]));
        QuickTests.assertSetsEqual("a", Stmt.stmts(new Stmt(null, p, (Value)o)), Stmt.dropSubjects(Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements((Resource)s, p, (Value)o, true, new Resource[0]))));
        RepositoryResult statements = this.conn.getStatements(null, null, null, false, new Resource[0]);
        Statement st = (Statement)statements.next();
        AGAbstractTest.assertSetsEqual("", Stmt.stmts(new Stmt(st)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements((Resource)s, st.getPredicate(), st.getObject(), false, new Resource[0])));
        AGAbstractTest.assertSetsEqual("", Stmt.stmts(new Stmt(st)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(st.getSubject(), st.getPredicate(), st.getObject(), false, new Resource[0])));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void bnode_rfe9776() throws Exception {
        Statement st;
        IRI orderedCollection = this.vf.createIRI("http://lumas#orderedCollection");
        IRI property = this.vf.createIRI("http://lumas#hasId");
        BNode node = this.vf.createBNode("newId");
        this.conn.prepareHttpRepoClient().setAllowExternalBlankNodeIds(true);
        this.conn.add((Resource)orderedCollection, property, (Value)node, new Resource[0]);
        RepositoryResult result = this.closeLater(this.conn.getStatements(null, null, null, false, new Resource[0]));
        BNode bnode = null;
        if (result.hasNext()) {
            st = (Statement)result.next();
            bnode = (BNode)st.getObject();
            junit.framework.Assert.assertNotNull((Object)st);
        } else {
            Assert.fail((String)"expected 1 result");
        }
        junit.framework.Assert.assertNotNull(bnode);
        result = this.closeLater(this.conn.getStatements(null, null, (Value)bnode, false, new Resource[0]));
        if (result.hasNext()) {
            st = (Statement)result.next();
            junit.framework.Assert.assertNotNull((Object)st);
        } else {
            Assert.fail((String)"no triple found!");
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void namespaceAfterError() throws Exception {
        IRI alice = this.vf.createIRI("http://example.org/people/alice");
        IRI name = this.vf.createIRI("http://example.org/ontology/name");
        Literal alicesName = this.vf.createLiteral("Alice");
        this.conn.add((Resource)alice, name, (Value)alicesName, new Resource[0]);
        try {
            this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, "ask { ?s xxx:name \"Alice\" } ").evaluate();
            Assert.fail((String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setNamespace("ont", "http://example.org/ontology/");
        Assert.assertTrue((String)"Boolean result", (boolean)this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, "ask { ?s ont:name \"Alice\" } ").evaluate());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void bulkDelete() throws Exception {
        IRI alice = this.vf.createIRI("http://example.org/people/alice");
        IRI firstname = this.vf.createIRI("http://example.org/ontology/firstname");
        IRI lastname = this.vf.createIRI("http://example.org/ontology/lastname");
        Literal alicesName = this.vf.createLiteral("Alice");
        ArrayList<Statement> input = new ArrayList<Statement>();
        input.add(this.vf.createStatement((Resource)alice, firstname, (Value)alicesName));
        input.add(this.vf.createStatement((Resource)alice, lastname, (Value)alicesName));
        this.conn.add(input, new Resource[0]);
        Assert.assertEquals((String)"size", (long)2L, (long)this.conn.size(new Resource[0]));
        this.conn.remove(input, new Resource[0]);
        Assert.assertEquals((String)"size", (long)0L, (long)this.conn.size(new Resource[0]));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void openRepo_rfe9837() throws Exception {
        block5: {
            AGRepository repo3;
            block4: {
                AGRepository repo2 = this.closeLater(cat.openRepository(this.repo.getRepositoryID()));
                AGRepositoryConnection conn2 = this.closeLater(repo2.getConnection());
                Assert.assertEquals((String)"size", (long)this.conn.size(new Resource[0]), (long)conn2.size(new Resource[0]));
                Assert.assertEquals((String)"id", (Object)this.repo.getRepositoryID(), (Object)repo2.getRepositoryID());
                try {
                    repo3 = this.closeLater(cat.createRepository(this.repo.getRepositoryID(), true));
                    Assert.fail((String)("strict should cause an exception: " + repo3.getRepositoryURL()));
                }
                catch (RepositoryException e) {
                    if (e.getMessage().contains("There is already a repository")) break block4;
                    throw e;
                }
            }
            try {
                repo3 = this.closeLater(cat.openRepository("no-such-repo"));
                Assert.fail((String)("should not exist: " + repo3.getRepositoryURL()));
            }
            catch (RepositoryException e) {
                if (e.getMessage().contains("Repository not found with ID:")) break block5;
                throw e;
            }
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void serverUrlTrailingSlashRemoved() throws Exception {
        String serverURL = server.getServerURL();
        AGServer server2 = new AGServer(serverURL + "/", QuickTests.username(), QuickTests.password());
        junit.framework.Assert.assertEquals((String)serverURL, (String)server2.getServerURL());
    }

    @RunWith(value=Categories.class)
    @Categories.IncludeCategory(value={TestSuites.Broken.class})
    @Suite.SuiteClasses(value={QuickTests.class})
    public static class Broken {
    }

    @RunWith(value=Categories.class)
    @Categories.ExcludeCategory(value={TestSuites.NonPrepushTest.class})
    @Suite.SuiteClasses(value={QuickTests.class})
    public static class Prepush {
    }
}

