/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.repl.DurabilityLevel;
import com.franz.agraph.repository.repl.TransactionSettings;
import com.franz.util.Ctx;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.eclipse.rdf4j.model.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class ReplHeaderTest
extends AGAbstractTest {
    private TransactionSettings settings = new TransactionSettings();
    private AGRepositoryConnection mock;
    private Header[] lastHeaders;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AGHTTPClient client = new AGHTTPClient(server.getServerURL()){

            public void get(String url, Header[] headers, NameValuePair[] params, AGResponseHandler handler) throws AGHttpException {
                super.get(url, headers, params, handler);
                ReplHeaderTest.access$002(ReplHeaderTest.this, headers);
            }

            public void post(String url, Header[] headers, NameValuePair[] params, HttpEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
                super.post(url, headers, params, requestEntity, handler);
                ReplHeaderTest.access$002(ReplHeaderTest.this, headers);
            }
        };
        client.setUsernameAndPassword(ReplHeaderTest.username(), ReplHeaderTest.password());
        AGHttpRepoClient repoClient = new AGHttpRepoClient((AGAbstractRepository)this.repo, client, this.repo.getRepositoryURL(), null);
        this.mock = new AGRepositoryConnection(this.repo, repoClient);
    }

    private String getReplHeader() {
        if (this.lastHeaders == null) {
            return null;
        }
        for (Header header : this.lastHeaders) {
            if (!header.getName().equalsIgnoreCase("x-repl-settings")) continue;
            return header.getValue();
        }
        return null;
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testNoReplHeaderByDefault() {
        this.mock.size(new Resource[0]);
        Assert.assertNull((Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSetIntegerDurability() {
        this.mock.setTransactionSettings(this.settings.withDurability(Integer.valueOf(42)));
        this.mock.size(new Resource[0]);
        Assert.assertEquals((Object)"durability=42", (Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSetKeywordDurability() {
        this.mock.setTransactionSettings(this.settings.withDurability(DurabilityLevel.QUORUM));
        this.mock.size(new Resource[0]);
        Assert.assertEquals((Object)"durability=quorum", (Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSetTimeout() {
        this.mock.setTransactionSettings(this.settings.withDistributedTransactionTimeout(Integer.valueOf(42)));
        this.mock.size(new Resource[0]);
        Assert.assertEquals((Object)"distributedTransactionTimeout=42", (Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSetLatency() {
        this.mock.setTransactionSettings(this.settings.withTransactionLatencyCount(Integer.valueOf(42)));
        this.mock.size(new Resource[0]);
        Assert.assertEquals((Object)"transactionLatencyCount=42", (Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSetLatencyTimeout() {
        this.mock.setTransactionSettings(this.settings.withTransactionLatencyTimeout(Integer.valueOf(42)));
        this.mock.size(new Resource[0]);
        Assert.assertEquals((Object)"transactionLatencyTimeout=42", (Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSetAll() {
        this.mock.setTransactionSettings(this.settings.withDurability(Integer.valueOf(1)).withDistributedTransactionTimeout(Integer.valueOf(2)).withTransactionLatencyCount(Integer.valueOf(3)).withTransactionLatencyTimeout(Integer.valueOf(42)));
        this.mock.size(new Resource[0]);
        Assert.assertEquals((Object)"durability=1 distributedTransactionTimeout=2 transactionLatencyCount=3 transactionLatencyTimeout=42", (Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testResetDurability() {
        this.mock.setTransactionSettings(this.settings.withDurability(DurabilityLevel.QUORUM).withDurability(DurabilityLevel.DEFAULT));
        this.mock.size(new Resource[0]);
        Assert.assertNull((Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testResetDurabilityNullInteger() {
        this.mock.setTransactionSettings(this.settings.withDurability(DurabilityLevel.QUORUM).withDurability((Integer)null));
        this.mock.size(new Resource[0]);
        Assert.assertNull((Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testResetDurabilityNullLevel() {
        this.mock.setTransactionSettings(this.settings.withDurability(DurabilityLevel.QUORUM).withDurability((DurabilityLevel)null));
        this.mock.size(new Resource[0]);
        Assert.assertNull((Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testResetTimeout() {
        this.mock.setTransactionSettings(this.settings.withDistributedTransactionTimeout(Integer.valueOf(42)).withDistributedTransactionTimeout(null));
        this.mock.size(new Resource[0]);
        Assert.assertNull((Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testResetLatency() {
        this.mock.setTransactionSettings(this.settings.withTransactionLatencyCount(Integer.valueOf(42)).withTransactionLatencyCount(null));
        this.mock.size(new Resource[0]);
        Assert.assertNull((Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testResetLatencyTimeout() {
        this.mock.setTransactionSettings(this.settings.withTransactionLatencyTimeout(Integer.valueOf(42)).withTransactionLatencyTimeout(null));
        this.mock.size(new Resource[0]);
        Assert.assertNull((Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testContextManager() {
        this.mock.setTransactionSettings(this.settings.withDurability(DurabilityLevel.QUORUM));
        this.mock.size(new Resource[0]);
        Assert.assertEquals((Object)"durability=quorum", (Object)this.getReplHeader());
        try (Ctx ignored = this.mock.transactionSettingsCtx(this.settings.withDurability(Integer.valueOf(100)));){
            this.mock.size(new Resource[0]);
            Assert.assertEquals((Object)"durability=100", (Object)this.getReplHeader());
        }
        this.mock.size(new Resource[0]);
        Assert.assertEquals((Object)"durability=quorum", (Object)this.getReplHeader());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testCommitSettings() {
        this.mock.commit(this.settings.withDurability(Integer.valueOf(42)));
        Assert.assertEquals((Object)"durability=42", (Object)this.getReplHeader());
    }

    static /* synthetic */ Header[] access$002(ReplHeaderTest x0, Header[] x1) {
        x0.lastHeaders = x1;
        return x1;
    }
}

