/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.exception.AGCustomStoredProcException;
import com.franz.agraph.http.storedproc.AGDecoder;
import com.franz.agraph.http.storedproc.AGDeserializer;
import com.franz.agraph.http.storedproc.AGEncoder;
import com.franz.agraph.http.storedproc.AGSerializer;
import com.franz.agraph.repository.AGQueryLanguage;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.http.HttpEntity;
import org.apache.http.entity.FileEntity;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.AGAbstractTest;
import test.Stmt;
import test.TutorialTests;
import test.Util;

public class ServerCodeTests
extends AGAbstractTest {
    static final Object ALL_TYPES = new Object[]{123, 0, -123, "abc", null, new Integer[]{9, 9, 9, 9}, Util.arrayList(123, 0, -123, "abc"), new byte[]{0, 1, 2, 3, 4, 5, 6, 7}};
    private static final File STORED_PROC = Util.resourceAsTempFile("/test/ag-test-stored-proc.cl");
    private static final File RULES_FILE = Util.resourceAsTempFile("/tutorial/java-rules.txt");
    private static String RULES = "java-rules.prolog";
    private static AGServerCode serverCode;

    @BeforeClass
    public static void installScripts() throws Exception {
        serverCode = new AGServerCode(server);
        serverCode.putScript("ag-test-stored-proc.cl", STORED_PROC);
        serverCode.deleteInitFile();
    }

    @AfterClass
    public static void cleanup() throws Exception {
        serverCode.deleteInitFile();
    }

    @Test
    public void storedProcs_encoding_rfe10189() throws Exception {
        byte[][] cases = new byte[][]{{1, 3, 32, 11, 13, 123}, new byte[0], {33}, {33, 44}, {33, 44, 55}, {33, 44, 55, 66}, {33, 44, 55, 66, 77}, {33, 44, 55, 66, 77, 88}, {-1, -2, -3, -4, -5}, {-1, -2, -3, -4}};
        for (int casenum = 0; casenum < cases.length; ++casenum) {
            byte[] input = cases[casenum];
            String encoded = AGEncoder.encode((byte[])input);
            byte[] result = AGDecoder.decode((String)encoded);
            ServerCodeTests.assertSetsEqual("encoding", input, result);
        }
    }

    @Test
    public void encoding_all_types_rfe10189() throws Exception {
        Object[] o = new Object[]{ALL_TYPES};
        ServerCodeTests.assertEqualsDeep("all types", o, AGDeserializer.decodeAndDeserialize((String)AGSerializer.serializeAndEncode((Object[])o)));
    }

    @Test
    public void storedProcsEncoded_rfe10189() throws Exception {
        String response = (String)AGDeserializer.decodeAndDeserialize((String)this.conn.prepareHttpRepoClient().callStoredProcEncoded("add-two-strings", "ag-test-stored-proc.cl", AGSerializer.serializeAndEncode((Object[])new String[]{"123", "456"})));
        Assert.assertEquals((long)579L, (long)Integer.parseInt(response));
    }

    @Test
    public void storedProcs_rfe10189() throws Exception {
        SProcTest sp = new SProcTest(this.conn);
        Assert.assertEquals((String)"supports strings", (Object)"579", (Object)sp.addTwoStrings("123", "456"));
        Assert.assertEquals((String)"supports pos int", (long)579L, (long)sp.addTwoInts(123, 456));
        Assert.assertEquals((String)"supports neg int and zero", (long)0L, (long)sp.addTwoInts(123, -123));
        Assert.assertEquals((String)"supports neg int", (long)-100L, (long)sp.addTwoInts(23, -123));
        Assert.assertEquals((String)"supports whole arg-vec strings", (Object)"579", (Object)sp.addTwoVecStrings("123", "456"));
        Assert.assertEquals((String)"supports whole arg-vec ints", (long)579L, (long)sp.addTwoVecInts(123, 456));
        Assert.assertEquals((String)"supports null", null, (Object)sp.bestBeNull(null));
        try {
            Assert.assertEquals(null, (Object)sp.bestBeNull("abc"));
            Assert.fail((String)"should be AGCustomStoredProcException");
        }
        catch (AGCustomStoredProcException e) {
            Assert.assertEquals((String)"test null and error", (Object)"I expected a nil, but got: abc", (Object)e.getMessage());
        }
        try {
            Assert.assertEquals((Object)"579", (Object)sp.addTwoVecStringsError());
            Assert.fail((String)"should be AGCustomStoredProcException");
        }
        catch (AGCustomStoredProcException e) {
            Assert.assertEquals((String)"test error", (Object)"wrong number of args", (Object)e.getMessage());
        }
        try {
            Assert.assertEquals((Object)"579", (Object)sp.addTwoVecStrings(null, null));
            Assert.fail((String)"should be AGCustomStoredProcException");
        }
        catch (AGCustomStoredProcException e) {
            Assert.assertEquals((String)"test null and error", (Object)"There is no integer in the string nil (:start 0 :end 0)", (Object)e.getMessage());
        }
        try {
            Assert.assertEquals((Object)"579", (Object)sp.addTwoVecStrings("abc", "def"));
            Assert.fail((String)"should be AGCustomStoredProcException");
        }
        catch (AGCustomStoredProcException e) {
            Assert.assertEquals((String)"test error", (Object)"There's junk in this string: \"abc\".", (Object)e.getMessage());
        }
        ServerCodeTests.assertEqualsDeep("supports all types, originating from java", ALL_TYPES, sp.checkAllTypes(ALL_TYPES));
        ServerCodeTests.assertEqualsDeep("supports all types, round-trip", ALL_TYPES, sp.identity(ALL_TYPES));
        ServerCodeTests.assertEqualsDeep("supports all types, originating from lisp", ALL_TYPES, sp.returnAllTypes());
    }

    @Test
    public void storedProcs_triples_rfe10189() throws Exception {
        SProcTest sp = new SProcTest(this.conn);
        junit.framework.Assert.assertNotNull((String)"add-a-triple-int", (Object)sp.addATripleInt(1));
        ServerCodeTests.assertEqualsDeep("get-a-triple-int", Stmt.stmts(new Stmt((Resource)this.vf.createIRI("http://test.com/add-a-triple-int"), this.vf.createIRI("http://test.com/p"), (Value)this.vf.createLiteral(1))), Stmt.stmts(new Stmt(sp.getATripleInt(1))));
    }

    @Test
    public void storedProcs_rollbackAfterException_spr38315() throws Exception {
        SProcTest sp = new SProcTest(this.conn);
        this.conn.setAutoCommit(false);
        long count = this.conn.size(new Resource[0]);
        try {
            junit.framework.Assert.assertNotNull((String)"add-a-triple-int", (Object)sp.addATripleInt(1));
            junit.framework.Assert.assertEquals((String)"expected a change in triple count", (long)(count + 1L), (long)this.conn.size(new Resource[0]));
            ServerCodeTests.assertEqualsDeep("get-a-triple-int", Stmt.stmts(new Stmt((Resource)this.vf.createIRI("http://test.com/add-a-triple-int"), this.vf.createIRI("http://test.com/p"), (Value)this.vf.createLiteral(1))), Stmt.stmts(new Stmt(sp.getATripleInt(1))));
            sp.bestBeNull("foo");
            junit.framework.Assert.fail((String)"expected an exception.");
        }
        catch (AGCustomStoredProcException e) {
            this.conn.rollback();
        }
        junit.framework.Assert.assertEquals((String)"expected no change in triple count", (long)count, (long)this.conn.size(new Resource[0]));
    }

    public TupleQuery rfe10256_setup() throws Exception {
        TutorialTests.example6_setup(this.conn, this.repo);
        this.conn.setNamespace("kdy", "http://www.franz.com/simple#");
        this.conn.setNamespace("rltv", "http://www.franz.com/simple#");
        String queryString = "(select (?ufirst ?ulast ?cfirst ?clast)(uncle ?uncle ?child)(name ?uncle ?ufirst ?ulast)(name ?child ?cfirst ?clast))";
        return this.conn.prepareTupleQuery((QueryLanguage)AGQueryLanguage.PROLOG, queryString);
    }

    private void rfe10256_fail(TupleQuery tupleQuery) throws QueryEvaluationException {
        block2: {
            try {
                tupleQuery.evaluate();
                Assert.fail((String)"expected QueryEvaluationException");
            }
            catch (QueryEvaluationException e) {
                if (e.getMessage().contains("Undefined functor in Prolog query")) break block2;
                throw e;
            }
        }
    }

    public void rfe10256_loadInitFile() throws Exception {
        serverCode.deleteInitFile();
        serverCode.putInitFile(RULES_FILE);
        this.conn.setSessionLoadInitFile(true);
        TupleQuery tupleQuery = this.rfe10256_setup();
        Assert.assertEquals((long)52L, (long)Stmt.statementSet(tupleQuery.evaluate(), new String[0]).size());
    }

    @Test
    public void rfe10256_doNotPut_InitFile() throws Exception {
        serverCode.deleteInitFile();
        TupleQuery tupleQuery = this.rfe10256_setup();
        this.rfe10256_fail(tupleQuery);
    }

    public void rfe10256_doNotUse_InitFile() throws Exception {
        serverCode.deleteInitFile();
        serverCode.putInitFile(RULES_FILE);
        TupleQuery tupleQuery = this.rfe10256_setup();
        this.rfe10256_fail(tupleQuery);
    }

    @Test
    public void rfe10257_script() throws Exception {
        serverCode.deleteInitFile();
        serverCode.deleteScript(RULES);
        serverCode.putScript(RULES, RULES_FILE);
        this.conn.addSessionLoadScript(RULES);
        TupleQuery tupleQuery = this.rfe10256_setup();
        Assert.assertEquals((long)52L, (long)Stmt.statementSet(tupleQuery.evaluate(), new String[0]).size());
    }

    @Test
    public void rfe10257_doNotPut_script() throws Exception {
        serverCode.deleteInitFile();
        serverCode.deleteScript(RULES);
        TupleQuery tupleQuery = this.rfe10256_setup();
        this.rfe10256_fail(tupleQuery);
    }

    @Test
    public void rfe10257_doNotUse_script() throws Exception {
        serverCode.deleteInitFile();
        serverCode.deleteScript(RULES);
        serverCode.putScript(RULES, RULES_FILE);
        TupleQuery tupleQuery = this.rfe10256_setup();
        this.rfe10256_fail(tupleQuery);
    }

    class SProcTest {
        static final String SCRIPT = "ag-test-stored-proc.cl";
        private final AGRepositoryConnection conn;

        SProcTest(AGRepositoryConnection conn) {
            this.conn = conn;
        }

        String addTwoStrings(String a, String b) throws Exception {
            return (String)this.conn.callStoredProc("add-two-strings", SCRIPT, new Object[]{a, b});
        }

        int addTwoInts(int a, int b) throws Exception {
            return (Integer)this.conn.callStoredProc("add-two-ints", SCRIPT, new Object[]{a, b});
        }

        String addTwoVecStrings(String a, String b) throws Exception {
            return (String)this.conn.callStoredProc("add-two-vec-strings", SCRIPT, new Object[]{a, b});
        }

        String addTwoVecStringsError() throws Exception {
            return (String)this.conn.callStoredProc("add-two-vec-strings", SCRIPT, new Object[0]);
        }

        int addTwoVecInts(int a, int b) throws Exception {
            return (Integer)this.conn.callStoredProc("add-two-vec-ints", SCRIPT, new Object[]{a, b});
        }

        Object bestBeNull(String a) throws Exception {
            return this.conn.callStoredProc("best-be-nil", SCRIPT, new Object[]{a});
        }

        Object returnAllTypes() throws Exception {
            return this.conn.callStoredProc("return-all-types", SCRIPT, new Object[0]);
        }

        Object identity(Object input) throws Exception {
            return this.conn.callStoredProc("identity", SCRIPT, new Object[]{input});
        }

        Object checkAllTypes(Object input) throws Exception {
            return this.conn.callStoredProc("check-all-types", SCRIPT, new Object[]{input});
        }

        Object addATripleInt(int i) throws Exception {
            return this.conn.callStoredProc("add-a-triple-int", SCRIPT, new Object[]{i});
        }

        Statement getATripleInt(int i) throws Exception {
            String r = (String)this.conn.callStoredProc("get-a-triple-int", SCRIPT, new Object[]{i});
            Statement st = this.parseNtriples(r);
            return st;
        }

        private Statement parseNtriples(String ntriples) throws IOException, RDFParseException, RDFHandlerException {
            RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.NTRIPLES, (ValueFactory)ServerCodeTests.this.vf);
            parser.setPreserveBNodeIDs(true);
            StatementCollector collector = new StatementCollector();
            parser.setRDFHandler((RDFHandler)collector);
            parser.parse((Reader)new StringReader(ntriples), "http://example.com/");
            Statement st = (Statement)collector.getStatements().iterator().next();
            return st;
        }
    }

    static class AGServerCode {
        private final AGServer server;

        AGServerCode(AGServer server) {
            this.server = server;
        }

        private AGHTTPClient http() {
            return this.server.getHTTPClient();
        }

        public TupleQueryResult scripts() throws Exception {
            return this.http().getTupleQueryResult(this.server.getServerURL() + "/scripts");
        }

        public void putScript(String path, File script) throws Exception {
            this.http().put(this.server.getServerURL() + "/scripts/" + path, null, null, (HttpEntity)new FileEntity(script, "text/plain"), null);
        }

        public void deleteScript(String path) throws Exception {
            this.http().delete(this.server.getServerURL() + "/scripts/" + path, null, null, null);
        }

        public TupleQueryResult initFile() throws Exception {
            return this.http().getTupleQueryResult(this.server.getServerURL() + "/initfile");
        }

        public void putInitFile(File script) throws Exception {
            this.http().put(this.server.getServerURL() + "/initfile", null, null, (HttpEntity)new FileEntity(script, "text/plain"), null);
        }

        public void deleteInitFile() throws Exception {
            this.http().delete(this.server.getServerURL() + "/initfile", null, null, null);
        }
    }
}

