/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class SessionTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sessionUsingDedicatedPort() throws Exception {
        int mainPort = this.getPort(this.conn);
        String oldUse = System.setProperty("com.franz.agraph.http.useMainPortForSessions", "false");
        String oldOverride = System.setProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", "true");
        this.conn.setAutoCommit(false);
        int sessionPort = this.getPort(this.conn);
        Assert.assertTrue((String)"session port should be different from main port", (mainPort != sessionPort ? 1 : 0) != 0);
        this.conn.add((Resource)OWL.INVERSEOF, OWL.INVERSEOF, (Value)OWL.INVERSEOF, new Resource[0]);
        this.conn.commit();
        if (oldUse != null) {
            System.setProperty("com.franz.agraph.http.useMainPortForSessions", oldUse);
        } else {
            System.clearProperty("com.franz.agraph.http.useMainPortForSessions");
        }
        if (oldOverride != null) {
            System.setProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", oldOverride);
        } else {
            System.clearProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions");
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sessionUsingMainPort() throws Exception {
        int mainPort = this.getPort(this.conn);
        String oldUse = System.setProperty("com.franz.agraph.http.useMainPortForSessions", "true");
        String oldOverride = System.setProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", "true");
        this.conn.setAutoCommit(false);
        int sessionPort = this.getPort(this.conn);
        Assert.assertEquals((String)"session port should be the same as main port", (int)mainPort, (int)sessionPort);
        this.conn.add((Resource)OWL.INVERSEOF, OWL.INVERSEOF, (Value)OWL.INVERSEOF, new Resource[0]);
        this.conn.commit();
        if (oldUse != null) {
            System.setProperty("com.franz.agraph.http.useMainPortForSessions", oldUse);
        } else {
            System.clearProperty("com.franz.agraph.http.useMainPortForSessions");
        }
        if (oldOverride != null) {
            System.setProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", oldOverride);
        } else {
            System.clearProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions");
        }
    }

    private int getPort(AGRepositoryConnection conn) throws AGHttpException, MalformedURLException {
        URL url = new URL(conn.prepareHttpRepoClient().getRoot());
        return url.getPort();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sessionLifetime_rfe9436() throws Exception {
        int conn2Life = 5;
        int timeoutFudge = 2;
        int connLife = conn2Life + timeoutFudge + 10;
        int conn3Life = 30;
        AGAbstractRepository repo = this.conn.getRepository();
        AGRepositoryConnection conn1 = repo.getConnection(null);
        Assert.assertEquals((String)"expected default session lifetime ", (long)AGHttpRepoClient.getDefaultSessionLifetime(), (long)this.conn.getSessionLifetime());
        conn1.setSessionLifetime(connLife);
        Assert.assertEquals((String)("expected lifetime " + connLife), (int)connLife, (int)conn1.getSessionLifetime());
        AGRepositoryConnection conn2 = repo.getConnection(null);
        Assert.assertEquals((String)"expected default session lifetime ", (long)AGHttpRepoClient.getDefaultSessionLifetime(), (long)conn2.getSessionLifetime());
        conn2.setSessionLifetime(conn2Life);
        Assert.assertEquals((String)("expected lifetime " + conn2Life), (int)conn2Life, (int)conn2.getSessionLifetime());
        Assert.assertEquals((String)("expected lifetime " + connLife), (int)connLife, (int)conn1.getSessionLifetime());
        AGHttpRepoClient.setDefaultSessionLifetime((int)conn3Life);
        Assert.assertEquals((String)("expected default session lifetime " + conn3Life), (long)conn3Life, (long)AGHttpRepoClient.getDefaultSessionLifetime());
        AGRepositoryConnection conn3 = repo.getConnection();
        Assert.assertEquals((String)("expected session lifetime " + conn3Life), (int)conn3Life, (int)conn3.getSessionLifetime());
        Assert.assertEquals((String)("expected lifetime " + conn2Life), (int)conn2Life, (int)conn2.getSessionLifetime());
        Assert.assertEquals((String)("expected lifetime " + connLife), (int)connLife, (int)conn1.getSessionLifetime());
        Util.logTimeStamped("conn.setAutoCommit(false);");
        conn1.setAutoCommit(false);
        Util.logTimeStamped("conn2.setAutoCommit(false);");
        conn2.setAutoCommit(false);
        int sleepTime = conn2Life + timeoutFudge;
        Util.logTimeStamped("Thread.sleep(" + sleepTime * 1000 + ")");
        Thread.sleep(sleepTime * 1000);
        try {
            conn2.size(new Resource[0]);
            Assert.fail((String)"expected conn2 session to expire");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        Util.logTimeStamped("conn.ping();");
        conn1.ping();
        int orig_timeout_remaining = connLife - sleepTime;
        sleepTime = orig_timeout_remaining + timeoutFudge;
        Util.logTimeStamped("Thread.sleep(" + sleepTime * 1000 + ")");
        Thread.sleep(sleepTime * 1000);
        Util.logTimeStamped("conn.size();");
        conn1.size(new Resource[0]);
        conn3.close();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sessionLifetime_rfe14296() throws Exception {
        int connLife = 2;
        this.conn.setSessionLifetime(connLife);
        int sleepTime = 2 * connLife * 1000;
        Util.logTimeStamped("Thread.sleep(" + sleepTime + ")");
        Thread.sleep(sleepTime);
        this.conn.size(new Resource[0]);
    }
}

