/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGQueryExecution;
import com.franz.agraph.jena.AGQueryExecutionFactory;
import com.franz.agraph.jena.AGQueryFactory;
import com.franz.agraph.repository.AGUpdate;
import junit.framework.Assert;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class SparqlUpdateTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSesameUpdate() throws Exception {
        IRI s = this.vf.createIRI("http://example/book1");
        IRI p = this.vf.createIRI("http://purl.org/dc/elements/1.1/title");
        Literal o_wrong = this.vf.createLiteral("Fundamentals of Compiler Desing");
        Literal o_right = this.vf.createLiteral("Fundamentals of Compiler Design");
        IRI g = this.vf.createIRI("http://example/bookStore");
        this.conn.add((Resource)s, p, (Value)o_wrong, new Resource[]{g});
        String queryString = "PREFIX dc: <http://purl.org/dc/elements/1.1/> \nDELETE DATA { GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Desing\" } } ; \n\nPREFIX dc: <http://purl.org/dc/elements/1.1/> \nINSERT DATA { GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Design\" } }";
        AGUpdate u = this.conn.prepareUpdate(QueryLanguage.SPARQL, queryString);
        u.execute();
        Assert.assertTrue((String)"Title should be correct", (boolean)this.conn.hasStatement((Resource)s, p, (Value)o_right, false, new Resource[]{g}));
        Assert.assertFalse((String)"Incorrect title should be gone", (boolean)this.conn.hasStatement((Resource)s, p, (Value)o_wrong, false, new Resource[]{g}));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSesameUpdateViaBooleanQuery() throws Exception {
        IRI s = this.vf.createIRI("http://example/book1");
        IRI p = this.vf.createIRI("http://purl.org/dc/elements/1.1/title");
        Literal o_wrong = this.vf.createLiteral("Fundamentals of Compiler Desing");
        Literal o_right = this.vf.createLiteral("Fundamentals of Compiler Design");
        IRI g = this.vf.createIRI("http://example/bookStore");
        this.conn.add((Resource)s, p, (Value)o_wrong, new Resource[]{g});
        String queryString = "PREFIX dc: <http://purl.org/dc/elements/1.1/> \nDELETE DATA { GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Desing\" } } ; \n\nPREFIX dc: <http://purl.org/dc/elements/1.1/> \nINSERT DATA { GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Design\" } }";
        this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString).evaluate();
        Assert.assertTrue((String)"Title should be correct", (boolean)this.conn.hasStatement((Resource)s, p, (Value)o_right, false, new Resource[]{g}));
        Assert.assertFalse((String)"Incorrect title should be gone", (boolean)this.conn.hasStatement((Resource)s, p, (Value)o_wrong, false, new Resource[]{g}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testJenaUpdate() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getUnionOfAllGraphs());
        AGModel model = this.closeLater(new AGModel(graph));
        model.read(Util.resourceAsStream("/test/example.nq"), null, "NQUADS");
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)model.size());
        Assert.assertTrue((String)"Bob should be there", (boolean)model.contains(model.createResource("http://example.org/bob/foaf.rdf#me"), FOAF.name, (RDFNode)model.createLiteral("Bob")));
        Assert.assertFalse((String)"Robert should not be there", (boolean)model.contains(model.createResource("http://example.org/bob/foaf.rdf#me"), FOAF.name, (RDFNode)model.createLiteral("Robert")));
        String queryString = "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \nDELETE DATA { GRAPH <http://example.org/bob/foaf.rdf> { <http://example.org/bob/foaf.rdf#me>  foaf:name  \"Bob\" } } ; \n\nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nINSERT DATA { GRAPH <http://example.org/bob/foaf.rdf> { <http://example.org/bob/foaf.rdf#me>  foaf:name  \"Robert\" } }";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.execUpdate();
        }
        Assert.assertTrue((String)"Robert should be there", (boolean)model.contains(model.createResource("http://example.org/bob/foaf.rdf#me"), FOAF.name, (RDFNode)model.createLiteral("Robert")));
        Assert.assertFalse((String)"Bob should not be there", (boolean)model.contains(model.createResource("http://example.org/bob/foaf.rdf#me"), FOAF.name, (RDFNode)model.createLiteral("Bob")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testJenaDeleteWithoutGraphs() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getGraph());
        AGModel model = this.closeLater(new AGModel(graph));
        org.apache.jena.rdf.model.Resource subject = model.createResource("http://franz.com/s");
        Property predicate = model.createProperty("http://franz.com/p");
        String object = "object";
        model.add(subject, predicate, object);
        Assert.assertTrue((String)"Triple should be there", (boolean)model.contains(subject, predicate, object));
        String queryString = "DELETE { ?s ?p ?o } WHERE { ?s ?p ?o }";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.execUpdate();
        }
        Assert.assertFalse((String)"Triple should not be there", (boolean)model.contains(subject, predicate, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testJenaDeleteUsingGraphs() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph defaultGraph = this.closeLater(maker.getGraph());
        AGGraph g1 = this.closeLater(maker.createGraph("http://franz.com/g1"));
        AGGraph g2 = this.closeLater(maker.createGraph("http://franz.com/g2"));
        AGGraph defaultAndG1 = (AGGraph)this.closeLater(maker.createUnion(new AGGraph[]{defaultGraph, g1}));
        AGModel defaultModel = this.closeLater(new AGModel(defaultGraph));
        AGModel model1 = this.closeLater(new AGModel(g1));
        AGModel model2 = this.closeLater(new AGModel(g2));
        AGModel defaultAndM1 = this.closeLater(new AGModel(defaultAndG1));
        org.apache.jena.rdf.model.Resource subject = defaultModel.createResource("http://franz.com/s");
        Property predicate = defaultModel.createProperty("http://franz.com/p");
        String o1 = "1";
        String o2 = "2";
        String o3 = "3";
        defaultModel.add(subject, predicate, o1);
        model1.add(subject, predicate, o2);
        model2.add(subject, predicate, o3);
        Assert.assertTrue((String)"Triple 2 should be visible in graph DEFAULT + G1", (boolean)defaultAndM1.contains(subject, predicate, o2));
        String queryString = "DELETE { ?s ?p ?o } WHERE { ?s ?p ?o }";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)defaultAndM1);){
            qe.execUpdate();
        }
        Assert.assertFalse((String)"Triple 1 should not be there", (boolean)defaultModel.contains(subject, predicate, o1));
        Assert.assertFalse((String)"Triple 2 should not be there", (boolean)model1.contains(subject, predicate, o2));
        Assert.assertTrue((String)"Triple 3 should still be there", (boolean)model2.contains(subject, predicate, o3));
    }
}

