/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryResult;
import test.Util;

public class Stmt
implements Statement {
    private static final String XSD_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    private static final String XSD_LONG = "http://www.w3.org/2001/XMLSchema#long";
    private static final String XSD_DATETIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    private static final String XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private final Resource s;
    private final IRI p;
    private final Value o;
    private final Resource c;

    public Stmt(Resource s, IRI p, Value o) {
        this(s, p, o, null);
    }

    public Stmt(Statement s) {
        this(s.getSubject(), s.getPredicate(), s.getObject(), s.getContext());
    }

    public Stmt(Resource s, IRI p, Value o, Resource c) {
        this.s = s;
        this.p = p;
        this.o = o;
        this.c = c;
    }

    static Value value(BindingSet s, String bindingName) {
        Binding b = s.getBinding(bindingName);
        return b == null ? null : b.getValue();
    }

    public static Set<Stmt> stmts(Stmt ... stmts) {
        HashSet<Stmt> set = new HashSet<Stmt>(Arrays.asList(stmts));
        set.remove(null);
        return set;
    }

    public static Stmt spog(BindingSet s, String ... SPOGnames) {
        return new Stmt((Resource)Stmt.value(s, Util.get(SPOGnames, 0, "s")), (IRI)Stmt.value(s, Util.get(SPOGnames, 1, "p")), Stmt.value(s, Util.get(SPOGnames, 2, "o")), (Resource)Stmt.value(s, Util.get(SPOGnames, 3, "g")));
    }

    public static Set<Stmt> statementSet(RepositoryResult<Statement> results) throws Exception {
        try (RepositoryResult<Statement> ignored = results;){
            HashSet<Stmt> ret = new HashSet<Stmt>();
            while (results.hasNext()) {
                ret.add(new Stmt((Statement)results.next()));
            }
            HashSet<Stmt> hashSet = ret;
            return hashSet;
        }
    }

    public static Set<Stmt> stmtsSP(Collection<? extends Statement> c) throws Exception {
        HashSet<Stmt> ret = new HashSet<Stmt>();
        for (Statement statement : c) {
            ret.add(new Stmt(statement.getSubject(), statement.getPredicate(), null, null));
        }
        return ret;
    }

    public static Set<Stmt> statementSet(QueryResult<Statement> results) throws Exception {
        try (QueryResult<Statement> ignored = results;){
            HashSet<Stmt> ret = new HashSet<Stmt>();
            while (results.hasNext()) {
                ret.add(new Stmt((Statement)results.next()));
            }
            HashSet<Stmt> hashSet = ret;
            return hashSet;
        }
    }

    public static Set<Stmt> statementSet(TupleQueryResult result, String ... SPOGnames) throws Exception {
        try (TupleQueryResult ignored = result;){
            HashSet<Stmt> ret = new HashSet<Stmt>();
            while (result.hasNext()) {
                BindingSet bindingSet = (BindingSet)result.next();
                ret.add(Stmt.spog(bindingSet, SPOGnames));
            }
            HashSet<Stmt> hashSet = ret;
            return hashSet;
        }
    }

    public static Collection<Stmt> dropSubjects(Collection<Stmt> c) {
        ArrayList<Stmt> r = new ArrayList<Stmt>(c.size());
        for (Stmt s : c) {
            r.add(new Stmt(null, s.getPredicate(), s.getObject(), s.getContext()));
        }
        return r;
    }

    public static Collection<Stmt> dropSubjects(Stmt ... c) {
        ArrayList<Stmt> r = new ArrayList<Stmt>(c.length);
        for (Stmt s : c) {
            r.add(new Stmt(null, s.getPredicate(), s.getObject(), s.getContext()));
        }
        return r;
    }

    static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof Literal && b instanceof Literal) {
            Literal al = (Literal)a;
            Literal bl = (Literal)b;
            if (Stmt.eq(al.getDatatype(), bl.getDatatype())) {
                if (al.getDatatype() == null) {
                    return false;
                }
                if (Stmt.eq(al.getDatatype().toString(), XSD_FLOAT)) {
                    return (double)Math.abs(al.floatValue() - bl.floatValue()) < 0.001;
                }
                if (Stmt.eq(al.getDatatype().toString(), XSD_DATETIME)) {
                    return Stmt.eq(al.calendarValue().toGregorianCalendar(), bl.calendarValue().toGregorianCalendar());
                }
                if (Stmt.eq(al.getDatatype().toString(), XSD_LONG)) {
                    return al.longValue() == bl.longValue();
                }
                if (Stmt.eq(al.getDatatype().toString(), XSD_DOUBLE)) {
                    return al.doubleValue() == bl.doubleValue();
                }
            }
        }
        return false;
    }

    public Resource getSubject() {
        return this.s;
    }

    public IRI getPredicate() {
        return this.p;
    }

    public Value getObject() {
        return this.o;
    }

    public Resource getContext() {
        return this.c;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement o = (Statement)obj;
        return Stmt.eq(this.getSubject(), o.getSubject()) && Stmt.eq(this.getPredicate(), o.getPredicate()) && Stmt.eq(this.getObject(), o.getObject()) && Stmt.eq(this.getContext(), o.getContext());
    }

    public String toString() {
        return "[" + this.getSubject() + " " + this.getPredicate() + " " + this.getObject() + (this.getContext() == null ? "" : " " + this.getContext()) + "]";
    }

    String str(Value o) {
        return o == null ? null : "[" + o.getClass() + o + "]";
    }
}

