/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGServer;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class UserManagementTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void addDeleteUsers() throws Exception {
        List permissions;
        List users;
        String newuser1;
        block4: {
            newuser1 = "newuser1";
            String newuser2 = "newuser2";
            users = server.listUsers();
            Assert.assertTrue((String)"expected some users", (users.size() > 0 ? 1 : 0) != 0);
            if (!users.contains(newuser1)) {
                server.addUser(newuser1, "password1");
            }
            if (!users.contains(newuser2)) {
                server.addUser(newuser2, "password2");
            }
            users = server.listUsers();
            Assert.assertTrue((boolean)users.contains(newuser1));
            Assert.assertTrue((boolean)users.contains(newuser2));
            server.deleteUser(newuser2);
            users = server.listUsers();
            Assert.assertTrue((boolean)users.contains(newuser1));
            Assert.assertFalse((boolean)users.contains(newuser2));
            AGServer testServer1 = new AGServer(server.getServerURL(), newuser1, "password1");
            server.addUserPermission(newuser1, "session");
            permissions = testServer1.listUserPermissions(newuser1);
            Assert.assertTrue((boolean)permissions.contains("session"));
            server.changeUserPassword(newuser1, "newpassword1");
            try {
                permissions = testServer1.listUserPermissions(newuser1);
                Assert.fail((String)"Expected AGHttpException exception not thrown");
            }
            catch (AGHttpException c) {
                if (c.getCause() instanceof UnauthorizedException) break block4;
                Assert.fail((String)"Expected UnauthorizedException exception not thrown");
            }
        }
        AGServer testServer2 = new AGServer(server.getServerURL(), newuser1, "newpassword1");
        permissions = testServer2.listUserPermissions(newuser1);
        Assert.assertEquals((int)1, (int)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("session"));
        server.deleteUser("newuser1");
        users = server.listUsers();
        Assert.assertFalse((boolean)users.contains("newuser1"));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void userAccess() throws Exception {
        List users = server.listUsers();
        if (!users.contains("newuser1")) {
            server.addUser("newuser1", "newuser1");
        }
        if (!users.contains("newuser2")) {
            server.addUser("newuser2", "newuser2");
        }
        server.addUserAccess("newuser1", true, false, "*", null);
        server.addUserAccess("newuser2", true, true, this.repo.getCatalog().getCatalogName(), this.repo.getRepositoryID());
        JSONArray accessList = server.listUserAccess("newuser1");
        JSONObject access = accessList.getJSONObject(0);
        Assert.assertTrue((boolean)access.getBoolean("read"));
        Assert.assertFalse((boolean)access.getBoolean("write"));
        Assert.assertEquals((String)access.getString("catalog"), (String)"*");
        Assert.assertEquals((String)access.getString("repository"), (String)"*");
        accessList = server.listUserAccess("newuser2");
        access = accessList.getJSONObject(0);
        Assert.assertTrue((boolean)access.getBoolean("read"));
        Assert.assertTrue((boolean)access.getBoolean("write"));
        Assert.assertEquals((String)access.getString("catalog"), (String)this.repo.getCatalog().getCatalogName());
        Assert.assertEquals((String)access.getString("repository"), (String)this.repo.getRepositoryID());
        server.deleteUser("newuser1");
        server.deleteUser("newuser2");
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void userRoles() throws Exception {
        String user = "user-test";
        String role = "role-test";
        String role2delete = "role-to-delete";
        server.addUser("user-test", "xyzzy");
        Assert.assertTrue((boolean)server.listUsers().contains("user-test"));
        server.addUserAccess("user-test", true, true, null, null);
        JSONArray accessList = server.listUserEffectiveAccess("user-test");
        Assert.assertEquals((int)1, (int)accessList.length());
        JSONObject access = accessList.getJSONObject(0);
        Assert.assertTrue((boolean)access.getBoolean("read"));
        Assert.assertTrue((boolean)access.getBoolean("write"));
        Assert.assertEquals((String)access.getString("catalog"), (String)"*");
        Assert.assertEquals((String)access.getString("repository"), (String)"*");
        List permissions = server.listUserPermissions("user-test");
        Assert.assertTrue((boolean)permissions.isEmpty());
        permissions = server.listUserEffectivePermissions("user-test");
        Assert.assertTrue((boolean)permissions.isEmpty());
        server.addUserPermission("user-test", "eval");
        server.addUserPermission("user-test", "replication");
        server.deleteUserPermission("user-test", "replication");
        permissions = server.listUserPermissions("user-test");
        Assert.assertEquals((int)1, (int)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("eval"));
        List roles = server.listRoles();
        Assert.assertEquals((int)0, (int)roles.size());
        server.addRole("role-test");
        server.addRole("role-to-delete");
        roles = server.listRoles();
        Assert.assertEquals((int)2, (int)roles.size());
        server.addRoleAccess("role-to-delete", true, true, "/", "*");
        accessList = server.listRoleAccess("role-to-delete");
        Assert.assertEquals((int)1, (int)accessList.length());
        access = accessList.getJSONObject(0);
        Assert.assertTrue((boolean)access.getBoolean("read"));
        Assert.assertTrue((boolean)access.getBoolean("write"));
        Assert.assertEquals((String)access.getString("catalog"), (String)"/");
        Assert.assertEquals((String)access.getString("repository"), (String)"*");
        server.addRoleSecurityFilter("role-to-delete", "allow", "<http://allowed>", null, null, null);
        JSONArray filters = server.listRoleSecurityFilters("role-to-delete", "allow");
        JSONObject filter = filters.getJSONObject(0);
        Assert.assertEquals((String)"<http://allowed>", (String)filter.optString("s"));
        Assert.assertEquals((String)"", (String)filter.optString("p"));
        Assert.assertEquals((String)"", (String)filter.optString("o"));
        Assert.assertEquals((String)"", (String)filter.optString("g"));
        server.deleteRoleSecurityFilter("role-to-delete", "allow", "<http://allowed>", null, null, null);
        filters = server.listRoleSecurityFilters("role-to-delete", "allow");
        Assert.assertEquals((int)0, (int)filters.length());
        server.addUserRole("user-test", "role-to-delete");
        accessList = server.listUserEffectiveAccess("user-test");
        Assert.assertEquals((int)2, (int)accessList.length());
        server.addUserSecurityFilter("user-test", "allow", "<http://allowed>", null, null, null);
        filters = server.listUserSecurityFilters("user-test", "allow");
        Assert.assertEquals((int)1, (int)filters.length());
        filter = filters.getJSONObject(0);
        Assert.assertEquals((String)"<http://allowed>", (String)filter.optString("s"));
        Assert.assertEquals((String)"", (String)filter.optString("p"));
        Assert.assertEquals((String)"", (String)filter.optString("o"));
        Assert.assertEquals((String)"", (String)filter.optString("g"));
        server.deleteUserSecurityFilter("user-test", "allow", "<http://allowed>", null, null, null);
        server.deleteUserRole("user-test", "role-to-delete");
        server.deleteRoleAccess("role-to-delete", true, true, "/", "*");
        accessList = server.listRoleAccess("role-to-delete");
        Assert.assertEquals((int)0, (int)accessList.length());
        server.deleteRole("role-to-delete");
        roles = server.listRoles();
        Assert.assertEquals((int)1, (int)roles.size());
        server.addRolePermission("role-test", "eval");
        server.addRolePermission("role-test", "session");
        server.deleteRolePermission("role-test", "eval");
        permissions = server.listRolePermissions("role-test");
        Assert.assertEquals((int)1, (int)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("session"));
        server.addUserRole("user-test", "role-test");
        roles = server.listUserRoles("user-test");
        Assert.assertEquals((int)1, (int)roles.size());
        Assert.assertTrue((boolean)roles.contains("role-test"));
        permissions = server.listUserEffectivePermissions("user-test");
        Assert.assertEquals((int)2, (int)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("eval"));
        Assert.assertTrue((boolean)permissions.contains("session"));
        roles = server.listRoles();
        server.deleteUserRole("user-test", "role-test");
        roles = server.listUserRoles("user-test");
        Assert.assertTrue((boolean)roles.isEmpty());
        server.deleteRole("role-test");
        roles = server.listRoles();
        Assert.assertTrue((boolean)roles.isEmpty());
        server.deleteUserAccess("user-test", true, true, null, null);
        accessList = server.listUserAccess("user-test");
        Assert.assertEquals((int)0, (int)accessList.length());
        server.deleteUser("user-test");
        Assert.assertFalse((boolean)server.listUsers().contains("user-test"));
    }
}

