/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.WarmupConfig;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class WarmupTests
extends AGAbstractTest {
    private int logLengthBeforeTest;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.logLengthBeforeTest = Util.getLogSize(server);
    }

    private void assertTriplesWarmedUpRecently() {
        Util.assertTriplesWarmedUpRecently(server, this.logLengthBeforeTest, "javatest");
    }

    private void assertStringsWarmedUpRecently() {
        Util.assertStringsWarmedUpRecently(server, this.logLengthBeforeTest, "javatest");
    }

    private void assertTriplesNotWarmedUpRecently() {
        Util.assertTriplesNotWarmedUpRecently(server, this.logLengthBeforeTest, "javatest");
    }

    private void assertStringsNotWarmedUpRecently() {
        Util.assertStringsNotWarmedUpRecently(server, this.logLengthBeforeTest, "javatest");
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testServerDefaultWarmup() {
        this.conn.warmup();
        this.assertStringsWarmedUpRecently();
        this.assertTriplesWarmedUpRecently();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testDefaultWarmup() {
        this.conn.warmup(WarmupConfig.create());
        this.assertStringsWarmedUpRecently();
        this.assertTriplesWarmedUpRecently();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testWarmupNoStrings() {
        this.conn.warmup(WarmupConfig.create().excludeStrings());
        this.assertStringsNotWarmedUpRecently();
        this.assertTriplesWarmedUpRecently();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testWarmupNoTriples() {
        this.conn.warmup(WarmupConfig.create().excludeTriples());
        this.assertStringsWarmedUpRecently();
        this.assertTriplesNotWarmedUpRecently();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testWarmupNothing() {
        this.conn.warmup(WarmupConfig.create().excludeStrings().excludeTriples());
        this.assertStringsNotWarmedUpRecently();
        this.assertTriplesNotWarmedUpRecently();
    }
}

