/*
 * Decompiled with CFR 0.152.
 */
package test.lubm;

import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGQueryLanguage;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGTupleQuery;
import java.util.Calendar;
import org.eclipse.rdf4j.OpenRDFException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.QueryLanguage;

public class AGLubmProlog {
    public static String SERVER_URL = System.getProperty("com.franz.agraph.serverURL", "http://localhost:10035");
    public static String CATALOG_ID = System.getProperty("com.franz.agraph.catalogID", "/");
    public static String REPOSITORY_ID = System.getProperty("com.franz.agraph.repositoryID", "LUBM-50");
    public static String USERNAME = System.getProperty("com.franz.agraph.username", "test");
    public static String PASSWORD = System.getProperty("com.franz.agraph.password", "xyzzy");
    public static String UBNAMESPACE = System.getProperty("com.franz.agraph.lubm.ubnamespace", "http://www.lehigh.edu/%7Ezhp2/2004/0401/univ-bench.owl#");
    public static int ITERATIONS = Integer.parseInt(System.getProperty("com.franz.agraph.lubm.iterations", "3"));

    public static void main(String[] args) throws OpenRDFException {
        AGCatalog catalog;
        AGServer server = new AGServer(SERVER_URL, USERNAME, PASSWORD);
        if (!server.listCatalogs().contains(CATALOG_ID)) {
            System.out.println("No catalog '" + CATALOG_ID + "' found.");
            System.exit(1);
        }
        if (!(catalog = server.getCatalog(CATALOG_ID)).listRepositories().contains(REPOSITORY_ID)) {
            System.out.println("No repository '" + REPOSITORY_ID + "' found in catalog " + CATALOG_ID);
            System.exit(1);
        }
        AGRepository repo = catalog.createRepository(REPOSITORY_ID);
        repo.initialize();
        AGRepositoryConnection conn = repo.getConnection();
        System.out.println("Connected to " + repo.getRepositoryURL() + ": " + conn.size(new Resource[0]) + " triples.");
        conn.setNamespace("ub", UBNAMESPACE);
        conn.setNamespace("u0d0", "http://www.Department0.University0.edu/");
        String rule = "(<-- (Chair ?x1)(q ?x1 !ub:headOf ?y)(q ?x1 !rdf:type !ub:Person)(q ?y !rdf:type !ub:Department))";
        conn.addRules(rule);
        for (int iter = 1; iter <= ITERATIONS; ++iter) {
            System.out.println("\nIteration " + iter + ":");
            AGLubmProlog.doQuery1(conn);
            AGLubmProlog.doQuery2(conn);
            AGLubmProlog.doQuery3(conn);
            AGLubmProlog.doQuery4(conn);
            AGLubmProlog.doQuery5(conn);
            AGLubmProlog.doQuery6(conn);
            AGLubmProlog.doQuery7(conn);
            AGLubmProlog.doQuery8(conn);
            AGLubmProlog.doQuery9(conn);
            AGLubmProlog.doQuery10(conn);
            AGLubmProlog.doQuery11(conn);
            AGLubmProlog.doQuery12(conn);
            AGLubmProlog.doQuery13(conn);
            AGLubmProlog.doQuery14(conn);
        }
        conn.close();
        repo.shutDown();
    }

    public static void doQuery1(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x) (:count-only t)(q ?x !ub:takesCourse !u0d0:GraduateCourse0)(q ?x !rdf:type !ub:GraduateStudent))";
        AGLubmProlog.doQuery(ts, 1, query);
    }

    public static void doQuery2(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x ?y ?z) (:count-only t)(:distinct t) (:reorder nil)(q- ?z !rdf:type !ub:Department)(q- ?z !ub:subOrganizationOf ?y)(q- ?x !ub:undergraduateDegreeFrom ?y)(q- ?x !ub:memberOf ?z)(q- ?x !rdf:type !ub:GraduateStudent)(q- ?y !rdf:type !ub:University))";
        AGLubmProlog.doQuery(ts, 2, query);
    }

    public static void doQuery3(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x) (:count-only t)(q ?x !ub:publicationAuthor !u0d0:AssistantProfessor0)(q ?x !rdf:type !ub:Publication))";
        AGLubmProlog.doQuery(ts, 3, query);
    }

    public static void doQuery4(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x ?name ?email ?telephone) (:count-only t)(q ?x !ub:worksFor !<http://www.Department0.University0.edu>)(q ?x !rdf:type !ub:Professor)(q ?x !ub:name ?name)(q ?x !ub:emailAddress ?email)(q ?x !ub:telephone ?telephone))";
        AGLubmProlog.doQuery(ts, 4, query);
    }

    public static void doQuery5(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x) (:count-only t)(q ?x !ub:memberOf !<http://www.Department0.University0.edu>)(q ?x !rdf:type !ub:Person))";
        AGLubmProlog.doQuery(ts, 5, query);
    }

    public static void doQuery6(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x) (:distinct t) (:count-only t)(q ?x !rdf:type !ub:Student))";
        AGLubmProlog.doQuery(ts, 6, query);
    }

    public static void doQuery7(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x ?y) (:count-only t)(q !u0d0:AssociateProfessor0 !ub:teacherOf ?y)(q ?y !rdf:type !ub:Course)(q ?x !ub:takesCourse ?y)(q ?x !rdf:type !ub:Student))";
        AGLubmProlog.doQuery(ts, 7, query);
    }

    public static void doQuery8(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?y ?x ?email) (:count-only t)(q ?y !ub:subOrganizationOf !<http://www.University0.edu>)(q ?y !rdf:type !ub:Department)(q ?x !ub:memberOf ?y)(q ?x !rdf:type !ub:Student)(q ?x !ub:emailAddress ?email))";
        AGLubmProlog.doQuery(ts, 8, query);
    }

    public static void doQuery9(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x ?y ?z) (:count-only t)(q ?x !ub:advisor ?y)(q ?x !ub:takesCourse ?z)(q ?y !ub:teacherOf ?z)(q ?x !rdf:type !ub:Student)(q ?y !rdf:type !ub:Faculty)(q ?z !rdf:type !ub:Course))";
        AGLubmProlog.doQuery(ts, 9, query);
    }

    public static void doQuery10(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x) (:count-only t)(q ?x !ub:takesCourse !u0d0:GraduateCourse0)(q ?x !rdf:type !ub:Student))";
        AGLubmProlog.doQuery(ts, 10, query);
    }

    public static void doQuery11(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x) (:count-only t)(q ?x !ub:subOrganizationOf !<http://www.University0.edu>)(q ?x !rdf:type !ub:ResearchGroup))";
        AGLubmProlog.doQuery(ts, 11, query);
    }

    public static void doQuery12(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x ?y) (:count-only t)(q ?y !ub:subOrganizationOf !<http://www.University0.edu>)(q ?y !rdf:type !ub:Department)(q ?x !ub:memberOf ?y)(Chair ?x))";
        AGLubmProlog.doQuery(ts, 12, query);
    }

    public static void doQuery13(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x) (:count-only t)(q !<http://www.University0.edu> !ub:hasAlumnus ?x)(q ?x !rdf:type !ub:Person))";
        AGLubmProlog.doQuery(ts, 13, query);
    }

    public static void doQuery14(AGRepositoryConnection ts) throws OpenRDFException {
        String query = "(select0 (?x) (:distinct t) (:count-only t)(q ?x !rdf:type !ub:UndergraduateStudent))";
        AGLubmProlog.doQuery(ts, 14, query);
    }

    public static void doQuery(AGRepositoryConnection conn, int qi, String query) throws OpenRDFException {
        System.out.format("[%tT]Query %2d:", Calendar.getInstance(), qi);
        AGTupleQuery tupleQuery = conn.prepareTupleQuery((QueryLanguage)AGQueryLanguage.PROLOG, query);
        long begin = System.nanoTime();
        tupleQuery.setIncludeInferred(true);
        long n = tupleQuery.count();
        long delta = System.nanoTime() - begin;
        System.out.format("%9d answers in %6d milliseconds.%n", n, delta / 1000000L);
    }
}

