/*
 * Decompiled with CFR 0.152.
 */
package test.openrdf.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.StatementImpl;
import org.eclipse.rdf4j.model.util.Namespaces;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.DatasetImpl;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnectionTest;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.contextaware.ContextAwareConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import test.AGAbstractTest;
import test.Util;

public class AGRepositoryConnectionTest
extends RepositoryConnectionTest {
    public static final String TEST_DATA_DIR = "/test/";

    public AGRepositoryConnectionTest() {
        super((IsolationLevel)IsolationLevels.SNAPSHOT);
    }

    protected Repository createRepository() throws Exception {
        return AGAbstractTest.sharedRepository();
    }

    public void testDeleteDefaultGraph() throws Exception {
        super.testDeleteDefaultGraph();
    }

    public void testDefaultContext() throws Exception {
        super.testDefaultContext();
    }

    public void testDefaultInsertContext() throws Exception {
        super.testDefaultInsertContext();
    }

    @Test
    public void testDefaultInsertContextNull() throws Exception {
        ContextAwareConnection con = new ContextAwareConnection(this.testCon);
        IRI defaultGraph = null;
        con.setInsertContext(defaultGraph);
        con.add((Resource)this.vf.createIRI("urn:test:s1"), this.vf.createIRI("urn:test:p1"), (Value)this.vf.createIRI("urn:test:o1"), new Resource[0]);
        con.prepareUpdate("INSERT DATA { <urn:test:s2> <urn:test:p2> \"l2\" }").execute();
        Assert.assertEquals((long)2L, (long)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size());
        Assert.assertEquals((long)2L, (long)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[]{defaultGraph})).size());
        Assert.assertEquals((long)2L, (long)this.size(defaultGraph));
        con.add((Resource)this.vf.createIRI("urn:test:s3"), this.vf.createIRI("urn:test:p3"), (Value)this.vf.createIRI("urn:test:o3"), new Resource[]{null});
        con.add((Resource)this.vf.createIRI("urn:test:s4"), this.vf.createIRI("urn:test:p4"), (Value)this.vf.createIRI("urn:test:o4"), new Resource[]{this.vf.createIRI("urn:test:other")});
        Assert.assertEquals((long)4L, (long)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size());
        Assert.assertEquals((long)3L, (long)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[]{defaultGraph})).size());
        Assert.assertEquals((long)4L, (long)Iterations.asList((Iteration)this.testCon.getStatements(null, null, null, true, new Resource[0])).size());
        Assert.assertEquals((long)3L, (long)this.size(defaultGraph));
        Assert.assertEquals((long)1L, (long)this.size(this.vf.createIRI("urn:test:other")));
        con.prepareUpdate("DELETE { ?s ?p ?o } WHERE { ?s ?p ?o }").execute();
        Assert.assertEquals((long)0L, (long)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size());
        Assert.assertEquals((long)0L, (long)Iterations.asList((Iteration)this.testCon.getStatements(null, null, null, true, new Resource[0])).size());
        Assert.assertEquals((long)0L, (long)this.size(defaultGraph));
        Assert.assertEquals((long)0L, (long)this.size(this.vf.createIRI("urn:test:other")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size(IRI defaultGraph) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        TupleQuery qry = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * { ?s ?p ?o }");
        DatasetImpl dataset = new DatasetImpl();
        dataset.addDefaultGraph(defaultGraph);
        qry.setDataset((Dataset)dataset);
        try (TupleQueryResult result = qry.evaluate();){
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Ignore
    public void testExclusiveNullContext() throws Exception {
    }

    public void testOrderByQueriesAreInterruptable() throws Exception {
        this.testCon.setAutoCommit(false);
        ArrayList<StatementImpl> stmts = new ArrayList<StatementImpl>();
        for (int index = 0; index < 512; ++index) {
            stmts.add(new StatementImpl((Resource)RDFS.CLASS, (URI)RDFS.COMMENT, (Value)this.testCon.getValueFactory().createBNode()));
        }
        this.testCon.add(stmts, new Resource[0]);
        this.testCon.setAutoCommit(true);
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * WHERE { ?s ?p ?o . ?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . ?s3 ?p3 ?o3 } ORDER BY ?s1 ?p1 ?o1 LIMIT 1000");
        query.setMaxQueryTime(2);
        long startTime = System.currentTimeMillis();
        try {
            TupleQueryResult result = query.evaluate();
            result.hasNext();
            Assert.fail((String)"Query should have been interrupted");
        }
        catch (QueryInterruptedException e) {
            long duration = System.currentTimeMillis() - startTime;
            Assert.assertTrue((String)("Query not interrupted quickly enough, should have been ~2s, but was " + duration / 1000L + "s"), (duration < 5000L ? 1 : 0) != 0);
        }
    }

    public void testXmlCalendarZ() throws Exception {
        super.testXmlCalendarZ();
    }

    public void testSES713() throws Exception {
        super.testSES713();
    }

    public void testBaseURIInQueryString() throws Exception {
        this.testCon.add((Resource)this.vf.createIRI("urn:test:s1"), this.vf.createIRI("urn:test:p1"), (Value)this.vf.createIRI("urn:test:o1"), new Resource[0]);
        try (TupleQueryResult rs = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "BASE <urn:test:s1> SELECT * { <> ?p ?o }").evaluate();){
            Assert.assertTrue((boolean)rs.hasNext());
        }
    }

    public void testBaseURIInParam() throws Exception {
        this.testCon.add((Resource)this.vf.createIRI("http://example.org/s1"), this.vf.createIRI("urn:test:p1"), (Value)this.vf.createIRI("urn:test:o1"), new Resource[0]);
        try (TupleQueryResult rs = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * { <s1> ?p ?o }", "http://example.org").evaluate();){
            Assert.assertTrue((boolean)rs.hasNext());
        }
    }

    public void testBaseURIInParamWithTrailingSlash() throws Exception {
        this.testCon.add((Resource)this.vf.createIRI("http://example.org/s1"), this.vf.createIRI("urn:test:p1"), (Value)this.vf.createIRI("urn:test:o1"), new Resource[0]);
        try (TupleQueryResult rs = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * { <s1> ?p ?o }", "http://example.org/").evaluate();){
            Assert.assertTrue((boolean)rs.hasNext());
        }
    }

    @Test
    public void testHasStatementWithoutBNodes() throws Exception {
        this.testCon.add((Resource)this.name, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.name, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    @Test
    public void testHasStatementWithBNodes() throws Exception {
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddGzipInputStreamNTriples() throws Exception {
        File gz = File.createTempFile("default-graph.nt-", ".gz");
        File nt = new File("/test/default-graph.nt");
        Util.gzip(nt, gz);
        try (FileInputStream defaultGraph = new FileInputStream(gz);){
            this.testCon.add((InputStream)defaultGraph, "", RDFFormat.NTRIPLES, new Resource[0]);
        }
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
    }

    @Test
    public void testAddZipFileNTriples() throws Exception {
        InputStream in = Util.resourceAsStream("/test/graphs.nt.zip");
        this.testCon.add(in, "", RDFFormat.NTRIPLES, new Resource[0]);
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddReaderNTriples() throws Exception {
        InputStream defaultGraphStream = Util.resourceAsStream("/test/default-graph.nt");
        InputStreamReader defaultGraph = new InputStreamReader(defaultGraphStream, "UTF-8");
        this.testCon.add((Reader)defaultGraph, "", RDFFormat.NTRIPLES, new Resource[0]);
        ((Reader)defaultGraph).close();
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        InputStream graph1Stream = Util.resourceAsStream("/test/graph1.nt");
        try (InputStreamReader graph1 = new InputStreamReader(graph1Stream, "UTF-8");){
            this.testCon.add((Reader)graph1, "", RDFFormat.NTRIPLES, new Resource[]{this.context1});
        }
        InputStream graph2Stream = Util.resourceAsStream("/test/graph2.nt");
        try (InputStreamReader graph2 = new InputStreamReader(graph2Stream, "UTF-8");){
            this.testCon.add((Reader)graph2, "", RDFFormat.NTRIPLES, new Resource[]{this.context2});
        }
        Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        Assert.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddInputStreamNTriples() throws Exception {
        try (InputStream defaultGraph = Util.resourceAsStream("/test/default-graph.nt");){
            this.testCon.add(defaultGraph, "", RDFFormat.NTRIPLES, new Resource[0]);
        }
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        try (InputStream graph1 = Util.resourceAsStream("/test/graph1.nt");){
            this.testCon.add(graph1, "", RDFFormat.NTRIPLES, new Resource[]{this.context1});
        }
        try (InputStream graph2 = Util.resourceAsStream("/test/graph2.nt");){
            this.testCon.add(graph2, "", RDFFormat.NTRIPLES, new Resource[]{this.context2});
        }
        Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        Assert.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    @Test
    public void testRecoverFromParseErrorNTriples() throws RepositoryException, IOException {
        String invalidData = "bad";
        String validData = "<http://example.org/foo#a> <http://example.org/foo#b> <http://example.org/foo#c> .";
        try {
            this.testCon.add((Reader)new StringReader(invalidData), "", RDFFormat.NTRIPLES, new Resource[0]);
            Assert.fail((String)"Invalid data should result in an exception");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
        try {
            this.testCon.add((Reader)new StringReader(validData), "", RDFFormat.NTRIPLES, new Resource[0]);
        }
        catch (RDFParseException e) {
            Assert.fail((String)"Valid data should not result in an exception");
        }
        Assert.assertEquals((String)"Repository contains incorrect number of statements", (long)1L, (long)this.testCon.size(new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTupleQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?name ?mbox");
        queryBuilder.append(" WHERE { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        try (TupleQueryResult result = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("name"));
                Assert.assertTrue((boolean)solution.hasBinding("mbox"));
                Value nameResult = solution.getValue("name");
                Value mboxResult = solution.getValue("mbox");
                Assert.assertTrue((this.nameAlice.equals((Object)nameResult) || this.nameBob.equals((Object)nameResult) ? 1 : 0) != 0);
                Assert.assertTrue((this.mboxAlice.equals((Object)mboxResult) || this.mboxBob.equals((Object)mboxResult) ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTupleQueryUnicode() throws Exception {
        this.testCon.add(this.alexander, this.name, (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?person");
        queryBuilder.append(" WHERE { ?person foaf:name '");
        queryBuilder.append(this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440.getLabel()).append("' .}");
        try (TupleQueryResult result = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("person"));
                Assert.assertEquals((Object)this.alexander, (Object)solution.getValue("person"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedTupleQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?name ?mbox");
        queryBuilder.append(" WHERE { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding("name", (Value)this.nameBob);
        try (TupleQueryResult result = query.evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("name"));
                Assert.assertTrue((boolean)solution.hasBinding("mbox"));
                Value nameResult = solution.getValue("name");
                Value mboxResult = solution.getValue("mbox");
                Assert.assertEquals((String)("unexpected value for name: " + nameResult), (Object)this.nameBob, (Object)nameResult);
                Assert.assertEquals((String)("unexpected value for mbox: " + mboxResult), (Object)this.mboxBob, (Object)mboxResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreparedTupleQuery2() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?name ?mbox");
        queryBuilder.append(" WHERE { ?x foaf:name ?name;");
        queryBuilder.append("            foaf:mbox ?mbox .}");
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding("x", (Value)this.bob);
        try (TupleQueryResult result = query.evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("name"));
                Assert.assertTrue((boolean)solution.hasBinding("mbox"));
                Value nameResult = solution.getValue("name");
                Value mboxResult = solution.getValue("mbox");
                Assert.assertEquals((String)("unexpected value for name: " + nameResult), (Object)this.nameBob, (Object)nameResult);
                Assert.assertEquals((String)("unexpected value for mbox: " + mboxResult), (Object)this.mboxBob, (Object)mboxResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedTupleQueryUnicode() throws Exception {
        this.testCon.add(this.alexander, this.name, (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?person");
        queryBuilder.append(" WHERE { ?person foaf:name '");
        queryBuilder.append(this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440.getLabel()).append("' .}");
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding("name", (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440);
        try (TupleQueryResult result = query.evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("person"));
                Assert.assertEquals((Object)this.alexander, (Object)solution.getValue("person"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleGraphQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" CONSTRUCT { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        queryBuilder.append(" WHERE { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        try (GraphQueryResult result = this.testCon.prepareGraphQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                Statement st = (Statement)result.next();
                if (this.name.equals((Object)st.getPredicate())) {
                    Assert.assertTrue((this.nameAlice.equals((Object)st.getObject()) || this.nameBob.equals((Object)st.getObject()) ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((boolean)this.mbox.equals((Object)st.getPredicate()));
                Assert.assertTrue((this.mboxAlice.equals((Object)st.getObject()) || this.mboxBob.equals((Object)st.getObject()) ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedGraphQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" CONSTRUCT { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        queryBuilder.append(" WHERE { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        GraphQuery query = this.testCon.prepareGraphQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding("name", (Value)this.nameBob);
        try (GraphQueryResult result = query.evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                Statement st = (Statement)result.next();
                Assert.assertTrue((this.name.equals((Object)st.getPredicate()) || this.mbox.equals((Object)st.getPredicate()) ? 1 : 0) != 0);
                if (this.name.equals((Object)st.getPredicate())) {
                    Assert.assertTrue((String)("unexpected value for name: " + st.getObject()), (boolean)this.nameBob.equals((Object)st.getObject()));
                    continue;
                }
                Assert.assertTrue((boolean)this.mbox.equals((Object)st.getPredicate()));
                Assert.assertTrue((String)("unexpected value for mbox: " + st.getObject()), (boolean)this.mboxBob.equals((Object)st.getObject()));
            }
        }
    }

    @Test
    public void testPrepareSeRQLQuery() throws Exception {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" SELECT person");
        queryBuilder.append(" FROM {person} foaf:name {").append(this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440.getLabel()).append("}");
        queryBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
        try {
            this.testCon.prepareQuery(QueryLanguage.SERQL, queryBuilder.toString());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ClassCastException e) {
            Assert.fail((String)("unexpected query object type: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStatementsInMultipleContexts() throws Exception {
        Statement st;
        int count;
        this.testCon.clear(new Resource[0]);
        this.testCon.begin();
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.commit();
        try (RepositoryResult iter = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});){
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsNull.nullValue(Resource.class)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2))));
            }
            Assert.assertEquals((String)"there should be three statements", (long)3L, (long)count);
        }
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
        try {
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2)));
            }
            Assert.assertEquals((String)"there should be two statements", (long)2L, (long)count);
        }
        finally {
            iter.close();
        }
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext, this.context2});
        try {
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2)));
            }
            Assert.assertEquals((String)"there should be two statements", (long)2L, (long)count);
        }
        finally {
            iter.close();
        }
        this.testCon.begin();
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        this.testCon.commit();
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
        try {
            Assert.assertThat((Object)iter, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        }
        finally {
            iter.close();
        }
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});
        try {
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsNull.nullValue(Resource.class)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2))));
            }
            Assert.assertEquals((String)"there should be four statements", (long)4L, (long)count);
        }
        finally {
            iter.close();
        }
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
        try {
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context1)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2))));
            }
            Assert.assertEquals((String)"there should be four statements", (long)4L, (long)count);
        }
        finally {
            iter.close();
        }
    }

    public void testOptionalFilter() throws Exception {
        String optional = "{ ?s :p1 ?v1 OPTIONAL {?s :p2 ?v2 FILTER(?v1<3) } }";
        IRI s = this.vf.createIRI("urn:test:s");
        IRI p1 = this.vf.createIRI("urn:test:p1");
        IRI p2 = this.vf.createIRI("urn:test:p2");
        Literal v1 = this.vf.createLiteral(1);
        Literal v2 = this.vf.createLiteral(2);
        Literal v3 = this.vf.createLiteral(3);
        this.testCon.add((Resource)s, p1, (Value)v1, new Resource[0]);
        this.testCon.add((Resource)s, p2, (Value)v2, new Resource[0]);
        this.testCon.add((Resource)s, p1, (Value)v3, new Resource[0]);
        String qry = "PREFIX :<urn:test:> SELECT ?s ?v1 ?v2 WHERE " + optional;
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, qry);
        TupleQueryResult result = query.evaluate();
        HashSet<List<Value>> set = new HashSet<List<Value>>();
        while (result.hasNext()) {
            BindingSet bindings = (BindingSet)result.next();
            set.add(Arrays.asList(bindings.getValue("v1"), bindings.getValue("v2")));
        }
        result.close();
        Assert.assertThat(set, (Matcher)JUnitMatchers.hasItem(Arrays.asList(v1, v2)));
        Assert.assertThat(set, (Matcher)JUnitMatchers.hasItem(Arrays.asList(v3, null)));
    }

    public void testOrPredicate() throws Exception {
        String union = "{ :s ?p :o FILTER (?p = :p1 || ?p = :p2) }";
        IRI s = this.vf.createIRI("urn:test:s");
        IRI p1 = this.vf.createIRI("urn:test:p1");
        IRI p2 = this.vf.createIRI("urn:test:p2");
        IRI o = this.vf.createIRI("urn:test:o");
        this.testCon.add((Resource)s, p1, (Value)o, new Resource[0]);
        this.testCon.add((Resource)s, p2, (Value)o, new Resource[0]);
        String qry = "PREFIX :<urn:test:> SELECT ?p WHERE " + union;
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, qry);
        TupleQueryResult result = query.evaluate();
        ArrayList<Value> list = new ArrayList<Value>();
        while (result.hasNext()) {
            BindingSet bindings = (BindingSet)result.next();
            list.add(bindings.getValue("p"));
        }
        result.close();
        Assert.assertThat(list, (Matcher)JUnitMatchers.hasItem((Object)p1));
        Assert.assertThat(list, (Matcher)JUnitMatchers.hasItem((Object)p2));
    }

    public void testGraphSerialization() throws Exception {
        LinkedHashModel graph;
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        try (RepositoryResult statements = this.testCon.getStatements(null, null, null, true, new Resource[0]);){
            graph = new LinkedHashModel((Collection)Iterations.asList((Iteration)statements));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(graph);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        Model deserializedGraph = (Model)in.readObject();
        in.close();
        Assert.assertThat((Object)deserializedGraph.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        for (Statement st : deserializedGraph) {
            Assert.assertThat((Object)graph, (Matcher)JUnitMatchers.hasItem((Object)st));
            Assert.assertThat((Object)this.testCon.hasStatement(st, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        }
    }

    public void testGetNamespaces() throws Exception {
        this.setupNamespaces();
        Map map = Namespaces.asMap((Set)Iterations.asSet((Iteration)this.testCon.getNamespaces()));
        Assert.assertThat((Object)map.size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)3)));
        Assert.assertThat(map.keySet(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"example", "rdfs", "rdf"}));
        Assert.assertThat(map.get("example"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"http://example.org/")));
        Assert.assertThat(map.get("rdfs"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"http://www.w3.org/2000/01/rdf-schema#")));
        Assert.assertThat(map.get("rdf"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#")));
    }

    private void setupNamespaces() throws IOException, RDFParseException, RepositoryException {
        this.testCon.setNamespace("example", "http://example.org/");
        this.testCon.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.testCon.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.testCon.add((Resource)this.vf.createIRI("http://example.org/", "Main"), this.vf.createIRI("http://www.w3.org/2000/01/rdf-schema#", "label"), (Value)this.vf.createLiteral("Main Node"), new Resource[0]);
    }
}

