/*
 * Decompiled with CFR 0.152.
 */
package test.stress;

import com.franz.agraph.pool.AGConnPool;
import com.franz.agraph.pool.AGConnProp;
import com.franz.agraph.pool.AGPoolProp;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGQueryLanguage;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGStreamTupleQuery;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.util.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;
import test.AGAbstractTest;
import test.Util;

public class Events
implements Closeable {
    static final long START = System.currentTimeMillis();
    private static final Util.RandomLong RANDOM = new Util.RandomLong();
    private static final RandomDateMaker BaselineRange = new RandomDateMaker(new GregorianCalendar(2008, 0, 1), new GregorianCalendar(2008, 1, 1));
    private static final RandomDateMaker BulkRange = new RandomDateMaker(Events.BaselineRange.end, new GregorianCalendar(2009, 0, 1));
    private static final RandomDateMaker SmallCommitsRange = new RandomDateMaker(Events.BulkRange.end, new GregorianCalendar(2009, 1, 1));
    private static final RandomDateMaker DeleteRangeOne = new RandomDateMaker(Events.BaselineRange.start, new GregorianCalendar(2008, 0, 31));
    private static final RandomDateMaker DeleteRangeTwo = new RandomDateMaker(Events.DeleteRangeOne.end, Events.BaselineRange.end);
    private static final RandomDateMaker FullDateRange = new RandomDateMaker(Events.BaselineRange.start, Events.SmallCommitsRange.end);
    private static AGRepository repoPool;
    private final Closer closer = new Closer();
    List<PhaseMeasures> phaseMeasures = new ArrayList<PhaseMeasures>();
    private int errors;

    static double logtime(double time) {
        return Defaults.LOG == Defaults.LOGT.NOTIME ? 0.0 : time;
    }

    public static void trace(String format, Object ... values) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        if (Defaults.LOG == Defaults.LOGT.ALL) {
            formatter.format("%s [%2$tF %2$tT.%2$tL]: ", Thread.currentThread().getName(), GregorianCalendar.getInstance());
        } else if (Defaults.LOG == Defaults.LOGT.ELAPSED) {
            formatter.format("%s [%d]: ", Thread.currentThread().getName(), System.currentTimeMillis() - START);
        } else if (Defaults.LOG == Defaults.LOGT.NOTIME) {
            formatter.format("%s: ", Thread.currentThread().getName());
        }
        formatter.format(format, values);
        System.out.println(sb.toString());
        formatter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void MaybeInitializePool() {
        if (Defaults.POOL_SIZE == 0) {
            return;
        }
        try {
            String myServerUrl = Defaults.URL;
            String myUsername = Defaults.USERNAME;
            String myPassword = Defaults.PASSWORD;
            String myCatalog = Defaults.CATALOG;
            String myRepo = Defaults.REPOSITORY;
            AGConnPool pool = AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, myServerUrl, AGConnProp.username, myUsername, AGConnProp.password, myPassword, AGConnProp.catalog, myCatalog, AGConnProp.repository, myRepo, AGConnProp.session, Defaults.SHARED ? AGConnProp.Session.SHARED : AGConnProp.Session.DEDICATED, AGConnProp.sessionLifetime, TimeUnit.MINUTES.toSeconds(10L), AGPoolProp.testOnBorrow, true, AGPoolProp.timeBetweenEvictionRunsMillis, TimeUnit.SECONDS.toMillis(120L), AGPoolProp.minEvictableIdleTimeMillis, TimeUnit.SECONDS.toMillis(120L), AGPoolProp.maxWait, TimeUnit.SECONDS.toMillis(60L), AGPoolProp.initialSize, Defaults.POOL_SIZE, AGPoolProp.maxActive, Defaults.POOL_SIZE});
            try (AGServer server = new AGServer(myServerUrl, myUsername, myPassword);){
                AGCatalog catalog = server.getCatalog(myCatalog);
                repoPool = catalog.createRepository(myRepo);
                repoPool.setConnPool(pool);
                repoPool.initialize();
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private static Value CalendarToValue(GregorianCalendar calendar) {
        return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(((DatatypeFactory)ThreadVars.datatypeFactory.get()).newXMLGregorianCalendar(calendar));
    }

    static AGTupleQuery streamQuery(AGTupleQuery tupleQuery) {
        if (Defaults.stream == Defaults.STREAM.PULL || Defaults.stream == Defaults.STREAM.PULH) {
            tupleQuery = new AGStreamTupleQuery(tupleQuery);
        }
        return tupleQuery;
    }

    public static void main(String[] args) throws Exception {
        Events events = new Events();
        try (Events ignored = events;){
            events.run(args);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        if (events.errors > 0) {
            throw new Exception("Errors during execution: " + events.errors);
        }
        System.exit(0);
    }

    @Override
    public void close() {
        this.closer.close();
    }

    private AGRepositoryConnection connect() throws RepositoryException {
        AGServer server = (AGServer)this.closer.closeLater((AutoCloseable)new AGServer(Defaults.URL, Defaults.USERNAME, Defaults.PASSWORD));
        AGCatalog cat = server.getCatalog(Defaults.CATALOG);
        AGRepository repo = (AGRepository)this.closer.closeLater((AutoCloseable)cat.createRepository(Defaults.REPOSITORY));
        repo.initialize();
        AGRepositoryConnection conn = (AGRepositoryConnection)this.closer.closeLater((AutoCloseable)repo.getConnection());
        if (!Defaults.SHARED) {
            conn.setAutoCommit(false);
            conn.setAutoCommit(true);
            Events.trace("Dedicated backend: " + conn.prepareHttpRepoClient().getRoot(), new Object[0]);
        } else {
            Events.trace("Shared backend: " + conn.prepareHttpRepoClient().getRoot(), new Object[0]);
        }
        return conn;
    }

    PhaseMeasures addPhaseMeasures(String phase) {
        PhaseMeasures pm = new PhaseMeasures(phase);
        this.phaseMeasures.add(pm);
        return pm;
    }

    String phaseMeasuresToString() {
        StringBuilder res = new StringBuilder();
        boolean first = true;
        res.append("(");
        for (PhaseMeasures pm : this.phaseMeasures) {
            if (first) {
                first = false;
            } else {
                res.append(" ");
            }
            res.append(pm.toString());
        }
        res.append(")");
        return res.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] args) throws Exception {
        Iterator tasks;
        long triplesStart;
        Defaults.init(args);
        Thread.currentThread().setName("./events");
        if (Defaults.hasOption("open")) {
            Events.trace("OPENING %s %s:%s.", Defaults.URL, Defaults.CATALOG, Defaults.REPOSITORY);
        } else {
            Events.trace("SUPERSEDING %s %s:%s.", Defaults.URL, Defaults.CATALOG, Defaults.REPOSITORY);
        }
        long initStart = System.currentTimeMillis();
        Events.trace("Phase 0 Begin: " + (Defaults.hasOption("open") ? "opening " : "renewing ") + Defaults.CATALOG + ":" + Defaults.REPOSITORY, new Object[0]);
        AGServer server = new AGServer(Defaults.URL, Defaults.USERNAME, Defaults.PASSWORD);
        AGCatalog catalog = server.getCatalog(Defaults.CATALOG);
        if (!Defaults.hasOption("open")) {
            catalog.deleteRepository(Defaults.REPOSITORY);
        }
        server.close();
        Events.MaybeInitializePool();
        AGRepositoryConnection conn = this.connect();
        long initEnd = System.currentTimeMillis();
        double initSeconds = (initEnd - initStart) / 1000L;
        Events.trace("Phase 0 End: Initial " + (Defaults.hasOption("open") ? "opening" : "renewing") + " took " + initSeconds + " seconds.", new Object[0]);
        Thread ping = new Thread(new Pinger(conn));
        ping.start();
        ThreadVars.valueFactory.set(conn.getValueFactory());
        conn.getRepository().getValueFactory().getRepository().setBulkMode(Defaults.BULKMODE);
        AllEvents.initialize();
        long triplesAtStart = conn.size(new Resource[0]);
        Events.trace("Testing with %d loading, %d querying processes. Repository contains %d triples.", Defaults.LOAD_WORKERS, Defaults.QUERY_WORKERS, triplesAtStart);
        long startTime = System.currentTimeMillis();
        if (Defaults.LOAD_WORKERS > 0) {
            long triples;
            double seconds;
            long end;
            long start;
            long triplesEnd = triplesStart = triplesAtStart;
            ExecutorService executor = Executors.newFixedThreadPool(Defaults.LOAD_WORKERS);
            if (Defaults.START_PHASE <= 1) {
                void var30_30;
                start = System.currentTimeMillis();
                Events.trace("Phase 0 Begin: Launching child load workers.", new Object[0]);
                tasks = new ArrayList(Defaults.LOAD_WORKERS);
                boolean bl = false;
                while (var30_30 < Defaults.LOAD_WORKERS) {
                    tasks.add(new Loader((int)var30_30, Defaults.SIZE / 10L, 1, BaselineRange));
                    ++var30_30;
                }
                end = System.currentTimeMillis();
                seconds = (end - start) / 1000L;
                Events.trace("Phase 0 End: Initial load_workers took " + seconds + " seconds.", new Object[0]);
                Events.trace("Phase 1 Begin: Baseline %d triple commits.", Defaults.EVENT_SIZE);
                Monitor.start(1);
                start = System.currentTimeMillis();
                this.invokeAndGetAll(executor, (List)((Object)tasks));
                end = System.currentTimeMillis();
                triplesEnd = conn.size(new Resource[0]);
                triples = triplesEnd - triplesStart;
                seconds = (double)(end - start) / 1000.0;
                this.addPhaseMeasures("Phase 1 (small commits)").add(new Measure("timestamp", end / 1000L)).add(new Measure("seconds", seconds));
                Events.trace("Phase 1 End: %d total triples added in %.3f seconds (%.2f triples/second, %.2f commits/second). Store contains %d triples.", triples, Events.logtime(seconds), Events.logtime((double)triples / seconds), Events.logtime((double)(triples / (long)Defaults.EVENT_SIZE) / seconds), triplesEnd);
                this.closer.close((Collection)((Object)tasks));
                Monitor.stop(1, conn);
            }
            if (Defaults.START_PHASE <= 2) {
                void var30_32;
                triplesStart = triplesEnd;
                tasks = new ArrayList<Loader>(Defaults.LOAD_WORKERS);
                boolean bl = false;
                while (var30_32 < Defaults.LOAD_WORKERS) {
                    tasks.add(new Loader((int)var30_32, Defaults.SIZE / 10L * 9L, Defaults.BULK_EVENTS, BulkRange));
                    ++var30_32;
                }
                Events.trace("Phase 2 Begin: Grow store by about %d triples.", Defaults.SIZE * 9L / 10L);
                Monitor.start(2);
                start = System.currentTimeMillis();
                this.invokeAndGetAll(executor, (List)((Object)tasks));
                end = System.currentTimeMillis();
                triplesEnd = conn.size(new Resource[0]);
                triples = triplesEnd - triplesStart;
                seconds = (double)(end - start) / 1000.0;
                this.addPhaseMeasures("Phase 2 (big commits)").add(new Measure("timestamp", end / 1000L)).add(new Measure("seconds", seconds));
                Events.trace("Phase 2 End: %d total triples bulk-loaded in %.3f seconds (%.2f triples/second, %.2f commits/second). Store contains %d triples.", triples, seconds, (double)triples / seconds, (double)(triples / (long)Defaults.BULK_EVENTS / (long)Defaults.EVENT_SIZE) / seconds, triplesEnd);
                this.closer.close((Collection)((Object)tasks));
                Monitor.stop(2, conn);
            }
            if (Defaults.START_PHASE <= 3) {
                void var30_34;
                triplesStart = triplesEnd;
                tasks = new ArrayList(Defaults.LOAD_WORKERS);
                boolean bl = false;
                while (var30_34 < Defaults.LOAD_WORKERS) {
                    tasks.add((int)var30_34, new Loader((int)var30_34, Defaults.SIZE / 10L, 1, SmallCommitsRange));
                    ++var30_34;
                }
                Events.trace("Phase 3 Begin: Perform %d triple commits.", Defaults.EVENT_SIZE);
                Monitor.start(3);
                start = System.currentTimeMillis();
                this.invokeAndGetAll(executor, (List)((Object)tasks));
                end = System.currentTimeMillis();
                Events.trace("p3: trying to get repo size on conn " + conn.prepareHttpRepoClient().getRoot(), new Object[0]);
                triplesEnd = conn.size(new Resource[0]);
                triples = triplesEnd - triplesStart;
                seconds = (double)(end - start) / 1000.0;
                this.addPhaseMeasures("Phase 3 (small commits)").add(new Measure("timestamp", end / 1000L)).add(new Measure("seconds", seconds));
                Events.trace("Phase 3 End: %d total triples added in %.3f seconds (%.2f triples/second, %.2f commits/second). Store contains %d triples.", triples, seconds, (double)triples / seconds, (double)(triples / (long)Defaults.EVENT_SIZE) / seconds, triplesEnd);
                executor.shutdown();
                this.closer.close((Collection)((Object)tasks));
                Monitor.stop(3, conn);
            }
        }
        if (Defaults.START_PHASE <= 4 && Defaults.QUERY_WORKERS > 0 && Defaults.START_PHASE > 0) {
            QueryResult queryResult;
            List fs;
            long start = System.currentTimeMillis();
            Events.trace("Phase 0 Begin: Launching child query workers.", new Object[0]);
            ExecutorService executor = Executors.newFixedThreadPool(Defaults.QUERY_WORKERS);
            ArrayList<Querier> sparqlQueriers = new ArrayList<Querier>(Defaults.QUERY_WORKERS);
            ArrayList<Querier> prologQueriers = new ArrayList<Querier>(Defaults.QUERY_WORKERS);
            for (int task2 = 0; task2 < Defaults.QUERY_WORKERS; ++task2) {
                sparqlQueriers.add(new Querier(task2, Defaults.QUERY_TIME * 60, FullDateRange, AGQueryLanguage.SPARQL));
                prologQueriers.add(new Querier(task2, Defaults.QUERY_TIME * 60, FullDateRange, (QueryLanguage)AGQueryLanguage.PROLOG));
            }
            long end = System.currentTimeMillis();
            double seconds = (double)(end - start) / 1000.0;
            Events.trace("Phase 0 End: Initial query_workers took " + seconds + " seconds.", new Object[0]);
            Events.trace("Phase 4 Begin: Perform SPARQL queries with %d processes for %d %s.", Defaults.QUERY_WORKERS, Defaults.QUERY_SIZE == 0 ? Defaults.QUERY_TIME : Defaults.QUERY_SIZE, Defaults.QUERY_SIZE == 0 ? "minutes" : "queries");
            Monitor.start(4);
            int queries = 0;
            long triples = 0L;
            start = System.currentTimeMillis();
            try {
                fs = executor.invokeAll(sparqlQueriers);
                for (Future future : fs) {
                    queryResult = (QueryResult)future.get();
                    queries = (int)((long)queries + queryResult.queries);
                    triples += queryResult.triples;
                }
            }
            catch (InterruptedException e) {
                ++this.errors;
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                ++this.errors;
                e.printStackTrace();
            }
            end = System.currentTimeMillis();
            seconds = (double)(end - start) / 1000.0;
            this.addPhaseMeasures("Phase 4 (SPARQL queries)").add(new Measure("timestamp", end / 1000L)).add(new Measure("seconds", seconds));
            Events.trace("Phase 4 End: %d total triples returned over %d queries in %.3f seconds (%.2f triples/second, %.2f queries/second, %d triples/query) MemUsed %d.", triples, queries, Events.logtime(seconds), Events.logtime((double)triples / seconds), Events.logtime((double)queries / seconds), triples / (long)queries, ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
            Monitor.stop(4, conn);
            this.closer.close(sparqlQueriers);
            Events.trace("Phase 5 Begin: Perform Prolog queries with %d processes for %d %s.", Defaults.QUERY_WORKERS, Defaults.QUERY_SIZE == 0 ? Defaults.QUERY_TIME : Defaults.QUERY_SIZE, Defaults.QUERY_SIZE == 0 ? "minutes" : "queries");
            Monitor.start(5);
            queries = 0;
            triples = 0L;
            start = System.currentTimeMillis();
            try {
                fs = executor.invokeAll(prologQueriers);
                for (Future future : fs) {
                    queryResult = (QueryResult)future.get();
                    queries = (int)((long)queries + queryResult.queries);
                    triples += queryResult.triples;
                }
            }
            catch (InterruptedException e) {
                ++this.errors;
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                ++this.errors;
                e.printStackTrace();
            }
            end = System.currentTimeMillis();
            seconds = (double)(end - start) / 1000.0;
            this.addPhaseMeasures("Phase 5 (Prolog queries)").add(new Measure("timestamp", end / 1000L)).add(new Measure("seconds", seconds));
            Events.trace("Phase 5 End: %d total triples returned over %d queries in %.3f seconds (%.2f triples/second, %.2f queries/second, %d triples/query).", triples, queries, Events.logtime(seconds), Events.logtime((double)triples / seconds), Events.logtime((double)queries / seconds), triples / (long)queries);
            Monitor.stop(5, conn);
            this.closer.close(prologQueriers);
            executor.shutdown();
        }
        if (Defaults.START_PHASE <= 6 && Defaults.DELETE_WORKERS > 0) {
            triplesStart = conn.size(new Resource[0]);
            long start = System.currentTimeMillis();
            Events.trace("Phase 0 Begin: Launching child delete workers.", new Object[0]);
            ExecutorService executor = Executors.newFixedThreadPool(2);
            ArrayList<Deleter> tasks2 = new ArrayList<Deleter>(2);
            tasks2.add(new Deleter(DeleteRangeOne));
            if (Defaults.DELETE_WORKERS > 1) {
                tasks2.add(new Deleter(DeleteRangeTwo));
            }
            long end = System.currentTimeMillis();
            double seconds = (double)(end - start) / 1000.0;
            Events.trace("Phase 0 End: Initial delete_workers took " + seconds + " seconds.", new Object[0]);
            Events.trace("Phase 6 Begin: Delete events.", new Object[0]);
            Monitor.start(6);
            start = System.currentTimeMillis();
            this.invokeAndGetAll(executor, tasks2);
            end = System.currentTimeMillis();
            this.closer.close(tasks2);
            executor.shutdown();
            long triplesEnd = conn.size(new Resource[0]);
            long triples = triplesStart - triplesEnd;
            seconds = (double)(end - start) / 1000.0;
            this.addPhaseMeasures("Phase 6 (deletes)").add(new Measure("timestamp", end / 1000L)).add(new Measure("seconds", seconds));
            Events.trace("Phase 6 End: %d total triples deleted in %.3f seconds (%.2f triples/second). Store contains %d triples.", triples, Events.logtime(seconds), Events.logtime((double)triples / seconds), triplesEnd);
            Monitor.stop(6, conn);
        }
        if (Defaults.START_PHASE <= 7 && Defaults.MIXED_RUNS != 0) {
            Monitor.start(7);
            RandomDateMaker smallCommitsRange = SmallCommitsRange;
            RandomDateMaker fullDateRange = FullDateRange;
            RandomDateMaker deleteRangeOne = DeleteRangeOne;
            RandomDateMaker deleteRangeTwo = DeleteRangeTwo;
            ExecutorService executor = Executors.newFixedThreadPool(Defaults.LOAD_WORKERS + Defaults.QUERY_WORKERS + 2);
            for (int run = 0; run < Defaults.MIXED_RUNS || Defaults.MIXED_RUNS == -1; ++run) {
                void var30_40;
                void var30_38;
                int queries = 0;
                long triples = 0L;
                long added = 0L;
                long deleted = 0L;
                smallCommitsRange = smallCommitsRange.next(6, 30);
                fullDateRange = new RandomDateMaker(deleteRangeTwo.end, smallCommitsRange.end);
                deleteRangeOne = deleteRangeTwo.next(6, 15);
                deleteRangeTwo = deleteRangeOne.next(6, 15);
                Events.trace("Phase 7 Begin: Mixed workload - adds, queries, deletes. %s", run);
                tasks = new ArrayList(Defaults.LOAD_WORKERS + Defaults.QUERY_WORKERS + 2);
                boolean bl = false;
                while (var30_38 < Defaults.LOAD_WORKERS) {
                    tasks.add(new Loader((int)var30_38, Defaults.SIZE / 10L, 1, smallCommitsRange));
                    ++var30_38;
                }
                boolean bl2 = false;
                while (var30_40 < Defaults.QUERY_WORKERS) {
                    tasks.add(new Querier((int)var30_40, Defaults.QUERY_TIME * 60, fullDateRange, AGQueryLanguage.SPARQL));
                    ++var30_40;
                }
                if (Defaults.DELETE_WORKERS > 0) {
                    tasks.add(new Deleter(deleteRangeOne));
                    if (Defaults.DELETE_WORKERS > 1) {
                        tasks.add(new Deleter(deleteRangeTwo));
                    }
                }
                long l = System.currentTimeMillis();
                try {
                    List fs = executor.invokeAll(tasks);
                    for (Future f : fs) {
                        Object o = f.get();
                        if (o instanceof QueryResult) {
                            QueryResult queryResult = (QueryResult)o;
                            queries = (int)((long)queries + queryResult.queries);
                            triples += queryResult.triples;
                            continue;
                        }
                        int i = (Integer)o;
                        if (i < 0) {
                            deleted += (long)i;
                            continue;
                        }
                        added += (long)i;
                    }
                }
                catch (InterruptedException e) {
                    ++this.errors;
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    ++this.errors;
                    e.printStackTrace();
                }
                long end = System.currentTimeMillis();
                double seconds = (double)(end - l) / 1000.0;
                Events.trace("Phase 7 End: %d total triples returned over %d queries in %.3f seconds (%.2f triples/second, %.2f queries/second, %d triples/query, %d triples added, %d deletes).", triples, queries, Events.logtime(seconds), Events.logtime((double)triples / seconds), Events.logtime((double)queries / seconds), queries == 0 ? 0L : triples / (long)queries, added, deleted);
                this.closer.close((Collection)((Object)tasks));
            }
            executor.shutdown();
            Monitor.stop(7, conn);
        }
        if (repoPool != null) {
            repoPool.shutDown();
        }
        long triplesEnd = conn.size(new Resource[0]);
        double totalSeconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        long triples = triplesEnd - triplesAtStart;
        Events.trace("Test completed in %.1f total seconds - store contains %d triples (%d triples added/removed).", Events.logtime(totalSeconds), triplesEnd, triples);
        Events.trace("MEASURES: " + this.phaseMeasuresToString(), new Object[0]);
    }

    private <Type> void invokeAndGetAll(ExecutorService executor, List<? extends Callable<Type>> tasks) {
        try {
            List fs = executor.invokeAll(tasks);
            for (Future f : fs) {
                f.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            ++this.errors;
            e.printStackTrace();
        }
    }

    class Pinger
    implements Runnable {
        private AGRepositoryConnection conn;

        public Pinger(AGRepositoryConnection c) {
            this.conn = c;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Events.trace("pinger running for " + this.conn.prepareHttpRepoClient().getRoot(), new Object[0]);
                        this.conn.ping();
                        Thread.sleep(Math.round(this.conn.getSessionLifetime() * 1000 / 2));
                    }
                }
                catch (InterruptedException e) {
                    Events.trace("Exception encountered in pinger: %s", e.toString());
                    continue;
                }
                catch (RepositoryException e) {
                    Events.trace("Exception encountered in pinger: %s", e.toString());
                    continue;
                }
                break;
            }
        }
    }

    class DeletingHandler
    implements TupleQueryResultHandler {
        private final AGRepositoryConnection conn;
        long count = 0L;

        DeletingHandler(AGRepositoryConnection conn) {
            this.conn = conn;
        }

        public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        }

        public void handleSolution(BindingSet bs) throws TupleQueryResultHandlerException {
            try {
                this.conn.remove(((ValueFactory)ThreadVars.valueFactory.get()).createStatement((Resource)((BNode)bs.getValue("s")), (IRI)bs.getValue("p"), bs.getValue("o")), new Resource[0]);
            }
            catch (RepositoryException e) {
                throw new TupleQueryResultHandlerException("failed to remove " + bs, (Throwable)e);
            }
            ++this.count;
        }

        public void endQueryResult() throws TupleQueryResultHandlerException {
        }

        public void handleBoolean(boolean arg0) throws QueryResultHandlerException {
        }

        public void handleLinks(List<String> arg0) throws QueryResultHandlerException {
        }
    }

    class Deleter
    implements Task {
        private final RandomDateMaker range;
        private ConnectionHolder connHolder;

        public Deleter(RandomDateMaker range) throws Exception {
            this.range = range;
            this.connHolder = new ConnectionHolder();
        }

        @Override
        public Integer call() {
            Thread.currentThread().setName("deleter(" + this.range + ")");
            this.connHolder.begin();
            String timestamp = NTriplesUtil.toNTriplesString((IRI)((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", "EventTimeStamp"));
            long interval = 86400000L;
            GregorianCalendar start = this.range.start;
            GregorianCalendar eod = (GregorianCalendar)this.range.start.clone();
            eod.setTimeInMillis(eod.getTimeInMillis() + interval);
            String startNT = NTriplesUtil.toNTriplesString((Value)Events.CalendarToValue(start));
            String endNT = NTriplesUtil.toNTriplesString((Value)Events.CalendarToValue(eod));
            this.connHolder.end();
            DateFormat f = SimpleDateFormat.getDateInstance();
            if (Defaults.hasOption("delete-using-prolog")) {
                Events.trace("Deleting using Prolog", new Object[0]);
            } else {
                Events.trace("Deleting using SPARQL", new Object[0]);
            }
            while (start.before(this.range.end)) {
                String queryString;
                if (Defaults.VERBOSE > 0) {
                    Events.trace("deleting " + f.format(start.getTime()) + " to " + f.format(eod.getTime()), new Object[0]);
                }
                if (!Defaults.hasOption("delete-using-prolog")) {
                    queryString = String.format("delete { ?s ?p ?o } where {     ?s %s ?date .     filter ( ( ?date >= %s ) && ( ?date <= %s ) ) .     ?s ?p ?o . }", timestamp, startNT, endNT);
                    if (Defaults.VERBOSE > 0) {
                        Events.trace(queryString, new Object[0]);
                    }
                    this.connHolder.begin();
                    AGBooleanQuery query = this.connHolder.use().prepareBooleanQuery(AGQueryLanguage.SPARQL, queryString);
                    try {
                        boolean result = query.evaluate();
                        if (!result) {
                            Events.trace("Got non-true response", new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        Events.this.errors++;
                        Events.trace("Error executing query:\n%s\n", queryString);
                        e.printStackTrace();
                    }
                    this.connHolder.end();
                } else {
                    int limit = 9 * (int)Math.pow(10.0, 5.0) / Defaults.EVENT_SIZE;
                    queryString = String.format("(select0 (?event)(:limit %d) (:count-only t)(q- ?event !%s (? !%s !%s))(lisp (delete-triples :s ?event)))", limit, timestamp, startNT, endNT);
                    if (Defaults.VERBOSE > 0) {
                        Events.trace(queryString, new Object[0]);
                    }
                    this.connHolder.begin();
                    AGTupleQuery tupleQuery = this.connHolder.use().prepareTupleQuery((QueryLanguage)AGQueryLanguage.PROLOG, queryString);
                    try {
                        tupleQuery.count();
                    }
                    catch (Exception e) {
                        Events.this.errors++;
                        Events.trace("Error executing query:\n%s\n", queryString);
                        e.printStackTrace();
                    }
                    this.connHolder.end();
                }
                start = eod;
                this.connHolder.begin();
                startNT = NTriplesUtil.toNTriplesString((Value)Events.CalendarToValue(start));
                eod = (GregorianCalendar)start.clone();
                eod.setTimeInMillis(eod.getTimeInMillis() + interval);
                endNT = NTriplesUtil.toNTriplesString((Value)Events.CalendarToValue(eod));
                this.connHolder.end();
            }
            return -1;
        }

        @Override
        public void close() {
            this.connHolder.close();
        }
    }

    class Querier
    implements Task {
        private final RandomDateMaker dateMaker;
        private final QueryLanguage language;
        private int secondsToRun;
        private int id;
        private String timestamp;
        private ConnectionHolder connHolder;

        public Querier(int theId, int theSecondsToRun, RandomDateMaker dateMaker, QueryLanguage lang) throws Exception {
            this.id = theId;
            this.secondsToRun = theSecondsToRun;
            this.dateMaker = dateMaker;
            this.language = lang;
            this.connHolder = new ConnectionHolder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long sparqlQuery(AGRepositoryConnection conn, boolean trace) {
            long count;
            TupleQueryResult result;
            block7: {
                GregorianCalendar end;
                String customerNT = NTriplesUtil.toNTriplesString((Value)new RandomCustomer().makeValue());
                GregorianCalendar start = FullDateRange.getRandom();
                if (start.after(end = FullDateRange.getRandom())) {
                    GregorianCalendar swap = end;
                    end = start;
                    start = swap;
                }
                String startNT = NTriplesUtil.toNTriplesString((Value)Events.CalendarToValue(start));
                String endNT = NTriplesUtil.toNTriplesString((Value)Events.CalendarToValue(end));
                String queryString = String.format("select ?s ?p ?o from %s where {   ?s %s ?date .   filter ( ( ?date >= %s ) && ( ?date <= %s ) )   ?s ?p ?o }", customerNT, this.timestamp, startNT, endNT);
                AGTupleQuery tupleQuery = conn.prepareTupleQuery(AGQueryLanguage.SPARQL, queryString);
                tupleQuery = Events.streamQuery(tupleQuery);
                result = null;
                count = 0L;
                try {
                    if (Defaults.VERBOSE > 0 && trace) {
                        Events.trace("query: %s", queryString);
                    }
                    if (Defaults.stream == Defaults.STREAM.HAND || Defaults.stream == Defaults.STREAM.PULH) {
                        CountingHandler handler = new CountingHandler();
                        tupleQuery.evaluate((TupleQueryResultHandler)handler);
                        count = handler.count;
                        break block7;
                    }
                    result = tupleQuery.evaluate();
                    count = this.count(result);
                }
                catch (Exception e) {
                    try {
                        Events.this.errors++;
                        Events.trace("Error executing query:\n%s\n", queryString);
                        e.printStackTrace();
                        count = -1L;
                    }
                    catch (Throwable throwable) {
                        Events.this.closer.close(result);
                        throw throwable;
                    }
                    Events.this.closer.close((AutoCloseable)result);
                }
            }
            Events.this.closer.close((AutoCloseable)result);
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long prologQuery(AGRepositoryConnection conn, boolean trace) {
            long count;
            TupleQueryResult result;
            block7: {
                GregorianCalendar end;
                String customerNT = NTriplesUtil.toNTriplesString((Value)new RandomCustomer().makeValue());
                GregorianCalendar start = FullDateRange.getRandom();
                if (start.after(end = FullDateRange.getRandom())) {
                    GregorianCalendar swap = end;
                    end = start;
                    start = swap;
                }
                String startNT = NTriplesUtil.toNTriplesString((Value)Events.CalendarToValue(start));
                String endNT = NTriplesUtil.toNTriplesString((Value)Events.CalendarToValue(end));
                String queryString = String.format("(select (?s ?p ?o)(:use-planner nil)(q- ?s !%s (? !%s !%s) !%s)(q- ?s ?p ?o !%s))", this.timestamp, startNT, endNT, customerNT, customerNT);
                AGTupleQuery tupleQuery = conn.prepareTupleQuery((QueryLanguage)AGQueryLanguage.PROLOG, queryString);
                tupleQuery = Events.streamQuery(tupleQuery);
                result = null;
                count = 0L;
                try {
                    if (Defaults.VERBOSE > 0 && trace) {
                        Events.trace("query: %s", queryString);
                    }
                    if (Defaults.stream == Defaults.STREAM.HAND || Defaults.stream == Defaults.STREAM.PULH) {
                        CountingHandler handler = new CountingHandler();
                        tupleQuery.evaluate((TupleQueryResultHandler)handler);
                        count = handler.count;
                        break block7;
                    }
                    result = tupleQuery.evaluate();
                    count = this.count(result);
                }
                catch (Exception e) {
                    try {
                        Events.this.errors++;
                        Events.trace("Error executing query:\n%s\n", queryString);
                        e.printStackTrace();
                        count = -1L;
                    }
                    catch (Throwable throwable) {
                        Events.this.closer.close(result);
                        throw throwable;
                    }
                    Events.this.closer.close((AutoCloseable)result);
                }
            }
            Events.this.closer.close((AutoCloseable)result);
            return count;
        }

        private long randomQuery(AGRepositoryConnection conn, boolean trace) {
            if (this.language == AGQueryLanguage.PROLOG) {
                return this.prologQuery(conn, trace);
            }
            return this.sparqlQuery(conn, trace);
        }

        private int count(TupleQueryResult result) throws Exception {
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            return count;
        }

        @Override
        public QueryResult call() {
            Calendar start;
            Thread.currentThread().setName("query(" + this.id + ")");
            ThreadVars.dateMaker.set(this.dateMaker);
            this.connHolder.begin();
            this.timestamp = NTriplesUtil.toNTriplesString((IRI)((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", "EventTimeStamp"));
            this.connHolder.end();
            int statusSize = Math.max(1, Defaults.STATUS / 5);
            long count = 0L;
            long subcount = 0L;
            long queries = 0L;
            long restarts = 0L;
            Calendar startTime = start = GregorianCalendar.getInstance();
            while (true) {
                this.connHolder.begin();
                long result = this.randomQuery(this.connHolder.use(), queries % (long)statusSize == 0L);
                this.connHolder.end();
                if (result < 0L) {
                    ++restarts;
                } else {
                    ++queries;
                    count += result;
                }
                if (queries % (long)statusSize != 0L) continue;
                Calendar end = GregorianCalendar.getInstance();
                double seconds = (double)(end.getTimeInMillis() - start.getTimeInMillis()) / 1000.0;
                subcount = count - subcount;
                Events.trace("Querying status - %d triples returned for %d queries in %.2f sec (%.2f queries/sec, %d triples per query), %d queries aborted.", subcount, statusSize, Events.logtime(seconds), Events.logtime((double)statusSize / seconds), subcount / (long)statusSize, restarts);
                start = end;
                subcount = count;
                seconds = (double)(end.getTimeInMillis() - startTime.getTimeInMillis()) / 1000.0;
                if (Defaults.QUERY_SIZE == 0 && seconds > (double)this.secondsToRun || Defaults.QUERY_SIZE > 0 && queries >= (long)(Defaults.QUERY_SIZE / Defaults.QUERY_WORKERS)) break;
            }
            double seconds = (double)(GregorianCalendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) / 1000.0;
            Events.trace("Querying done - %d triple results returned for %d queries in %f seconds (%f queries/second, %d triples per query), %d queries aborted.", count, queries, Events.logtime(seconds), Events.logtime((double)queries / seconds), count / queries, restarts);
            return new QueryResult(queries, count);
        }

        @Override
        public void close() {
            this.connHolder.close();
        }

        class CountingHandler
        implements TupleQueryResultHandler {
            long count = 0L;

            CountingHandler() {
            }

            public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
            }

            public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
                ++this.count;
            }

            public void endQueryResult() throws TupleQueryResultHandlerException {
            }

            public void handleBoolean(boolean arg0) throws QueryResultHandlerException {
            }

            public void handleLinks(List<String> arg0) throws QueryResultHandlerException {
            }
        }
    }

    class Loader
    implements Task {
        private final RandomDateMaker dateMaker;
        private final ConnectionHolder connHolder;
        private int id;
        private long loopCount;
        private int eventsPerCommit;
        private int triplesPerCommit;

        public Loader(int theId, long theTripleGoal, int theEventsPerCommit, RandomDateMaker dateMaker) throws Exception {
            this.id = theId;
            this.dateMaker = dateMaker;
            this.triplesPerCommit = theEventsPerCommit * Defaults.EVENT_SIZE;
            this.loopCount = theTripleGoal / (long)this.triplesPerCommit / (long)Defaults.LOAD_WORKERS;
            this.eventsPerCommit = theEventsPerCommit;
            this.connHolder = new ConnectionHolder();
        }

        @Override
        public Integer call() {
            Thread.currentThread().setName("loader(" + this.id + ")");
            ThreadVars.dateMaker.set(this.dateMaker);
            int statusSize = Defaults.STATUS;
            int count = 0;
            int errors = 0;
            Vector<Statement> statements = new Vector<Statement>(this.triplesPerCommit);
            Calendar start = GregorianCalendar.getInstance();
            statements.setSize(this.triplesPerCommit);
            int loop = 0;
            while ((long)loop < this.loopCount) {
                this.connHolder.begin();
                int index = 0;
                for (int event = 0; event < this.eventsPerCommit; ++event) {
                    index = AllEvents.makeEvent(statements, index);
                }
                if (loop > 0 && loop % statusSize == 0) {
                    Calendar end = GregorianCalendar.getInstance();
                    double seconds = (double)(end.getTimeInMillis() - start.getTimeInMillis()) / 1000.0;
                    Events.trace("Loading Status - %d triples loaded so far at %d triples per commit (%.2f commits/sec, %.2f triples/sec over last %d commits), %d errors.", count, this.triplesPerCommit, Events.logtime((double)statusSize / seconds), Events.logtime((double)(statusSize * this.triplesPerCommit) / seconds), statusSize, errors);
                    start = end;
                }
                try {
                    this.connHolder.use().add(statements, new Resource[0]);
                    count += this.triplesPerCommit;
                }
                catch (Exception e) {
                    ++errors;
                    Events.trace("Error adding statements...", new Object[0]);
                    e.printStackTrace();
                }
                this.connHolder.end();
                ++loop;
            }
            Events.trace("Loading Done - %d triples at %d triples per commit, %d errors.", count, this.triplesPerCommit, errors);
            return 0;
        }

        @Override
        public void close() {
            this.connHolder.close();
        }
    }

    public class ConnectionHolder {
        private AGRepositoryConnection conn;

        public ConnectionHolder() throws RepositoryException {
            if (repoPool == null) {
                this.conn = Events.this.connect();
            }
        }

        public void begin() {
            try {
                if (repoPool != null) {
                    this.conn = repoPool.getConnection();
                }
                ThreadVars.valueFactory.set(this.conn.getValueFactory());
            }
            catch (RepositoryException e) {
                Events.this.errors++;
                e.printStackTrace();
            }
        }

        public AGRepositoryConnection use() {
            return this.conn;
        }

        public void end() {
            try {
                ThreadVars.valueFactory.set(null);
                if (repoPool != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (RepositoryException e) {
                Events.this.errors++;
                e.printStackTrace();
            }
        }

        void close() {
            if (repoPool == null) {
                ThreadVars.valueFactory.set(null);
                Events.this.closer.close((AutoCloseable)this.conn);
            }
        }
    }

    private class PhaseMeasures {
        String phase;
        List<Measure> measures = new ArrayList<Measure>();

        PhaseMeasures(String phase) {
            this.phase = phase;
        }

        PhaseMeasures add(Measure m) {
            this.measures.add(m);
            return this;
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            res.append("(\"" + this.phase + "\" . (");
            for (Measure m : this.measures) {
                res.append(m.toString());
            }
            res.append("))");
            return res.toString();
        }
    }

    private class Measure {
        String name;
        Object value;

        Measure(String name, double value) {
            this.name = name;
            this.value = value;
        }

        Measure(String name, long value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "(" + this.name + " . " + this.value + ")";
        }
    }

    public static class Monitor {
        private static void printOutput(Process p) throws IOException {
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                System.out.println(line);
                System.out.flush();
            }
            input.close();
        }

        public static void start(int phase) {
            if (Defaults.MONITOR) {
                try {
                    File monitor = Util.resourceAsTempFile("/test/stress/monitor.sh", true);
                    String[] commands = new String[]{monitor.getAbsolutePath(), "start", "phase-" + phase, Defaults.CATALOG, Defaults.REPOSITORY};
                    Process p = Runtime.getRuntime().exec(commands);
                    Monitor.printOutput(p);
                    Events.trace("./monitor.sh was started.", new Object[0]);
                }
                catch (IOException e) {
                    Events.trace("./monitor.sh was not started.", new Object[0]);
                }
            }
        }

        public static void stop(int phase, AGRepositoryConnection c) {
            if (Defaults.MONITOR) {
                try {
                    String[] commands = new String[]{"src/test/stress/monitor.sh", "end", "phase-" + phase, Defaults.CATALOG, Defaults.REPOSITORY};
                    Process p = Runtime.getRuntime().exec(commands);
                    Monitor.printOutput(p);
                    Events.trace("./monitor.sh was stopped.", new Object[0]);
                    if (phase < 4) {
                        AGRepository repo = c.getRepository().getValueFactory().getRepository();
                        Events.trace("Phase 0 Begin: Forced Merge", new Object[0]);
                        c.optimizeIndices(Boolean.valueOf(true), 1);
                        repo.ensureDBIdle();
                        Events.trace("Phase 0 End: Forced Merge", new Object[0]);
                        Events.trace("Phase 0 Begin: Forced Checkpoint", new Object[0]);
                        repo.forceCheckpoint();
                        Events.trace("Phase 0 End: Forced Checkpoint", new Object[0]);
                    }
                }
                catch (IOException e) {
                    Events.trace("./monitor.sh was not stopped.", new Object[0]);
                }
                catch (RepositoryException e) {
                    Events.trace("error in Monitor.stop()", new Object[0]);
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        }
    }

    private static class QueryResult {
        public long queries;
        public long triples;

        public QueryResult(long theQueries, long theTriples) {
            this.queries = theQueries;
            this.triples = theTriples;
        }
    }

    private static class AllEvents {
        private static PredicateInfo[] interaction = new PredicateInfo[Defaults.access$300()];
        private static PredicateInfo[] invoice = new PredicateInfo[Defaults.access$300()];
        private static PredicateInfo[] payment = new PredicateInfo[Defaults.access$300()];
        private static PredicateInfo[] purchase = new PredicateInfo[Defaults.access$300()];

        private AllEvents() {
        }

        private static void PadEvent(String padName, PredicateInfo[] to, PredicateInfo[] from) {
            System.arraycopy(from, 0, to, 0, from.length);
            for (int i = from.length; i < Defaults.EVENT_SIZE; ++i) {
                to[i] = new PredicateInfo(padName + i, (RandomCallback)new RandomInteger());
            }
        }

        public static void initialize() {
            AllEvents.PadEvent("Interaction", interaction, new PredicateInfo[]{new PredicateInfo(RDF.TYPE, (RandomCallback)new TypeURI("CustomerInteraction")), new PredicateInfo("EventTimeStamp", (RandomCallback)new RandomCalendar()), new PredicateInfo("EntityId", (RandomCallback)new RandomInteger()), new PredicateInfo("OriginatingSystem", (RandomCallback)new StringValue("CRM")), new PredicateInfo("Agent", (RandomCallback)new RandomName()), new PredicateInfo("Direction", (RandomCallback)new RandomDirection()), new PredicateInfo("DoneInOne", (RandomCallback)new RandomBoolean()), new PredicateInfo("EndDate", (RandomCallback)new RandomCalendar()), new PredicateInfo("FeeBased", (RandomCallback)new RandomBoolean()), new PredicateInfo("InteractionId", (RandomCallback)new RandomInteger()), new PredicateInfo("Origin", (RandomCallback)new RandomOrigin()), new PredicateInfo("PayOption", (RandomCallback)new RandomPayOption()), new PredicateInfo("ReasonLevel1", (RandomCallback)new RandomInteger()), new PredicateInfo("ReasonLevel2", (RandomCallback)new RandomInteger()), new PredicateInfo("OriginatingSystem", (RandomCallback)new RandomInteger()), new PredicateInfo("Result", (RandomCallback)new RandomInteger())});
            AllEvents.PadEvent("Invoice", invoice, new PredicateInfo[]{new PredicateInfo(RDF.TYPE, (RandomCallback)new TypeURI("Invoice")), new PredicateInfo("EventTimeStamp", (RandomCallback)new RandomCalendar()), new PredicateInfo("AccountId", (RandomCallback)new RandomAccount()), new PredicateInfo("OriginatingSystem", (RandomCallback)new StringValue("Invoicing")), new PredicateInfo("DueDate", (RandomCallback)new RandomCalendar()), new PredicateInfo("Action", (RandomCallback)new RandomAction()), new PredicateInfo("TotalAmountDue", (RandomCallback)new RandomMoney()), new PredicateInfo("AmountDueHandling", (RandomCallback)new RandomHandling()), new PredicateInfo("LegalInvoiceNumber", (RandomCallback)new RandomInteger()), new PredicateInfo("PreviousBalanceAmount", (RandomCallback)new RandomMoney()), new PredicateInfo("TotalFinanceActivites", (RandomCallback)new RandomMoney()), new PredicateInfo("BillDate", (RandomCallback)new RandomCalendar()), new PredicateInfo("TotalUsageCharges", (RandomCallback)new RandomMoney()), new PredicateInfo("TotalRecurringCharges", (RandomCallback)new RandomMoney()), new PredicateInfo("TotalOneTimeCharges", (RandomCallback)new RandomMoney())});
            AllEvents.PadEvent("Payment", payment, new PredicateInfo[]{new PredicateInfo(RDF.TYPE, (RandomCallback)new TypeURI("AccountPayment")), new PredicateInfo("EventTimeStamp", (RandomCallback)new RandomCalendar()), new PredicateInfo("AccountId", (RandomCallback)new RandomAccount()), new PredicateInfo("OriginatingSystem", (RandomCallback)new StringValue("Ordering")), new PredicateInfo("SubscriberId", (RandomCallback)new RandomCustomer()), new PredicateInfo("InvoiceId", (RandomCallback)new RandomInteger()), new PredicateInfo("PaymentAmount", (RandomCallback)new RandomMoney()), new PredicateInfo("OriginalAmount", (RandomCallback)new RandomMoney()), new PredicateInfo("AmountDue", (RandomCallback)new RandomMoney()), new PredicateInfo("DepositDate", (RandomCallback)new RandomCalendar()), new PredicateInfo("PaymentType", (RandomCallback)new RandomPayOption()), new PredicateInfo("OriginalPostedAmount", (RandomCallback)new RandomMoney()), new PredicateInfo("PaymentTarget", (RandomCallback)new RandomPaymentTarget()), new PredicateInfo("DepositDesignation", (RandomCallback)new RandomDepositDesignation()), new PredicateInfo("BusinessEntity", (RandomCallback)new RandomBusinessEntity())});
            AllEvents.PadEvent("Purchase", purchase, new PredicateInfo[]{new PredicateInfo(RDF.TYPE, (RandomCallback)new TypeURI("Purchase")), new PredicateInfo("EventTimeStamp", (RandomCallback)new RandomCalendar()), new PredicateInfo("AccountId", (RandomCallback)new RandomAccount()), new PredicateInfo("OriginatingSystem", (RandomCallback)new StringValue("Sales")), new PredicateInfo("PurchaseDate", (RandomCallback)new RandomCalendar()), new PredicateInfo("PurchaseAmount", (RandomCallback)new RandomMoney()), new PredicateInfo("InvoiceID", (RandomCallback)new RandomInteger()), new PredicateInfo("ProductID", (RandomCallback)new RandomProductID()), new PredicateInfo("LegalInvoiceNumber", (RandomCallback)new RandomInteger()), new PredicateInfo("PreviousBalanceAmount", (RandomCallback)new RandomMoney()), new PredicateInfo("DeliveredVia", (RandomCallback)new RandomDelivery()), new PredicateInfo("PaidVia", (RandomCallback)new RandomPayOption()), new PredicateInfo("CCApprovalNumber", (RandomCallback)new RandomInteger()), new PredicateInfo("TotalRecurringCharges", (RandomCallback)new RandomMoney()), new PredicateInfo("TotalOneTimeCharges", (RandomCallback)new RandomMoney())});
        }

        public static int makeEvent(Vector<Statement> statements, int index) {
            PredicateInfo[] event = null;
            switch (RANDOM.nextInt(4)) {
                case 0: {
                    event = interaction;
                    break;
                }
                case 1: {
                    event = invoice;
                    break;
                }
                case 2: {
                    event = payment;
                    break;
                }
                case 3: {
                    event = purchase;
                }
            }
            BNode bnode = ((ValueFactory)ThreadVars.valueFactory.get()).createBNode();
            Resource context = (Resource)new RandomCustomer().makeValue();
            for (int i = 0; i < Defaults.EVENT_SIZE; ++i) {
                statements.set(index, event[i].makeStatement((Resource)bnode, context));
                ++index;
            }
            return index;
        }
    }

    private static class PredicateInfo {
        private IRI predicate;
        private RandomCallback objectMaker;

        public PredicateInfo(IRI thePredicate, RandomCallback theMaker) {
            this.predicate = thePredicate;
            this.objectMaker = theMaker;
        }

        public PredicateInfo(String label, RandomCallback theMaker) {
            this.predicate = ((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", label);
            this.objectMaker = theMaker;
        }

        public Statement makeStatement(Resource subject, Resource context) {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createStatement(subject, this.predicate, this.objectMaker.makeValue(), context);
        }
    }

    private static class StringValue
    implements RandomCallback {
        private String value;

        public StringValue(String theValue) {
            this.value = theValue;
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(this.value);
        }
    }

    private static class TypeURI
    implements RandomCallback {
        private String typeLabel;

        public TypeURI(String label) {
            this.typeLabel = label;
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", this.typeLabel);
        }
    }

    private static class RandomDepositDesignation
    implements RandomCallback {
        private RandomDepositDesignation() {
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", "BusinessEntity-" + RANDOM.nextInt(100));
        }
    }

    private static class RandomBusinessEntity
    implements RandomCallback {
        private RandomBusinessEntity() {
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", "DepositDesignation-" + RANDOM.nextInt(100));
        }
    }

    private static class RandomPaymentTarget
    implements RandomCallback {
        private RandomPaymentTarget() {
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", "PaymentTarget-" + RANDOM.nextInt(100));
        }
    }

    private static class RandomProductID
    implements RandomCallback {
        private RandomProductID() {
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", "ProductID-" + RANDOM.nextLong(Defaults.SIZE / 1000L));
        }
    }

    private static class RandomAccount
    implements RandomCallback {
        private RandomAccount() {
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", "Account-" + RANDOM.nextLong(Defaults.SIZE / 1000L));
        }
    }

    private static class RandomCustomer
    implements RandomCallback {
        private RandomCustomer() {
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createIRI("http://franz.com/events#", "Customer-" + RANDOM.nextLong(Defaults.SIZE / 1000L));
        }
    }

    private static class RandomHandling
    implements RandomCallback {
        static String[] handlings = new String[]{"Nothing", "Past Due Notice", "Collections"};

        private RandomHandling() {
        }

        @Override
        public Value makeValue() {
            int handling = RANDOM.nextInt(handlings.length);
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(handlings[handling]);
        }
    }

    private static class RandomAction
    implements RandomCallback {
        static String[] actions = new String[]{"Add", "Modify"};

        private RandomAction() {
        }

        @Override
        public Value makeValue() {
            int action = RANDOM.nextInt(actions.length);
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(actions[action]);
        }
    }

    private static class RandomMoney
    implements RandomCallback {
        private RandomMoney() {
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral((double)RANDOM.nextFloat() * 10000.0);
        }
    }

    private static class RandomDelivery
    implements RandomCallback {
        static String[] deliverytypes = new String[]{"Mail", "FedEx", "UPS", "Truck Freight"};

        private RandomDelivery() {
        }

        @Override
        public Value makeValue() {
            int deliverytype = RANDOM.nextInt(deliverytypes.length);
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(deliverytypes[deliverytype]);
        }
    }

    private static class RandomPayOption
    implements RandomCallback {
        static String[] payoptions = new String[]{"Cash", "Credit", "Money Order"};

        private RandomPayOption() {
        }

        @Override
        public Value makeValue() {
            int payoption = RANDOM.nextInt(payoptions.length);
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(payoptions[payoption]);
        }
    }

    private static class RandomOrigin
    implements RandomCallback {
        static String[] origins = new String[]{"Call Center", "Sales", "Front Desk"};

        private RandomOrigin() {
        }

        @Override
        public Value makeValue() {
            int origin = RANDOM.nextInt(origins.length);
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(origins[origin]);
        }
    }

    private static class RandomBoolean
    implements RandomCallback {
        private RandomBoolean() {
        }

        @Override
        public Value makeValue() {
            boolean isOdd = RANDOM.nextInt(2) == 1;
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(isOdd);
        }
    }

    private static class RandomDirection
    implements RandomCallback {
        static String[] directions = new String[]{"Inbound", "Outbound"};

        private RandomDirection() {
        }

        @Override
        public Value makeValue() {
            int direction = RANDOM.nextInt(directions.length);
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(directions[direction]);
        }
    }

    private static class RandomName
    implements RandomCallback {
        static String[] firsts = new String[]{"Sam", "Bruce", "Mandy", "Stacy", "Marcus", "Susan", "Jason", "Chris", "Becky", "Britney", "David", "Paul", "Daniel", "James", "Bradley", "Amy", "Tina", "Brandy", "Jessica", "Mary", "George", "Jane"};
        static String[] lasts = new String[]{"Smith", "Jones", "Flintstones", "Rubble", "Jetson", "Wayne", "McFly", "Stadtham", "Lee", "Chan", "Brown", "Quinn", "Henderson", "Anderson", "Roland"};

        private RandomName() {
        }

        @Override
        public Value makeValue() {
            int first = RANDOM.nextInt(firsts.length);
            int last = RANDOM.nextInt(lasts.length);
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(firsts[first] + " " + lasts[last]);
        }
    }

    private static class RandomInteger
    implements RandomCallback {
        private RandomInteger() {
        }

        @Override
        public Value makeValue() {
            return ((ValueFactory)ThreadVars.valueFactory.get()).createLiteral(RANDOM.nextInt());
        }
    }

    private static class RandomCalendar
    implements RandomCallback {
        private RandomCalendar() {
        }

        @Override
        public Value makeValue() {
            return Events.CalendarToValue(((RandomDateMaker)ThreadVars.dateMaker.get()).getRandom());
        }
    }

    private static class RandomDateMaker {
        public GregorianCalendar start;
        public GregorianCalendar end;
        int seconds;

        public RandomDateMaker(GregorianCalendar theStart, GregorianCalendar theEnd) {
            assert (theStart.before(theEnd));
            this.start = theStart;
            this.end = theEnd;
            this.seconds = (int)((this.end.getTimeInMillis() - this.start.getTimeInMillis()) / 1000L);
        }

        public GregorianCalendar getRandom() {
            GregorianCalendar rand = (GregorianCalendar)this.start.clone();
            rand.setTimeInMillis(rand.getTimeInMillis() + (long)RANDOM.nextInt(this.seconds) * 1000L);
            return rand;
        }

        public RandomDateMaker next(int field, int val) {
            GregorianCalendar c = (GregorianCalendar)this.end.clone();
            c.add(6, 30);
            return new RandomDateMaker(this.end, c);
        }

        public String toString() {
            DateFormat f = SimpleDateFormat.getDateInstance();
            return "[" + f.format(this.start.getTime()) + " - " + f.format(this.end.getTime()) + "]";
        }
    }

    private static class ThreadVars {
        private static ThreadLocal<ValueFactory> valueFactory = new ThreadLocal();
        private static ThreadLocal<RandomDateMaker> dateMaker = new ThreadLocal();
        private static ThreadLocal<DatatypeFactory> datatypeFactory = new ThreadLocal<DatatypeFactory>(){

            @Override
            protected DatatypeFactory initialValue() {
                DatatypeFactory factory = null;
                try {
                    factory = DatatypeFactory.newInstance();
                }
                catch (DatatypeConfigurationException e) {
                    System.err.println("Couldn't create DatatypeFactory!");
                    e.printStackTrace();
                }
                return factory;
            }
        };

        private ThreadVars() {
        }
    }

    static class Defaults {
        private static final String NS = "http://franz.com/events#";
        static int LOAD_WORKERS = 20;
        static int QUERY_WORKERS = 8;
        static int DELETE_WORKERS = 2;
        static int MIXED_RUNS = 0;
        static long SIZE = (long)Math.pow(10.0, 9.0);
        static String CATALOG = "tests";
        static String REPOSITORY = "events_test";
        static int START_PHASE = 1;
        static int STATUS = 500;
        static int VERBOSE = 0;
        static String URL = AGAbstractTest.findServerUrl();
        static String USERNAME = AGAbstractTest.username();
        static String PASSWORD = AGAbstractTest.password();
        static boolean MONITOR = false;
        static boolean BULKMODE = false;
        static boolean SHARED = false;
        static LOGT LOG = LOGT.ALL;
        static STREAM stream = STREAM.NONE;
        private static CommandLine cmd;
        private static int QUERY_TIME;
        private static int QUERY_SIZE;
        private static int EVENT_SIZE;
        private static int BULK_EVENTS;
        private static int POOL_SIZE;

        Defaults() {
        }

        static String cmdVal(String opt, String defaultVal) {
            String val = cmd.getOptionValue(opt);
            if (val == null) {
                return defaultVal;
            }
            return val;
        }

        static int cmdVal(String opt, int defaultVal) {
            String val = cmd.getOptionValue(opt);
            if (val == null) {
                return defaultVal;
            }
            return Integer.parseInt(val);
        }

        static int cmdVal(String opt, int defaultVal, int defaultVal2) {
            if (cmd.hasOption(opt)) {
                String val = cmd.getOptionValue(opt);
                if (val == null) {
                    return defaultVal2;
                }
                return Integer.parseInt(val);
            }
            return defaultVal;
        }

        static boolean cmdVal(String opt, boolean defaultVal) {
            String val = cmd.getOptionValue(opt);
            if (val == null) {
                return defaultVal;
            }
            return Boolean.parseBoolean(val);
        }

        static <EnumType extends Enum> EnumType cmdVal(String opt, EnumType defaultVal) {
            String val = cmd.getOptionValue(opt);
            if (val == null) {
                return defaultVal;
            }
            return (EnumType)Enum.valueOf(defaultVal.getClass(), val);
        }

        public static void init(String[] args) throws Exception {
            Options options = new Options();
            options.addOption(new Option("h", "help", false, "print this message"));
            OptionBuilder.withLongOpt((String)"delete-using-prolog");
            OptionBuilder.withDescription((String)"Use prolog to delete triples in phase 6.  Default is to use SPARQL");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"open");
            OptionBuilder.withDescription((String)"OPEN the repository and add to it [default is to SUPERSEDE]");
            options.addOption(OptionBuilder.create((String)"o"));
            OptionBuilder.withLongOpt((String)"status");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("use STATUS size [default=" + STATUS + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"load");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("use number of loading processes [default=" + LOAD_WORKERS + "]"));
            options.addOption(OptionBuilder.create((String)"l"));
            OptionBuilder.withLongOpt((String)"query");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("use number of querying processes [default=" + QUERY_WORKERS + "]"));
            options.addOption(OptionBuilder.create((String)"q"));
            OptionBuilder.withLongOpt((String)"delete");
            OptionBuilder.withArgName((String)"0-2");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("use 0-2 deleting processes [default=" + DELETE_WORKERS + "]"));
            options.addOption(OptionBuilder.create((String)"d"));
            OptionBuilder.withLongOpt((String)"size");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("triple limit for bulk load (e.g. 10,000, 100m, 2b, 1.5t) (minimum=1000) [default=" + SIZE + "]"));
            options.addOption(OptionBuilder.create((String)"s"));
            OptionBuilder.withLongOpt((String)"time");
            OptionBuilder.withArgName((String)"MINUTES");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("time limit for query phase [default=" + QUERY_TIME + "]"));
            options.addOption(OptionBuilder.create((String)"t"));
            OptionBuilder.withLongOpt((String)"query-size");
            OptionBuilder.withArgName((String)"QUERY_SIZE");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("Total QUERY_EVENTS to perform in each query phase [default=" + QUERY_SIZE + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"event");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("each event will contain number of triples [default=" + EVENT_SIZE + "]"));
            options.addOption(OptionBuilder.create((String)"e"));
            OptionBuilder.withLongOpt((String)"bulk");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("commit number of events per commit during bulk load [default=" + BULK_EVENTS + "]"));
            options.addOption(OptionBuilder.create((String)"b"));
            OptionBuilder.withLongOpt((String)"mixed");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("Add MIXED workload phases after the normal run (-1, runs until java process is killed) [default=" + MIXED_RUNS + "]"));
            options.addOption(OptionBuilder.create((String)"m"));
            OptionBuilder.withLongOpt((String)"verbose");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)("Verbosity level for extra log messages if VERBOSE > 0. [default=" + VERBOSE + ", no value=1]"));
            options.addOption(OptionBuilder.create((String)"v"));
            OptionBuilder.withLongOpt((String)"catalog");
            OptionBuilder.withArgName((String)"NAME");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("AGraph catalog [default=" + CATALOG + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"repository");
            OptionBuilder.withArgName((String)"NAME");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("AGraph repository [default=" + REPOSITORY + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"url");
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("AGraph URL [default=" + URL + " from env var AGRAPH_HOST, java property AGRAPH_HOST, or \"localhost\";" + " and env var AGRAPH_PORT, java property AGRAPH_PORT, ../agraph/lisp/agraph.port, or 10035"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"username");
            OptionBuilder.withArgName((String)"NAME");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("AGraph username [default=" + USERNAME + " from env var AGRAPH_USER, or \"test\"]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"password");
            OptionBuilder.withArgName((String)"PASSWORD");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("AGraph password [default=" + PASSWORD + " from env var AGRAPH_PASSWORD, or \"xyzzy\"]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"seed");
            OptionBuilder.withArgName((String)"INTEGER");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"seed to the random number generator so that one can do repeated runs with the exact same data generated. Default: random.");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"phase");
            OptionBuilder.withArgName((String)"1-6");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("Run the test starting at phase 1-6 [default=" + START_PHASE + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"monitor");
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("Try to start monitor.sh or not. [default=" + MONITOR + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"log");
            OptionBuilder.withArgName((String)"LOG");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("One of: " + Arrays.asList(LOGT.values()) + ". [default=" + (Object)((Object)LOG) + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"stream");
            OptionBuilder.withArgName((String)"STREAM");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("Stream results. One of: " + Arrays.asList(STREAM.values()) + ". [default=" + (Object)((Object)stream) + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"bulkmode");
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("Use repository bulk mode. [default=" + BULKMODE + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"pool-size");
            OptionBuilder.withArgName((String)"POOL_SIZE");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("When non-zero, sets the connection pool size [default=" + POOL_SIZE + "]"));
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"shared");
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)("Use shared backends instead of dedicated sessions. [default=" + SHARED + "]"));
            options.addOption(OptionBuilder.create());
            cmd = new PosixParser().parse(options, args);
            if (cmd.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("./events [options]", "To performance test AllegroGraph v4, connects as a client, uses multiple threads, and adds data, makes queries, deletes data, and runs mixed-load threads.", options, "Example usage:\n./events.sh --help\n# Prints help text.\n./events.sh \n# Runs default options: supersedes repo, runs test.\n./events.sh --open --status 500 -v 1 -l 1 -d 0 -q 1 -m 1 --size 100000 --sparql\n# Runs less verbose status, single-threaded, adding to an existing repo, no deletes, sparql queries.\n./events.sh -l 10 -q 2 -m 2 --size 1m\n# Runs with a superseded repo, prolog queries, multi-threaded.\n", false);
                System.exit(0);
            }
            LOAD_WORKERS = Defaults.cmdVal("load", LOAD_WORKERS);
            QUERY_WORKERS = Defaults.cmdVal("query", QUERY_WORKERS);
            DELETE_WORKERS = Defaults.cmdVal("delete", DELETE_WORKERS);
            MIXED_RUNS = Defaults.cmdVal("mixed", MIXED_RUNS);
            STATUS = Defaults.cmdVal("status", STATUS);
            SIZE = Math.max(1000L, Util.fromHumanInt(Defaults.cmdVal("size", "" + SIZE)));
            QUERY_TIME = Defaults.cmdVal("time", QUERY_TIME);
            QUERY_SIZE = Defaults.cmdVal("query-size", QUERY_SIZE);
            EVENT_SIZE = Defaults.cmdVal("event", EVENT_SIZE);
            BULK_EVENTS = Defaults.cmdVal("bulk", BULK_EVENTS);
            VERBOSE = Defaults.cmdVal("verbose", VERBOSE, 1);
            CATALOG = Defaults.cmdVal("catalog", CATALOG);
            REPOSITORY = Defaults.cmdVal("repository", REPOSITORY);
            URL = Defaults.cmdVal("url", URL);
            USERNAME = Defaults.cmdVal("username", USERNAME);
            PASSWORD = Defaults.cmdVal("password", PASSWORD);
            START_PHASE = Defaults.cmdVal("phase", START_PHASE);
            MONITOR = Defaults.cmdVal("monitor", MONITOR);
            LOG = Defaults.cmdVal("log", LOG);
            stream = Defaults.cmdVal("stream", stream);
            BULKMODE = Defaults.cmdVal("bulkmode", BULKMODE);
            POOL_SIZE = Defaults.cmdVal("pool-size", POOL_SIZE);
            SHARED = Defaults.cmdVal("shared", SHARED);
            if (cmd.hasOption("seed")) {
                long seed = Long.parseLong(cmd.getOptionValue("seed"));
                RANDOM.setSeed(seed);
                Events.trace("Set random seed to %s.", seed);
            }
            Events.trace("Parameters: catalog=" + CATALOG + " repository=" + REPOSITORY + " url=" + URL + " size=" + SIZE + " stream=" + (Object)((Object)stream), new Object[0]);
        }

        public static boolean hasOption(String opt) {
            return cmd.hasOption(opt);
        }

        static {
            QUERY_TIME = 10;
            QUERY_SIZE = 0;
            EVENT_SIZE = 50;
            BULK_EVENTS = 250;
            POOL_SIZE = 0;
        }

        public static enum STREAM {
            NONE,
            PULL,
            HAND,
            PULH;

        }

        public static enum LOGT {
            ALL,
            ELAPSED,
            NOTIME;

        }
    }

    private static interface Task
    extends Callable<Object>,
    AutoCloseable {
    }

    private static interface RandomCallback {
        public Value makeValue();
    }
}

