/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.AGAbstractTest;

public class AGHTTPClientTests {
    private AGHTTPClient client;
    private AuditingConnectionManager manager;
    private String serverUrl;

    @Before
    public void setUp() {
        this.serverUrl = AGAbstractTest.findServerUrl();
        this.manager = new AuditingConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager());
        this.client = new AGHTTPClient(this.serverUrl, (HttpClientConnectionManager)this.manager);
        this.client.setUsernameAndPassword(AGAbstractTest.username(), AGAbstractTest.password());
    }

    @Test
    public void testConnectionReleasedOnErrorWhenStreaming() {
        NullStreamer handler = new NullStreamer();
        int connectionsBefore = this.manager.getConnectionCount();
        try {
            this.client.get(this.serverUrl + "/PleaseRespondWith404", null, null, null);
        }
        catch (AGHttpException aGHttpException) {
            // empty catch block
        }
        this.manager.closeIdleConnections(0L, TimeUnit.SECONDS);
        Assert.assertEquals((long)connectionsBefore, (long)this.manager.getConnectionCount());
    }

    private static final class AuditingConnectionManager
    implements HttpClientConnectionManager {
        private final HttpClientConnectionManager wrapped;
        private int connectionCount = 0;

        public AuditingConnectionManager(HttpClientConnectionManager wrapped) {
            this.wrapped = wrapped;
        }

        public int getConnectionCount() {
            return this.connectionCount;
        }

        public ConnectionRequest requestConnection(HttpRoute route, Object state) {
            ++this.connectionCount;
            return this.wrapped.requestConnection(route, state);
        }

        public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
            this.wrapped.releaseConnection(conn, newState, validDuration, timeUnit);
            --this.connectionCount;
        }

        public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
            this.wrapped.connect(conn, route, connectTimeout, context);
        }

        public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            this.wrapped.upgrade(conn, route, context);
        }

        public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            this.wrapped.routeComplete(conn, route, context);
        }

        public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
            this.wrapped.closeIdleConnections(idletime, timeUnit);
            this.connectionCount = 0;
        }

        public void closeExpiredConnections() {
            this.wrapped.closeExpiredConnections();
        }

        public void shutdown() {
            this.wrapped.shutdown();
        }
    }

    private static final class NullStreamer
    extends AGResponseHandler {
        public NullStreamer() {
            super("who/cares/and/why/is/this/required");
        }

        public void handleResponse(HttpResponse httpResponse, HttpUriRequest httpUriRequest) {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }

        public boolean releaseConnection() {
            return false;
        }
    }
}

