/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGQueryExecution;
import com.franz.agraph.jena.AGQueryExecutionFactory;
import com.franz.agraph.jena.AGQueryFactory;
import com.franz.agraph.repository.AGCatalog;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.jena.query.Query;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.StmtIterator;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.Assert;
import org.junit.Test;
import test.AGAbstractTest;
import test.Util;

public class AGQueryExecutionTest
extends AGAbstractTest {
    protected static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";
    public static String SERVER_URL = System.getProperty("com.franz.agraph.test.serverURL", "http://localhost:10035");
    public static String CATALOG_ID = System.getProperty("com.franz.agraph.test.catalogID", "/");
    public static String REPOSITORY_ID = System.getProperty("com.franz.agraph.test.repositoryID", "testRepo");
    public static String USERNAME = System.getProperty("com.franz.agraph.test.username", "test");
    public static String PASSWORD = System.getProperty("com.franz.agraph.test.password", "xyzzy");
    protected static AGCatalog catalog;
    protected static AGGraphMaker maker;
    protected static AGModel model;
    protected static String baseURI;
    protected static ValueFactory vf;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        maker = new AGGraphMaker(this.conn);
        model = new AGModel(maker.getGraph());
        String path = "/tutorial/java-kennedy.ntriples";
        baseURI = "http://example.org/example/local";
        model.read(Util.resourceAsStream(path), baseURI, "N-TRIPLE");
    }

    @Test
    public void testExecConstructTriples() throws RepositoryException {
        String queryString = "PREFIX kdy: <http://www.franz.com/simple#> construct {?a kdy:has-grandchild ?c}    where { ?a kdy:has-child ?b .             ?b kdy:has-child ?c . }";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            int count = 0;
            Iterator iter = qe.execConstructTriples();
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            Assert.assertTrue((count != 0 ? 1 : 0) != 0);
            Assert.assertTrue((count <= 1000000 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExecConstructTriplesForNullQuery() throws RepositoryException {
        String queryString = null;
        AGQuery query = AGQueryFactory.create(queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.execConstructTriples();
            Assert.fail((String)"expected exception for null query string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testExecConstructTriplesForBadQuery() throws RepositoryException {
        String queryString = "select * from emp where emp_id=1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.execConstructTriples();
            Assert.fail((String)"expected exception for bad query string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testExecConstructTriplesForZeroResult() throws RepositoryException {
        String queryString = "PREFIX kdy: <http://www.franz.com/simple#> construct {?a kdy:has-grandchild ?d}    where { ?a kdy:has-child ?b .             ?b kdy:has-child ?c .            ?c kdy:has-child ?d . }";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            Iterator iter = qe.execConstructTriples();
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    @Test
    public void testExecConstructTriplesForNonConstructQuery() throws RepositoryException {
        String queryString = "select ?s ?p ?o where { ?s ?p ?o . } limit 1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.execConstructTriples();
            Assert.fail((String)"expected exception for non construct query.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testExecDescribeTriples() throws RepositoryException {
        String queryString = "describe ?s ?p ?o where { ?s ?p ?o . } limit 1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            int count = 0;
            Iterator iter = qe.execDescribeTriples();
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            Assert.assertTrue((count != 0 ? 1 : 0) != 0);
            Assert.assertTrue((count <= 1000000 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExecDescribeTriplesForNullQuery() throws RepositoryException {
        String queryString = null;
        AGQuery query = AGQueryFactory.create(queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.execDescribeTriples();
            Assert.fail((String)"expected exception for null query string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testExecDescribeTriplesForBadQuery() throws RepositoryException {
        String queryString = "select * from emp where emp_id=1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.execDescribeTriples();
            Assert.fail((String)"expected exception for bad query string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testExecDescribeTriplesForZeroResult() throws RepositoryException {
        String queryString = "describe ?s ?p ?o where { ?s ?p 'madhu' . } limit 1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            Iterator iter = qe.execDescribeTriples();
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    @Test
    public void testExecDescribeTriplesForNonDescribeQuery() throws RepositoryException {
        String queryString = "select ?s ?p ?o where { ?s ?p ?o . } limit 1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.execDescribeTriples();
            Assert.fail((String)"expected exception for non describe query.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecConstruct() throws RepositoryException {
        String queryString = "construct {?a kdy:has-grandchild ?c}    where { ?a kdy:has-child ?b .             ?b kdy:has-child ?c . }";
        model.setNsPrefix("kdy", "http://www.franz.com/simple#");
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            int count = 0;
            Model iter = qe.execConstruct();
            StmtIterator it = iter.listStatements();
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            Assert.assertTrue((count != 0 ? 1 : 0) != 0);
            Assert.assertTrue((count <= 1000000 ? 1 : 0) != 0);
        }
        finally {
            model.removeNsPrefix("kdy");
        }
    }

    @Test
    public void testgetQueryWithOutNamespace() throws RepositoryException {
        String queryString = "select ?s ?p ?o where { ?s ?p ?o . }";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            Query gq = qe.getQuery();
            Assert.assertNotNull((Object)gq);
        }
    }

    @Test
    public void testgetQueryWithOutNamespaceWrongQuery() throws RepositoryException {
        String queryString = "select sdfdsfdsf ?s ?p ?o where { ?s ?p ?o . }";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.getQuery();
            Assert.fail((String)"expected exception for bad query string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testgetQueryForNullQuery() throws RepositoryException {
        String queryString = null;
        AGQuery query = AGQueryFactory.create(queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.getQuery();
            Assert.fail((String)"expected exception for null query string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetTimeoutForExecSelect() throws RepositoryException {
        String queryString = "SELECT * WHERE { ?s ?p ?o . ?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . ?s3 ?p3 ?o3 } ORDER BY ?s1 ?p1 ?o1 LIMIT 1000";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.setTimeout(1001L);
            qe.execSelect();
            Assert.fail((String)"expected exception for query execution time.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetTimeoutForExecSelectWithZero() throws RepositoryException {
        String queryString = "SELECT (COUNT(DISTINCT ?s ) AS ?no) { { ?s ?p ?o  } UNION { ?o ?p ?s } FILTER(!isBlank(?s) && !isLiteral(?s)) }";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.setTimeout(0L);
            ResultSet rs = qe.execSelect();
            Assert.assertNotNull((Object)rs);
        }
    }

    @Test
    public void testSetTimeoutForExecSelectWithNegative() throws RepositoryException {
        String queryString = "select ?s ?p ?o where { ?s ?p ?o . } limit 1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.setTimeout(-5L);
            ResultSet rs = qe.execSelect();
            Assert.assertNotNull((Object)rs);
        }
    }

    @Test
    public void testSetTimeoutWithTimeunitForExecSelect() throws RepositoryException {
        String queryString = "SELECT * WHERE { ?s ?p ?o . ?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . ?s3 ?p3 ?o3 } ORDER BY ?s1 ?p1 ?o1 LIMIT 1000";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.setTimeout(1L, TimeUnit.SECONDS);
            qe.execSelect();
            Assert.fail((String)"expected exception for query execution time.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetTimeoutWithTimeunitForExecSelectWithZero() throws RepositoryException {
        String queryString = "select ?s ?p ?o where { ?s ?p ?o . } limit 1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.setTimeout(0L, TimeUnit.SECONDS);
            ResultSet rs = qe.execSelect();
            Assert.assertNotNull((Object)rs);
        }
    }

    @Test
    public void testSetTimeoutWithTimeunitForExecSelectWithNegative() throws RepositoryException {
        String queryString = "select ?s ?p ?o where { ?s ?p ?o . } limit 1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.setTimeout(-5L, TimeUnit.SECONDS);
            ResultSet rs = qe.execSelect();
            Assert.assertNotNull((Object)rs);
        }
    }

    @Test
    public void testSetTimeoutWithTimeunitForExecSelectWith1hour() throws RepositoryException {
        String queryString = "select ?s ?p ?o where { ?s ?p ?o . } limit 1";
        AGQuery query = AGQueryFactory.create((String)queryString);
        try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);){
            qe.setTimeout(1L, TimeUnit.HOURS);
            ResultSet rs = qe.execSelect();
            Assert.assertNotNull((Object)rs);
        }
    }

    static {
        maker = null;
        model = null;
        baseURI = null;
    }
}

