/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGServer;
import java.io.File;
import org.junit.AfterClass;
import org.junit.experimental.categories.Categories;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import test.AGAbstractTest;
import test.RepositoryConnectionTest;
import test.TestSuites;

public class AGRepositoryConnectionTest
extends RepositoryConnectionTest {
    public String TEST_DIR_PREFIX = System.getProperty("com.franz.agraph.test.dataDir", System.getProperty("user.dir") + File.separator + "src" + File.separator + "test" + File.separator);

    protected AGRepository createRepository() throws Exception {
        AGServer server = new AGServer(AGAbstractTest.findServerUrl(), AGAbstractTest.username(), AGAbstractTest.password());
        AGCatalog catalog = server.getCatalog("java-catalog");
        if (catalog == null) {
            throw new Exception("Test catalog java-catalog not available");
        }
        return catalog.createRepository("testRepo2");
    }

    @AfterClass
    public static void tearDownClass() {
        AGServer server = new AGServer(AGAbstractTest.findServerUrl(), AGAbstractTest.username(), AGAbstractTest.password());
        server.deleteRepository("testRepo2", "java-catalog");
    }

    @RunWith(value=Categories.class)
    @Categories.IncludeCategory(value={TestSuites.Broken.class})
    @Suite.SuiteClasses(value={AGRepositoryConnectionTest.class})
    public static class Broken {
    }

    @RunWith(value=Categories.class)
    @Categories.ExcludeCategory(value={TestSuites.NonPrepushTest.class})
    @Suite.SuiteClasses(value={AGRepositoryConnectionTest.class})
    public static class Prepush {
    }
}

