/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.pool.AGConnPool;
import com.franz.agraph.pool.AGConnProp;
import com.franz.agraph.pool.AGPoolProp;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRDFFormat;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGServerVersion;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.agraph.repository.AGXid;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.hamcrest.Matcher;
import org.json.JSONObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Categories;
import org.junit.matchers.JUnitMatchers;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import test.AGAbstractTest;
import test.RepositoryConnectionTest;
import test.TestSuites;
import test.Util;

public class AGRepositoryConnectionTests
extends RepositoryConnectionTest.RepositoryConnectionTests {
    private static final String TEST_REPO_1 = "testRepo1";
    private String oldUseAddStatementBuffer;
    private String oldAddStatementBufferMaxSize;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.oldUseAddStatementBuffer = System.getProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer", null);
        this.oldAddStatementBufferMaxSize = System.getProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", null);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.oldUseAddStatementBuffer != null) {
            System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer", this.oldUseAddStatementBuffer);
        } else {
            System.clearProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer");
        }
        if (this.oldAddStatementBufferMaxSize != null) {
            System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", this.oldAddStatementBufferMaxSize);
        } else {
            System.clearProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize");
        }
        super.tearDown();
    }

    @AfterClass
    public static void tearDownAll() {
        AGServer server = new AGServer(AGAbstractTest.findServerUrl(), AGAbstractTest.username(), AGAbstractTest.password());
        AGCatalog catalog = server.getCatalog("java-catalog");
        catalog.deleteRepository(TEST_REPO_1);
    }

    @Override
    protected Repository createRepository() throws Exception {
        AGServer server = new AGServer(AGAbstractTest.findServerUrl(), AGAbstractTest.username(), AGAbstractTest.password());
        AGCatalog catalog = server.getCatalog("java-catalog");
        if (catalog == null) {
            throw new Exception("Test catalog java-catalog not available");
        }
        AGRepository repo = catalog.createRepository(TEST_REPO_1);
        return repo;
    }

    @Test
    public void testHasStatementWithoutBNodes() throws Exception {
        this.testCon.add((Resource)this.name, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.name, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    @Test
    public void testHasStatementWithBNodes() throws Exception {
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    public void addInputStream(InputStream stream, RDFFormat format) throws Exception {
        this.testCon.add(stream, "", format, new Resource[0]);
    }

    public void addInputFile(File source, RDFFormat format) throws Exception {
        try (FileInputStream stream = new FileInputStream(source);){
            this.addInputStream(stream, format);
        }
    }

    public File createTempGzipFileFrom(File from) throws IOException {
        File gz = File.createTempFile(from.getName() + ".", ".gz");
        gz.deleteOnExit();
        Util.gzip(from, gz);
        return gz;
    }

    public File createTempZipFileFrom(File from) throws IOException {
        File zip = File.createTempFile(from.getName() + ".", ".zip");
        zip.deleteOnExit();
        Util.zip(from, zip);
        return zip;
    }

    @Test
    public void testAddGzipInputStreamNTriples() throws Exception {
        File nt = Util.resourceAsTempFile("/test/default-graph.nt");
        this.addInputFile(this.createTempGzipFileFrom(nt), RDFFormat.NTRIPLES);
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
    }

    @Test
    public void testAddZipFileNTriples() throws Exception {
        InputStream in = Util.resourceAsStream("/test/graphs.nt.zip");
        this.addInputStream(in, RDFFormat.NTRIPLES);
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    @Test
    public void testAddReaderNTriples() throws Exception {
        InputStream defaultGraphStream = Util.resourceAsStream("/test/default-graph.nt");
        try (InputStreamReader defaultGraph = new InputStreamReader(defaultGraphStream, "UTF-8");){
            this.testCon.add((Reader)defaultGraph, "", RDFFormat.NTRIPLES, new Resource[0]);
        }
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        InputStream graph1Stream = Util.resourceAsStream("/test/graph1.nt");
        try (InputStreamReader graph1 = new InputStreamReader(graph1Stream, "UTF-8");){
            this.testCon.add((Reader)graph1, "", RDFFormat.NTRIPLES, new Resource[]{this.context1});
        }
        InputStream graph2Stream = Util.resourceAsStream("/test/graph2.nt");
        try (InputStreamReader graph2 = new InputStreamReader(graph2Stream, "UTF-8");){
            this.testCon.add((Reader)graph2, "", RDFFormat.NTRIPLES, new Resource[]{this.context2});
        }
        Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        Assert.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    @Test
    public void testAddInputStreamNTriples() throws Exception {
        try (InputStream defaultGraph = Util.resourceAsStream("/test/default-graph.nt");){
            this.testCon.add(defaultGraph, "", RDFFormat.NTRIPLES, new Resource[0]);
        }
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        var2_2 = null;
        try (InputStream graph1 = Util.resourceAsStream("/test/graph1.nt");){
            this.testCon.add(graph1, "", RDFFormat.NTRIPLES, new Resource[]{this.context1});
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        var2_2 = null;
        try (InputStream graph2 = Util.resourceAsStream("/test/graph2.nt");){
            this.testCon.add(graph2, "", RDFFormat.NTRIPLES, new Resource[]{this.context2});
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        Assert.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    @Test
    public void testRecoverFromParseErrorNTriples() throws RepositoryException, IOException {
        String invalidData = "bad";
        String validData = "<http://example.org/foo#a> <http://example.org/foo#b> <http://example.org/foo#c> .";
        try {
            this.testCon.add((Reader)new StringReader(invalidData), "", RDFFormat.NTRIPLES, new Resource[0]);
            Assert.fail((String)"Invalid data should result in an exception");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
        try {
            this.testCon.add((Reader)new StringReader(validData), "", RDFFormat.NTRIPLES, new Resource[0]);
        }
        catch (RDFParseException e) {
            Assert.fail((String)"Valid data should not result in an exception");
        }
        Assert.assertEquals((String)"Repository contains incorrect number of statements", (long)1L, (long)this.testCon.size(new Resource[0]));
    }

    @Test
    public void testImportAllSupportedFormats() throws Exception {
        class SampleInput {
            public String file;
            public RDFFormat type;

            public SampleInput(RDFFormat format, String sampleFile) {
                this.type = format;
                this.file = sampleFile;
            }
        }
        SampleInput[] formats;
        AGRepository repo = (AGRepository)this.createRepository();
        AGRepositoryConnection conn = repo.getConnection();
        for (SampleInput format : formats = new SampleInput[]{new SampleInput(RDFFormat.NTRIPLES, "default-graph.nt"), new SampleInput(RDFFormat.NQUADS, "example.nq"), new SampleInput(AGRDFFormat.TRIG, "sample.trig"), new SampleInput(RDFFormat.TRIG, "sample.trig"), new SampleInput(RDFFormat.TRIX, "sample.trix"), new SampleInput(RDFFormat.TURTLE, "default-graph.ttl"), new SampleInput(RDFFormat.RDFXML, "tutorial-test8-expected.rdf"), new SampleInput(AGRDFFormat.NQX, "sample.nqx")}) {
            conn.remove((Resource)null, (URI)null, (Value)null, new Resource[]{null});
            try (InputStream in = Util.resourceAsStream("/test/" + format.file);){
                this.addInputStream(in, format.type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTupleQuerySparql() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?name ?mbox");
        queryBuilder.append(" WHERE { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        try (TupleQueryResult result = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("name"));
                Assert.assertTrue((boolean)solution.hasBinding("mbox"));
                Value nameResult = solution.getValue("name");
                Value mboxResult = solution.getValue("mbox");
                Assert.assertTrue((this.nameAlice.equals((Object)nameResult) || this.nameBob.equals((Object)nameResult) ? 1 : 0) != 0);
                Assert.assertTrue((this.mboxAlice.equals((Object)mboxResult) || this.mboxBob.equals((Object)mboxResult) ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTupleQueryUnicodeSparql() throws Exception {
        this.testCon.add((Resource)this.alexander, this.name, (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?person");
        queryBuilder.append(" WHERE { ?person foaf:name '");
        queryBuilder.append(this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440.getLabel()).append("' .}");
        try (TupleQueryResult result = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("person"));
                Assert.assertEquals((Object)this.alexander, (Object)solution.getValue("person"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedTupleQuerySparql() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?name ?mbox");
        queryBuilder.append(" WHERE { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding("name", (Value)this.nameBob);
        try (TupleQueryResult result = query.evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("name"));
                Assert.assertTrue((boolean)solution.hasBinding("mbox"));
                Value nameResult = solution.getValue("name");
                Value mboxResult = solution.getValue("mbox");
                Assert.assertEquals((String)("unexpected value for name: " + nameResult), (Object)this.nameBob, (Object)nameResult);
                Assert.assertEquals((String)("unexpected value for mbox: " + mboxResult), (Object)this.mboxBob, (Object)mboxResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedTupleQueryUnicodeSparql() throws Exception {
        this.testCon.add((Resource)this.alexander, this.name, (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?person");
        queryBuilder.append(" WHERE { ?person foaf:name '");
        queryBuilder.append(this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440.getLabel()).append("' .}");
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding("name", (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440);
        try (TupleQueryResult result = query.evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertTrue((boolean)solution.hasBinding("person"));
                Assert.assertEquals((Object)this.alexander, (Object)solution.getValue("person"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleGraphQuerySparql() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" CONSTRUCT { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        queryBuilder.append(" WHERE { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        try (GraphQueryResult result = this.testCon.prepareGraphQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                Statement st = (Statement)result.next();
                if (this.name.equals((Object)st.getPredicate())) {
                    Assert.assertTrue((this.nameAlice.equals((Object)st.getObject()) || this.nameBob.equals((Object)st.getObject()) ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((boolean)this.mbox.equals((Object)st.getPredicate()));
                Assert.assertTrue((this.mboxAlice.equals((Object)st.getObject()) || this.mboxBob.equals((Object)st.getObject()) ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedGraphQuerySparql() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" CONSTRUCT { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        queryBuilder.append(" WHERE { ?x foaf:name ?name .");
        queryBuilder.append("         ?x foaf:mbox ?mbox .}");
        GraphQuery query = this.testCon.prepareGraphQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding("name", (Value)this.nameBob);
        try (GraphQueryResult result = query.evaluate();){
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)result.hasNext());
            while (result.hasNext()) {
                Statement st = (Statement)result.next();
                Assert.assertTrue((this.name.equals((Object)st.getPredicate()) || this.mbox.equals((Object)st.getPredicate()) ? 1 : 0) != 0);
                if (this.name.equals((Object)st.getPredicate())) {
                    Assert.assertTrue((String)("unexpected value for name: " + st.getObject()), (boolean)this.nameBob.equals((Object)st.getObject()));
                    continue;
                }
                Assert.assertTrue((boolean)this.mbox.equals((Object)st.getPredicate()));
                Assert.assertTrue((String)("unexpected value for mbox: " + st.getObject()), (boolean)this.mboxBob.equals((Object)st.getObject()));
            }
        }
    }

    @Test
    public void testBegin() throws Exception {
        Assert.assertFalse((boolean)this.testCon.isActive());
        this.testCon.begin();
        Assert.assertTrue((boolean)this.testCon.isActive());
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.commit();
    }

    @Test
    public void testBeginRollback() throws Exception {
        Assert.assertFalse((boolean)this.testCon.isActive());
        this.testCon.begin();
        Assert.assertTrue((boolean)this.testCon.isActive());
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.rollback();
    }

    @Test
    public void testisActive() throws Exception {
        Assert.assertFalse((boolean)this.testCon.isActive());
        this.testCon.begin();
        Assert.assertTrue((boolean)this.testCon.isActive());
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.commit();
    }

    @Test
    public void testAddFile() throws Exception {
        Util.add(this.testCon, "/test/default-graph.nt", "", RDFFormat.NTRIPLES, new Resource[0]);
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        String graph1 = "/test/graph1.nt";
        Util.add(this.testCon, graph1, "", RDFFormat.NTRIPLES, new Resource[]{this.context1});
        String graph2 = "/test/graph2.nt";
        Util.add(this.testCon, graph2, "", RDFFormat.NTRIPLES, new Resource[]{this.context2});
        Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Assert.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        Assert.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        Assert.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        Assert.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextOverriding() throws Exception {
        block25: {
            AGRepository repo = (AGRepository)this.createRepository();
            AGValueFactory vf = repo.getValueFactory();
            AGRepositoryConnection conn = repo.getConnection();
            String oldPropValue = System.getProperty("com.franz.agraph.http.AGProtocol.overrideContext", "false");
            System.setProperty("com.franz.agraph.http.AGProtocol.overrideContext", "true");
            IRI originalContext = vf.createIRI("http://www.w3.org/2000/01/rdf-schema");
            IRI substituteContext1 = vf.createIRI("http://example.org#override1");
            IRI substituteContext2 = vf.createIRI("http://example.org#override2");
            try (InputStream in = Util.resourceAsStream("/test/sample.trix");){
                if (conn.getServer().getComparableVersion().compareTo(new AGServerVersion("7.0.0")) >= 0) {
                    conn.add(in, null, AGRDFFormat.TRIX, new Resource[]{substituteContext1, substituteContext2});
                    Assert.assertTrue((String)"statements should be in the substitute context 1", (boolean)conn.hasStatement(null, null, null, false, new Resource[]{substituteContext1}));
                    Assert.assertTrue((String)"statements should be in the substitute context 2", (boolean)conn.hasStatement(null, null, null, false, new Resource[]{substituteContext2}));
                    Assert.assertFalse((String)"no statements should be in the original context", (boolean)conn.hasStatement(null, null, null, false, new Resource[]{originalContext}));
                    break block25;
                }
                try {
                    conn.add(in, null, AGRDFFormat.TRIX, new Resource[]{substituteContext1});
                }
                catch (IllegalArgumentException e) {
                    if (in != null) {
                        if (var9_9 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                var9_9.addSuppressed(throwable);
                            }
                        } else {
                            in.close();
                        }
                    }
                    System.setProperty("com.franz.agraph.http.AGProtocol.overrideContext", oldPropValue);
                    return;
                }
                Assert.fail((String)"context overriding must fail with pre-v7.0.0 AG servers");
            }
            finally {
                System.setProperty("com.franz.agraph.http.AGProtocol.overrideContext", oldPropValue);
            }
        }
    }

    @Test
    public void testAddNQXFile() throws Exception {
        AGRepositoryConnection conn;
        AGRepository repo = (AGRepository)this.createRepository();
        AGRepositoryConnection aGRepositoryConnection = conn = repo.getConnection();
        aGRepositoryConnection.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, "color").add();
        try (InputStream in = Util.resourceAsStream("/test/sample.nqx");){
            conn.add(in, null, AGRDFFormat.NQX, new Resource[0]);
        }
    }

    @Test
    public void testClientImportWithAttributes() throws Exception {
        AGRepository repo = (AGRepository)this.createRepository();
        AGRepositoryConnection conn = repo.getConnection();
        try (InputStream in = Util.resourceAsStream("/test/default-graph.nt");){
            conn.add(in, null, RDFFormat.NTRIPLES, new JSONObject("{ color: blue }"), new Resource[0]);
        }
        in = Util.resourceAsStream("/test/default-graph.ttl");
        var4_4 = null;
        try {
            conn.add(in, null, RDFFormat.TURTLE, new JSONObject("{ color: green }"), new Resource[0]);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var4_4 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        conn.clear(new Resource[0]);
        in = Util.resourceAsStream("/test/rdftransaction.xml");
        var4_4 = null;
        try {
            conn.sendRDFTransaction(in, new JSONObject("{ color: red }"));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var4_4 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    @Test
    public void testSizeXRollback() throws Exception {
        AGRepository repo = (AGRepository)this.createRepository();
        AGRepositoryConnection conn = repo.getConnection();
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        conn.setAutoCommit(false);
        conn.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertEquals((long)1L, (long)conn.size(new Resource[0]));
        conn.prepareHttpRepoClient().setSendRollbackHeader(true);
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        conn.prepareHttpRepoClient().setSendRollbackHeader(false);
        conn.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertEquals((long)1L, (long)conn.size(new Resource[0]));
        conn.rollback();
    }

    @Test
    public void testNoBufferedAddStatementsInTransactionByDefault() throws Exception {
        int bufSize = 5;
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", "" + bufSize);
        try (AGRepositoryConnection testConBuffered = (AGRepositoryConnection)this.testRepository.getConnection();){
            Assert.assertEquals((long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            testConBuffered.begin();
            Assert.assertEquals((long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            testConBuffered.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertEquals((long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            testConBuffered.commit();
            Assert.assertEquals((long)0L, (long)testConBuffered.getNumBufferedAddStatements());
        }
    }

    @Test
    public void testNoBufferedAddStatementsInAutocommit() throws Exception {
        int bufSize = 5;
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer", "true");
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", "" + bufSize);
        try (AGRepositoryConnection testConBuffered = (AGRepositoryConnection)this.testRepository.getConnection();){
            testConBuffered.setAutoCommit(true);
            for (int i = 0; i < 2 * bufSize; ++i) {
                testConBuffered.add((Resource)this.bob, this.mbox, (Value)this.vf.createLiteral("bob" + i + "@example.org"), new Resource[0]);
                Assert.assertEquals((String)"Buffer should not be used in autocommit mode", (Object)false, (Object)testConBuffered.isUseAddStatementBuffer());
                Assert.assertEquals((String)"Buffer should be empty in autocommit mode", (long)0L, (long)testConBuffered.getNumBufferedAddStatements());
                Assert.assertEquals((String)"testCon sees the statements immediately", (long)(i + 1), (long)this.getTotalStatementCount(this.testCon));
            }
        }
    }

    @Test
    public void testBufferedAddStatementInTransaction() throws Exception {
        int bufSize = 5;
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer", "true");
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", "" + bufSize);
        try (AGRepositoryConnection testConBuffered = (AGRepositoryConnection)this.testRepository.getConnection();){
            testConBuffered.begin();
            Assert.assertEquals((long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            int numLoops = 10;
            for (int loopIter = 0; loopIter < numLoops; ++loopIter) {
                for (int i = 0; i < bufSize - 1; ++i) {
                    testConBuffered.add((Resource)this.bob, this.mbox, (Value)this.vf.createLiteral("bob" + loopIter + "-" + i + "@example.org"), new Resource[0]);
                    Assert.assertEquals((long)(i + 1), (long)testConBuffered.getNumBufferedAddStatements());
                    Assert.assertEquals((long)0L, (long)((AGRepositoryConnection)this.testCon).getNumBufferedAddStatements());
                }
                testConBuffered.add((Resource)this.bob, this.mbox, (Value)this.vf.createLiteral("bob" + loopIter + "-" + bufSize + "@example.org"), new Resource[0]);
                Assert.assertEquals((long)0L, (long)testConBuffered.getNumBufferedAddStatements());
                Assert.assertEquals((long)0L, (long)this.getTotalStatementCount(this.testCon));
            }
            testConBuffered.commit();
            Assert.assertEquals((long)(numLoops * bufSize), (long)this.getTotalStatementCount(this.testCon));
            Assert.assertEquals((long)(numLoops * bufSize), (long)this.getTotalStatementCount((RepositoryConnection)testConBuffered));
        }
    }

    @Test
    public void testBufferedAddStatementsInCancelledTransaction() throws Exception {
        int bufSize = 5;
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", "" + bufSize);
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer", "true");
        try (AGRepositoryConnection testConBuffered = (AGRepositoryConnection)this.testRepository.getConnection();){
            testConBuffered.begin();
            testConBuffered.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertEquals((long)1L, (long)testConBuffered.getNumBufferedAddStatements());
            testConBuffered.rollback();
            Assert.assertEquals((long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            Assert.assertEquals((long)0L, (long)this.getTotalStatementCount((RepositoryConnection)testConBuffered));
        }
    }

    @Test
    public void testBufferedAddStatementsHandled() throws Exception {
        int bufSize = 5;
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", "" + bufSize);
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer", "true");
        int i = 0;
        while (true) {
            try (AGRepositoryConnection testConBuffered = (AGRepositoryConnection)this.testRepository.getConnection();){
                testConBuffered.begin();
                testConBuffered.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
                Assert.assertEquals((long)1L, (long)testConBuffered.getNumBufferedAddStatements());
                switch (i) {
                    case 0: {
                        testConBuffered.prepareHttpRepoClient();
                        break;
                    }
                    case 1: {
                        testConBuffered.getUserAttributes();
                        break;
                    }
                    case 2: {
                        testConBuffered.getAttributeDefinitions();
                        break;
                    }
                    case 3: {
                        testConBuffered.getContextIDs();
                        break;
                    }
                    case 4: {
                        testConBuffered.getNamespaces();
                        break;
                    }
                    case 5: {
                        testConBuffered.remove((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context1});
                        break;
                    }
                    case 6: {
                        testConBuffered.commit();
                        break;
                    }
                    case 7: {
                        return;
                    }
                }
                Assert.assertEquals((long)0L, (long)testConBuffered.getNumBufferedAddStatements());
                Assert.assertEquals((String)("In iter #" + i + " there should be 1 statement"), (long)1L, (long)this.getTotalStatementCount((RepositoryConnection)testConBuffered));
            }
            ++i;
        }
    }

    @Test
    public void testBufferedAddStatementsCanBeRemoved() throws Exception {
        int bufSize = 5;
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", "" + bufSize);
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer", "true");
        try (AGRepositoryConnection testConBuffered = (AGRepositoryConnection)this.testRepository.getConnection();){
            testConBuffered.begin();
            testConBuffered.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertEquals((String)"item should be buffered", (long)1L, (long)testConBuffered.getNumBufferedAddStatements());
            testConBuffered.remove((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertEquals((String)"item should not be buffered, because remove() calls prepareHttpRepoClient()", (long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            testConBuffered.commit();
            Assert.assertEquals((String)"Nothing should be added in the end", (long)0L, (long)this.getTotalStatementCount(this.testCon));
        }
    }

    @Test
    public void testBufferedAddStatementsHandledWhenStartingAutoCommit() throws Exception {
        int bufSize = 5;
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize", "" + bufSize);
        System.setProperty("com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer", "true");
        try (AGRepositoryConnection testConBuffered = (AGRepositoryConnection)this.testRepository.getConnection();){
            boolean numStatements = false;
            Assert.assertEquals((String)"Starting in autocommit is the default", (Object)true, (Object)testConBuffered.isAutoCommit());
            Assert.assertEquals((String)"Buffering is initially disabled", (Object)false, (Object)testConBuffered.isUseAddStatementBuffer());
            Assert.assertEquals((String)"Buffer is initially empty", (long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            testConBuffered.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertEquals((String)"item should not be buffered", (long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            Assert.assertEquals((String)"Stmt #1 should be visible to other connection", (long)1L, (long)this.getTotalStatementCount(this.testCon));
            testConBuffered.setAutoCommit(false);
            Assert.assertEquals((String)"Disabling autocommit should enable buffer", (Object)true, (Object)testConBuffered.isUseAddStatementBuffer());
            Assert.assertEquals((String)"Disabling autocommit should start with empty buffer", (long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            testConBuffered.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[0]);
            Assert.assertEquals((long)1L, (long)testConBuffered.getNumBufferedAddStatements());
            Assert.assertEquals((String)"Stmt #2 should not yet be visible to other connection", (long)1L, (long)this.getTotalStatementCount(this.testCon));
            testConBuffered.setAutoCommit(true);
            Assert.assertEquals((String)"Enabling autocomit should handle and then disable buffering", (long)0L, (long)testConBuffered.getNumBufferedAddStatements());
            Assert.assertEquals((String)"Stmt #2 should now be visible to other connection", (long)2L, (long)this.getTotalStatementCount(this.testCon));
        }
    }

    @Test
    public void testBufferedAddStatementsProgrammaticallyDisableNoop() throws Exception {
        try (AGRepositoryConnection testConUnbuffered = (AGRepositoryConnection)this.testRepository.getConnection();){
            testConUnbuffered.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[0]);
            Assert.assertEquals((long)1L, (long)this.getTotalStatementCount(this.testCon));
            Assert.assertEquals((long)0L, (long)testConUnbuffered.getNumBufferedAddStatements());
            testConUnbuffered.setAddStatementBufferEnabled(false);
            testConUnbuffered.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertEquals((long)2L, (long)this.getTotalStatementCount(this.testCon));
            Assert.assertEquals((long)0L, (long)testConUnbuffered.getNumBufferedAddStatements());
            testConUnbuffered.clear(new Resource[0]);
            Assert.assertEquals((long)0L, (long)this.getTotalStatementCount(this.testCon));
        }
    }

    @Test
    public void testBufferedAddStatementsProgrammaticallyEnableDisable() throws Exception {
        try (AGRepositoryConnection c = (AGRepositoryConnection)this.testRepository.getConnection();){
            Assert.assertEquals((Object)false, (Object)c.isUseAddStatementBuffer());
            c.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[0]);
            Assert.assertEquals((String)"Unbuffered stmt should be seen", (long)1L, (long)this.getTotalStatementCount(this.testCon));
            Assert.assertEquals((String)"No buffer applicable", (long)0L, (long)c.getNumBufferedAddStatements());
            c.setAddStatementBufferEnabled(true);
            Assert.assertEquals((String)"buffering now enabled, but no transaction started so buffer should have no effect", (Object)false, (Object)c.isUseAddStatementBuffer());
            c.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertEquals((long)2L, (long)this.getTotalStatementCount(this.testCon));
            Assert.assertEquals((long)0L, (long)c.getNumBufferedAddStatements());
            c.clear(new Resource[0]);
            c.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[0]);
            c.begin();
            Assert.assertEquals((String)"now in a transaction, so buffering should be active", (Object)true, (Object)c.isUseAddStatementBuffer());
            c.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertEquals((long)1L, (long)this.getTotalStatementCount(this.testCon));
            Assert.assertEquals((long)1L, (long)c.getNumBufferedAddStatements());
            c.setAddStatementBufferEnabled(false);
            Assert.assertEquals((String)"Disabling buffer should send pending stmt", (long)0L, (long)c.getNumBufferedAddStatements());
            Assert.assertEquals((String)"Disabling buffer should send pending stmt", (long)1L, (long)this.getTotalStatementCount(this.testCon));
        }
    }

    @Test
    public void testBufferedAddStatementsProgrammaticallyResize() throws Exception {
        try (AGRepositoryConnection c = (AGRepositoryConnection)this.testRepository.getConnection();){
            c.setAddStatementBufferEnabled(true);
            c.setAddStatementBufferMaxSize(10);
            c.begin();
            for (int i = 0; i < 8; ++i) {
                c.add((Resource)this.alice, this.mbox, (Value)this.vf.createLiteral("alice" + i + "@example.org"), new Resource[0]);
            }
            Assert.assertEquals((long)0L, (long)this.getTotalStatementCount(this.testCon));
            Assert.assertEquals((long)8L, (long)c.getNumBufferedAddStatements());
            c.setAddStatementBufferMaxSize(15);
            Assert.assertEquals((String)"upsizing buffer should keep items", (long)8L, (long)c.getNumBufferedAddStatements());
            c.setAddStatementBufferMaxSize(9);
            Assert.assertEquals((String)"downsizing buffer should keep items", (long)8L, (long)c.getNumBufferedAddStatements());
            c.setAddStatementBufferMaxSize(7);
            Assert.assertEquals((String)"downsizing buffer should forcee all items out", (long)0L, (long)c.getNumBufferedAddStatements());
            Assert.assertEquals((String)"not committed yet", (long)0L, (long)this.getTotalStatementCount(this.testCon));
            c.commit();
            Assert.assertEquals((String)"downsizing buffer should force all items out", (long)8L, (long)this.getTotalStatementCount(this.testCon));
        }
    }

    @Test
    public void testBufferedAddStatementsProgrammaticallyWithContext() throws Exception {
        try (AGRepositoryConnection c = (AGRepositoryConnection)this.testRepository.getConnection();){
            c.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context1});
            Assert.assertEquals((long)1L, (long)this.getTotalStatementCount(this.testCon));
            this.testCon.remove((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            Assert.assertEquals((String)"Remove with different context should have no effect", (long)1L, (long)this.getTotalStatementCount(this.testCon));
            this.testCon.remove((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context1});
            Assert.assertEquals((String)"Remove with matching context should have effect", (long)0L, (long)this.getTotalStatementCount(this.testCon));
            c.setAddStatementBufferMaxSize(3);
            c.setAddStatementBufferEnabled(true);
            c.begin();
            Assert.assertEquals((Object)true, (Object)c.isUseAddStatementBuffer());
            c.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context1});
            c.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            c.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context2});
            Assert.assertEquals((String)"3 statements should have filled the buffer", (long)0L, (long)c.getNumBufferedAddStatements());
            Assert.assertEquals((String)"Statements should not yet be committed", (long)0L, (long)this.getTotalStatementCount(this.testCon));
            c.commit();
            Assert.assertEquals((long)3L, (long)this.getTotalStatementCount(this.testCon));
            this.testCon.remove((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context1});
            Assert.assertEquals((long)2L, (long)this.getTotalStatementCount(this.testCon));
            this.testCon.remove((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            Assert.assertEquals((long)1L, (long)this.getTotalStatementCount(this.testCon));
            this.testCon.remove((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context2});
            Assert.assertEquals((long)0L, (long)this.getTotalStatementCount(this.testCon));
        }
    }

    @Test
    public void testBufferedAddStatementsAndPool() throws Exception {
        Assert.assertEquals((long)0L, (long)this.getTotalStatementCount(this.testCon));
        AGConnPool pool = AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "java-catalog", AGConnProp.repository, TEST_REPO_1, AGConnProp.session, AGConnProp.Session.TX, AGPoolProp.maxActive, 1, AGPoolProp.initialSize, 1});
        AGRepositoryConnection conn = pool.borrowConnection();
        Assert.assertEquals((long)0L, (long)this.getTotalStatementCount((RepositoryConnection)conn));
        conn.setAddStatementBufferEnabled(true);
        conn.setAddStatementBufferMaxSize(10);
        conn.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
        conn.close();
        conn = pool.borrowConnection();
        Assert.assertEquals((long)0L, (long)this.getTotalStatementCount((RepositoryConnection)conn));
    }

    @Test
    public void testGetStoreID() {
        try (AGRepositoryConnection c = (AGRepositoryConnection)this.testRepository.getConnection();){
            long id1 = c.getStoreID();
            long id2 = c.getStoreID();
            Assert.assertEquals((long)id1, (long)id2);
        }
    }

    private void testXAResourceCommon(AGRepositoryConnection conn, boolean twoPhase, boolean abort) throws XAException {
        if (conn.getServer().getComparableVersion().compareTo(new AGServerVersion("6.5.0")) >= 0) {
            XAResource xares = conn.getXAResource();
            conn.setAutoCommit(false);
            TestXid xid = new TestXid();
            long beforeSize = conn.size(new Resource[0]);
            xares.start(xid, 0);
            conn.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
            Assert.assertEquals((long)(1L + beforeSize), (long)conn.size(new Resource[0]));
            xares.end(xid, 0x4000000);
            if (twoPhase) {
                xares.prepare(xid);
                Xid[] preparedXids = xares.recover(0x1000000);
                Assert.assertEquals((long)1L, (long)preparedXids.length);
                if (preparedXids.length == 1) {
                    Assert.assertTrue((boolean)xid.equals(preparedXids[0]));
                }
            }
            if (abort) {
                if (twoPhase) {
                    xares.rollback(xid);
                } else {
                    conn.rollback();
                }
                Assert.assertEquals((long)beforeSize, (long)conn.size(new Resource[0]));
            } else {
                if (twoPhase) {
                    xares.commit(xid, false);
                } else {
                    xares.commit(xid, true);
                }
                Assert.assertEquals((long)(1L + beforeSize), (long)conn.size(new Resource[0]));
                Assert.assertEquals((long)0L, (long)xares.recover(0x1000000).length);
            }
        }
    }

    @Test
    public void testXAResourceRollback() throws Exception {
        AGRepositoryConnection conn = (AGRepositoryConnection)this.testCon;
        this.testXAResourceCommon(conn, true, true);
    }

    @Test
    public void testXAResourceSinglePhaseCommit() throws Exception {
        AGRepositoryConnection conn = (AGRepositoryConnection)this.testCon;
        this.testXAResourceCommon(conn, false, false);
    }

    @Test
    public void testXAResourceTwoPhaseCommit() throws Exception {
        AGRepositoryConnection conn = (AGRepositoryConnection)this.testCon;
        this.testXAResourceCommon(conn, true, false);
    }

    @Test
    public void testNDGeospatialDatatypeAutomation() throws Exception {
        AGRepository repo = (AGRepository)this.createRepository();
        try (AGRepositoryConnection conn = repo.getConnection();){
            boolean result = conn.getNDGeospatialDatatypeAutomation();
            Assert.assertFalse((String)"non-false result for nD geospatial automation.", (boolean)result);
            conn.enableNDGeospatialDatatypeAutomation();
            result = conn.getNDGeospatialDatatypeAutomation();
            Assert.assertTrue((String)"non-true result for nD geospatial automation.", (boolean)result);
            conn.disableNDGeospatialDatatypeAutomation();
            result = conn.getNDGeospatialDatatypeAutomation();
            Assert.assertFalse((String)"non-false result for nD geospatial automation.", (boolean)result);
        }
    }

    @Test
    public void testQueryOptions() throws Exception {
        AGRepositoryConnection agTestCon = (AGRepositoryConnection)this.testCon;
        AGServerVersion minVersion = new AGServerVersion("7.1.0");
        if (agTestCon.getServer().getComparableVersion().compareTo(minVersion) >= 0) {
            agTestCon.setQueryOption("engine", "mjqe");
            agTestCon.setQueryOption("logLineLength", "100");
            Assert.assertEquals((Object)agTestCon.getQueryOption("engine"), (Object)"mjqe");
            Map options = agTestCon.getQueryOptions();
            Assert.assertEquals((long)options.size(), (long)2L);
            Assert.assertThat(options.keySet(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"engine", "logLineLength"}));
            Assert.assertEquals(options.get("engine"), (Object)"mjqe");
            Assert.assertEquals(options.get("logLineLength"), (Object)"100");
            agTestCon.removeQueryOption("engine");
            Assert.assertEquals((Object)agTestCon.getQueryOption("engine"), null);
        }
    }

    @Test
    public void testRootCatalog() throws Exception {
        AGRepositoryConnection agTestCon = (AGRepositoryConnection)this.testCon;
        AGServer server = agTestCon.getServer();
        AGCatalog catalog = server.getCatalog("root");
        Assert.assertEquals((long)catalog.getCatalogType(), (long)0L);
        Assert.assertEquals((Object)catalog, (Object)server.getRootCatalog());
    }

    private class TestXid
    implements Xid {
        private int formatId = 123;
        private byte[] branchQualifier = this.makeRandomByteArray(64);
        private byte[] globalTransactionId = this.makeRandomByteArray(64);

        private byte[] makeRandomByteArray(int size) {
            Random rand = new Random();
            byte[] nbyte = new byte[size];
            rand.nextBytes(nbyte);
            return nbyte;
        }

        @Override
        public byte[] getBranchQualifier() {
            return this.branchQualifier;
        }

        @Override
        public int getFormatId() {
            return this.formatId;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return this.globalTransactionId;
        }

        public boolean equals(Object other) {
            if (other instanceof AGXid) {
                AGXid xid = (AGXid)other;
                return xid.getFormatId() == this.getFormatId() && Arrays.equals(xid.getGlobalTransactionId(), this.getGlobalTransactionId()) && Arrays.equals(xid.getBranchQualifier(), this.getBranchQualifier());
            }
            return false;
        }
    }

    @RunWith(value=Categories.class)
    @Categories.IncludeCategory(value={TestSuites.Broken.class})
    @Suite.SuiteClasses(value={AGRepositoryConnectionTests.class})
    public static class Broken {
    }

    @RunWith(value=Categories.class)
    @Categories.ExcludeCategory(value={TestSuites.NonPrepushTest.class})
    @Suite.SuiteClasses(value={AGRepositoryConnectionTests.class})
    public static class Prepush {
    }
}

