/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.util.Util;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import test.AGAbstractTest;

public class AGUtilTest
extends AGAbstractTest {
    @Test
    public void testGetCatalog() {
        Assert.assertEquals((Object)"cat", (Object)Util.getCatalogFromSpec((String)"cat:repo"));
    }

    @Test
    public void testGetCatalogNull() {
        Assert.assertNull((Object)Util.getCatalogFromSpec((String)"repo"));
    }

    @Test
    public void testGetRepo() {
        Assert.assertEquals((Object)"repo", (Object)Util.getRepoFromSpec((String)"cat:repo"));
    }

    @Test
    public void testGetRepoNoCat() {
        Assert.assertEquals((Object)"repo", (Object)Util.getRepoFromSpec((String)"repo"));
    }

    @RunWith(value=Parameterized.class)
    public static class IntArrayCompareTests {
        private final int[] a;
        private final int[] b;
        private final Integer expected;

        public static Collection<Object[]> data() {
            return Arrays.asList({new int[0], new int[0], 0}, {new int[]{1}, new int[]{2}, -1}, {new int[]{42}, new int[]{42}, 0}, {new int[]{1, 2, 3}, new int[]{1, 2, 3}, 0}, {new int[]{1, 2, 3}, new int[]{2, 2, 3}, -1}, {new int[]{1, 2, 3}, new int[]{1, 0, 3}, 1}, {new int[]{1, 2, 3}, new int[]{1, 2}, 1}, {new int[]{0, 1}, new int[]{1, 2, 3}, -1}, {new int[]{1, 2, 3}, new int[]{1, 2, 4}, -1}, {null, new int[]{1, 2, 3}, null}, {new int[]{1, 2, 3}, null, null}, {null, null, null});
        }

        public IntArrayCompareTests(int[] a, int[] b, Integer expected) {
            this.a = a;
            this.b = b;
            this.expected = expected;
        }

        @Test
        public void test() {
            try {
                Integer actual = Integer.signum(Util.compare((int[])this.a, (int[])this.b));
                Assert.assertEquals((Object)this.expected, (Object)actual);
            }
            catch (NullPointerException e) {
                Assert.assertNull((String)"Expected exception not thrown", (Object)this.expected);
            }
        }

        @Test
        public void testReversed() {
            try {
                Integer actual = Integer.signum(-Util.compare((int[])this.b, (int[])this.a));
                Assert.assertEquals((Object)this.expected, (Object)actual);
            }
            catch (NullPointerException e) {
                Assert.assertNull((String)"Expected exception not thrown", (Object)this.expected);
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class IntArrayMismatchTests {
        private final int[] a;
        private final int[] b;
        private final Integer expected;

        public static Collection<Object[]> data() {
            return Arrays.asList({new int[0], new int[0], -1}, {new int[]{1}, new int[]{2}, 0}, {new int[]{42}, new int[]{42}, -1}, {new int[]{1, 2, 3}, new int[]{2, 2, 3}, 0}, {new int[]{1, 2, 3}, new int[]{1, 0, 3}, 1}, {new int[]{1, 2, 3}, new int[]{1, 2}, 3}, {new int[]{1, 2}, new int[]{1, 2, 3}, 3}, {new int[]{0, 1}, new int[]{1, 2, 3}, 0}, {null, new int[]{1, 2, 3}, null}, {new int[]{1, 2, 3}, null, null}, {null, null, null});
        }

        public IntArrayMismatchTests(int[] a, int[] b, Integer expected) {
            this.a = a;
            this.b = b;
            this.expected = expected;
        }

        @Test
        public void test() {
            try {
                Integer actual = Util.mismatch((int[])this.a, (int[])this.b);
                Assert.assertEquals((Object)this.expected, (Object)actual);
            }
            catch (NullPointerException e) {
                Assert.assertNull((String)"Expected exception not thrown", (Object)this.expected);
            }
        }
    }
}

