/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGVirtualRepository;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class FederationTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void federationBNodes() throws Exception {
        BNode bnode = this.vf.createBNode();
        this.conn.add((Resource)bnode, RDF.TYPE, (Value)this.vf.createIRI("http://Foo"), new Resource[0]);
        AGVirtualRepository fed = server.federate(new AGAbstractRepository[]{this.repo, this.repo});
        AGRepositoryConnection conn2 = fed.getConnection();
        conn2.getValueFactory().createBNode();
        conn2.getValueFactory().createBNode("foo");
        try {
            conn2.add((Resource)bnode, RDF.TYPE, (Value)this.vf.createIRI("http://Boo"), new Resource[0]);
            Assert.fail((String)"expected can't write to federation.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        AGTupleQuery q = conn2.prepareTupleQuery(QueryLanguage.SPARQL, "select ?s {?s ?p ?o}");
        TupleQueryResult result = q.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        BindingSet bind = (BindingSet)result.next();
        Assert.assertEquals((String)bnode.stringValue(), (String)bind.getValue("s").stringValue());
    }
}

