/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGInfModel;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGQueryExecution;
import com.franz.agraph.jena.AGQueryExecutionFactory;
import com.franz.agraph.jena.AGQueryFactory;
import com.franz.agraph.jena.AGReasoner;
import com.franz.agraph.jena.AGStatement;
import com.franz.agraph.repository.AGRepositoryConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class JenaTests
extends AGAbstractTest {
    private void addOne(AGModel model) throws RepositoryException {
        Assert.assertEquals((long)0L, (long)model.size());
        org.apache.jena.rdf.model.Resource bob = model.createResource("http://example.org/people/bob");
        org.apache.jena.rdf.model.Resource dave = model.createResource("http://example.org/people/dave");
        Property fatherOf = model.createProperty("http://example.org/ontology/fatherOf");
        model.add(bob, fatherOf, (RDFNode)dave);
        Assert.assertEquals((long)1L, (long)model.size());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaAutoCommitTrue() throws Exception {
        this.conn.setAutoCommit(true);
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getGraph());
        AGModel model = this.closeLater(new AGModel(graph));
        this.addOne(model);
        Assert.assertEquals((String)"a different connection, triple was already committed", (long)1L, (long)this.getSize());
        model.commit();
        Assert.assertEquals((long)1L, (long)this.conn.size(new Resource[0]));
        Assert.assertEquals((String)"a different connection", (long)1L, (long)this.getSize());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaAutoCommitFalse() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getGraph());
        AGModel model = this.closeLater(new AGModel(graph));
        try {
            model.begin();
            this.addOne(model);
            Assert.assertEquals((String)"a different connection, empty", (long)0L, (long)this.getSize());
            model.commit();
            Assert.assertEquals((long)1L, (long)this.conn.size(new Resource[0]));
            Assert.assertEquals((String)"a different connection", (long)1L, (long)this.getSize());
        }
        catch (Exception e) {
            model.abort();
            throw e;
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sparqlOrderByError_bug19157_rfe9971_no_check() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getGraph());
        AGModel model = this.closeLater(new AGModel(graph));
        org.apache.jena.rdf.model.Resource bob = model.createResource("http://example.org/people/bob");
        org.apache.jena.rdf.model.Resource dave = model.createResource("http://example.org/people/dave");
        Property fatherOf = model.createProperty("http://example.org/ontology/fatherOf");
        Property age = model.createProperty("http://example.org/ontology/age");
        Literal three = model.createTypedLiteral(3);
        model.add(bob, fatherOf, (RDFNode)dave);
        model.add(dave, age, (RDFNode)three);
        AGQuery query = AGQueryFactory.create((String)"select ?s ?p ?o where { ?s ?p ?o . } order by ?x ?s");
        AGQueryExecution qe = this.closeLater(AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model));
        qe.execSelect();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sparqlOrderByError_bug19157_rfe9971_yes_check() throws Exception {
        block2: {
            AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
            AGGraph graph = this.closeLater(maker.getGraph());
            AGModel model = this.closeLater(new AGModel(graph));
            org.apache.jena.rdf.model.Resource bob = model.createResource("http://example.org/people/bob");
            org.apache.jena.rdf.model.Resource dave = model.createResource("http://example.org/people/dave");
            Property fatherOf = model.createProperty("http://example.org/ontology/fatherOf");
            Property age = model.createProperty("http://example.org/ontology/age");
            Literal three = model.createTypedLiteral(3);
            model.add(bob, fatherOf, (RDFNode)dave);
            model.add(dave, age, (RDFNode)three);
            AGQuery query = AGQueryFactory.create((String)"select ?s ?p ?o where { ?s ?p ?o . } order by ?z ?s");
            query.setCheckVariables(true);
            AGQueryExecution qe = this.closeLater(AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model));
            try {
                qe.execSelect();
                Assert.fail((String)"query should have failed because of ?z");
            }
            catch (QueryException e) {
                if (e.getMessage().contains("Variables do not intersect with query: ?z") || e.getMessage().contains("unknown variable in order expression: ?z") || e.getMessage().contains("Unknown variable used in order expression: ?z")) break block2;
                throw e;
            }
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaGraphs_bug19491() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph defaultGraph = this.closeLater(maker.getGraph());
        AGModel defaultModel = this.closeLater(new AGModel(defaultGraph));
        this.addOne(defaultModel);
        AGGraph namedGraph = this.closeLater(maker.openGraph("http://example.com/named"));
        AGModel namedModel = this.closeLater(new AGModel(namedGraph));
        this.addOne(namedModel);
        AGReasoner reasoner = new AGReasoner();
        defaultGraph = this.closeLater(maker.getGraph());
        defaultModel = this.closeLater(new AGModel(defaultGraph));
        AGInfModel infModel = this.closeLater(new AGInfModel(reasoner, defaultModel));
        Assert.assertEquals((String)"conn is full", (long)2L, (long)this.conn.size(new Resource[0]));
        Assert.assertEquals((String)"infModel should be partial", (long)1L, (long)this.closeLater(infModel.listStatements((org.apache.jena.rdf.model.Resource)null, (Property)null, (RDFNode)null)).toList().size());
        Assert.assertEquals((String)"defaultModel should be partial", (long)1L, (long)this.closeLater(defaultModel.listStatements((org.apache.jena.rdf.model.Resource)null, (Property)null, (RDFNode)null)).toList().size());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaReasoning_bug19484() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getGraph());
        AGModel model = this.closeLater(new AGModel(graph));
        org.apache.jena.rdf.model.Resource bob = model.createResource("http://example.org/people/bob");
        org.apache.jena.rdf.model.Resource dave = model.createResource("http://example.org/people/dave");
        Property fatherOf = model.createProperty("http://example.org/ontology/fatherOf");
        Property hasFather = model.createProperty("http://example.org/ontology/hasFather");
        model.add((org.apache.jena.rdf.model.Resource)hasFather, OWL.inverseOf, (RDFNode)fatherOf);
        model.add(bob, fatherOf, (RDFNode)dave);
        AGQuery query = AGQueryFactory.create((String)"select * where { <http://example.org/people/dave> <http://example.org/ontology/hasFather> ?o . }");
        AGInfModel inf = this.closeLater(new AGInfModel(new AGReasoner(), model));
        StmtIterator stmts = this.closeLater(inf.listStatements(dave, hasFather, (RDFNode)bob));
        Assert.assertTrue((String)"with reasoning", (boolean)stmts.hasNext());
        AGQueryExecution exe = this.closeLater(AGQueryExecutionFactory.create((AGQuery)query, (AGModel)inf));
        this.closeLater(exe);
        ResultSet results = exe.execSelect();
        Assert.assertTrue((String)"with reasoning", (boolean)results.hasNext());
        StmtIterator stmts2 = this.closeLater(model.listStatements(dave, hasFather, (RDFNode)bob));
        Assert.assertFalse((String)"without reasoning", (boolean)stmts2.hasNext());
        AGQueryExecution exe2 = this.closeLater(AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model));
        this.closeLater(exe2);
        ResultSet results2 = exe2.execSelect();
        Assert.assertFalse((String)"without reasoning", (boolean)results2.hasNext());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void savingModel_spr37167() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getGraph());
        AGModel model = this.closeLater(new AGModel(graph));
        org.apache.jena.rdf.model.Resource bob = model.createResource("http://example.org/people/bob");
        org.apache.jena.rdf.model.Resource dave = model.createResource("http://example.org/people/dave");
        Property fatherOf = model.createProperty("http://example.org/ontology/fatherOf");
        model.add(bob, fatherOf, (RDFNode)dave);
        org.apache.jena.rdf.model.Resource blankNode = model.createResource();
        Property has = model.createProperty("http://example.org/ontology/has");
        model.add(blankNode, has, (RDFNode)dave);
        File outputFile = File.createTempFile("JenaTest-", ".txt");
        outputFile.deleteOnExit();
        model.write((OutputStream)this.closeLater(new FileOutputStream(outputFile)));
        graph = this.closeLater(maker.getGraph());
        model = this.closeLater(new AGModel(graph));
        outputFile = File.createTempFile("JenaTest-", ".txt");
        outputFile.deleteOnExit();
        model.write((OutputStream)this.closeLater(new FileOutputStream(outputFile)));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaRestrictionReasoning() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.getGraph());
        AGModel model = this.closeLater(new AGModel(graph));
        AGReasoner reasoner = AGReasoner.RESTRICTION;
        AGInfModel infmodel = this.closeLater(new AGInfModel(reasoner, model));
        org.apache.jena.rdf.model.Resource a = model.createResource("http://a");
        org.apache.jena.rdf.model.Resource c = model.createResource("http://C");
        org.apache.jena.rdf.model.Resource d = model.createResource("http://D");
        Property p = model.createProperty("http://p");
        org.apache.jena.rdf.model.Resource r = model.createResource("http://R");
        org.apache.jena.rdf.model.Resource v = model.createResource("http://v");
        org.apache.jena.rdf.model.Resource w = model.createResource("http://w");
        model.add(c, OWL.equivalentClass, (RDFNode)r);
        model.add(r, RDF.type, (RDFNode)OWL.Restriction);
        model.add(r, OWL.onProperty, (RDFNode)p);
        model.add(r, OWL.hasValue, (RDFNode)v);
        model.add(a, RDF.type, (RDFNode)c);
        Assert.assertTrue((String)"missing hasValue inference 1", (boolean)infmodel.contains(a, p, (RDFNode)v));
        model.removeAll();
        model.add(c, OWL.equivalentClass, (RDFNode)r);
        model.add(r, RDF.type, (RDFNode)OWL.Restriction);
        model.add(r, OWL.onProperty, (RDFNode)p);
        model.add(r, OWL.hasValue, (RDFNode)v);
        model.add(a, p, (RDFNode)v);
        Assert.assertTrue((String)"missing hasValue inference 2", (boolean)infmodel.contains(a, RDF.type, (RDFNode)c));
        model.removeAll();
        model.add(c, OWL.equivalentClass, (RDFNode)r);
        model.add(r, RDF.type, (RDFNode)OWL.Restriction);
        model.add(r, OWL.onProperty, (RDFNode)p);
        model.add(r, OWL.someValuesFrom, (RDFNode)d);
        model.add(a, p, (RDFNode)v);
        model.add(a, p, (RDFNode)w);
        model.add(v, RDF.type, (RDFNode)d);
        Assert.assertTrue((String)"missing someValuesFrom inference", (boolean)infmodel.contains(a, RDF.type, (RDFNode)c));
        Assert.assertFalse((String)"unexpected someValuesFrom inference", (boolean)infmodel.contains(w, RDF.type, (RDFNode)d));
        model.removeAll();
        model.add(c, OWL.equivalentClass, (RDFNode)r);
        model.add(r, RDF.type, (RDFNode)OWL.Restriction);
        model.add(r, OWL.onProperty, (RDFNode)p);
        model.add(r, OWL.allValuesFrom, (RDFNode)d);
        model.add(a, p, (RDFNode)v);
        model.add(a, RDF.type, (RDFNode)c);
        Assert.assertTrue((String)"missing allValuesFrom inference", (boolean)infmodel.contains(v, RDF.type, (RDFNode)d));
        model.removeAll();
        model.add(c, OWL.equivalentClass, (RDFNode)r);
        model.add(r, RDF.type, (RDFNode)OWL.Restriction);
        model.add(r, OWL.onProperty, (RDFNode)p);
        model.add(r, OWL.allValuesFrom, (RDFNode)d);
        model.add(a, p, (RDFNode)v);
        model.add(a, p, (RDFNode)w);
        model.add(v, RDF.type, (RDFNode)d);
        model.add(w, RDF.type, (RDFNode)d);
        Assert.assertFalse((String)"unexpected allValuesFrom inference", (boolean)infmodel.contains(a, RDF.type, (RDFNode)c));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaGraphScopedReasoning() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph gd = this.closeLater(maker.getGraph());
        AGGraph g1 = this.closeLater(maker.createGraph("http://example.org/g1"));
        AGGraph g2 = this.closeLater(maker.createGraph("http://example.org/g2"));
        AGGraph g3 = this.closeLater(maker.createGraph("http://example.org/g3"));
        AGGraph gAll = this.closeLater(maker.getUnionOfAllGraphs());
        AGGraph gAllb = (AGGraph)this.closeLater(maker.createUnion(new AGGraph[0]));
        AGGraph gd12 = (AGGraph)this.closeLater(maker.createUnion(new AGGraph[]{gd, g1, g2}));
        AGGraph gd23 = (AGGraph)this.closeLater(maker.createUnion(new AGGraph[]{gd, g2, g3}));
        AGGraph g123 = (AGGraph)this.closeLater(maker.createUnion(new AGGraph[]{g1, g2, g3}));
        AGModel md = this.closeLater(new AGModel(gd));
        AGModel m1 = this.closeLater(new AGModel(g1));
        AGModel m2 = this.closeLater(new AGModel(g2));
        AGModel m3 = this.closeLater(new AGModel(g3));
        AGModel mAll = this.closeLater(new AGModel(gAll));
        AGModel mAllb = this.closeLater(new AGModel(gAllb));
        AGModel md12 = this.closeLater(new AGModel(gd12));
        AGModel md23 = this.closeLater(new AGModel(gd23));
        AGModel m123 = this.closeLater(new AGModel(g123));
        org.apache.jena.rdf.model.Resource a = md.createResource("http://a");
        org.apache.jena.rdf.model.Resource b = md.createResource("http://b");
        org.apache.jena.rdf.model.Resource c = md.createResource("http://c");
        org.apache.jena.rdf.model.Resource d = md.createResource("http://d");
        Property p = md.createProperty("http://p");
        Property q = md.createProperty("http://q");
        md.add((org.apache.jena.rdf.model.Resource)p, RDF.type, (RDFNode)OWL.TransitiveProperty);
        m1.add(a, p, (RDFNode)b);
        m1.add((org.apache.jena.rdf.model.Resource)p, RDFS.subPropertyOf, (RDFNode)q);
        m2.add(b, p, (RDFNode)c);
        m3.add(c, p, (RDFNode)d);
        Assert.assertTrue((String)"size of md", (md.size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"size of m1", (m1.size() == 2L ? 1 : 0) != 0);
        Assert.assertTrue((String)"size of m2", (m2.size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"size of m3", (m3.size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"size of mAll", (mAll.size() == 5L ? 1 : 0) != 0);
        Assert.assertTrue((String)"size of mAllb", (mAllb.size() == 5L ? 1 : 0) != 0);
        Assert.assertTrue((String)"size of md12", (md12.size() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((String)"size of md23", (md23.size() == 3L ? 1 : 0) != 0);
        Assert.assertTrue((String)"size of m123", (m123.size() == 4L ? 1 : 0) != 0);
        AGReasoner reasoner = AGReasoner.RDFS_PLUS_PLUS;
        AGInfModel infAll = this.closeLater(new AGInfModel(reasoner, mAll));
        AGInfModel infd = this.closeLater(new AGInfModel(reasoner, md));
        AGInfModel inf1 = this.closeLater(new AGInfModel(reasoner, m1));
        AGInfModel infd12 = this.closeLater(new AGInfModel(reasoner, md12));
        reasoner = AGReasoner.RESTRICTION;
        AGInfModel infd23 = this.closeLater(new AGInfModel(reasoner, md23));
        AGInfModel inf123 = this.closeLater(new AGInfModel(reasoner, m123));
        Assert.assertTrue((String)"missing inference All", (boolean)infAll.contains(a, p, (RDFNode)d));
        Assert.assertFalse((String)"unsound inference d", (boolean)infd.contains(a, p, (RDFNode)b));
        Assert.assertTrue((String)"missing inference 1", (boolean)inf1.contains(a, q, (RDFNode)b));
        Assert.assertFalse((String)"unsound inference 1", (boolean)inf1.contains(a, p, (RDFNode)c));
        Assert.assertTrue((String)"missing inference d12", (boolean)infd12.contains(a, p, (RDFNode)c));
        Assert.assertFalse((String)"unsound inference d12", (boolean)infd12.contains(a, p, (RDFNode)d));
        Assert.assertTrue((String)"missing inference d23", (boolean)infd23.contains(b, p, (RDFNode)d));
        Assert.assertFalse((String)"unsound inference d23", (boolean)infd23.contains(a, p, (RDFNode)d));
        Assert.assertTrue((String)"missing inference 123", (boolean)inf123.contains(b, p, (RDFNode)c));
        Assert.assertFalse((String)"unsound inference 123", (boolean)inf123.contains(a, p, (RDFNode)d));
        AGStatement s = inf123.createStatement((org.apache.jena.rdf.model.Resource)p, RDF.type, (RDFNode)OWL.TransitiveProperty);
        inf123.add((Statement)s);
        Assert.assertTrue((String)"missing added statement in m123", (boolean)m123.contains((Statement)s));
        Assert.assertTrue((String)"missing added statement in m1", (boolean)m1.contains((Statement)s));
        Assert.assertTrue((String)"missing added statement in md12", (boolean)md12.contains((Statement)s));
        Assert.assertTrue((String)"missing inference 123", (boolean)inf123.contains(a, p, (RDFNode)d));
        inf1.remove(a, p, (RDFNode)b);
        Assert.assertFalse((String)"unexpected statement in inf1", (boolean)inf1.contains(a, p, (RDFNode)b));
        Assert.assertFalse((String)"unexpected statement in m1", (boolean)m1.contains(a, p, (RDFNode)b));
        Assert.assertTrue((String)"missing statement in m1", (boolean)m1.contains((Statement)s));
        Assert.assertFalse((String)"unexpected statement in infAll", (boolean)m1.contains(a, p, (RDFNode)d));
        Assert.assertTrue((String)"missing inference in infAll", (boolean)infAll.contains(b, p, (RDFNode)d));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testIsEmpty() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph gd = this.closeLater(maker.getGraph());
        AGGraph g1 = this.closeLater(maker.createGraph("http://example.org/g1"));
        AGGraph g2 = this.closeLater(maker.createGraph("http://example.org/g2"));
        AGGraph g3 = this.closeLater(maker.createGraph("http://example.org/g3"));
        AGGraph gAll = this.closeLater(maker.getUnionOfAllGraphs());
        AGGraph gd12 = (AGGraph)this.closeLater(maker.createUnion(new AGGraph[]{gd, g1, g2}));
        AGGraph gd23 = (AGGraph)this.closeLater(maker.createUnion(new AGGraph[]{gd, g2, g3}));
        AGGraph g123 = (AGGraph)this.closeLater(maker.createUnion(new AGGraph[]{g1, g2, g3}));
        AGModel md = this.closeLater(new AGModel(gd));
        AGModel m1 = this.closeLater(new AGModel(g1));
        AGModel m2 = this.closeLater(new AGModel(g2));
        AGModel m3 = this.closeLater(new AGModel(g3));
        AGModel mAll = this.closeLater(new AGModel(gAll));
        AGModel md12 = this.closeLater(new AGModel(gd12));
        AGModel md23 = this.closeLater(new AGModel(gd23));
        AGModel m123 = this.closeLater(new AGModel(g123));
        AGReasoner reasoner = AGReasoner.RDFS_PLUS_PLUS;
        AGInfModel infAll = this.closeLater(new AGInfModel(reasoner, mAll));
        AGInfModel infd = this.closeLater(new AGInfModel(reasoner, md));
        AGInfModel inf1 = this.closeLater(new AGInfModel(reasoner, m1));
        AGInfModel infd12 = this.closeLater(new AGInfModel(reasoner, md12));
        reasoner = AGReasoner.RESTRICTION;
        AGInfModel infd23 = this.closeLater(new AGInfModel(reasoner, md23));
        AGInfModel inf123 = this.closeLater(new AGInfModel(reasoner, m123));
        org.apache.jena.rdf.model.Resource a = md.createResource("http://a");
        org.apache.jena.rdf.model.Resource b = md.createResource("http://b");
        org.apache.jena.rdf.model.Resource c = md.createResource("http://c");
        org.apache.jena.rdf.model.Resource d = md.createResource("http://d");
        Property p = md.createProperty("http://p");
        Assert.assertTrue((String)"md", (boolean)md.isEmpty());
        Assert.assertTrue((String)"m1", (boolean)m1.isEmpty());
        Assert.assertTrue((String)"m2", (boolean)m2.isEmpty());
        Assert.assertTrue((String)"m3", (boolean)m3.isEmpty());
        Assert.assertTrue((String)"mAll", (boolean)mAll.isEmpty());
        Assert.assertTrue((String)"infd", (boolean)infd.isEmpty());
        md.add((org.apache.jena.rdf.model.Resource)p, RDF.type, (RDFNode)OWL.TransitiveProperty);
        Assert.assertFalse((String)"md empty?", (boolean)md.isEmpty());
        Assert.assertFalse((String)"infd", (boolean)infd.isEmpty());
        Assert.assertFalse((String)"mAll empty?", (boolean)mAll.isEmpty());
        Assert.assertFalse((String)"md12 empty?", (md12.size() == 4L ? 1 : 0) != 0);
        Assert.assertFalse((String)"md23 empty?", (md23.size() == 3L ? 1 : 0) != 0);
        Assert.assertTrue((String)"m1", (boolean)m1.isEmpty());
        Assert.assertTrue((String)"inf1", (boolean)inf1.isEmpty());
        Assert.assertTrue((String)"m2", (boolean)m2.isEmpty());
        Assert.assertTrue((String)"m3", (boolean)m3.isEmpty());
        Assert.assertTrue((String)"m123", (boolean)m123.isEmpty());
        m1.add(a, p, (RDFNode)b);
        Assert.assertFalse((String)"md empty?", (boolean)md.isEmpty());
        Assert.assertFalse((String)"mAll empty?", (boolean)mAll.isEmpty());
        Assert.assertFalse((String)"md12 empty?", (boolean)md12.isEmpty());
        Assert.assertFalse((String)"md23 empty?", (boolean)md23.isEmpty());
        Assert.assertFalse((String)"m1 empty?", (boolean)m1.isEmpty());
        Assert.assertTrue((String)"m2", (boolean)m2.isEmpty());
        Assert.assertTrue((String)"m3", (boolean)m3.isEmpty());
        Assert.assertFalse((String)"m123 empty?", (boolean)m123.isEmpty());
        m2.add(b, p, (RDFNode)c);
        Assert.assertFalse((String)"md empty?", (boolean)md.isEmpty());
        Assert.assertFalse((String)"mAll empty?", (boolean)mAll.isEmpty());
        Assert.assertFalse((String)"md12 empty?", (boolean)md12.isEmpty());
        Assert.assertFalse((String)"md23 empty?", (boolean)md23.isEmpty());
        Assert.assertFalse((String)"m1 empty?", (boolean)m1.isEmpty());
        Assert.assertFalse((String)"m2 empty?", (boolean)m2.isEmpty());
        Assert.assertTrue((String)"m3", (boolean)m3.isEmpty());
        Assert.assertFalse((String)"m123 empty?", (boolean)m123.isEmpty());
        m3.add(c, p, (RDFNode)d);
        Assert.assertFalse((String)"md empty?", (boolean)md.isEmpty());
        Assert.assertFalse((String)"mAll empty?", (boolean)mAll.isEmpty());
        Assert.assertFalse((String)"md12 empty?", (boolean)md12.isEmpty());
        Assert.assertFalse((String)"md23 empty?", (boolean)md23.isEmpty());
        Assert.assertFalse((String)"m1 empty?", (boolean)m1.isEmpty());
        Assert.assertFalse((String)"m2 empty?", (boolean)m2.isEmpty());
        Assert.assertFalse((String)"m3 empty?", (boolean)m3.isEmpty());
        Assert.assertFalse((String)"m123 empty?", (boolean)m123.isEmpty());
        Assert.assertFalse((String)"infAll empty?", (boolean)infAll.isEmpty());
        Assert.assertFalse((String)"infd empty?", (boolean)infd.isEmpty());
        Assert.assertFalse((String)"inf1 empty?", (boolean)inf1.isEmpty());
        Assert.assertFalse((String)"infd12 empty?", (boolean)infd12.isEmpty());
        Assert.assertFalse((String)"infd23 empty?", (boolean)infd23.isEmpty());
        Assert.assertFalse((String)"inf123 empty?", (boolean)inf123.isEmpty());
        m1.remove(a, p, (RDFNode)b);
        Assert.assertFalse((String)"infAll empty?", (boolean)infAll.isEmpty());
        Assert.assertFalse((String)"infd empty?", (boolean)infd.isEmpty());
        Assert.assertTrue((String)"inf1 empty?", (boolean)inf1.isEmpty());
        Assert.assertFalse((String)"infd12 empty?", (boolean)infd12.isEmpty());
        Assert.assertFalse((String)"infd23 empty?", (boolean)infd23.isEmpty());
        Assert.assertFalse((String)"inf123 empty?", (boolean)inf123.isEmpty());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaReadTurtle() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph g = this.closeLater(maker.getGraph());
        AGModel m = this.closeLater(new AGModel(g));
        m.read(Util.resourceAsStream("/test/default-graph.ttl"), null, "TURTLE");
        Assert.assertTrue((String)"size of m", (m.size() == 4L ? 1 : 0) != 0);
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaDeleteQuads() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph unionGraph = this.closeLater(maker.getUnionOfAllGraphs());
        AGModel model = this.closeLater(new AGModel(unionGraph));
        IRI s = this.conn.getValueFactory().createIRI("http://s");
        IRI p = this.conn.getValueFactory().createIRI("http://p");
        IRI o = this.conn.getValueFactory().createIRI("http://o");
        IRI g = this.conn.getValueFactory().createIRI("http://g");
        this.conn.add((Resource)s, p, (Value)o, new Resource[]{g});
        this.conn.add((Resource)g, p, (Value)o, new Resource[0]);
        Assert.assertEquals((String)"unexpected model size", (long)2L, (long)model.size());
        org.apache.jena.rdf.model.Resource r = model.createResource("http://g");
        model.removeAll(r, null, null);
        Assert.assertEquals((String)"unexpected model size", (long)1L, (long)model.size());
        AGGraph metadataGraph = this.closeLater(maker.createGraph("http://g"));
        AGModel metadataModel = this.closeLater(new AGModel(metadataGraph));
        Assert.assertEquals((String)"unexpected metamodel size", (long)1L, (long)metadataModel.size());
        metadataModel.removeAll();
        Assert.assertEquals((String)"unexpected metamodel size", (long)0L, (long)metadataModel.size());
        Assert.assertEquals((String)"unexpected model size", (long)0L, (long)model.size());
        this.conn.add((Resource)s, p, (Value)o, new Resource[]{g});
        this.conn.add((Resource)g, p, (Value)o, new Resource[0]);
        Assert.assertEquals((String)"unexpected model size", (long)2L, (long)model.size());
        model.removeAll();
        Assert.assertEquals((String)"unexpected model size", (long)0L, (long)model.size());
    }

    private long getSize() {
        try (AGRepositoryConnection conn = this.getConnection();){
            long l = conn.size(new Resource[0]);
            return l;
        }
    }
}

