/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.RepositoryException;
import test.AGAbstractTest;

public class JenaUtil
extends TestSetup {
    private static final String SERVER_URL = AGAbstractTest.findServerUrl();
    private static final String CATALOG_ID = "java-catalog";
    private static final String REPOSITORY_ID = "javatest";
    private static final String USERNAME = AGAbstractTest.username();
    private static final String PASSWORD = AGAbstractTest.password();
    private AGRepositoryConnection conn = null;
    private AGGraphMaker maker = null;

    public JenaUtil(Class<? extends Test> test) {
        super((Test)new TestSuite(test));
    }

    private void connect() {
        AGServer server = new AGServer(SERVER_URL, USERNAME, PASSWORD);
        AGCatalog catalog = server.getCatalog(CATALOG_ID);
        try {
            catalog.deleteRepository(REPOSITORY_ID);
            AGRepository repo = catalog.createRepository(REPOSITORY_ID);
            repo.initialize();
            this.conn = repo.getConnection();
            this.maker = new AGGraphMaker(this.conn);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to connect", e);
        }
    }

    public void disconnect() {
        if (this.conn != null) {
            this.maker.close();
            try {
                this.conn.close();
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Unable to close connection.", e);
            }
            this.conn = null;
            this.maker = null;
        }
    }

    public AGRepositoryConnection getConn() {
        if (this.conn == null) {
            this.connect();
        }
        try {
            this.conn.clear(new Resource[0]);
            this.conn.clearNamespaces();
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to clear connection.", e);
        }
        return this.conn;
    }

    public AGGraphMaker getMaker() {
        if (this.maker == null) {
            this.connect();
        }
        return this.maker;
    }

    protected void tearDown() throws Exception {
        this.disconnect();
        super.tearDown();
    }
}

