/*
 * Decompiled with CFR 0.152.
 */
package test;

import junit.framework.Assert;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class MappingsTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testClearMappings() throws Exception {
        this.conn.clearMappings();
        String[] mappings = this.conn.getDatatypeMappings();
        int numAutoMappings = mappings.length;
        Assert.assertTrue((String)"expected some automatic datatype mappings", (numAutoMappings > 0 ? 1 : 0) != 0);
        IRI myDouble = this.vf.createIRI("http://example.org/mydouble");
        BNode s = this.vf.createBNode();
        IRI p = this.vf.createIRI("http://example.org/hasAge");
        String d = "1.86733E1";
        Literal o = this.vf.createLiteral(d, myDouble);
        this.conn.registerDatatypeMapping(myDouble, XMLSchema.DOUBLE);
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        RepositoryResult results = this.conn.getStatements((Resource)s, p, null, false, new Resource[0]);
        Value v = ((Statement)results.next()).getObject();
        Assert.assertNotSame((String)"expected loss of precision due to encoding as a double", (Object)d, (Object)v.stringValue());
        this.conn.clear(new Resource[0]);
        Assert.assertEquals((long)0L, (long)this.conn.size(new Resource[0]));
        this.conn.clearMappings(true);
        mappings = this.conn.getDatatypeMappings();
        Assert.assertEquals((String)"expected no mappings", (int)0, (int)mappings.length);
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        results = this.conn.getStatements((Resource)s, p, null, false, new Resource[0]);
        v = ((Statement)results.next()).getObject();
        Assert.assertEquals((String)"expected no auto-mapping of xsd:double", (String)d, (String)v.stringValue());
        this.conn.clearMappings();
        mappings = this.conn.getDatatypeMappings();
        Assert.assertEquals((String)"expected auto-mappings", (int)numAutoMappings, (int)mappings.length);
    }
}

