/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGRepositoryConnection;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class MasqueradeAsUserTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void limitedUser() throws Exception {
        server.addUser("lim", "lim");
        AGRepositoryConnection conn = this.repo.getConnection();
        AGRepositoryConnection conn2 = this.repo.getConnection();
        conn.clear(new Resource[0]);
        IRI lim = this.vf.createIRI("http://lim");
        server.addUserSecurityFilter("lim", "allow", NTriplesUtil.toNTriplesString((IRI)lim), null, null, null);
        conn.add((Resource)lim, lim, (Value)lim, new Resource[]{lim});
        conn.add((Resource)OWL.INVERSEOF, OWL.INVERSEOF, (Value)OWL.INVERSEOF, new Resource[0]);
        Assert.assertEquals((String)"expected size 2", (long)2L, (long)conn.size(new Resource[0]));
        conn.setMasqueradeAsUser("lim");
        Assert.assertEquals((String)"expected conn size 1", (long)1L, (long)conn.size(new Resource[0]));
        Assert.assertEquals((String)"expected conn2 size 2", (long)2L, (long)conn2.size(new Resource[0]));
        conn.clear(new Resource[0]);
        conn.setMasqueradeAsUser(null);
        Assert.assertEquals((String)"expected size 1", (long)1L, (long)conn.size(new Resource[0]));
        conn.close();
        conn2.close();
        server.deleteUser("lim");
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void noSuchUser() throws Exception {
        this.conn.clear(new Resource[0]);
        try {
            this.conn.setMasqueradeAsUser("noSuchUser");
            this.conn.size(new Resource[0]);
            Assert.fail((String)"Expected a no such user exception");
        }
        catch (AGHttpException aGHttpException) {
            // empty catch block
        }
        this.conn.close();
    }
}

