/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGQueryExecution;
import com.franz.agraph.jena.AGQueryExecutionFactory;
import com.franz.agraph.jena.AGQueryFactory;
import com.franz.agraph.repository.AGTupleQuery;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class QueryLimitOffsetTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sesameQueryLimitOffset_tests() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/tutorial/java-vcards.rdf", null, RDFFormat.RDFXML, new Resource[0]);
        String queryString = "SELECT ?s ?p ?o  WHERE {?s ?p ?o .}";
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        Assert.assertEquals((String)"expected 16 results", (long)16L, (long)tupleQuery.count());
        tupleQuery.setLimit(5);
        Assert.assertEquals((String)"expected 5 results", (long)5L, (long)tupleQuery.count());
        tupleQuery.setOffset(15);
        Assert.assertEquals((String)"expected 1 result", (long)1L, (long)tupleQuery.count());
        tupleQuery.setLimit(-1);
        tupleQuery.setOffset(10);
        Assert.assertEquals((String)"expected 6 results", (long)6L, (long)tupleQuery.count());
        tupleQuery.setOffset(-1);
        Assert.assertEquals((String)"expected 16 results", (long)16L, (long)tupleQuery.count());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaQueryLimitOffset_tests() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/tutorial/java-vcards.rdf", null, RDFFormat.RDFXML, new Resource[0]);
        AGGraphMaker maker = new AGGraphMaker(this.conn);
        AGModel model = new AGModel(maker.getGraph());
        String queryString = "SELECT ?s ?p ?o  WHERE {?s ?p ?o .}";
        AGQuery query = AGQueryFactory.create((String)queryString);
        AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model);
        Assert.assertEquals((String)"expected 16 results", (long)16L, (long)qe.countSelect());
        query.setLimit(5);
        Assert.assertEquals((String)"expected 5 results", (long)5L, (long)qe.countSelect());
        query.setOffset(15);
        Assert.assertEquals((String)"expected 1 result", (long)1L, (long)qe.countSelect());
        query.setLimit(-1);
        query.setOffset(10);
        Assert.assertEquals((String)"expected 6 results", (long)6L, (long)qe.countSelect());
        query.setOffset(-1);
        Assert.assertEquals((String)"expected 16 results", (long)16L, (long)qe.countSelect());
    }
}

