/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGStatement;
import java.io.OutputStream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RSIterator;
import org.apache.jena.rdf.model.ReifiedStatement;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.rdf4j.model.IRI;
import org.junit.Test;
import test.AGAbstractTest;

public class ReifiedStatementTest
extends AGAbstractTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test1() throws Exception {
        AGGraphMaker maker = new AGGraphMaker(this.conn);
        AGGraph graph = maker.getGraph();
        AGModel model = new AGModel(graph);
        String exns = "http://example.org/people/";
        model.setNsPrefix("ex", exns);
        Property fullname = model.createProperty(exns + "fullname");
        this.conn.createFreetextIndex("index1", new IRI[]{this.conn.getValueFactory().createIRI(exns + "fullname")});
        Resource alice = model.createResource(exns + "alice1");
        Resource carroll = model.createResource(exns + "carroll");
        Resource persontype = model.createResource(exns + "Person");
        Literal alicename = model.createLiteral("Alice B. Toklas");
        Literal lewisCarroll = model.createLiteral("Lewis Carroll");
        Resource book = model.createResource(exns + "book1");
        Resource booktype = model.createResource(exns + "Book");
        Property booktitle = model.createProperty(exns + "title");
        Property author = model.createProperty(exns + "author");
        Literal wonderland = model.createLiteral("Alice in Wonderland");
        model.add(alice, RDF.type, (RDFNode)persontype);
        AGStatement stmt = model.createStatement(alice, fullname, (RDFNode)alicename);
        ReifiedStatement rs = stmt.createReifiedStatement();
        rs.addProperty(ResourceFactory.createProperty((String)"urn:foo:fooProperty"), "FOOBAR");
        model.add(book, RDF.type, (RDFNode)booktype);
        model.add(book, booktitle, (RDFNode)wonderland);
        model.add(book, author, (RDFNode)carroll);
        model.add(carroll, RDF.type, (RDFNode)persontype);
        model.add(carroll, fullname, (RDFNode)lewisCarroll);
        try (StmtIterator statements = model.listStatements();){
            while (statements.hasNext()) {
                System.out.println(statements.next());
            }
        }
        System.out.println("\nN-TRIPLE output:");
        model.write((OutputStream)System.out, "N-TRIPLE");
        long l = model.size();
        System.out.println("Number of stmts: " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() throws Exception {
        AGGraphMaker maker = new AGGraphMaker(this.conn);
        AGGraph graph = maker.getGraph();
        AGModel model = new AGModel(graph);
        String exns = "http://example.org/people/";
        model.setNsPrefix("ex", exns);
        Property fullname = model.createProperty(exns + "fullname");
        this.conn.createFreetextIndex("index1", new IRI[]{this.conn.getValueFactory().createIRI(exns + "fullname")});
        Resource alice = model.createResource(exns + "alice1");
        Resource carroll = model.createResource(exns + "carroll");
        Resource persontype = model.createResource(exns + "Person");
        Literal alicename = model.createLiteral("Alice B. Toklas");
        Literal lewisCarroll = model.createLiteral("Lewis Carroll");
        Resource book = model.createResource(exns + "book1");
        Resource booktype = model.createResource(exns + "Book");
        Property booktitle = model.createProperty(exns + "title");
        Property author = model.createProperty(exns + "author");
        Literal wonderland = model.createLiteral("Alice in Wonderland");
        model.add(alice, RDF.type, (RDFNode)persontype);
        AGStatement stmt = model.createStatement(alice, fullname, (RDFNode)alicename);
        ReifiedStatement rs = stmt.createReifiedStatement();
        rs.addProperty(ResourceFactory.createProperty((String)"urn:foo:fooProperty"), "FOOBAR");
        model.add(book, RDF.type, (RDFNode)booktype);
        model.add(book, booktitle, (RDFNode)wonderland);
        model.add(book, author, (RDFNode)carroll);
        model.add(carroll, RDF.type, (RDFNode)persontype);
        model.add(carroll, fullname, (RDFNode)lewisCarroll);
        try (StmtIterator statements = model.listStatements();){
            while (statements.hasNext()) {
                System.out.println(statements.next());
            }
        }
        System.out.println("Reified Statements:");
        RSIterator iter = stmt.listReifiedStatements();
        while (iter.hasNext()) {
            ReifiedStatement rs1 = (ReifiedStatement)iter.next();
            System.out.println(rs1);
            System.out.println("listProperties:");
            StmtIterator iter1 = rs1.listProperties();
            while (iter1.hasNext()) {
                System.out.println(iter1.next());
            }
        }
    }
}

