/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.handler.AGLongHandler;
import com.franz.agraph.http.handler.AGRDFHandler;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServerVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.URIImpl;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.DatasetImpl;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.RDFHandlerBase;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.TestSuites;
import test.Util;

public abstract class RepositoryConnectionTest {
    public static final String TEST_DIR_PREFIX = "/test/";
    protected static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";
    protected static final String DC_NS = "http://purl.org/dc/elements/1.1/";
    protected Repository testRepository;
    protected RepositoryConnection testCon;
    protected RepositoryConnection testCon2;
    protected ValueFactory vf;
    protected BNode bob;
    protected BNode alice;
    protected BNode alexander;
    protected IRI name;
    protected IRI mbox;
    protected IRI publisher;
    protected IRI unknownContext;
    protected IRI context1;
    protected IRI context2;
    protected Literal nameAlice;
    protected Literal nameBob;
    protected Literal nameTrudy;
    protected Literal mboxAlice;
    protected Literal mboxBob;
    protected Literal \u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440;

    @Before
    public void setUp() throws Exception {
        this.testRepository = this.createRepository();
        this.testRepository.initialize();
        this.testCon = this.testRepository.getConnection();
        this.testCon.clear(new Resource[0]);
        this.testCon.clearNamespaces();
        this.testCon2 = this.testRepository.getConnection();
        this.vf = this.testRepository.getValueFactory();
        this.bob = this.vf.createBNode();
        this.alice = this.vf.createBNode();
        this.alexander = this.vf.createBNode();
        this.name = this.vf.createIRI("http://xmlns.com/foaf/0.1/name");
        this.mbox = this.vf.createIRI("http://xmlns.com/foaf/0.1/mbox");
        this.publisher = this.vf.createIRI("http://purl.org/dc/elements/1.1/publisher");
        this.nameAlice = this.vf.createLiteral("Alice");
        this.nameBob = this.vf.createLiteral("Bob");
        this.nameTrudy = this.vf.createLiteral("Evil \t \n \r \\ Trudy");
        this.mboxAlice = this.vf.createLiteral("alice@example.org");
        this.mboxBob = this.vf.createLiteral("bob@example.org");
        this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440 = this.vf.createLiteral("\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440");
        this.unknownContext = new URIImpl("urn:unknownContext");
        this.context1 = this.vf.createIRI("urn:x-local:graph1");
        this.context2 = this.vf.createIRI("urn:x-local:graph2");
    }

    @After
    public void tearDown() throws Exception {
        if (this.testCon2 != null) {
            this.testCon2.close();
            this.testCon2 = null;
        }
        if (this.testCon != null) {
            this.testCon.close();
            this.testCon = null;
        }
        if (this.testRepository != null) {
            this.testRepository.shutDown();
            this.testRepository = null;
        }
        this.vf = null;
    }

    protected abstract Repository createRepository() throws Exception;

    public static abstract class RepositoryConnectionTests
    extends RepositoryConnectionTest {
        @Test
        public void testAddStatement() throws Exception {
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            Assert.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Statement statement = this.vf.createStatement((Resource)this.alice, this.name, (Value)this.nameAlice);
            this.testCon.add(statement, new Resource[0]);
            Assert.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement(statement, false, new Resource[0]));
            Assert.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            SailRepository tempRep = new SailRepository((Sail)new MemoryStore());
            tempRep.initialize();
            RepositoryConnection con = tempRep.getConnection();
            con.add((Iteration)this.testCon.getStatements(null, null, null, false, new Resource[0]), new Resource[0]);
            Assert.assertTrue((String)"Temp Repository should contain newly added statement", (boolean)con.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            con.close();
            tempRep.shutDown();
        }

        @Test
        public void testTransactionIsolation() throws Exception {
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertFalse((boolean)this.testCon2.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            this.testCon.commit();
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon2.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        }

        @Test
        public void testAddReader() throws Exception {
            InputStream defaultGraphStream = Util.resourceAsStream("/test/default-graph.ttl");
            InputStreamReader defaultGraph = new InputStreamReader(defaultGraphStream, "UTF-8");
            this.testCon.add((Reader)defaultGraph, "", RDFFormat.TURTLE, new Resource[0]);
            ((Reader)defaultGraph).close();
            Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
            InputStream graph1Stream = Util.resourceAsStream("/test/graph1.ttl");
            InputStreamReader graph1 = new InputStreamReader(graph1Stream, "UTF-8");
            this.testCon.add((Reader)graph1, "", RDFFormat.TURTLE, new Resource[]{this.context1});
            ((Reader)graph1).close();
            InputStream graph2Stream = Util.resourceAsStream("/test/graph2.ttl");
            InputStreamReader graph2 = new InputStreamReader(graph2Stream, "UTF-8");
            this.testCon.add((Reader)graph2, "", RDFFormat.TURTLE, new Resource[]{this.context2});
            ((Reader)graph2).close();
            Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
            Assert.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
            Assert.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
            Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
            Assert.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
        }

        @Test
        public void testAddInputStream() throws Exception {
            InputStream defaultGraph = Util.resourceAsStream("/test/default-graph.ttl");
            this.testCon.add(defaultGraph, "", RDFFormat.TURTLE, new Resource[0]);
            defaultGraph.close();
            Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
            InputStream graph1 = Util.resourceAsStream("/test/graph1.ttl");
            this.testCon.add(graph1, "", RDFFormat.TURTLE, new Resource[]{this.context1});
            graph1.close();
            InputStream graph2 = Util.resourceAsStream("/test/graph2.ttl");
            this.testCon.add(graph2, "", RDFFormat.TURTLE, new Resource[]{this.context2});
            graph2.close();
            Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
            Assert.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
            Assert.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
            Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
            Assert.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
        }

        @Test
        public void testAddGzipInputStream() throws Exception {
            try (InputStream defaultGraph = Util.resourceAsStream("/test/default-graph.ttl.gz");){
                this.testCon.add(defaultGraph, "", RDFFormat.TURTLE, new Resource[0]);
            }
            Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        }

        @Test
        public void testAddZipFile() throws Exception {
            InputStream in = Util.resourceAsStream("/test/graphs.ttl.zip");
            this.testCon.add(in, "", RDFFormat.TURTLE, new Resource[0]);
            Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
            Assert.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
            Assert.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        }

        @Test
        public void testAutoCommit() throws Exception {
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
            Assert.assertTrue((String)"Uncommitted update should be visible to own connection", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            this.testCon.commit();
            Assert.assertTrue((String)"Repository should contain statement after commit", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            this.testCon.setAutoCommit(true);
        }

        @Test
        public void testRollback() throws Exception {
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
            Assert.assertTrue((String)"Uncommitted updates should be visible to own connection", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            this.testCon.rollback();
            Assert.assertFalse((String)"Repository should not contain statement after rollback", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            this.testCon.setAutoCommit(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test(expected=QueryEvaluationException.class)
        public void testSimpleTupleQuery() throws Exception {
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(" SELECT name, mbox");
            queryBuilder.append(" FROM {} foaf:name {name};");
            queryBuilder.append("         foaf:mbox {mbox}");
            queryBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
            try (TupleQueryResult result = this.testCon.prepareTupleQuery(QueryLanguage.SERQL, queryBuilder.toString()).evaluate();){
                Assert.assertTrue((result != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)result.hasNext());
                while (result.hasNext()) {
                    BindingSet solution = (BindingSet)result.next();
                    Assert.assertTrue((boolean)solution.hasBinding("name"));
                    Assert.assertTrue((boolean)solution.hasBinding("mbox"));
                    Value nameResult = solution.getValue("name");
                    Value mboxResult = solution.getValue("mbox");
                    Assert.assertTrue((this.nameAlice.equals((Object)nameResult) || this.nameBob.equals((Object)nameResult) ? 1 : 0) != 0);
                    Assert.assertTrue((this.mboxAlice.equals((Object)mboxResult) || this.mboxBob.equals((Object)mboxResult) ? 1 : 0) != 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test(expected=QueryEvaluationException.class)
        public void testSimpleTupleQueryUnicode() throws Exception {
            this.testCon.add((Resource)this.alexander, this.name, (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(" SELECT person");
            queryBuilder.append(" FROM {person} foaf:name {").append(this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440.getLabel()).append("}");
            queryBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
            try (TupleQueryResult result = this.testCon.prepareTupleQuery(QueryLanguage.SERQL, queryBuilder.toString()).evaluate();){
                Assert.assertTrue((result != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)result.hasNext());
                while (result.hasNext()) {
                    BindingSet solution = (BindingSet)result.next();
                    Assert.assertTrue((boolean)solution.hasBinding("person"));
                    Assert.assertEquals((Object)this.alexander, (Object)solution.getValue("person"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test(expected=QueryEvaluationException.class)
        public void testPreparedTupleQuery() throws Exception {
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(" SELECT name, mbox");
            queryBuilder.append(" FROM {} foaf:name {name};");
            queryBuilder.append("         foaf:mbox {mbox}");
            queryBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
            TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SERQL, queryBuilder.toString());
            query.setBinding("name", (Value)this.nameBob);
            try (TupleQueryResult result = query.evaluate();){
                Assert.assertTrue((result != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)result.hasNext());
                while (result.hasNext()) {
                    BindingSet solution = (BindingSet)result.next();
                    Assert.assertTrue((boolean)solution.hasBinding("name"));
                    Assert.assertTrue((boolean)solution.hasBinding("mbox"));
                    Value nameResult = solution.getValue("name");
                    Value mboxResult = solution.getValue("mbox");
                    Assert.assertEquals((String)("unexpected value for name: " + nameResult), (Object)this.nameBob, (Object)nameResult);
                    Assert.assertEquals((String)("unexpected value for mbox: " + mboxResult), (Object)this.mboxBob, (Object)mboxResult);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test(expected=QueryEvaluationException.class)
        public void testPreparedTupleQueryUnicode() throws Exception {
            this.testCon.add((Resource)this.alexander, this.name, (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(" SELECT person");
            queryBuilder.append(" FROM {person} foaf:name {name}");
            queryBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
            TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SERQL, queryBuilder.toString());
            query.setBinding("name", (Value)this.\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440);
            try (TupleQueryResult result = query.evaluate();){
                Assert.assertTrue((result != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)result.hasNext());
                while (result.hasNext()) {
                    BindingSet solution = (BindingSet)result.next();
                    Assert.assertTrue((boolean)solution.hasBinding("person"));
                    Assert.assertEquals((Object)this.alexander, (Object)solution.getValue("person"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test(expected=QueryEvaluationException.class)
        public void testSimpleGraphQuery() throws Exception {
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(" CONSTRUCT *");
            queryBuilder.append(" FROM {} foaf:name {name};");
            queryBuilder.append("         foaf:mbox {mbox}");
            queryBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
            try (GraphQueryResult result = this.testCon.prepareGraphQuery(QueryLanguage.SERQL, queryBuilder.toString()).evaluate();){
                Assert.assertTrue((result != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)result.hasNext());
                while (result.hasNext()) {
                    Statement st = (Statement)result.next();
                    if (this.name.equals((Object)st.getPredicate())) {
                        Assert.assertTrue((this.nameAlice.equals((Object)st.getObject()) || this.nameBob.equals((Object)st.getObject()) ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertTrue((boolean)this.mbox.equals((Object)st.getPredicate()));
                    Assert.assertTrue((this.mboxAlice.equals((Object)st.getObject()) || this.mboxBob.equals((Object)st.getObject()) ? 1 : 0) != 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test(expected=QueryEvaluationException.class)
        public void testPreparedGraphQuery() throws Exception {
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(" CONSTRUCT *");
            queryBuilder.append(" FROM {} foaf:name {name};");
            queryBuilder.append("         foaf:mbox {mbox}");
            queryBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
            GraphQuery query = this.testCon.prepareGraphQuery(QueryLanguage.SERQL, queryBuilder.toString());
            query.setBinding("name", (Value)this.nameBob);
            try (GraphQueryResult result = query.evaluate();){
                Assert.assertTrue((result != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)result.hasNext());
                while (result.hasNext()) {
                    Statement st = (Statement)result.next();
                    Assert.assertTrue((this.name.equals((Object)st.getPredicate()) || this.mbox.equals((Object)st.getPredicate()) ? 1 : 0) != 0);
                    if (this.name.equals((Object)st.getPredicate())) {
                        Assert.assertTrue((String)("unexpected value for name: " + st.getObject()), (boolean)this.nameBob.equals((Object)st.getObject()));
                        continue;
                    }
                    Assert.assertTrue((boolean)this.mbox.equals((Object)st.getPredicate()));
                    Assert.assertTrue((String)("unexpected value for mbox: " + st.getObject()), (boolean)this.mboxBob.equals((Object)st.getObject()));
                }
            }
        }

        @Test
        public void testSimpleBooleanQuery() throws Exception {
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
            queryBuilder.append("ASK ");
            queryBuilder.append("{ ?p foaf:name ?name }");
            boolean exists = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();
            Assert.assertTrue((boolean)exists);
        }

        @Test
        public void testTSVTupleQueryWithSpecialSymbols() throws Exception {
            AGServerVersion minVersion = new AGServerVersion("v6.6.0");
            if (((AGRepository)this.testRepository).getServer().getComparableVersion().compareTo(minVersion) >= 0) {
                this.testCon.add((Resource)this.alice, this.name, (Value)this.nameTrudy, new Resource[]{this.context2});
                StringBuilder queryBuilder = new StringBuilder();
                queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
                queryBuilder.append("SELECT ?name WHERE ");
                queryBuilder.append("{ ?p foaf:name ?name }");
                try (TupleQueryResult res = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
                    while (res.hasNext()) {
                        BindingSet bs = (BindingSet)res.next();
                        Assert.assertEquals((String)"", (Object)this.nameTrudy.getLabel(), (Object)bs.getValue("name").stringValue());
                    }
                }
            }
        }

        @Test
        public void testPreparedBooleanQuery() throws Exception {
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
            queryBuilder.append("ASK ");
            queryBuilder.append("{ ?p foaf:name ?name }");
            BooleanQuery query = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, queryBuilder.toString());
            query.setBinding("name", (Value)this.nameBob);
            Assert.assertTrue((boolean)query.evaluate());
        }

        @Test
        public void testDataset() throws Exception {
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
            queryBuilder.append("ASK ");
            queryBuilder.append("{ ?p foaf:name ?name }");
            BooleanQuery query = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, queryBuilder.toString());
            query.setBinding("name", (Value)this.nameBob);
            Assert.assertTrue((boolean)query.evaluate());
            DatasetImpl dataset = new DatasetImpl();
            dataset.addDefaultGraph(this.context1);
            query.setDataset((Dataset)dataset);
            Assert.assertTrue((boolean)query.evaluate());
            dataset.addDefaultGraph(this.context2);
            query.setDataset((Dataset)dataset);
            Assert.assertTrue((boolean)query.evaluate());
            dataset.removeDefaultGraph(this.context1);
            query.setDataset((Dataset)dataset);
            Assert.assertFalse((boolean)query.evaluate());
            queryBuilder.setLength(0);
            queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
            queryBuilder.append("ASK ");
            queryBuilder.append("{ GRAPH ?g { ?p foaf:name ?name } }");
            query = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, queryBuilder.toString());
            query.setBinding("name", (Value)this.nameBob);
            query.setDataset((Dataset)dataset);
            Assert.assertFalse((boolean)query.evaluate());
            dataset.addDefaultGraph(this.context1);
            dataset.addNamedGraph(this.context2);
            query.setDataset((Dataset)dataset);
            Assert.assertFalse((boolean)query.evaluate());
            dataset.addNamedGraph(this.context1);
            query.setDataset((Dataset)dataset);
            Assert.assertTrue((boolean)query.evaluate());
        }

        @Test
        public void testGetStatementsCountLimit() throws Exception {
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
            AGHttpRepoClient client = ((AGRepositoryConnection)this.testCon).prepareHttpRepoClient();
            AGLongHandler handler = new AGLongHandler();
            client.getStatementsCountLimit(0, null, null, (Value)this.nameBob, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should be 1", (handler.getResult() == 1L ? 1 : 0) != 0);
            client.getStatementsCountLimit(0, null, null, (Value)this.nameAlice, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should be 2", (handler.getResult() == 2L ? 1 : 0) != 0);
            client.getStatementsCountLimit(1, null, null, (Value)this.nameAlice, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should be 1", (handler.getResult() == 1L ? 1 : 0) != 0);
            client.getStatementsCountLimit(2, null, this.name, null, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should be 2", (handler.getResult() == 2L ? 1 : 0) != 0);
            client.getStatementsCountLimit(0, null, this.name, null, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should be 3", (handler.getResult() == 3L ? 1 : 0) != 0);
            client.getStatementsCountLimit(0, (Resource)this.alice, this.name, (Value)this.nameBob, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should be 0", (handler.getResult() == 0L ? 1 : 0) != 0);
        }

        @Test
        public void testGetStatementsLimit() throws Exception {
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            final ArrayList items = new ArrayList();
            AGHttpRepoClient client = ((AGRepositoryConnection)this.testCon).prepareHttpRepoClient();
            StatementCollector collector = new StatementCollector(){

                public void handleStatement(Statement s) {
                    items.add(s);
                }
            };
            AGRDFHandler handler = new AGRDFHandler(client.getPreferredRDFFormat(), (RDFHandler)collector, ((AGRepositoryConnection)this.testCon).getRepository().getValueFactory(), client.getAllowExternalBlankNodeIds());
            client.getStatementsLimit(1, (Resource)this.bob, this.name, (Value)this.nameBob, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should contain a single statement", (items.size() == 1 ? 1 : 0) != 0);
            items.clear();
            client.getStatementsLimit(2, (Resource)this.bob, this.name, (Value)this.nameBob, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should contain two statements", (items.size() == 2 ? 1 : 0) != 0);
            items.clear();
            client.getStatementsLimit(0, (Resource)this.bob, this.name, (Value)this.nameBob, "false", (AGResponseHandler)handler, new Resource[0]);
            Assert.assertTrue((String)"The result should contain all three statements", (items.size() == 3 ? 1 : 0) != 0);
        }

        @Test
        public void testGetStatements() throws Exception {
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            Assert.assertTrue((String)"Repository should contain statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            try (RepositoryResult result = this.testCon.getStatements(null, this.name, null, false, new Resource[0]);){
                Assert.assertTrue((String)"Iterator should not be null", (result != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"Iterator should not be empty", (boolean)result.hasNext());
                while (result.hasNext()) {
                    Statement st = (Statement)result.next();
                    Assert.assertNull((String)"Statement should not be in a context ", (Object)st.getContext());
                    Assert.assertTrue((String)"Statement predicate should be equal to name ", (boolean)st.getPredicate().equals((Object)this.name));
                }
            }
            List list = (List)Iterations.addAll((Iteration)this.testCon.getStatements(null, this.name, null, false, new Resource[0]), new ArrayList());
            Assert.assertTrue((String)"List should not be null", (list != null ? 1 : 0) != 0);
            Assert.assertFalse((String)"List should not be empty", (boolean)list.isEmpty());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testGetStatementsInSingleContext() throws Exception {
            Statement st;
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.setAutoCommit(true);
            Assert.assertTrue((String)"Repository should contain statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((String)"Repository should contain statement in context1", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
            Assert.assertFalse((String)"Repository should not contain statement in context2", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
            try (RepositoryResult result = this.testCon.getStatements((Resource)this.bob, this.name, null, false, new Resource[0]);){
                while (result.hasNext()) {
                    st = (Statement)result.next();
                    Assert.assertTrue((boolean)this.bob.equals((Object)st.getSubject()));
                    Assert.assertTrue((boolean)this.name.equals((Object)st.getPredicate()));
                    Assert.assertTrue((boolean)this.nameBob.equals((Object)st.getObject()));
                    Assert.assertTrue((boolean)this.context1.equals((Object)st.getContext()));
                }
            }
            result = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
            try {
                while (result.hasNext()) {
                    st = (Statement)result.next();
                    Assert.assertTrue((boolean)this.context1.equals((Object)st.getContext()));
                }
            }
            finally {
                result.close();
            }
            result = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext});
            try {
                Assert.assertTrue((result != null ? 1 : 0) != 0);
                Assert.assertFalse((boolean)result.hasNext());
            }
            finally {
                result.close();
            }
            List list = (List)Iterations.addAll((Iteration)this.testCon.getStatements(null, this.name, null, false, new Resource[]{this.context1}), new ArrayList());
            Assert.assertTrue((String)"List should not be null", (list != null ? 1 : 0) != 0);
            Assert.assertFalse((String)"List should not be empty", (boolean)list.isEmpty());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testGetStatementsInMultipleContexts() throws Exception {
            Statement st;
            int count;
            this.testCon.clear(new Resource[0]);
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
            this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
            this.testCon.setAutoCommit(true);
            try (RepositoryResult iter = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});){
                count = 0;
                while (iter.hasNext()) {
                    ++count;
                    st = (Statement)iter.next();
                    Assert.assertTrue((st.getContext() == null || this.context2.equals((Object)st.getContext()) ? 1 : 0) != 0);
                }
                Assert.assertEquals((String)"there should be three statements", (long)3L, (long)count);
            }
            iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
            try {
                count = 0;
                while (iter.hasNext()) {
                    ++count;
                    st = (Statement)iter.next();
                    Assert.assertTrue((boolean)this.context2.equals((Object)st.getContext()));
                }
                Assert.assertEquals((String)"there should be two statements", (long)2L, (long)count);
            }
            finally {
                iter.close();
            }
            iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext, this.context2});
            try {
                count = 0;
                while (iter.hasNext()) {
                    ++count;
                    st = (Statement)iter.next();
                    Assert.assertTrue((boolean)this.context2.equals((Object)st.getContext()));
                }
                Assert.assertEquals((String)"there should be two statements", (long)2L, (long)count);
            }
            finally {
                iter.close();
            }
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
            this.testCon.setAutoCommit(true);
            iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
            try {
                Assert.assertTrue((iter != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)iter.hasNext());
            }
            finally {
                iter.close();
            }
            iter = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});
            try {
                count = 0;
                while (iter.hasNext()) {
                    ++count;
                    st = (Statement)iter.next();
                    Assert.assertTrue((st.getContext() == null || this.context2.equals((Object)st.getContext()) ? 1 : 0) != 0);
                }
                Assert.assertEquals((String)"there should be four statements", (long)4L, (long)count);
            }
            finally {
                iter.close();
            }
            iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
            try {
                count = 0;
                while (iter.hasNext()) {
                    ++count;
                    st = (Statement)iter.next();
                    Assert.assertTrue((this.context1.equals((Object)st.getContext()) || this.context2.equals((Object)st.getContext()) ? 1 : 0) != 0);
                }
                Assert.assertEquals((String)"there should be four statements", (long)4L, (long)count);
            }
            finally {
                iter.close();
            }
        }

        @Test
        public void testDuplicateFilterWithGraphs() throws Exception {
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context2});
            this.testCon.setAutoCommit(true);
            RepositoryResult result = this.testCon.getStatements((Resource)this.bob, this.name, null, true, new Resource[0]);
            result.enableDuplicateFilter();
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            Assert.assertEquals((long)3L, (long)count);
        }

        @Test
        public void testDuplicateFilter() throws Exception {
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.setAutoCommit(true);
            RepositoryResult result = this.testCon.getStatements((Resource)this.bob, this.name, null, true, new Resource[0]);
            result.enableDuplicateFilter();
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }

        @Test
        public void testRemoveStatements() throws Exception {
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
            this.testCon.setAutoCommit(true);
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            this.testCon.remove((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            Assert.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            this.testCon.remove((Resource)this.alice, null, null, new Resource[0]);
            Assert.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.isEmpty());
        }

        @Test
        public void testRemoveStatementCollection() throws Exception {
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.setAutoCommit(true);
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            Collection c = Iterations.addAll((Iteration)this.testCon.getStatements(null, null, null, false, new Resource[0]), new ArrayList());
            this.testCon.remove((Iterable)c, new Resource[0]);
            Assert.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        }

        @Test
        public void testRemoveStatementIteration() throws Exception {
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.setAutoCommit(true);
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
            try (RepositoryResult iter = this.testCon.getStatements(null, null, null, false, new Resource[0]);){
                this.testCon.remove((Iteration)iter, new Resource[0]);
            }
            Assert.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
            Assert.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        }

        @Test
        public void testGetNamespaces() throws Exception {
            StringBuilder rdfFragment = new StringBuilder();
            rdfFragment.append("<rdf:RDF\n");
            rdfFragment.append("    xmlns:example='http://example.org/'\n");
            rdfFragment.append("    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n");
            rdfFragment.append("    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' >\n");
            rdfFragment.append("  <rdf:Description rdf:about='http://example.org/Main'>\n");
            rdfFragment.append("    <rdfs:label>Main Node</rdfs:label>\n");
            rdfFragment.append("  </rdf:Description>\n");
            rdfFragment.append("</rdf:RDF>");
            this.testCon.add((Reader)new StringReader(rdfFragment.toString()), "", RDFFormat.RDFXML, new Resource[0]);
            try (RepositoryResult nsIter = this.testCon.getNamespaces();){
                int nsCount = 0;
                while (nsIter.hasNext()) {
                    ++nsCount;
                    nsIter.next();
                }
                Assert.assertEquals((String)"Namespaces from imported RDF should not be added to repository", (long)0L, (long)nsCount);
            }
        }

        @Test
        public void testClear() throws Exception {
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            Assert.assertTrue((boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
            this.testCon.clear(new Resource[0]);
            Assert.assertFalse((boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        }

        @Test
        public void testRecoverFromParseError() throws RepositoryException, IOException {
            String invalidData = "bad";
            String validData = "@prefix foo: <http://example.org/foo#>.\nfoo:a foo:b foo:c.";
            try {
                this.testCon.add((Reader)new StringReader(invalidData), "", RDFFormat.TURTLE, new Resource[0]);
                Assert.fail((String)"Invalid data should result in an exception");
            }
            catch (RDFParseException rDFParseException) {
                // empty catch block
            }
            try {
                this.testCon.add((Reader)new StringReader(validData), "", RDFFormat.TURTLE, new Resource[0]);
            }
            catch (RDFParseException e) {
                Assert.fail((String)"Valid data should not result in an exception");
            }
            Assert.assertEquals((String)"Repository contains incorrect number of statements", (long)1L, (long)this.testCon.size(new Resource[0]));
        }

        @Test
        public void testStatementSerialization() throws Exception {
            Statement st;
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            try (RepositoryResult statements = this.testCon.getStatements(null, null, null, true, new Resource[0]);){
                st = (Statement)statements.next();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(st);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            Statement deserializedStatement = (Statement)in.readObject();
            in.close();
            Assert.assertTrue((boolean)st.equals((Object)deserializedStatement));
            Assert.assertTrue((boolean)this.testCon.hasStatement(st, true, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.hasStatement(deserializedStatement, true, new Resource[0]));
        }

        @Test
        public void testBNodeSerialization() throws Exception {
            Statement st;
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            try (RepositoryResult statements = this.testCon.getStatements(null, null, null, false, new Resource[0]);){
                st = (Statement)statements.next();
            }
            BNode bnode = (BNode)st.getSubject();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(bnode);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            BNode deserializedBNode = (BNode)in.readObject();
            in.close();
            Assert.assertTrue((boolean)bnode.equals((Object)deserializedBNode));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)bnode, this.name, (Value)this.nameBob, true, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)deserializedBNode, this.name, (Value)this.nameBob, true, new Resource[0]));
        }

        @Test
        public void testURISerialization() throws Exception {
            Statement st;
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            try (RepositoryResult statements = this.testCon.getStatements(null, null, null, false, new Resource[0]);){
                st = (Statement)statements.next();
            }
            IRI uri = st.getPredicate();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(uri);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            IRI deserializedURI = (IRI)in.readObject();
            in.close();
            Assert.assertTrue((boolean)uri.equals((Object)deserializedURI));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, uri, (Value)this.nameBob, true, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, deserializedURI, (Value)this.nameBob, true, new Resource[0]));
        }

        @Test
        public void testLiteralSerialization() throws Exception {
            Statement st;
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            try (RepositoryResult statements = this.testCon.getStatements(null, null, null, false, new Resource[0]);){
                st = (Statement)statements.next();
            }
            Literal literal = (Literal)st.getObject();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(literal);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            Literal deserializedLiteral = (Literal)in.readObject();
            in.close();
            Assert.assertTrue((boolean)literal.equals((Object)deserializedLiteral));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)literal, true, new Resource[0]));
            Assert.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)deserializedLiteral, true, new Resource[0]));
        }

        @Test
        public void testGraphSerialization() throws Exception {
            LinkedHashModel graph;
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
            this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
            try (RepositoryResult statements = this.testCon.getStatements(null, null, null, true, new Resource[0]);){
                graph = new LinkedHashModel((Collection)statements.asList());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(graph);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            Model deserializedGraph = (Model)in.readObject();
            in.close();
            Assert.assertFalse((boolean)deserializedGraph.isEmpty());
            for (Statement st : deserializedGraph) {
                Assert.assertTrue((boolean)graph.contains((Object)st));
                Assert.assertTrue((boolean)this.testCon.hasStatement(st, true, new Resource[0]));
            }
        }

        @Test
        public void testEmptyRollback() throws Exception {
            Assert.assertTrue((boolean)this.testCon.isEmpty());
            Assert.assertTrue((boolean)this.testCon2.isEmpty());
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.vf.createBNode(), this.vf.createIRI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
            Assert.assertFalse((boolean)this.testCon.isEmpty());
            Assert.assertTrue((boolean)this.testCon2.isEmpty());
            this.testCon.rollback();
            Assert.assertTrue((boolean)this.testCon.isEmpty());
            Assert.assertTrue((boolean)this.testCon2.isEmpty());
        }

        @Test
        public void testEmptyCommit() throws Exception {
            Assert.assertTrue((boolean)this.testCon.isEmpty());
            Assert.assertTrue((boolean)this.testCon2.isEmpty());
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.vf.createBNode(), this.vf.createIRI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
            Assert.assertFalse((boolean)this.testCon.isEmpty());
            Assert.assertTrue((boolean)this.testCon2.isEmpty());
            this.testCon.commit();
            Assert.assertFalse((boolean)this.testCon.isEmpty());
            Assert.assertFalse((boolean)this.testCon2.isEmpty());
        }

        @Test
        public void testOpen() throws Exception {
            Assert.assertTrue((boolean)this.testCon.isOpen());
            Assert.assertTrue((boolean)this.testCon2.isOpen());
            this.testCon.close();
            Assert.assertFalse((boolean)this.testCon.isOpen());
            Assert.assertTrue((boolean)this.testCon2.isOpen());
        }

        @Test
        public void testSizeRollback() throws Exception {
            Assert.assertEquals((long)0L, (long)this.testCon.size(new Resource[0]));
            Assert.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.vf.createBNode(), this.vf.createIRI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
            Assert.assertEquals((long)1L, (long)this.testCon.size(new Resource[0]));
            Assert.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
            this.testCon.add((Resource)this.vf.createBNode(), this.vf.createIRI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
            Assert.assertEquals((long)2L, (long)this.testCon.size(new Resource[0]));
            Assert.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
            this.testCon.rollback();
            Assert.assertEquals((long)0L, (long)this.testCon.size(new Resource[0]));
            Assert.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
        }

        @Test
        public void testSizeCommit() throws Exception {
            Assert.assertEquals((long)0L, (long)this.testCon.size(new Resource[0]));
            Assert.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.vf.createBNode(), this.vf.createIRI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
            Assert.assertEquals((long)1L, (long)this.testCon.size(new Resource[0]));
            Assert.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
            this.testCon.add((Resource)this.vf.createBNode(), this.vf.createIRI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
            Assert.assertEquals((long)2L, (long)this.testCon.size(new Resource[0]));
            Assert.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
            this.testCon.commit();
            Assert.assertEquals((long)2L, (long)this.testCon.size(new Resource[0]));
            Assert.assertEquals((long)2L, (long)this.testCon2.size(new Resource[0]));
        }

        @Test
        public void testAddRemove() throws Exception {
            IRI FOAF_PERSON = this.vf.createIRI("http://xmlns.com/foaf/0.1/Person");
            final Statement stmt = this.vf.createStatement((Resource)this.bob, this.name, (Value)this.nameBob);
            this.testCon.add((Resource)this.bob, RDF.TYPE, (Value)FOAF_PERSON, new Resource[0]);
            this.testCon.setAutoCommit(false);
            this.testCon.add(stmt, new Resource[0]);
            this.testCon.remove(stmt, new Resource[0]);
            this.testCon.commit();
            this.testCon.exportStatements(null, null, null, false, (RDFHandler)new RDFHandlerBase(){

                public void handleStatement(Statement st) throws RDFHandlerException {
                    Assert.assertTrue((!stmt.equals((Object)st) ? 1 : 0) != 0);
                }
            }, new Resource[0]);
        }

        @Test
        public void testInferredStatementCount() throws Exception {
            Assert.assertTrue((boolean)this.testCon.isEmpty());
            int inferred = this.getTotalStatementCount(this.testCon);
            IRI root = this.vf.createIRI("urn:root");
            this.testCon.add((Resource)root, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            this.testCon.remove((Resource)root, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            Assert.assertTrue((boolean)this.testCon.isEmpty());
            Assert.assertEquals((long)inferred, (long)this.getTotalStatementCount(this.testCon));
        }

        @Test
        public void testGetContextIDs() throws Exception {
            Assert.assertEquals((long)0L, (long)this.testCon.getContextIDs().asList().size());
            this.testCon.setAutoCommit(false);
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            Assert.assertEquals(Arrays.asList(this.context1), (Object)Iterations.asList((Iteration)this.testCon.getContextIDs()));
            this.testCon.remove((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
            Assert.assertEquals((long)0L, (long)Iterations.asList((Iteration)this.testCon.getContextIDs()).size());
            this.testCon.setAutoCommit(true);
            Assert.assertEquals((long)0L, (long)Iterations.asList((Iteration)this.testCon.getContextIDs()).size());
            this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context2});
            Assert.assertEquals(Arrays.asList(this.context2), (Object)Iterations.asList((Iteration)this.testCon.getContextIDs()));
        }

        @Test
        @Category(value={TestSuites.Broken.class})
        public void testXmlCalendarZ() throws Exception {
            String NS = "http://example.org/rdf/";
            int OFFSET = TimeZone.getDefault().getOffset(new Date(2007, 10, 6).getTime()) / 1000 / 60;
            String SELECT_BY_DATE = "SELECT ?s ?d WHERE { ?s <http://www.w3.org/1999/02/22-rdf-syntax-ns#value> ?d . FILTER (?d <= ?date) }";
            DatatypeFactory data = DatatypeFactory.newInstance();
            for (int i = 1; i < 5; ++i) {
                IRI uri = this.vf.createIRI(NS, "date" + i);
                XMLGregorianCalendar xcal = data.newXMLGregorianCalendar();
                xcal.setYear(2000);
                xcal.setMonth(11);
                xcal.setDay(i * 2);
                this.testCon.add((Resource)uri, RDF.VALUE, (Value)this.vf.createLiteral(xcal), new Resource[0]);
                IRI uriz = this.vf.createIRI(NS, "dateZ" + i);
                xcal = data.newXMLGregorianCalendar();
                xcal.setYear(2007);
                xcal.setMonth(11);
                xcal.setDay(i * 2);
                xcal.setTimezone(OFFSET);
                this.testCon.add((Resource)uriz, RDF.VALUE, (Value)this.vf.createLiteral(xcal), new Resource[0]);
            }
            XMLGregorianCalendar xcal = data.newXMLGregorianCalendar();
            xcal.setYear(2007);
            xcal.setMonth(11);
            xcal.setDay(6);
            xcal.setTimezone(OFFSET);
            TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, SELECT_BY_DATE);
            query.setBinding("date", (Value)this.vf.createLiteral(xcal));
            TupleQueryResult result = query.evaluate();
            ArrayList<Object> list = new ArrayList<Object>();
            while (result.hasNext()) {
                list.add(result.next());
            }
            Assert.assertEquals((long)7L, (long)list.size());
        }

        @Test
        public void testOptionalFilter() throws Exception {
            String optional = "{ ?s :p1 ?v1 OPTIONAL {?s :p2 ?v2 FILTER(?v1<3) } }";
            IRI s = this.vf.createIRI("urn:test:s");
            IRI p1 = this.vf.createIRI("urn:test:p1");
            IRI p2 = this.vf.createIRI("urn:test:p2");
            Literal v1 = this.vf.createLiteral(1);
            Literal v2 = this.vf.createLiteral(2);
            Literal v3 = this.vf.createLiteral(3);
            this.testCon.add((Resource)s, p1, (Value)v1, new Resource[0]);
            this.testCon.add((Resource)s, p2, (Value)v2, new Resource[0]);
            this.testCon.add((Resource)s, p1, (Value)v3, new Resource[0]);
            String qry = "PREFIX :<urn:test:> SELECT ?s ?v1 ?v2 WHERE " + optional;
            TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, qry);
            TupleQueryResult result = query.evaluate();
            HashSet<List<Value>> set = new HashSet<List<Value>>();
            while (result.hasNext()) {
                BindingSet bindings = (BindingSet)result.next();
                set.add(Arrays.asList(bindings.getValue("v1"), bindings.getValue("v2")));
            }
            result.close();
            Assert.assertTrue((boolean)set.contains(Arrays.asList(v1, v2)));
            Assert.assertTrue((boolean)set.contains(Arrays.asList(v3, null)));
        }

        @Test
        public void testOrPredicate() throws Exception {
            String union = "{ :s ?p :o FILTER (?p = :p1 || ?p = :p2) }";
            IRI s = this.vf.createIRI("urn:test:s");
            IRI p1 = this.vf.createIRI("urn:test:p1");
            IRI p2 = this.vf.createIRI("urn:test:p2");
            IRI o = this.vf.createIRI("urn:test:o");
            this.testCon.add((Resource)s, p1, (Value)o, new Resource[0]);
            this.testCon.add((Resource)s, p2, (Value)o, new Resource[0]);
            String qry = "PREFIX :<urn:test:> SELECT ?p WHERE " + union;
            TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, qry);
            TupleQueryResult result = query.evaluate();
            ArrayList<Value> list = new ArrayList<Value>();
            while (result.hasNext()) {
                BindingSet bindings = (BindingSet)result.next();
                list.add(bindings.getValue("p"));
            }
            result.close();
            Assert.assertTrue((boolean)list.contains(p1));
            Assert.assertTrue((boolean)list.contains(p2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int getTotalStatementCount(RepositoryConnection connection) throws RepositoryException {
            try (RepositoryResult iter = connection.getStatements(null, null, null, true, new Resource[0]);){
                int size = 0;
                while (iter.hasNext()) {
                    iter.next();
                    ++size;
                }
                int n = size;
                return n;
            }
        }
    }
}

