/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class SparqlDefaultDatasetTest
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.NotApplicableForAgraph.class})
    public void testMemoryStoreDefaultDataset() throws Exception {
        SailRepository repo = new SailRepository((Sail)new MemoryStore());
        repo.initialize();
        RepositoryConnection conn = repo.getConnection();
        this.testSesameDefaultDataset(conn);
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testAGDefaultDataset() throws Exception {
        this.testSesameDefaultDataset((RepositoryConnection)this.conn);
    }

    private void testSesameDefaultDataset(RepositoryConnection conn) throws IOException, UpdateExecutionException, RepositoryException, MalformedQueryException, QueryEvaluationException {
        IRI g1 = conn.getValueFactory().createIRI("eh:graph1");
        IRI g2 = conn.getValueFactory().createIRI("eh:graph2");
        IRI g3 = conn.getValueFactory().createIRI("eh:graph3");
        String update = AGAbstractTest.readResourceAsString("/test/update-default.ru");
        conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        Assert.assertEquals((long)4L, (long)conn.size(new Resource[]{null}));
        Assert.assertEquals((long)2L, (long)conn.size(new Resource[]{g1}));
        Assert.assertEquals((long)2L, (long)conn.size(new Resource[]{g2}));
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[]{g3}));
        Assert.assertEquals((long)8L, (long)conn.size(new Resource[0]));
        String query = "CONSTRUCT {?s ?p ?o} WHERE {?s ?p ?o}";
        GraphQueryResult result = conn.prepareGraphQuery(QueryLanguage.SPARQL, query).evaluate();
        int i = 0;
        while (result.hasNext()) {
            result.next();
            ++i;
        }
        Assert.assertTrue((i == 7 || i == 8 ? 1 : 0) != 0);
        query = "CONSTRUCT {?s ?p ?o} WHERE {GRAPH <eh:graph1> {?s ?p ?o}}";
        result = conn.prepareGraphQuery(QueryLanguage.SPARQL, query).evaluate();
        i = 0;
        while (result.hasNext()) {
            result.next();
            ++i;
        }
        Assert.assertEquals((int)2, (int)i);
        update = "INSERT DATA { <eh:c> <eh:yyyy> <eh:here> }";
        conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        Assert.assertEquals((long)5L, (long)conn.size(new Resource[]{null}));
        update = "DELETE DATA {  <eh:this> <eh:is> 'triple'  . }";
        conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        Assert.assertEquals((long)5L, (long)conn.size(new Resource[]{null}));
        Assert.assertEquals((long)1L, (long)conn.size(new Resource[]{g1}));
        Assert.assertEquals((long)1L, (long)conn.size(new Resource[]{g2}));
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[]{g3}));
        Assert.assertEquals((long)7L, (long)conn.size(new Resource[0]));
    }
}

