/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class SparqlDefaultTest
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.NotApplicableForAgraph.class})
    public void testMemoryStoreDEFAULT() throws Exception {
        SailRepository repo = new SailRepository((Sail)new MemoryStore());
        repo.initialize();
        RepositoryConnection conn = repo.getConnection();
        this.testDEFAULT(conn);
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testAGDEFAULT() throws Exception {
        this.testDEFAULT((RepositoryConnection)this.conn);
    }

    private void testDEFAULT(RepositoryConnection conn) throws IOException, UpdateExecutionException, RepositoryException, MalformedQueryException, QueryEvaluationException {
        IRI g1 = conn.getValueFactory().createIRI("eh:graph1");
        IRI g2 = conn.getValueFactory().createIRI("eh:graph2");
        IRI g3 = conn.getValueFactory().createIRI("eh:graph3");
        String update = AGAbstractTest.readResourceAsString("/test/update-default.ru");
        conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        Assert.assertEquals((long)4L, (long)conn.size(new Resource[]{null}));
        Assert.assertEquals((long)2L, (long)conn.size(new Resource[]{g1}));
        Assert.assertEquals((long)2L, (long)conn.size(new Resource[]{g2}));
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[]{g3}));
        Assert.assertEquals((long)8L, (long)conn.size(new Resource[0]));
        update = "ADD DEFAULT TO <eh:graph3>";
        conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        Assert.assertEquals((long)4L, (long)conn.size(new Resource[]{g3}));
        Assert.assertEquals((long)12L, (long)conn.size(new Resource[0]));
        conn.prepareUpdate(QueryLanguage.SPARQL, "DROP DEFAULT").execute();
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[]{null}));
        Assert.assertEquals((long)8L, (long)conn.size(new Resource[0]));
    }
}

