/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGGraphQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import test.AGAbstractTest;

@RunWith(value=Parameterized.class)
public class UnicodeRDFFormatTest
extends AGAbstractTest {
    private final RDFFormat format;
    private RDFFormat oldFormat;

    public UnicodeRDFFormatTest(RDFFormat format) {
        this.format = format;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({RDFFormat.NQUADS}, {RDFFormat.TRIX});
    }

    @Before
    public void setUpFormat() {
        this.oldFormat = this.conn.prepareHttpRepoClient().getPreferredRDFFormat();
        this.conn.prepareHttpRepoClient().setPreferredRDFFormat(this.format);
    }

    @After
    public void tearDownFormat() {
        this.conn.prepareHttpRepoClient().setPreferredRDFFormat(this.oldFormat);
    }

    @Test
    public void testAddUnicodeLiteral() throws RepositoryException {
        IRI s = this.vf.createIRI("http://franz.com/s");
        IRI p = this.vf.createIRI("http://franz.com/p");
        Literal o = this.vf.createLiteral("\u091c\u0941\u092a");
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        List result = Iterations.asList((Iteration)this.conn.getStatements((Resource)s, p, null, false, new Resource[0]));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Statement)result.get(0)).getObject().stringValue(), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }

    @Test
    public void testAddUnicodeSubject() throws RepositoryException {
        IRI s = this.vf.createIRI("http://franz.com/\u091c\u0941\u092a");
        IRI p = this.vf.createIRI("http://franz.com/p");
        Literal o = this.vf.createLiteral("o");
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        List result = Iterations.asList((Iteration)this.conn.getStatements((Resource)s, p, null, false, new Resource[0]));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Statement)result.get(0)).getSubject().stringValue(), (Matcher)CoreMatchers.is((Object)"http://franz.com/\u091c\u0941\u092a"));
    }

    @Test
    public void testUnicodeCreate() throws RepositoryException, QueryEvaluationException {
        AGGraphQuery query = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, "CONSTRUCT { <s> <p> \"\u091c\u0941\u092a\"} WHERE {}");
        List result = Iterations.asList((Iteration)query.evaluate());
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Statement)result.get(0)).getObject().stringValue(), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }
}

