/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.atomikos.datasource.xa.XID;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGServerVersion;
import com.franz.agraph.repository.AGValueFactory;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import test.AGAbstractTest;

public class XAAtomikosTests
extends AGAbstractTest {
    private static final String REPO_ID = "test-2pc";
    private static AGServer server;
    private AGRepository agrepo;
    private AGRepositoryConnection testConnection;
    private XAResource testXAResource;
    private Xid testXid;
    private AGRepositoryConnection independentConnection;
    private XAResource independentXAResource;

    @BeforeClass
    public static void setUpClass() {
        server = XAAtomikosTests.newAGServer();
        Assume.assumeTrue((String)"XA was added in AG 6.5.0", (server.getComparableVersion().compareTo(new AGServerVersion("6.5")) >= 0 ? 1 : 0) != 0);
    }

    @AfterClass
    public static void tearDownClass() {
        server.close();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.agrepo = XAAtomikosTests.freshRepository("java-catalog", REPO_ID);
        this.closer.closeLater((AutoCloseable)this.agrepo);
        AGRepositoryConnection conn = this.agrepo.getConnection();
        this.initData(conn);
        this.testConnection = this.agrepo.getConnection();
        this.closer.closeLater((AutoCloseable)this.testConnection);
        this.testConnection.begin();
        this.testXAResource = this.testConnection.getXAResource();
        this.testXAResource.setTransactionTimeout(10);
        this.testXid = XAUtils.createXid();
        this.independentConnection = this.agrepo.getConnection();
        this.closer.closeLater((AutoCloseable)this.independentConnection);
        this.independentConnection.begin();
        this.independentXAResource = this.independentConnection.getXAResource();
        this.independentXAResource.setTransactionTimeout(10);
    }

    @Override
    @After
    public void tearDown() {
        this.closer.close();
    }

    @Test
    public void testConnectToDatabase1() throws Exception {
        try (RepositoryResult res = this.testConnection.getStatements(null, null, null, false, new Resource[0]);){
            Assert.assertTrue((boolean)res.hasNext());
        }
    }

    @Test
    public void testUpdateVisibleToIndependentTransactionAfterCommit() throws Exception {
        long initialBalance = this.getBalanceInIndependentTransaction();
        this.updateBalanceViaTestConnection(initialBalance + 10L, 0);
        this.performOnePhaseCommitWithXA();
        this.assertBalanceViaIndependentTransaction("updated balance should be visible after commit", initialBalance + 10L);
    }

    @Test
    public void testTwoPhaseCommitWithXA() throws Exception {
        this.updateBalanceViaTestConnection(10L, 0);
        this.performPrepareWithXA();
        this.performCommitAfterPrepareWithXA(this.testXAResource);
    }

    @Test
    public void testCommitAfterPrepareIsAllowedOnDifferentXAResource() throws Exception {
        this.updateBalanceViaTestConnection(10L, 0);
        this.performPrepareWithXA();
        this.performCommitAfterPrepareWithXA(this.independentXAResource);
    }

    @Test
    public void testRollbackAfterPrepareIsAllowedOnDifferentXAResource() throws Exception {
        this.updateBalanceViaTestConnection(10L, 0);
        this.performPrepareWithXA();
        this.performRollbackWithXA(this.independentXAResource);
    }

    @Test
    public void testRollbackOfUnknownXidWorks() {
        try {
            this.testXAResource.rollback(XAUtils.createXid());
        }
        catch (Exception err) {
            Assert.assertTrue((boolean)(err instanceof XAException));
            XAException xaerr = (XAException)err;
            Assert.assertTrue((String)("rollback of unknown xid gives unexpected errorCode: " + xaerr.errorCode), (100 <= xaerr.errorCode && xaerr.errorCode <= 107 || xaerr.errorCode == -4 ? 1 : 0) != 0);
        }
    }

    private void performRollbackWithXA(XAResource xaResource) throws XAException {
        xaResource.rollback(this.testXid);
    }

    private void performCommitAfterPrepareWithXA(XAResource xaResource) throws XAException {
        xaResource.commit(this.testXid, false);
    }

    private void performPrepareWithXA() throws XAException {
        this.testXAResource.prepare(this.testXid);
    }

    private void performOnePhaseCommitWithXA() throws XAException {
        this.testXAResource.commit(this.testXid, true);
    }

    private void updateBalanceViaTestConnection(long balance, int xaStartFlag) throws XAException {
        this.testXAResource.start(this.testXid, xaStartFlag);
        AGValueFactory vf = this.testConnection.getRepository().getValueFactory();
        IRI alice = vf.createIRI("http://example.org/people/alice");
        IRI has = vf.createIRI("http://example.org/ontology/has");
        Literal alicesBalance = vf.createLiteral(balance);
        this.testConnection.remove((Resource)alice, has, null, new Resource[0]);
        this.testConnection.add((Resource)alice, has, (Value)alicesBalance, new Resource[0]);
        this.testXAResource.end(this.testXid, 0x4000000);
    }

    private void assertBalanceViaIndependentTransaction(String msg, long expectedBalance) throws XAException {
        long balance = this.getBalanceInIndependentTransaction();
        Assert.assertEquals((String)msg, (long)expectedBalance, (long)balance);
    }

    private long getBalanceInIndependentTransaction() throws XAException {
        Xid independentXid = XAUtils.createXid();
        this.independentConnection.rollback();
        this.independentXAResource.start(independentXid, 0);
        long balance = this.getBalance(this.independentConnection);
        this.independentXAResource.end(independentXid, 0x4000000);
        this.independentXAResource.commit(independentXid, true);
        return balance;
    }

    private long getBalance(AGRepositoryConnection conn) {
        AGValueFactory vf = conn.getRepository().getValueFactory();
        IRI alice = vf.createIRI("http://example.org/people/alice");
        IRI has = vf.createIRI("http://example.org/ontology/has");
        RepositoryResult res = conn.getStatements((Resource)alice, has, null, false, new Resource[0]);
        return Long.parseLong(((Statement)res.next()).getObject().stringValue());
    }

    private void initData(AGRepositoryConnection conn) {
        AGValueFactory vf = conn.getRepository().getValueFactory();
        conn.begin();
        IRI alice = vf.createIRI("http://example.org/people/alice");
        IRI has = vf.createIRI("http://example.org/ontology/has");
        Literal alicesBalance = vf.createLiteral("100", XMLSchema.LONG);
        conn.add((Resource)alice, has, (Value)alicesBalance, new Resource[0]);
        conn.commit();
        conn.close();
    }

    public static class XAUtils {
        private static final int XA_TIMEOUT = 10;
        private static long counter = 1L;

        public static String createTid() {
            return String.valueOf(++counter);
        }

        public static Xid createXid() {
            return new XID(XAUtils.createTid(), "test");
        }
    }
}

