/*
 * Decompiled with CFR 0.152.
 */
package test.openrdf;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.openrdf.SPARQLUpdateTest;

public class AGSparqlUpdateTest
extends SPARQLUpdateTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void batchUpdate() throws Exception {
        IRI s = this.f.createIRI("http://example/book1");
        IRI p = this.f.createIRI("http://purl.org/dc/elements/1.1/title");
        Literal o_wrong = this.f.createLiteral("Fundamentals of Compiler Desing");
        Literal o_right = this.f.createLiteral("Fundamentals of Compiler Design");
        IRI g = this.f.createIRI("http://example/bookStore");
        this.con.add((Resource)s, p, (Value)o_wrong, new Resource[]{g});
        String queryString = "PREFIX dc: <http://purl.org/dc/elements/1.1/> \nDELETE DATA { GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Desing\" } } ; \n\nPREFIX dc: <http://purl.org/dc/elements/1.1/> \nINSERT DATA { GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Design\" } }";
        Update u = this.con.prepareUpdate(QueryLanguage.SPARQL, queryString);
        u.execute();
        Assert.assertTrue((String)"Title should be correct", (boolean)this.con.hasStatement((Resource)s, p, (Value)o_right, false, new Resource[]{g}));
        Assert.assertFalse((String)"Incorrect title should be gone", (boolean)this.con.hasStatement((Resource)s, p, (Value)o_wrong, false, new Resource[]{g}));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void updateViaBooleanQuery() throws Exception {
        IRI s = this.f.createIRI("http://example/book1");
        IRI p = this.f.createIRI("http://purl.org/dc/elements/1.1/title");
        Literal o_wrong = this.f.createLiteral("Fundamentals of Compiler Desing");
        Literal o_right = this.f.createLiteral("Fundamentals of Compiler Design");
        IRI g = this.f.createIRI("http://example/bookStore");
        this.con.add((Resource)s, p, (Value)o_wrong, new Resource[]{g});
        String queryString = "PREFIX dc: <http://purl.org/dc/elements/1.1/> \nDELETE DATA { GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Desing\" } } ; \n\nPREFIX dc: <http://purl.org/dc/elements/1.1/> \nINSERT DATA { GRAPH <http://example/bookStore> { <http://example/book1>  dc:title  \"Fundamentals of Compiler Design\" } }";
        this.con.prepareBooleanQuery(QueryLanguage.SPARQL, queryString).evaluate();
        Assert.assertTrue((String)"Title should be correct", (boolean)this.con.hasStatement((Resource)s, p, (Value)o_right, false, new Resource[]{g}));
        Assert.assertFalse((String)"Incorrect title should be gone", (boolean)this.con.hasStatement((Resource)s, p, (Value)o_wrong, false, new Resource[]{g}));
    }

    @Override
    protected Repository newRepository() throws Exception {
        return AGAbstractTest.sharedRepository();
    }

    @Override
    protected void loadDataset(String datasetFile) throws RDFParseException, RepositoryException, IOException {
        logger.debug("loading dataset...");
        try (InputStream dataset = org.eclipse.rdf4j.query.parser.sparql.SPARQLUpdateTest.class.getResourceAsStream(datasetFile);){
            RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TRIG, (ValueFactory)this.f);
            parser.setPreserveBNodeIDs(true);
            StatementCollector collector = new StatementCollector();
            parser.setRDFHandler((RDFHandler)collector);
            parser.parse(dataset, "");
            this.con.add((Iterable)collector.getStatements(), new Resource[0]);
        }
    }
}

