/*
 * Decompiled with CFR 0.152.
 */
package test.openrdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.common.io.ZipUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.parser.sparql.manifest.SPARQLQueryTest;
import org.eclipse.rdf4j.query.parser.sparql.manifest.SPARQLUpdateConformanceTest;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.turtle.TurtleParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQL11ManifestTest {
    static final Logger logger = LoggerFactory.getLogger(SPARQL11ManifestTest.class);
    private static File tmpDir;

    public static TestSuite suite(SPARQLQueryTest.Factory factory, boolean officialWorkingGroupTests, boolean approvedTestsOnly, boolean useRemoteTests, String ... excludedSubdirs) throws Exception {
        String manifestFile = SPARQL11ManifestTest.getManifestFile(officialWorkingGroupTests, useRemoteTests);
        TestSuite suite = new TestSuite(factory.getClass().getName()){

            public void run(TestResult result) {
                try {
                    super.run(result);
                }
                finally {
                    if (tmpDir != null) {
                        try {
                            FileUtil.deleteDir((File)tmpDir);
                        }
                        catch (IOException e) {
                            System.err.println("Unable to clean up temporary directory '" + tmpDir + "': " + e.getMessage());
                        }
                    }
                }
            }
        };
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        manifestRep.initialize();
        RepositoryConnection con = manifestRep.getConnection();
        SPARQL11ManifestTest.addTurtle(con, new URL(manifestFile), manifestFile, new Resource[0]);
        String query = " PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> SELECT DISTINCT ?manifestFile WHERE { [] mf:include [ rdf:rest*/rdf:first ?manifestFile ] . }   ";
        TupleQueryResult manifestResults = con.prepareTupleQuery(QueryLanguage.SPARQL, query, manifestFile).evaluate();
        while (manifestResults.hasNext()) {
            BindingSet bindingSet = (BindingSet)manifestResults.next();
            String subManifestFile = bindingSet.getValue("manifestFile").toString();
            if (!SPARQL11ManifestTest.includeSubManifest(subManifestFile, excludedSubdirs)) continue;
            suite.addTest((Test)SPARQLQueryTest.suite((String)subManifestFile, (SPARQLQueryTest.Factory)factory, (boolean)approvedTestsOnly));
        }
        manifestResults.close();
        con.close();
        manifestRep.shutDown();
        logger.info("Created aggregated test suite with " + suite.countTestCases() + " test cases.");
        return suite;
    }

    public static TestSuite suite(SPARQLUpdateConformanceTest.Factory factory, boolean officialWorkingGroupTests, boolean approvedTestsOnly, boolean useRemote, String ... excludedSubdirs) throws Exception {
        String manifestFile = SPARQL11ManifestTest.getManifestFile(officialWorkingGroupTests, useRemote);
        TestSuite suite = new TestSuite(factory.getClass().getName()){

            public void run(TestResult result) {
                try {
                    super.run(result);
                }
                finally {
                    if (tmpDir != null) {
                        try {
                            FileUtil.deleteDir((File)tmpDir);
                        }
                        catch (IOException e) {
                            System.err.println("Unable to clean up temporary directory '" + tmpDir + "': " + e.getMessage());
                        }
                    }
                }
            }
        };
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        manifestRep.initialize();
        RepositoryConnection con = manifestRep.getConnection();
        SPARQL11ManifestTest.addTurtle(con, new URL(manifestFile), manifestFile, new Resource[0]);
        String query = " PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> SELECT DISTINCT ?manifestFile WHERE { [] mf:include [ rdf:rest*/rdf:first ?manifestFile ] . }   ";
        TupleQueryResult manifestResults = con.prepareTupleQuery(QueryLanguage.SPARQL, query, manifestFile).evaluate();
        while (manifestResults.hasNext()) {
            BindingSet bindingSet = (BindingSet)manifestResults.next();
            String subManifestFile = bindingSet.getValue("manifestFile").toString();
            if (!SPARQL11ManifestTest.includeSubManifest(subManifestFile, excludedSubdirs)) continue;
            suite.addTest((Test)SPARQLUpdateConformanceTest.suite((String)subManifestFile, (SPARQLUpdateConformanceTest.Factory)factory, (boolean)approvedTestsOnly));
        }
        manifestResults.close();
        con.close();
        manifestRep.shutDown();
        logger.info("Created aggregated test suite with " + suite.countTestCases() + " test cases.");
        return suite;
    }

    private static String getManifestFile(boolean officialWorkingGroupTests, boolean useRemote) {
        String manifestFile = null;
        if (useRemote) {
            manifestFile = "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/manifest-all.ttl";
        } else {
            URL url = null;
            url = officialWorkingGroupTests ? SPARQL11ManifestTest.class.getResource("/testcases-sparql-1.1-w3c/manifest-all.ttl") : SPARQL11ManifestTest.class.getResource("/testcases-sparql-1.1/manifest-evaluation.ttl");
            if ("jar".equals(url.getProtocol())) {
                try {
                    tmpDir = FileUtil.createTempDir((String)"sparql11-test-evaluation");
                    JarURLConnection con = (JarURLConnection)url.openConnection();
                    JarFile jar = con.getJarFile();
                    ZipUtil.extract((ZipFile)jar, (File)tmpDir);
                    File localFile = new File(tmpDir, con.getEntryName());
                    manifestFile = localFile.toURI().toURL().toString();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                manifestFile = url.toString();
            }
        }
        return manifestFile;
    }

    private static boolean includeSubManifest(String subManifestFile, String[] excludedSubdirs) {
        boolean result = true;
        if (excludedSubdirs != null && excludedSubdirs.length > 0) {
            int index = subManifestFile.lastIndexOf("/");
            String path = subManifestFile.substring(0, index);
            String sd = path.substring(path.lastIndexOf("/") + 1);
            for (String subdir : excludedSubdirs) {
                if (!sd.equals(subdir)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addTurtle(RepositoryConnection con, URL url, String baseURI, Resource ... contexts) throws IOException, RepositoryException, RDFParseException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        try (InputStream in = url.openStream();){
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            ValueFactory vf = con.getRepository().getValueFactory();
            TurtleParser rdfParser = new TurtleParser();
            rdfParser.setValueFactory(vf);
            rdfParser.setVerifyData(false);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            RDFInserter rdfInserter = new RDFInserter(con);
            rdfInserter.enforceContext(contexts);
            rdfParser.setRDFHandler((RDFHandler)rdfInserter);
            con.begin();
            try {
                rdfParser.parse(in, baseURI);
                con.commit();
            }
            catch (RDFHandlerException e) {
                con.rollback();
                throw (RepositoryException)e.getCause();
            }
            catch (RuntimeException e) {
                con.rollback();
            }
        }
    }
}

