/*
 * Decompiled with CFR 0.152.
 */
package test.openrdf.repository;

import com.franz.agraph.repository.AGRepository;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.Assert;
import org.junit.Test;
import test.AGAbstractTest;
import test.openrdf.repository.AGRepositoryConnectionTest;

public class AGRDFSchemaRepositoryConnectionTest
extends AGRepositoryConnectionTest {
    static AGRepository repo = null;
    private IRI person;
    private IRI woman;
    private IRI man;

    @Override
    protected Repository createRepository() throws Exception {
        return AGAbstractTest.sharedRepository();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.person = this.vf.createIRI("http://xmlns.com/foaf/0.1/Person");
        this.woman = this.vf.createIRI("http://example.org/Woman");
        this.man = this.vf.createIRI("http://example.org/Man");
    }

    @Test
    public void testDomainInference() throws Exception {
        this.testCon.add((Resource)this.name, RDFS.DOMAIN, (Value)this.person, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    @Test
    public void testSubClassInference() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.woman, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add((Resource)this.man, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add(this.alice, RDF.TYPE, (Value)this.woman, new Resource[0]);
        this.testCon.setAutoCommit(true);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    @Test
    public void testMakeExplicit() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.woman, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add(this.alice, RDF.TYPE, (Value)this.woman, new Resource[0]);
        this.testCon.setAutoCommit(true);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
        this.testCon.add(this.alice, RDF.TYPE, (Value)this.person, new Resource[0]);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    @Test
    public void testExplicitFlag() throws Exception {
        RepositoryResult result = this.testCon.getStatements((Resource)RDF.TYPE, RDF.TYPE, null, true, new Resource[0]);
        while (result.hasNext()) {
            try {
                Assert.assertTrue((String)"result should not be empty", (boolean)result.hasNext());
            }
            finally {
                result.close();
            }
        }
        result = this.testCon.getStatements((Resource)RDF.TYPE, RDF.TYPE, null, false, new Resource[0]);
        try {
            Assert.assertFalse((String)"result should be empty", (boolean)result.hasNext());
        }
        finally {
            result.close();
        }
    }

    @Test
    public void testInferencerUpdates() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.remove(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.setAutoCommit(true);
        Assert.assertFalse((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
    }

    @Test
    public void testInferencerQueryDuringTransaction() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        this.testCon.setAutoCommit(true);
    }

    @Test
    public void testInferencerTransactionIsolation() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        Assert.assertFalse((boolean)this.testCon2.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        this.testCon.setAutoCommit(true);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        Assert.assertTrue((boolean)this.testCon2.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
    }
}

