/*
 * Decompiled with CFR 0.152.
 */
package test.pool;

import com.franz.agraph.pool.AGConnPool;
import com.franz.agraph.pool.AGConnProp;
import com.franz.agraph.pool.AGPoolProp;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class AGConnPoolClosingTest
extends Closer {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    private static List<String> netstatLinesToRegex(List<String> netstatBefore) throws Exception {
        return netstatBefore.stream().map(netstatLine -> {
            String[] netstatFields = netstatLine.split(" +");
            return ".*" + netstatFields[3] + " +" + netstatFields[4] + ".*";
        }).collect(Collectors.toList());
    }

    @After
    public void closeAfter() throws Exception {
        this.close();
        Map<String, String> sessions = AGAbstractTest.sessions(AGAbstractTest.newAGServer());
        if (!sessions.isEmpty()) {
            this.log.warn("sessions after close: " + sessions);
        }
    }

    @Test
    @Category(value={TestSuites.Stress.class})
    public void openAG() throws Exception {
        String repoName = "pool.openAG";
        AGConnPool pool = (AGConnPool)this.closeLater((AutoCloseable)AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "java-catalog", AGConnProp.repository, "pool.openAG", AGConnProp.session, AGConnProp.Session.DEDICATED, AGConnProp.sessionLifetime, TimeUnit.MINUTES.toSeconds(5L), AGPoolProp.shutdownHook, true, AGPoolProp.initialSize, 2, AGPoolProp.maxActive, 6, AGPoolProp.maxWait, TimeUnit.SECONDS.toMillis(45L), AGPoolProp.maxIdle, 8}));
        Assert.assertEquals((String)pool.toString(), (long)0L, (long)pool.getNumActive());
        int NUM = 10;
        int HOLD_TIME = 5;
        AGServer server = AGAbstractTest.newAGServer();
        AGCatalog catalog = server.getCatalog("java-catalog");
        final AGRepository repo = (AGRepository)this.closeLater((AutoCloseable)catalog.createRepository("pool.openAG"));
        repo.setConnPool(pool);
        ExecutorService exec = Executors.newFixedThreadPool(10);
        final ArrayList errors = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    try (AGRepositoryConnection conn = repo.getConnection();){
                        conn.size(new Resource[0]);
                        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                        conn.size(new Resource[0]);
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                }
            });
        }
        int EXTRA_TIME = 60;
        int WAIT_TIMEOUT = 70;
        exec.shutdown();
        if (!exec.awaitTermination(70L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Not all worker threads terminated within 70 seconds");
        }
        Assert.assertEquals((String)pool.toString(), (long)0L, (long)pool.getNumActive());
        if (!errors.isEmpty()) {
            for (Throwable e : errors) {
                this.log.error("error", e);
            }
            Assert.fail((String)("see log for details: " + ((Object)errors).toString()));
        }
        this.close();
        long start = System.nanoTime();
        Map<String, String> sessions = Util.waitForSessionsToGoAway(server, "pool.openAG");
        Assert.assertNull((String)("Sessions alive " + TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) + " seconds after closing: " + sessions), sessions);
        this.close((AutoCloseable)server);
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void openSockets_bug21099() throws Exception {
        String repoName = "pool.bug21099";
        Thread.sleep(1000L);
        List<String> netstatBefore = Util.netstat();
        this.log.info("openSockets_bug21099 netstatBefore:\n" + String.join((CharSequence)"\n", netstatBefore));
        netstatBefore = AGConnPoolClosingTest.netstatLinesToRegex(netstatBefore);
        int minIdle = 10;
        int maxIdle = 20;
        AGConnPool pool = (AGConnPool)this.closeLater((AutoCloseable)AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "java-catalog", AGConnProp.repository, "pool.bug21099", AGConnProp.session, AGConnProp.Session.TX, AGConnProp.sessionLifetime, 30, AGPoolProp.maxActive, 40, AGPoolProp.maxWait, 40000, AGPoolProp.shutdownHook, true, AGPoolProp.testOnBorrow, false, AGPoolProp.minIdle, 10, AGPoolProp.maxIdle, 20, AGPoolProp.timeBetweenEvictionRunsMillis, 1000, AGPoolProp.minEvictableIdleTimeMillis, 2000, AGPoolProp.testWhileIdle, true, AGPoolProp.numTestsPerEvictionRun, 10, AGPoolProp.initialSize, 5}));
        this.log.info("openSockets_bug21099: Pool created");
        this.log.info("openSockets_bug21099: Sleeping for 30 seconds while pool oscillates");
        Thread.sleep(30000L);
        this.log.info("openSockets_bug21099: Sleep completed.  Checking for sockets in CLOSE_WAIT state");
        List<String> netstat = Util.waitForNetStat(0, netstatBefore);
        List<String> closeWait = Util.closeWait(netstat);
        Assert.assertTrue((String)("sockets in CLOSE_WAIT:\n" + String.join((CharSequence)"\n", closeWait)), (boolean)closeWait.isEmpty());
        if (netstat != null) {
            Assert.assertTrue((String)("too many sockets open:\n" + String.join((CharSequence)"\n", netstat)), (40 >= netstat.size() ? 1 : 0) != 0);
        }
        this.close((AutoCloseable)pool);
        netstat = Util.waitForNetStat(120, netstatBefore);
        Assert.assertNull((String)("sockets open after closing pool:\n" + String.join((CharSequence)"\n", netstat)), netstat);
        AGServer server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        long start = System.nanoTime();
        Map<String, String> sessions = Util.waitForSessionsToGoAway(server, "pool.bug21099");
        Assert.assertNull((String)("Sessions alive " + TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) + " seconds after closing:\n" + sessions), sessions);
        this.close((AutoCloseable)server);
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void openSockets_bug21109_direct() throws Exception {
        this.log.info("openSockets_bug21109_direct: Test started. Sleeping for 1 second");
        Thread.sleep(1000L);
        List<String> netstatBefore = Util.netstat();
        this.log.info("openSockets_bug21109_direct netstatBefore:\n" + String.join((CharSequence)"\n", netstatBefore));
        netstatBefore = AGConnPoolClosingTest.netstatLinesToRegex(netstatBefore);
        String repoName = "direct.bug21109";
        AGServer server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        AGCatalog cat = server.getCatalog("java-catalog");
        AGRepository repo = cat.createRepository("direct.bug21109");
        for (int i = 0; i < 30; ++i) {
            AGRepositoryConnection conn1 = (AGRepositoryConnection)this.closeLater((AutoCloseable)repo.getConnection());
            conn1.setAutoCommit(false);
            AGRepositoryConnection conn2 = (AGRepositoryConnection)this.closeLater((AutoCloseable)repo.getConnection());
            conn2.setAutoCommit(false);
            AGRepositoryConnection conn3 = (AGRepositoryConnection)this.closeLater((AutoCloseable)repo.getConnection());
            conn3.setAutoCommit(false);
            this.close((AutoCloseable)conn1);
            this.close((AutoCloseable)conn2);
            this.close((AutoCloseable)conn3);
            if (i != 5) continue;
            this.log.debug("netstat " + i + ":\n" + String.join((CharSequence)"\n", Util.netstat()));
        }
        List<String> netstat = Util.waitForNetStat(0, netstatBefore);
        List<String> closeWait = Util.closeWait(netstat);
        Assert.assertTrue((String)("sockets in CLOSE_WAIT:\n" + String.join((CharSequence)"\n", closeWait)), (boolean)closeWait.isEmpty());
        Assert.assertTrue((String)("too many sockets open:\n" + String.join((CharSequence)"\n", netstat)), (10 >= netstat.size() ? 1 : 0) != 0);
        repo = (AGRepository)this.close((AutoCloseable)repo);
        server = (AGServer)this.close((AutoCloseable)server);
        netstat = Util.waitForNetStat(120, netstatBefore);
        Assert.assertNull((String)("sockets open after closing pool:\n" + String.join((CharSequence)"\n", netstat)), netstat);
        server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        long start = System.nanoTime();
        Map<String, String> sessions = Util.waitForSessionsToGoAway(server, "direct.bug21109");
        Assert.assertNull((String)("Sessions alive " + TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) + " seconds after closing: " + sessions), sessions);
        this.close((AutoCloseable)server);
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void invalidSessionPortsConfiguration_spr30491() throws Exception {
        String repoName = "pool.spr30491-test";
        AGConnPool pool = (AGConnPool)this.closeLater((AutoCloseable)AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "java-catalog", AGConnProp.repository, "pool.spr30491-test", AGConnProp.session, AGConnProp.Session.DEDICATED, AGPoolProp.shutdownHook, true, AGPoolProp.maxActive, 1, AGPoolProp.initialSize, 1}));
        AGRepositoryConnection conn = pool.borrowConnection();
        Assert.assertEquals((long)pool.getNumActive(), (long)1L);
        AGValueFactory vf = conn.getValueFactory();
        conn.add(vf.createStatement((Resource)vf.createIRI("http://ag/test-spr30491-test1"), vf.createIRI("http://ag/spr-name"), (Value)vf.createLiteral("spr30491")), new Resource[0]);
        AGTupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s ?p ?o WHERE { ?s ?p ?o . }");
        AGValueFactory fvf = vf;
        AGRepositoryConnection fconn = conn;
        TupleQueryResultHandler handler = new TupleQueryResultHandler((RepositoryConnection)fconn, (ValueFactory)fvf){
            final /* synthetic */ RepositoryConnection val$fconn;
            final /* synthetic */ ValueFactory val$fvf;
            {
                this.val$fconn = repositoryConnection;
                this.val$fvf = valueFactory;
            }

            public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
            }

            public void endQueryResult() throws TupleQueryResultHandlerException {
            }

            public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
                try {
                    RepositoryResult statements = this.val$fconn.getStatements((Resource)this.val$fvf.createIRI(bindingSet.getValue("s").stringValue()), null, null, false, new Resource[0]);
                    Assert.assertNotNull((Object)statements);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new TupleQueryResultHandlerException((Throwable)e);
                }
            }

            public void handleBoolean(boolean arg0) throws QueryResultHandlerException {
            }

            public void handleLinks(List<String> arg0) throws QueryResultHandlerException {
            }
        };
        try {
            query.evaluate(handler);
        }
        catch (QueryEvaluationException e) {
            Assert.fail((String)"HttpSessionManager no configured properly in com.franz.agraph.pool.AGConnFactory");
        }
        pool.returnObject(conn);
        Assert.assertEquals((long)pool.getNumActive(), (long)0L);
        this.close((AutoCloseable)pool);
    }
}

