/*
 * Decompiled with CFR 0.152.
 */
package test.stress;

import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGValueFactory;
import java.util.LinkedList;
import java.util.Random;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class TransactionStressTest {
    private static final int WORKERS = 10;
    private static final int PER = 1000;

    public static AGRepositoryConnection connect() throws RepositoryException {
        AGServer server = new AGServer(AGAbstractTest.findServerUrl(), AGAbstractTest.username(), AGAbstractTest.password());
        AGCatalog catalog = server.getCatalog("java-catalog");
        AGRepository repository = catalog.createRepository("transaction-stress");
        repository.initialize();
        AGRepositoryConnection conn = repository.getConnection();
        return conn;
    }

    public static void main(String[] args) throws Exception {
        new TransactionStressTest().test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Category(value={TestSuites.Stress.class})
    public void test() throws Exception {
        try (AGRepositoryConnection conn = TransactionStressTest.connect();){
            conn.clear(new Resource[0]);
            LinkedList<Object> workers = new LinkedList<Object>();
            for (int i = 0; i < 10; ++i) {
                Worker w = new Worker(i * 1000, (i + 1) * 1000);
                workers.add(w);
                w.start();
            }
            String failed = null;
            for (Worker worker : workers) {
                worker.join();
                if (worker.failed == null) continue;
                failed = worker.failed;
            }
            if (failed != null) {
                Assert.fail(failed);
            }
            Assert.assertEquals((long)10000L, (long)conn.size(new Resource[0]));
            AGValueFactory vf = conn.getRepository().getValueFactory();
            RepositoryResult repositoryResult = conn.getStatements(null, vf.createIRI("http://example.org/finished"), (Value)vf.createLiteral("false"), false, new Resource[0]);
            Assert.assertTrue((!repositoryResult.hasNext() ? 1 : 0) != 0);
        }
    }

    private static class Worker
    extends Thread {
        int from;
        int to;
        String failed = null;
        Random rnd;

        public Worker(int from1, int to1) {
            this.from = from1;
            this.to = to1;
            this.rnd = new Random(from1);
            this.rnd.nextInt();
        }

        @Override
        public void run() {
            try {
                conn.setAutoCommit(false);
                try (AGRepositoryConnection conn = TransactionStressTest.connect();){
                    for (int i = this.from; i < this.to; ++i) {
                        while (!this.transaction(conn, i)) {
                        }
                    }
                }
            }
            catch (Exception e) {
                this.failed = e.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean transaction(AGRepositoryConnection conn, int id) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
            boolean okay = false;
            try {
                AGValueFactory vf = conn.getRepository().getValueFactory();
                IRI node = vf.createIRI("http://example.org/" + id);
                conn.add((Resource)node, vf.createIRI("http://example.org/finished"), (Value)vf.createLiteral("false"), new Resource[0]);
                String q = "SELECT ?n WHERE {?n <http://example.org/finished> \"false\"}";
                boolean found = false;
                try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, q).evaluate();){
                    while (result.hasNext()) {
                        Value n = ((BindingSet)result.next()).getValue("n");
                        if (n.equals(node)) {
                            found = true;
                            continue;
                        }
                        throw new RuntimeException("Unexpected unfinished node found: " + n);
                    }
                }
                if (!found) {
                    throw new RuntimeException("Unfinished node not found.");
                }
                if (this.rnd.nextInt() % 20 == 0) {
                    boolean bl = false;
                    return bl;
                }
                conn.remove((Resource)node, vf.createIRI("http://example.org/finished"), (Value)vf.createLiteral("false"), new Resource[0]);
                conn.add((Resource)node, vf.createIRI("http://example.org/finished"), (Value)vf.createLiteral("true"), new Resource[0]);
                conn.commit();
                conn.setAutoCommit(false);
                okay = true;
            }
            finally {
                if (!okay) {
                    conn.rollback();
                    conn.setAutoCommit(false);
                }
            }
            return true;
        }
    }
}

