/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGErrorHandler;
import com.franz.agraph.http.handler.AGMethodRetryHandler;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGStringHandler;
import com.franz.agraph.http.handler.AGTQRHandler;
import com.franz.agraph.repository.AGValueFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGHTTPClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AGHTTPClient.class);
    public static final String PROP_HTTP_NUM_RETRIES = "com.franz.agraph.http.numRetries";
    private static final int DEFAULT_HTTP_NUM_RETRIES = 1;
    private final String serverURL;
    private final HttpClient httpClient;
    private String masqueradeAsUser;
    private boolean isClosed = false;
    private final HttpClientConnectionManager mManager;
    private final AGMethodRetryHandler retryHandler = new AGMethodRetryHandler();
    private final int httpNumRetries;
    private CredentialsProvider credsProvider;
    private AuthCache authCache;

    public AGHTTPClient(String serverURL, HttpClientConnectionManager manager, SocketConfig socketConfig) {
        this.serverURL = serverURL.replaceAll("/$", "");
        this.mManager = manager != null ? manager : AGHTTPClient.createManager();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(this.mManager).setRetryHandler((HttpRequestRetryHandler)this.retryHandler);
        if (socketConfig != null) {
            httpClientBuilder.setDefaultSocketConfig(socketConfig);
        }
        this.httpClient = httpClientBuilder.build();
        this.httpNumRetries = Integer.parseInt(System.getProperty(PROP_HTTP_NUM_RETRIES, "1"));
        if (logger.isDebugEnabled()) {
            logger.debug("connect: {} {}", (Object)serverURL, (Object)this.httpClient);
        }
    }

    public AGHTTPClient(String serverURL, HttpClientConnectionManager manager) {
        this(serverURL, manager, null);
    }

    public AGHTTPClient(String serverURL) {
        this(serverURL, null, null);
    }

    private static HttpClientConnectionManager createManager() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        manager.setMaxTotal(Integer.MAX_VALUE);
        return manager;
    }

    public String toString() {
        return "{" + super.toString() + " " + this.serverURL + " " + this.httpClient + "}";
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void post(String url, Header[] headers, NameValuePair[] params, HttpEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
        HttpPost post = new HttpPost(url);
        this.setDoAuthentication((HttpRequest)post);
        for (Header header : headers) {
            post.addHeader(header);
        }
        if (System.getProperty("com.franz.agraph.http.useGzip", "true").equals("true")) {
            post.addHeader("Accept-encoding", "gzip");
        }
        Header contentType = post.getFirstHeader("Content-Type");
        if (requestEntity == null && (contentType == null || contentType.getValue().contains("application/x-www-form-urlencoded"))) {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(params), StandardCharsets.UTF_8));
        } else {
            post.setURI(this.getUri(url, params));
            post.setEntity(requestEntity);
        }
        this.executeMethod(url, (HttpUriRequest)post, handler);
    }

    private boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public void get(String url, Header[] headers, NameValuePair[] params, AGResponseHandler handler) throws AGHttpException {
        URI uri = this.getUri(url, params);
        int numTries = this.httpNumRetries + 1;
        for (int i = 0; i < numTries; ++i) {
            boolean mightRetry;
            HttpGet get = new HttpGet(uri);
            this.setDoAuthentication((HttpRequest)get);
            if (headers != null) {
                for (Header header : headers) {
                    get.setHeader(header);
                }
            }
            if (System.getProperty("com.franz.agraph.http.useGzip", "true").equals("true")) {
                get.setHeader("Accept-encoding", "gzip");
            }
            boolean bl = mightRetry = i < numTries - 1;
            if (this.executeMethod(url, (HttpUriRequest)get, handler, mightRetry) != ExecuteResult.SUCCESS) continue;
            return;
        }
        throw new AGHttpException("GET request failed (unreachable)");
    }

    private URI getUri(String url, NameValuePair[] params) {
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (params != null) {
                uriBuilder = uriBuilder.addParameters(Arrays.asList(params));
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException exc) {
            throw new AGHttpException(exc);
        }
    }

    public void delete(String url, Header[] headers, NameValuePair[] params, AGResponseHandler handler) throws AGHttpException {
        HttpDelete delete = new HttpDelete(this.getUri(url, params));
        this.setDoAuthentication((HttpRequest)delete);
        if (headers != null) {
            for (Header header : headers) {
                delete.addHeader(header);
            }
        }
        this.executeMethod(url, (HttpUriRequest)delete, handler);
    }

    public void put(String url, Header[] headers, NameValuePair[] params, HttpEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
        HttpPut put = new HttpPut(this.getUri(url, params));
        this.setDoAuthentication((HttpRequest)put);
        if (headers != null) {
            for (Header header : headers) {
                put.addHeader(header);
            }
        }
        if (requestEntity != null) {
            put.setEntity(requestEntity);
        }
        this.executeMethod(url, (HttpUriRequest)put, handler);
    }

    private void executeMethod(String url, HttpUriRequest method, AGResponseHandler handler) {
        this.executeMethod(url, method, handler, false);
    }

    private ExecuteResult executeMethod(String url, HttpUriRequest httpUriRequest, AGResponseHandler handler, boolean returnRetryOn408) throws AGHttpException {
        boolean release = true;
        HttpResponse httpResponse = null;
        try {
            Object serverHost;
            HttpClientContext context = HttpClientContext.create();
            if (this.credsProvider != null && this.authCache != null) {
                context.setCredentialsProvider(this.credsProvider);
                URI serverUri = this.getUri(this.serverURL, null);
                serverHost = new HttpHost(serverUri.getHost(), serverUri.getPort(), serverUri.getScheme());
                URI targetUri = this.getUri(url, null);
                HttpHost targetHost = new HttpHost(targetUri.getHost(), targetUri.getPort(), targetUri.getScheme());
                if (!serverHost.equals((Object)targetHost)) {
                    BasicAuthCache newac = new BasicAuthCache();
                    newac.put(targetHost, (AuthScheme)new BasicScheme());
                    context.setAuthCache((AuthCache)newac);
                } else {
                    context.setAuthCache(this.authCache);
                }
            }
            httpUriRequest.addHeader((Header)new BasicHeader("Connection", "keep-alive"));
            httpResponse = this.getHttpClient().execute(httpUriRequest, (HttpContext)context);
            int httpCode = httpResponse.getStatusLine().getStatusCode();
            if (httpCode == 200 || httpCode == 204) {
                if (handler != null) {
                    release = handler.releaseConnection();
                    handler.handleResponse(httpResponse, httpUriRequest);
                }
                serverHost = ExecuteResult.SUCCESS;
                return serverHost;
            }
            if (httpCode == 401) {
                throw new AGHttpException((Exception)new UnauthorizedException());
            }
            if (returnRetryOn408 && httpCode == 408) {
                serverHost = ExecuteResult.RETRY;
                return serverHost;
            }
            if (this.is2xx(httpCode)) {
                serverHost = ExecuteResult.SUCCESS;
                return serverHost;
            }
            try {
                AGErrorHandler errHandler = new AGErrorHandler();
                release = errHandler.releaseConnection();
                errHandler.handleResponse(httpResponse, httpUriRequest);
                throw errHandler.getResult();
            }
            catch (IOException e) {
                throw new AGHttpException(e);
            }
        }
        finally {
            if (release && httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
    }

    public void setUsernameAndPassword(String username, String password) {
        if (username != null && password != null) {
            logger.debug("Setting username '{}' and password for server at {}.", (Object)username, (Object)this.serverURL);
            try {
                URI serverUri = new URI(this.serverURL);
                HttpHost targetHost = new HttpHost(serverUri.getHost(), serverUri.getPort(), serverUri.getScheme());
                this.credsProvider = new BasicCredentialsProvider();
                this.credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                this.authCache = new BasicAuthCache();
                this.authCache.put(targetHost, (AuthScheme)new BasicScheme());
            }
            catch (URISyntaxException e) {
                logger.warn("Unable to set username and password for malformed URL " + this.serverURL, (Throwable)e);
            }
        } else {
            this.credsProvider = null;
            this.authCache = null;
        }
    }

    public String[] getUsernameAndPassword() {
        String[] res = new String[]{this.credsProvider.getCredentials(AuthScope.ANY).getUserPrincipal().getName(), this.credsProvider.getCredentials(AuthScope.ANY).getPassword()};
        return res;
    }

    public void setMasqueradeAsUser(String user) {
        this.masqueradeAsUser = user;
    }

    protected final void setDoAuthentication(HttpRequest method) {
        if (this.masqueradeAsUser != null) {
            method.addHeader((Header)new BasicHeader("x-masquerade-as-user", this.masqueradeAsUser));
        }
    }

    public void putCatalog(String catalogURL) throws AGHttpException {
        if (logger.isDebugEnabled()) {
            logger.debug("putCatalog: " + catalogURL);
        }
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.put(catalogURL, headers, params, null, null);
    }

    public void deleteCatalog(String catalogURL) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.delete(catalogURL, headers, params, null);
    }

    public void putRepository(String repositoryURL) throws AGHttpException {
        if (logger.isDebugEnabled()) {
            logger.debug("putRepository: " + repositoryURL);
        }
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new BasicNameValuePair("override", "false")};
        this.put(repositoryURL, headers, params, null, null);
    }

    public void deleteRepository(String repositoryURL) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.delete(repositoryURL, headers, params, null);
    }

    public TupleQueryResult getTupleQueryResult(String url) throws AGHttpException {
        Header[] headers = new Header[]{new BasicHeader("Accept", TupleQueryResultFormat.SPARQL.getDefaultMIMEType())};
        NameValuePair[] params = new NameValuePair[]{};
        TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
        AGTQRHandler handler = new AGTQRHandler(TupleQueryResultFormat.SPARQL, (TupleQueryResultHandler)builder, new AGValueFactory(null), false);
        this.get(url, headers, params, handler);
        return builder.getQueryResult();
    }

    public String[] getBlankNodes(String repositoryURL, int amount) throws AGHttpException {
        String url = AGProtocol.getBlankNodesURL(repositoryURL);
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new BasicNameValuePair("amount", Integer.toString(amount))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult().split("\n");
    }

    public String getString(String url) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        AGStringHandler handler = new AGStringHandler();
        this.get(url, headers, data, handler);
        return handler.getResult();
    }

    public String[] getStringArray(String url) throws AGHttpException {
        String result = this.getString(url);
        if (result.equals("")) {
            return new String[0];
        }
        return result.split("\n");
    }

    public List<String> getListOfStrings(String url) throws AGHttpException {
        return Arrays.asList(this.getStringArray(url));
    }

    public String openSession(String spec, boolean autocommit) throws AGHttpException {
        String url = AGProtocol.getSessionURL(this.serverURL);
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new BasicNameValuePair("store", spec), new BasicNameValuePair("autoCommit", Boolean.toString(autocommit)), new BasicNameValuePair("lifetime", Long.toString(3600L))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult();
    }

    @Override
    public void close() {
        logger.debug("close: " + this.serverURL + " " + this.mManager);
        if (this.mManager instanceof PoolingHttpClientConnectionManager) {
            this.mManager.shutdown();
        }
        this.isClosed = true;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    public String[] generateURIs(String repositoryURL, String namespace, int amount) throws AGHttpException {
        String url = repositoryURL + "/encodedIds";
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new BasicNameValuePair("prefix", namespace), new BasicNameValuePair("amount", Integer.toString(amount))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult().split("\n");
    }

    private static enum ExecuteResult {
        SUCCESS,
        RETRY;

    }
}

