/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.exception.AGHttpException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class AGResponseHandler {
    private final String requestMIMEType;

    public AGResponseHandler(String mimeType) {
        this.requestMIMEType = mimeType;
    }

    protected static InputStream getInputStream(HttpResponse httpResponse) throws IOException {
        if (httpResponse.getEntity() != null) {
            InputStream is = httpResponse.getEntity().getContent();
            Header h = httpResponse.getFirstHeader("Content-Encoding");
            if (h != null && h.getValue().equals("gzip")) {
                is = new GZIPInputStream(is);
            }
            return is;
        }
        return null;
    }

    protected static String streamToString(InputStream in) throws IOException {
        return IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
    }

    public String getRequestMIMEType() {
        return this.requestMIMEType;
    }

    public abstract void handleResponse(HttpResponse var1, HttpUriRequest var2) throws IOException, AGHttpException;

    public boolean releaseConnection() {
        return true;
    }

    protected String getResponseMIMEType(HttpResponse httpResponse) throws IOException {
        Header[] headers;
        for (Header header : headers = httpResponse.getHeaders("Content-Type")) {
            HeaderElement[] headerElements;
            for (HeaderElement headerEl : headerElements = header.getElements()) {
                String mimeType = headerEl.getName();
                if (mimeType == null) continue;
                return mimeType;
            }
        }
        return null;
    }
}

