/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphUnion;
import com.franz.agraph.repository.AGRepositoryConnection;
import java.io.Closeable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.jena.graph.GraphMaker;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.AlreadyExistsException;
import org.apache.jena.shared.DoesNotExistException;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.RepositoryException;

public class AGGraphMaker
implements GraphMaker,
Closeable {
    protected Map<String, AGGraph> created = CollectionFactory.createHashedMap();
    private AGRepositoryConnection conn;
    private AGGraph defaultGraph;

    public AGGraphMaker(AGRepositoryConnection conn) {
        this.conn = conn;
        conn.prepareHttpRepoClient().setAllowExternalBlankNodeIds(true);
    }

    public AGRepositoryConnection getRepositoryConnection() {
        return this.conn;
    }

    @Override
    public void close() {
    }

    public AGGraph getGraph() {
        if (this.defaultGraph == null) {
            this.defaultGraph = new AGGraph(this, null);
        }
        return this.defaultGraph;
    }

    public AGGraph createGraph() {
        String id = this.conn.getValueFactory().createBNode().getID();
        Node anon = NodeFactory.createBlankNode((String)id);
        return new AGGraph(this, anon);
    }

    public AGGraph createGraph(String uri) {
        return this.createGraph(uri, false);
    }

    public AGGraph createGraph(String uri, boolean strict) {
        AGGraph g = this.created.get(uri);
        if (g == null) {
            Node node = NodeFactory.createURI((String)this.absUriFromString(uri));
            g = new AGGraph(this, node);
            this.created.put(uri, g);
        } else if (strict) {
            throw new AlreadyExistsException(uri);
        }
        return g;
    }

    private String absUriFromString(String name) {
        String uri = name;
        if (name.indexOf(58) < 0) {
            uri = "urn:x-franz:" + name;
        }
        return uri;
    }

    public boolean hasGraph(String uri) {
        return null != this.created.get(uri);
    }

    public ExtendedIterator<String> listGraphs() {
        return new NiceIterator().andThen(this.created.keySet().iterator());
    }

    public AGGraph openGraph() {
        return this.getGraph();
    }

    public AGGraph openGraph(String name) {
        return this.openGraph(name, false);
    }

    public AGGraph openGraph(String uri, boolean strict) {
        AGGraph g = this.created.get(uri);
        if (g == null) {
            if (strict) {
                throw new DoesNotExistException(uri);
            }
            Node node = NodeFactory.createURI((String)this.absUriFromString(uri));
            g = new AGGraph(this, node);
            this.created.put(uri, g);
        }
        return g;
    }

    public void removeGraph(String uri) {
        AGGraph g = this.created.get(uri);
        if (g == null) {
            throw new DoesNotExistException(uri);
        }
        try {
            g.getConnection().clear(g.getGraphContext());
            this.created.remove(uri);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public AGGraph getUnionOfAllGraphs() {
        return this.createUnion(new AGGraph[0]);
    }

    public AGGraphUnion createUnion(AGGraph ... graphs) {
        HashSet<Resource> contexts = new HashSet<Resource>();
        for (AGGraph g : graphs) {
            contexts.addAll(Arrays.asList(g.getGraphContexts()));
        }
        Resource context = null;
        if (graphs.length > 0) {
            context = graphs[0].getGraphContext();
        }
        return new AGGraphUnion(this, context, contexts.toArray(new Resource[contexts.size()]));
    }
}

