/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

public class AGNodeFactory {
    public static Triple asTriple(Statement st) {
        Node s = AGNodeFactory.asNode((Value)st.getSubject());
        Node p = AGNodeFactory.asNode((Value)st.getPredicate());
        Node o = AGNodeFactory.asNode(st.getObject());
        return new Triple(s, p, o);
    }

    public static Quad asQuad(Statement st) {
        Node s = AGNodeFactory.asNode((Value)st.getSubject());
        Node p = AGNodeFactory.asNode((Value)st.getPredicate());
        Node o = AGNodeFactory.asNode(st.getObject());
        Node g = AGNodeFactory.asNode((Value)st.getContext());
        return new Quad(s, p, o, g);
    }

    public static Node asNode(Value v) {
        Node node;
        if (v == null) {
            node = Node.ANY;
        } else if (v instanceof IRI) {
            node = NodeFactory.createURI((String)v.stringValue());
        } else if (v instanceof BNode) {
            node = NodeFactory.createBlankNode((String)((BNode)v).getID());
        } else if (v instanceof Literal) {
            Literal lit = (Literal)v;
            IRI datatype = lit.getDatatype();
            String lang = lit.getLanguage().orElse(null);
            node = lang != null ? NodeFactory.createLiteral((String)lit.getLabel(), (String)lang, null) : (datatype != null ? NodeFactory.createLiteral((String)lit.getLabel(), null, (RDFDatatype)NodeFactory.getType((String)datatype.toString())) : NodeFactory.createLiteral((String)lit.stringValue()));
        } else {
            throw new IllegalArgumentException("Cannot create Node from Value: " + v);
        }
        return node;
    }
}

