/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuerySolution;
import java.util.List;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.engine.binding.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class AGResultSet
implements ResultSet {
    private final TupleQueryResult result;
    private final AGModel model;

    public AGResultSet(TupleQueryResult result, AGModel model) {
        this.result = result;
        this.model = model;
    }

    public Model getResourceModel() {
        return this.model;
    }

    public List<String> getResultVars() {
        try {
            return this.result.getBindingNames();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRowNumber() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    public boolean hasNext() {
        boolean res;
        try {
            res = this.result.hasNext();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public AGQuerySolution next() {
        BindingSet bs;
        try {
            bs = (BindingSet)this.result.next();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return new AGQuerySolution(bs, this.model);
    }

    public Binding nextBinding() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    public AGQuerySolution nextSolution() {
        return this.next();
    }

    public void remove() {
        try {
            this.result.remove();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }
}

