/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGModel;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ReifiedStatement;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.ReifiedStatementImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;

public class AGStatement
extends StatementImpl {
    public AGStatement(Resource subject, Property predicate, RDFNode object) {
        super(subject, predicate, object);
    }

    public AGStatement(Resource subject, Property predicate, RDFNode object, AGModel model) {
        super(subject, predicate, object, (ModelCom)model);
    }

    public static Statement toStatement(Triple t, AGModel eg) {
        ResourceImpl s = new ResourceImpl(t.getSubject(), (ModelCom)eg);
        PropertyImpl p = new PropertyImpl(t.getPredicate(), (EnhGraph)eg);
        RDFNode o = AGStatement.createObject((Node)t.getObject(), (EnhGraph)eg);
        return new AGStatement((Resource)s, (Property)p, o, eg);
    }

    public AGModel getModel() {
        return (AGModel)super.getModel();
    }

    public ReifiedStatement createReifiedStatement() {
        Resource bnode = this.getModel().createResource();
        return ReifiedStatementImpl.create((EnhGraph)this.getModel(), (Node)bnode.asNode(), (Statement)this);
    }
}

