/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGNodeFactory;
import java.io.Closeable;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.NiceIterator;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;

public class AGTripleIterator
extends NiceIterator<Triple>
implements Closeable {
    private final AGGraph graph;
    private final RepositoryResult<Statement> result;
    private Statement current = null;

    AGTripleIterator(AGGraph graph, RepositoryResult<Statement> result) {
        this.graph = graph;
        this.result = result;
    }

    @Override
    public void close() {
        try {
            this.result.close();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNext() {
        try {
            return this.result.hasNext();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public Triple next() {
        Triple tr;
        try {
            this.current = (Statement)this.result.next();
            tr = AGNodeFactory.asTriple(this.current);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return tr;
    }

    public void remove() {
        if (this.current != null) {
            Triple tr = AGNodeFactory.asTriple(this.current);
            this.graph.delete(tr);
            this.current = null;
        }
    }
}

