/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.pool;

import com.franz.agraph.pool.AGConnConfig;
import com.franz.agraph.pool.AGConnFactory;
import com.franz.agraph.pool.AGConnProp;
import com.franz.agraph.pool.AGPoolConfig;
import com.franz.agraph.pool.AGPoolProp;
import com.franz.agraph.repository.AGRepositoryConnection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGConnPool
implements ObjectPool<AGRepositoryConnection>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AGConnPool.class);
    private final ObjectPool<AGRepositoryConnection> delegate;
    private final Thread shutdownHook;

    private AGConnPool(PooledObjectFactory<AGRepositoryConnection> factory, AGPoolConfig poolConfig) {
        this.delegate = new GenericObjectPool(factory, (GenericObjectPoolConfig)poolConfig);
        if (poolConfig.initialSize > 0) {
            ArrayList<AGRepositoryConnection> conns = new ArrayList<AGRepositoryConnection>(poolConfig.initialSize);
            try {
                for (int i = 0; i < poolConfig.initialSize; ++i) {
                    conns.add(this.borrowObject());
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            for (AGRepositoryConnection conn : conns) {
                conn.close();
            }
        }
        if (poolConfig.shutdownHook) {
            this.shutdownHook = new Thread(this::close);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            this.shutdownHook = null;
        }
        if (poolConfig.getWarmupConfig() != null) {
            AGRepositoryConnection conn = this.borrowObject();
            Object object = null;
            try {
                conn.warmup(poolConfig.getWarmupConfig());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (object != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
    }

    private AGConnPool(AGPoolConfig poolConfig, AGConnConfig connConfig) {
        this(new AGConnFactory(connConfig), poolConfig);
    }

    public static AGConnPool create(PooledObjectFactory<AGRepositoryConnection> factory, AGPoolConfig poolConfig) {
        return new AGConnPool(factory, poolConfig);
    }

    public static AGConnPool create(Map<AGConnProp, String> connProps, Map<AGPoolProp, String> poolProps) throws RepositoryException {
        AGPoolConfig poolConfig = new AGPoolConfig(poolProps);
        AGConnConfig connConfig = new AGConnConfig(connProps);
        return new AGConnPool(poolConfig, connConfig);
    }

    public static AGConnPool create(Object ... keyValuePairs) throws RepositoryException {
        Map<? extends Enum, String> connProps = AGConnPool.toMap(keyValuePairs, EnumSet.allOf(AGConnProp.class));
        Map<? extends Enum, String> poolProps = AGConnPool.toMap(keyValuePairs, EnumSet.allOf(AGPoolProp.class));
        return AGConnPool.create(connProps, poolProps);
    }

    private static Map<? extends Enum, String> toMap(Object[] keyValuePairs, EnumSet<? extends Enum> enumSet) {
        HashMap<Enum, String> map = new HashMap<Enum, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Enum key = (Enum)keyValuePairs[i];
            if (!enumSet.contains(key)) continue;
            Object val = keyValuePairs[i + 1];
            map.put(key, val == null ? null : val.toString());
        }
        return map;
    }

    public void addObject() throws Exception {
        this.delegate.addObject();
    }

    public AGRepositoryConnection borrowObject() throws RepositoryException {
        AGRepositoryConnection conn;
        try {
            conn = (AGRepositoryConnection)this.delegate.borrowObject();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        conn.setPool(this);
        return conn;
    }

    public AGRepositoryConnection borrowConnection() {
        return this.borrowObject();
    }

    public void clear() throws Exception {
        this.delegate.clear();
    }

    public int getNumActive() throws UnsupportedOperationException {
        return this.delegate.getNumActive();
    }

    public int getNumIdle() throws UnsupportedOperationException {
        return this.delegate.getNumIdle();
    }

    public void invalidateObject(AGRepositoryConnection conn) throws Exception {
        this.delegate.invalidateObject((Object)conn);
    }

    public void returnObject(AGRepositoryConnection conn) throws Exception {
        conn.setPool(null);
        this.delegate.returnObject((Object)conn);
    }

    public void ensureIdle(int n) throws Exception {
        if (this.delegate instanceof GenericObjectPool) {
            GenericObjectPool gop = (GenericObjectPool)this.delegate;
            gop.setMinIdle(n);
            if (gop.getMaxIdle() < n) {
                gop.setMaxIdle(n);
            }
        }
        for (int i = 0; i < n; ++i) {
            this.addObject();
        }
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("close " + this);
        }
        this.delegate.close();
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.getNumActive() > 0) {
            this.close();
            log.warn("Finalizing with open connections, please close the pool properly. " + this);
        }
        super.finalize();
    }

    public String toString() {
        return "{AGConnPool active=" + this.getNumActive() + " idle=" + this.getNumIdle() + " delegate=" + this.delegate + " this=" + super.toString() + "}";
    }
}

