/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.pool.AGConnPool;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGValueFactory;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;

public class AGRepository
extends AbstractRepository
implements AGAbstractRepository {
    private final AGCatalog catalog;
    private final String repositoryID;
    private final String catalogPrefixedRepositoryID;
    private final String repositoryURL;
    private final AGValueFactory vf;
    private AGConnPool pool;

    public AGRepository(AGCatalog catalog, String repositoryID) {
        this.catalog = catalog;
        this.repositoryID = repositoryID;
        this.catalogPrefixedRepositoryID = catalog.getCatalogPrefixedRepositoryID(repositoryID);
        this.repositoryURL = catalog.getRepositoryURL(repositoryID);
        this.vf = new AGValueFactory(this);
    }

    @Override
    public AGServer getServer() {
        return this.getCatalog().getServer();
    }

    @Override
    public AGCatalog getCatalog() {
        return this.catalog;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public String getCatalogPrefixedRepositoryID() {
        return this.catalogPrefixedRepositoryID;
    }

    public String getRepositoryURL(boolean includeAuth) {
        if (includeAuth) {
            try {
                URI uri = new URI(this.repositoryURL);
                AGServer server = this.catalog.getServer();
                String user = server.getUser();
                String password = server.getPassword();
                String auth = null;
                if (user != null) {
                    auth = password != null ? user + ":" + password : user;
                }
                return new URI(uri.getScheme(), auth, uri.getHost(), uri.getPort(), uri.getPath(), null, null).toString();
            }
            catch (URISyntaxException e) {
                return this.repositoryURL;
            }
        }
        return this.repositoryURL;
    }

    public String getRepositoryURL() {
        return this.getRepositoryURL(false);
    }

    @Override
    public AGValueFactory getValueFactory() {
        return this.vf;
    }

    public AGHTTPClient getHTTPClient() {
        return this.getCatalog().getHTTPClient();
    }

    protected void initializeInternal() throws RepositoryException {
    }

    @Override
    public AGRepositoryConnection getConnection(ScheduledExecutorService executor) throws RepositoryException {
        if (this.pool != null) {
            return this.pool.borrowObject();
        }
        AGHttpRepoClient repoclient = new AGHttpRepoClient(this, this.getCatalog().getHTTPClient(), this.repositoryURL, null, executor);
        return new AGRepositoryConnection(this, repoclient);
    }

    @Override
    public AGRepositoryConnection getConnection() throws RepositoryException {
        AGRepositoryConnection conn = this.getConnection(this.catalog.getServer().getExecutor());
        conn.setStreamResults(true);
        return conn;
    }

    public boolean isWritable() throws RepositoryException {
        String url = this.getCatalog().getRepositoriesURL();
        TupleQueryResult tqresult = this.getHTTPClient().getTupleQueryResult(url);
        Value writable = null;
        try {
            while (null == writable && tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value uri = bindingSet.getValue("uri");
                if (!uri.stringValue().equals(this.getRepositoryURL())) continue;
                writable = bindingSet.getValue("writable");
            }
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            try {
                tqresult.close();
            }
            catch (QueryEvaluationException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (null == writable) {
            throw new IllegalStateException("Repository not found in catalog's list of repositories: " + this.getRepositoryURL());
        }
        boolean result = Boolean.parseBoolean(writable.stringValue());
        return result;
    }

    @Override
    public String getSpec() {
        return "<" + this.getRepositoryURL(true) + ">";
    }

    public File getDataDir() {
        return null;
    }

    public void setDataDir(File dataDir) {
    }

    protected void shutDownInternal() throws RepositoryException {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    @Override
    public void close() throws RepositoryException {
        this.shutDown();
    }

    public boolean isBulkMode() throws RepositoryException {
        try {
            return Boolean.parseBoolean(this.getHTTPClient().getString(this.repositoryURL + "/bulkMode"));
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void setBulkMode(boolean bulkMode) throws RepositoryException {
        String url = this.repositoryURL + "/bulkMode";
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        try {
            if (bulkMode) {
                this.getHTTPClient().put(url, headers, data, null, null);
            } else {
                this.getHTTPClient().delete(url, headers, data, null);
            }
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public String getDuplicateSuppressionPolicy() throws RepositoryException {
        try {
            return this.getHTTPClient().getString(this.repositoryURL + "/suppressDuplicates");
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void setDuplicateSuppressionPolicy(String policy) throws RepositoryException {
        String url = this.repositoryURL + "/suppressDuplicates";
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new BasicNameValuePair("type", policy)};
        try {
            this.getHTTPClient().put(url, headers, data, null, null);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void setConnPool(AGConnPool pool) {
        this.pool = pool;
    }

    public void forceCheckpoint() throws RepositoryException {
        String url = this.repositoryURL + "/force-checkpoint";
        BasicHeader[] hdr = new BasicHeader[]{};
        NameValuePair[] data = new NameValuePair[]{};
        this.getHTTPClient().post(url, (Header[])hdr, data, null, null);
    }

    public void ensureDBIdle() throws RepositoryException {
        String url = this.repositoryURL + "/ensure-db-idle";
        Header[] hdr = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        this.getHTTPClient().post(url, hdr, data, null, null);
    }
}

