/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.exception.AGMalformedDataException;
import com.franz.agraph.http.handler.AGDownloadHandler;
import com.franz.agraph.http.handler.AGLongHandler;
import com.franz.agraph.http.handler.AGRDFHandler;
import com.franz.agraph.http.handler.AGRawStreamer;
import com.franz.agraph.pool.AGConnPool;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGFormattedNamespace;
import com.franz.agraph.repository.AGFreetextIndexConfig;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGMaterializer;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGQueryLanguage;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGSpinFunction;
import com.franz.agraph.repository.AGSpinMagicProperty;
import com.franz.agraph.repository.AGStreamTupleQuery;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGUpdate;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.agraph.repository.AGVirtualRepository;
import com.franz.agraph.repository.AGXAResource;
import com.franz.agraph.repository.WarmupConfig;
import com.franz.agraph.repository.repl.TransactionSettings;
import com.franz.util.Ctx;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.codec.DecoderException;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.io.GZipUtil;
import org.eclipse.rdf4j.common.io.ZipUtil;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.impl.StatementImpl;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.repository.base.AbstractRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AGRepositoryConnection
extends AbstractRepositoryConnection
implements RepositoryConnection,
AutoCloseable {
    public static final String PROP_STREAM_RESULTS = "com.franz.agraph.repository.AGRepositoryConnection.streamResults";
    public static final String PROP_USE_ADD_STATEMENT_BUFFER = "com.franz.agraph.repository.AGRepositoryConnection.useAddStatementBuffer";
    public static final String PROP_ADD_STATEMENT_BUFFER_MAX_SIZE = "com.franz.agraph.repository.AGRepositoryConnection.addStatementBufferMaxSize";
    public static final int DEFAULT_ADD_STATEMENT_BUFFER_SIZE = 10000;
    private final AGAbstractRepository repository;
    private final AGHttpRepoClient repoclient;
    private final AGValueFactory vf;
    private final List<JSONArray> addStatementBuffer;
    private boolean streamResults;
    private AGConnPool pool;
    private boolean addStatementBufferEnabled;
    private int addStatementBufferMaxSize;
    long cachedStoreID = -1L;

    public AGRepositoryConnection(AGRepository repository, AGHttpRepoClient client) {
        this(repository, client, repository);
    }

    public AGRepositoryConnection(AGVirtualRepository repository, AGHttpRepoClient client) {
        this(repository, client, repository.wrapped);
    }

    private AGRepositoryConnection(AGAbstractRepository repository, AGHttpRepoClient client, AGRepository realRepo) {
        super((Repository)repository);
        this.repository = repository;
        this.repoclient = client;
        this.setStreamResults(Boolean.parseBoolean(System.getProperty(PROP_STREAM_RESULTS)));
        this.vf = new AGValueFactory(realRepo, this);
        this.addStatementBufferEnabled = Boolean.parseBoolean(System.getProperty(PROP_USE_ADD_STATEMENT_BUFFER));
        this.addStatementBufferMaxSize = Integer.parseInt(System.getProperty(PROP_ADD_STATEMENT_BUFFER_MAX_SIZE, "10000"));
        this.addStatementBuffer = new ArrayList<JSONArray>();
    }

    public String toString() {
        return "{" + super.toString() + " " + this.getHttpRepoClientInternal() + "}";
    }

    public AGAbstractRepository getRepository() {
        return this.repository;
    }

    public AGServer getServer() {
        return this.getRepository().getCatalog().getServer();
    }

    public AGHttpRepoClient prepareHttpRepoClient() {
        return this.getHttpRepoClientHandlingBuffer(true);
    }

    private AGHttpRepoClient getHttpRepoClientInternal() {
        return this.getHttpRepoClientHandlingBuffer(false);
    }

    private AGHttpRepoClient getHttpRepoClientHandlingBuffer(boolean handleBuffer) {
        if (handleBuffer && this.addStatementBufferEnabled) {
            this.forwardBufferedAddStatements();
        }
        return this.repoclient;
    }

    public boolean isAddStatementBufferEnabled() {
        return this.addStatementBufferEnabled;
    }

    public void setAddStatementBufferEnabled(boolean enabled) {
        this.addStatementBufferEnabled = enabled;
        if (!this.addStatementBufferEnabled) {
            this.forwardBufferedAddStatements();
        }
    }

    public boolean isUseAddStatementBuffer() {
        return this.addStatementBufferEnabled && !this.getHttpRepoClientInternal().isAutoCommit();
    }

    private void bufferAddStatement(JSONArray rows) {
        this.addStatementBuffer.add(rows);
        if (this.addStatementBuffer.size() >= this.addStatementBufferMaxSize) {
            this.forwardBufferedAddStatements();
        }
    }

    public int getAddStatementBufferMaxSize() {
        return this.addStatementBufferMaxSize;
    }

    public void setAddStatementBufferMaxSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Buffer maxSize must be positive integer");
        }
        this.addStatementBufferMaxSize = size;
        if (this.addStatementBuffer.size() >= this.addStatementBufferMaxSize) {
            this.forwardBufferedAddStatements();
        }
    }

    private void forwardBufferedAddStatements() throws RepositoryException {
        if (!this.addStatementBuffer.isEmpty()) {
            JSONArray totalArray = new JSONArray();
            for (JSONArray addStmtJson : this.addStatementBuffer) {
                this.append(totalArray, addStmtJson);
            }
            try {
                this.getHttpRepoClientInternal().uploadJSON(totalArray, new Resource[0]);
            }
            catch (AGHttpException e) {
                throw new RepositoryException((Throwable)((Object)e));
            }
            finally {
                this.addStatementBuffer.clear();
            }
        }
    }

    public int getNumBufferedAddStatements() {
        return this.addStatementBuffer.size();
    }

    public AGValueFactory getValueFactory() {
        return this.vf;
    }

    protected void addWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        StatementImpl st = new StatementImpl(subject, (URI)predicate, object);
        JSONArray rows = this.encodeJSON((Statement)st, null, contexts);
        if (this.isUseAddStatementBuffer()) {
            this.bufferAddStatement(rows);
        } else {
            try {
                this.prepareHttpRepoClient().uploadJSON(rows, new Resource[0]);
            }
            catch (AGHttpException e) {
                throw new RepositoryException((Throwable)((Object)e));
            }
        }
    }

    protected void addWithoutCommit(Resource subject, IRI predicate, Value object, JSONObject attributes, Resource ... contexts) throws RepositoryException {
        StatementImpl st = new StatementImpl(subject, (URI)predicate, object);
        JSONArray rows = this.encodeJSON((Statement)st, attributes, contexts);
        if (this.isUseAddStatementBuffer()) {
            this.bufferAddStatement(rows);
        } else {
            try {
                this.prepareHttpRepoClient().uploadJSON(rows, new Resource[0]);
            }
            catch (AGHttpException e) {
                throw new RepositoryException((Throwable)((Object)e));
            }
        }
    }

    protected void removeWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.prepareHttpRepoClient().deleteStatements(subject, predicate, object, contexts);
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        for (Statement statement : statements) {
            JSONArray rows_st = this.encodeJSON(statement, null, contexts);
            this.append(rows, rows_st);
        }
        try {
            this.prepareHttpRepoClient().uploadJSON(rows, contexts);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void add(Iterable<? extends Statement> statements, JSONObject attributes, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        for (Statement statement : statements) {
            JSONArray rows_st = this.encodeJSON(statement, attributes, contexts);
            this.append(rows, rows_st);
        }
        try {
            this.prepareHttpRepoClient().uploadJSON(rows, contexts);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    private void append(JSONArray rows, JSONArray rowsSt) {
        for (int i = 0; i < rowsSt.length(); ++i) {
            try {
                rows.put(rowsSt.get(i));
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        while (statementIter.hasNext()) {
            this.append(rows, this.encodeJSON((Statement)statementIter.next(), null, contexts));
        }
        try {
            this.prepareHttpRepoClient().uploadJSON(rows, new Resource[0]);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, JSONObject attributes, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        while (statementIter.hasNext()) {
            this.append(rows, this.encodeJSON((Statement)statementIter.next(), attributes, contexts));
        }
        try {
            this.prepareHttpRepoClient().uploadJSON(rows, new Resource[0]);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    private JSONArray encodeJSON(Statement st, JSONObject attributes, Resource ... contexts) {
        JSONArray rows = new JSONArray();
        String attrs = null;
        if (attributes != null) {
            attrs = attributes.toString();
        }
        if (contexts.length == 0) {
            JSONArray row = new JSONArray().put((Object)this.encodeValueForStorageJSON((Value)st.getSubject())).put((Object)this.encodeValueForStorageJSON((Value)st.getPredicate())).put((Object)this.encodeValueForStorageJSON(st.getObject()));
            if (st.getContext() != null) {
                row.put((Object)this.encodeValueForStorageJSON((Value)st.getContext()));
            } else {
                row.put(null);
            }
            if (attrs != null) {
                row.put((Object)attrs);
            }
            rows.put((Object)row);
        } else {
            for (Resource c : contexts) {
                JSONArray row = new JSONArray().put((Object)this.encodeValueForStorageJSON((Value)st.getSubject())).put((Object)this.encodeValueForStorageJSON((Value)st.getPredicate())).put((Object)this.encodeValueForStorageJSON(st.getObject()));
                if (c != null) {
                    row.put((Object)this.encodeValueForStorageJSON((Value)c));
                } else {
                    row.put(null);
                }
                if (attrs != null) {
                    row.put((Object)attrs);
                }
                rows.put((Object)row);
            }
        }
        return rows;
    }

    private String encodeValueForStorageJSON(Value v) {
        Value storableValue = AGHttpRepoClient.getStorableValue(v, this.vf, this.getHttpRepoClientInternal().getAllowExternalBlankNodeIds());
        return NTriplesUtil.toNTriplesString((Value)storableValue);
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(file, baseURI, dataFormat, (JSONObject)null, contexts);
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = file.toURI().toString();
        }
        if (dataFormat == null) {
            dataFormat = Rio.getParserFormatForFileName((String)file.getName()).orElse(null);
        }
        try (FileInputStream in = new FileInputStream(file);){
            this.add((InputStream)in, baseURI, dataFormat, file.length(), attributes, contexts);
        }
    }

    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(url, baseURI, dataFormat, (JSONObject)null, contexts);
    }

    public void add(URL url, String baseURI, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        URLConnection con = url.openConnection();
        if (dataFormat != null) {
            for (String mimeType : dataFormat.getMIMETypes()) {
                con.addRequestProperty("Accept", mimeType);
            }
        } else {
            Set rdfFormats = RDFParserRegistry.getInstance().getKeys();
            List acceptParams = RDFFormat.getAcceptParams((Iterable)rdfFormats, (boolean)true, null);
            for (String acceptParam : acceptParams) {
                con.addRequestProperty("Accept", acceptParam);
            }
        }
        if (dataFormat == null) {
            String mimeType = con.getContentType();
            int semiColonIdx = mimeType.indexOf(59);
            if (semiColonIdx >= 0) {
                mimeType = mimeType.substring(0, semiColonIdx);
            }
            if ((dataFormat = (RDFFormat)Rio.getParserFormatForMIMEType((String)mimeType).orElse(null)) == null) {
                dataFormat = Rio.getParserFormatForFileName((String)url.getPath()).orElse(null);
            }
        }
        try (InputStream in = con.getInputStream();){
            this.add(in, baseURI, dataFormat, attributes, contexts);
        }
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(in, baseURI, dataFormat, (JSONObject)null, contexts);
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(in, baseURI, dataFormat, -1L, attributes, contexts);
    }

    private void add(InputStream in, String baseURI, RDFFormat dataFormat, long size, JSONObject attributes, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, 1024);
        }
        if (ZipUtil.isZipStream((InputStream)in)) {
            this.addZip(in, baseURI, dataFormat, contexts);
        } else {
            this.prepareHttpRepoClient().upload(in, baseURI, dataFormat, false, size, GZipUtil.isGZipStream((InputStream)in) ? "gzip" : null, attributes, contexts);
        }
    }

    private void addZip(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        boolean autoCommit = !this.isActive();
        this.begin();
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    RDFFormat format = Rio.getParserFormatForFileName((String)entry.getName()).orElse(dataFormat);
                    try {
                        FilterInputStream wrapper = new FilterInputStream(zipIn){

                            @Override
                            public void close() {
                            }
                        };
                        this.add((InputStream)wrapper, baseURI, format, contexts);
                    }
                    catch (RDFParseException e) {
                        if (autoCommit) {
                            this.rollback();
                        }
                        String msg = e.getMessage() + " in " + entry.getName();
                        RDFParseException pe = new RDFParseException(msg, e.getLineNumber(), e.getColumnNumber());
                        pe.initCause((Throwable)e);
                        throw pe;
                    }
                    finally {
                        zipIn.closeEntry();
                    }
                }
                entry = zipIn.getNextEntry();
            }
        }
        catch (IOException | RepositoryException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        finally {
            if (autoCommit) {
                this.commit();
            }
        }
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(reader, baseURI, dataFormat, (JSONObject)null, contexts);
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        try {
            this.prepareHttpRepoClient().upload(reader, baseURI, dataFormat, false, attributes, contexts);
        }
        catch (AGMalformedDataException e) {
            throw new RDFParseException((Throwable)((Object)e));
        }
    }

    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.addWithoutCommit(subject, predicate, object, contexts);
    }

    public void add(Resource subject, IRI predicate, Value object, JSONObject attributes, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.addWithoutCommit(subject, predicate, object, attributes, contexts);
    }

    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.removeWithoutCommit(subject, predicate, object, contexts);
    }

    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.removeWithoutCommit(st, contexts);
    }

    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.addWithoutCommit(st, contexts);
    }

    public void add(Statement st, JSONObject attributes, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.addWithoutCommit(st, attributes, contexts);
    }

    protected void addWithoutCommit(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.addWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
    }

    protected void addWithoutCommit(Statement st, JSONObject attributes, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.addWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), attributes, contexts);
    }

    protected void removeWithoutCommit(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.removeWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        for (Statement statement : statements) {
            this.append(rows, this.encodeJSON(statement, null, contexts));
        }
        this.prepareHttpRepoClient().deleteJSON(rows, new Resource[0]);
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        while (statements.hasNext()) {
            this.append(rows, this.encodeJSON((Statement)statements.next(), null, contexts));
        }
        this.prepareHttpRepoClient().deleteJSON(rows, new Resource[0]);
    }

    public boolean isAutoCommit() throws RepositoryException {
        return this.prepareHttpRepoClient().isAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        this.prepareHttpRepoClient().setAutoCommit(autoCommit);
    }

    public XAResource getXAResource() {
        return new AGXAResource(this);
    }

    public void prepareCommit(Xid xid) {
        this.prepareHttpRepoClient().commit(AGHttpRepoClient.CommitPhase.PREPARE, xid);
    }

    public void commit() throws RepositoryException {
        this.prepareHttpRepoClient().commit();
    }

    public void commit(Xid xid) {
        this.prepareHttpRepoClient().commit(AGHttpRepoClient.CommitPhase.COMMIT, xid);
    }

    public void commit(TransactionSettings transactionSettings) throws RepositoryException {
        try (Ctx ignored = this.transactionSettingsCtx(transactionSettings);){
            this.prepareHttpRepoClient().commit();
        }
    }

    public void rollback() throws RepositoryException {
        this.prepareHttpRepoClient().rollback();
    }

    public void rollback(Xid xid) {
        this.prepareHttpRepoClient().rollback(xid);
    }

    public Xid[] getPreparedTransactions() throws DecoderException {
        return this.prepareHttpRepoClient().getPreparedTransactions();
    }

    public boolean isStreamResults() {
        return this.streamResults;
    }

    public void setStreamResults(boolean streamResults) {
        this.streamResults = streamResults;
    }

    public void clearNamespaces() throws RepositoryException {
        this.prepareHttpRepoClient().clearNamespaces();
    }

    @Override
    public void close() throws RepositoryException {
        if (this.pool != null) {
            try {
                this.pool.returnObject(this);
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        } else if (this.isOpen()) {
            this.prepareHttpRepoClient().close();
            super.close();
        }
    }

    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, RepositoryException {
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), handler, contexts);
    }

    public void exportStatements(RDFHandler handler, String ... ids) throws RDFHandlerException, RepositoryException {
        this.prepareHttpRepoClient().getStatements(handler, ids);
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            ArrayList<Resource> contextList = new ArrayList<Resource>();
            try (TupleQueryResult contextIDs = this.prepareHttpRepoClient().getContextIDs();){
                while (contextIDs.hasNext()) {
                    BindingSet bindingSet = (BindingSet)contextIDs.next();
                    Value context = bindingSet.getValue("contextID");
                    if (!(context instanceof Resource)) continue;
                    contextList.add((Resource)context);
                }
            }
            return this.createRepositoryResult(contextList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> elements) {
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(elements.iterator()));
    }

    public String getNamespace(String prefix) throws RepositoryException {
        return this.prepareHttpRepoClient().getNamespace(prefix);
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            ArrayList<SimpleNamespace> namespaceList = new ArrayList<SimpleNamespace>();
            try (TupleQueryResult namespaces = this.prepareHttpRepoClient().getNamespaces();){
                while (namespaces.hasNext()) {
                    BindingSet bindingSet = (BindingSet)namespaces.next();
                    Value prefix = bindingSet.getValue("prefix");
                    Value namespace = bindingSet.getValue("namespace");
                    if (!(prefix instanceof Literal) || !(namespace instanceof Literal)) continue;
                    String prefixStr = ((Literal)prefix).getLabel();
                    String namespaceStr = ((Literal)namespace).getLabel();
                    namespaceList.add(new SimpleNamespace(prefixStr, namespaceStr));
                }
            }
            return this.createRepositoryResult(namespaceList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getQueryOption(String name) throws RepositoryException {
        return this.prepareHttpRepoClient().getQueryOption(name);
    }

    public Map<String, String> getQueryOptions() throws RepositoryException {
        try {
            HashMap<String, String> queryOptionMap = new HashMap<String, String>();
            try (TupleQueryResult queryOptions = this.prepareHttpRepoClient().getQueryOptions();){
                while (queryOptions.hasNext()) {
                    BindingSet bindingSet = (BindingSet)queryOptions.next();
                    Value name = bindingSet.getValue("name");
                    Value value = bindingSet.getValue("value");
                    if (!(name instanceof Literal) || !(value instanceof Literal)) continue;
                    queryOptionMap.put(((Literal)name).getLabel(), ((Literal)value).getLabel());
                }
            }
            return queryOptionMap;
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements(subj, pred, obj, includeInferred, (RDFHandler)collector, contexts);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        AGHttpRepoClient client = this.prepareHttpRepoClient();
        AGLongHandler handler = new AGLongHandler();
        client.getStatementsCountLimit(1, subj, pred, obj, Boolean.toString(includeInferred), handler, contexts);
        return handler.getResult() > 0L;
    }

    public void downloadStatements(File file, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), new AGDownloadHandler(file), contexts);
    }

    public void downloadStatements(String file, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), new AGDownloadHandler(file), contexts);
    }

    public void downloadStatements(File file, RDFFormat format, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), new AGDownloadHandler(file, format), contexts);
    }

    public void downloadStatements(String file, RDFFormat format, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), new AGDownloadHandler(file, format), contexts);
    }

    public void downloadStatements(File file, String mimeType, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), new AGDownloadHandler(file, mimeType), contexts);
    }

    public void downloadStatements(String file, String mimeType, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), new AGDownloadHandler(file, mimeType), contexts);
    }

    public InputStream streamStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        AGRawStreamer handler = new AGRawStreamer();
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), handler, contexts);
        return handler.getStream();
    }

    public InputStream streamStatements(String mimeType, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        AGRawStreamer handler = new AGRawStreamer(mimeType);
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), handler, contexts);
        return handler.getStream();
    }

    public InputStream streamStatements(RDFFormat format, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws AGHttpException {
        AGRawStreamer handler = new AGRawStreamer(format);
        this.prepareHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), handler, contexts);
        return handler.getStream();
    }

    public RepositoryResult<Statement> getStatements(String ... ids) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements((RDFHandler)collector, ids);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void downloadStatements(File file, RDFFormat format, String ids) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(new AGDownloadHandler(file, format), ids);
    }

    public void downloadStatements(String file, RDFFormat format, String ids) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(new AGDownloadHandler(file, format), ids);
    }

    public void downloadStatements(File file, String mimeType, String ids) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(new AGDownloadHandler(file, mimeType), ids);
    }

    public void downloadStatements(String file, String mimeType, String ids) throws AGHttpException {
        this.prepareHttpRepoClient().getStatements(new AGDownloadHandler(file, mimeType), ids);
    }

    public InputStream streamStatements(RDFFormat format, String ... ids) throws AGHttpException {
        AGRawStreamer handler = new AGRawStreamer(format);
        this.prepareHttpRepoClient().getStatements(handler, ids);
        return handler.getStream();
    }

    public InputStream streamStatements(String mimeType, String ... ids) throws AGHttpException {
        AGRawStreamer handler = new AGRawStreamer(mimeType);
        this.prepareHttpRepoClient().getStatements(handler, ids);
        return handler.getStream();
    }

    public AGQuery prepareQuery(QueryLanguage ql, String queryString, String baseURI) {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            String strippedQuery = this.stripSparqlQueryString(queryString).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, queryString, baseURI);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, queryString, baseURI);
            }
            if (strippedQuery.startsWith("CONSTRUCT") || strippedQuery.startsWith("DESCRIBE")) {
                return this.prepareGraphQuery(ql, queryString, baseURI);
            }
            throw new IllegalArgumentException("Unable to determine a query type (Tuple, Graph, Boolean) for the query:\n" + queryString);
        }
        if (AGQueryLanguage.PROLOG.equals(ql)) {
            return this.prepareTupleQuery(ql, queryString, baseURI);
        }
        throw new UnsupportedOperationException("Operation not supported for query language " + ql);
    }

    private String stripSparqlQueryString(String queryString) {
        String normalizedQuery = queryString;
        Pattern pattern = Pattern.compile("prefix[^:]+:\\s*<[^>]*>\\s*", 2);
        Matcher matcher = pattern.matcher(queryString);
        int startIndexCorrection = 0;
        while (matcher.find()) {
            normalizedQuery = normalizedQuery.substring(matcher.end() - startIndexCorrection, normalizedQuery.length());
            startIndexCorrection += matcher.end() - startIndexCorrection;
        }
        pattern = Pattern.compile("base\\s+<[^>]*>\\s*", 2);
        matcher = pattern.matcher(normalizedQuery);
        if (matcher.find()) {
            normalizedQuery = normalizedQuery.substring(matcher.end(), normalizedQuery.length());
        }
        pattern = Pattern.compile("\\s*#.*", 2);
        matcher = pattern.matcher(normalizedQuery);
        normalizedQuery = matcher.replaceAll("");
        return normalizedQuery.trim();
    }

    public AGTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString) {
        return this.prepareTupleQuery(ql, queryString, null);
    }

    public AGTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGTupleQuery q = new AGTupleQuery(this, ql, queryString, baseURI);
        q.prepare();
        if (this.streamResults) {
            q = new AGStreamTupleQuery(q);
        }
        return q;
    }

    public AGGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString) {
        return this.prepareGraphQuery(ql, queryString, null);
    }

    public AGGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGGraphQuery q = new AGGraphQuery(this, ql, queryString, baseURI);
        q.prepare();
        return q;
    }

    public AGBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString) {
        return this.prepareBooleanQuery(ql, queryString, null);
    }

    public AGBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGBooleanQuery q = new AGBooleanQuery(this, ql, queryString, baseURI);
        q.prepare();
        return q;
    }

    public AGUpdate prepareUpdate(QueryLanguage ql, String queryString, String baseURI) {
        AGUpdate u = new AGUpdate(this, ql, queryString, baseURI);
        u.prepare();
        return u;
    }

    public AGUpdate prepareUpdate(QueryLanguage ql, String queryString) {
        AGUpdate u = new AGUpdate(this, ql, queryString, null);
        u.prepare();
        return u;
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        this.prepareHttpRepoClient().removeNamespacePrefix(prefix);
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.prepareHttpRepoClient().setNamespacePrefix(prefix, name);
    }

    public void removeQueryOption(String name) throws RepositoryException {
        this.prepareHttpRepoClient().removeQueryOption(name);
    }

    public void setQueryOption(String name, String value) throws RepositoryException {
        this.prepareHttpRepoClient().setQueryOption(name, value);
    }

    public long size(Resource ... contexts) throws RepositoryException {
        return this.prepareHttpRepoClient().size(contexts);
    }

    public void createFreetextIndex(String indexName, AGFreetextIndexConfig config) throws RepositoryException {
        ArrayList<String> predicates = new ArrayList<String>();
        for (IRI uri : config.getPredicates()) {
            predicates.add(NTriplesUtil.toNTriplesString((IRI)uri));
        }
        this.prepareHttpRepoClient().createFreetextIndex(indexName, predicates, config.getIndexLiterals(), config.getIndexLiteralTypes(), config.getIndexResources(), config.getIndexFields(), config.getMinimumWordSize(), config.getStopWords(), config.getWordFilters(), config.getInnerChars(), config.getBorderChars(), config.getTokenizer());
    }

    public void deleteFreetextIndex(String indexName) throws RepositoryException {
        this.prepareHttpRepoClient().deleteFreetextIndex(indexName);
    }

    public void createFreetextIndex(String name, IRI[] predicates) throws RepositoryException {
        AGFreetextIndexConfig config = AGFreetextIndexConfig.newInstance();
        config.getPredicates().addAll(Arrays.asList(predicates));
        this.createFreetextIndex(name, config);
    }

    public String[] getFreetextPredicates(String index) throws RepositoryException {
        return this.prepareHttpRepoClient().getFreetextPredicates(index);
    }

    public AGFreetextIndexConfig getFreetextIndexConfig(String indexName) throws RepositoryException, JSONException {
        return new AGFreetextIndexConfig(this.prepareHttpRepoClient().getFreetextIndexConfiguration(indexName));
    }

    public String[] getFreetextIndices() throws RepositoryException {
        return this.prepareHttpRepoClient().getFreetextIndices();
    }

    public List<String> listFreetextIndices() throws RepositoryException {
        return this.prepareHttpRepoClient().listFreetextIndices();
    }

    public void registerPredicateMapping(IRI predicate, IRI primtype) throws RepositoryException {
        this.prepareHttpRepoClient().registerPredicateMapping(predicate, primtype);
    }

    public void deletePredicateMapping(IRI predicate) throws RepositoryException {
        this.prepareHttpRepoClient().deletePredicateMapping(predicate);
    }

    public String[] getPredicateMappings() throws RepositoryException {
        return this.prepareHttpRepoClient().getPredicateMappings();
    }

    public void registerDatatypeMapping(IRI datatype, IRI primtype) throws RepositoryException {
        this.prepareHttpRepoClient().registerDatatypeMapping(datatype, primtype);
    }

    public void deleteDatatypeMapping(IRI datatype) throws RepositoryException {
        this.prepareHttpRepoClient().deleteDatatypeMapping(datatype);
    }

    public String[] getDatatypeMappings() throws RepositoryException {
        return this.prepareHttpRepoClient().getDatatypeMappings();
    }

    public void clearMappings() throws RepositoryException {
        this.prepareHttpRepoClient().clearMappings();
    }

    public void clearMappings(boolean includeAutoEncodedPrimitiveTypes) throws RepositoryException {
        this.prepareHttpRepoClient().clearMappings(includeAutoEncodedPrimitiveTypes);
    }

    public void clearAttributes() throws RepositoryException {
        try {
            JSONArray attributes = this.getAttributeDefinitions();
            for (int i = 0; i < attributes.length(); ++i) {
                JSONObject attribute = attributes.getJSONObject(i);
                this.deleteAttributeDefinition(attribute.getString("name"));
            }
        }
        catch (JSONException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void addRules(String rules) throws RepositoryException {
        this.prepareHttpRepoClient().addRules(rules);
    }

    public void addRules(InputStream rulestream) throws RepositoryException {
        this.prepareHttpRepoClient().addRules(rulestream);
    }

    public String evalInServer(String lispForm) throws RepositoryException {
        return this.prepareHttpRepoClient().evalInServer(lispForm);
    }

    public String evalInServer(InputStream stream) throws RepositoryException {
        return this.prepareHttpRepoClient().evalInServer(stream);
    }

    public void load(IRI source, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws RepositoryException {
        this.prepareHttpRepoClient().load(source, baseURI, dataFormat, contexts);
    }

    public void load(IRI source, String baseURI, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws RepositoryException {
        this.prepareHttpRepoClient().load(source, baseURI, dataFormat, attributes, contexts);
    }

    public void load(String absoluteServerPath, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws RepositoryException {
        this.prepareHttpRepoClient().load(absoluteServerPath, baseURI, dataFormat, contexts);
    }

    public void load(String absoluteServerPath, String baseURI, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws RepositoryException {
        this.prepareHttpRepoClient().load(absoluteServerPath, baseURI, dataFormat, attributes, contexts);
    }

    public void ping() throws RepositoryException {
        this.prepareHttpRepoClient().ping();
    }

    public String[] getGeoTypes() throws RepositoryException {
        return this.prepareHttpRepoClient().getGeoTypes();
    }

    public IRI registerCartesianType(float stripWidth, float xmin, float xmax, float ymin, float ymax) throws RepositoryException {
        String nTriplesURI = this.prepareHttpRepoClient().registerCartesianType(stripWidth, xmin, xmax, ymin, ymax);
        return NTriplesUtil.parseURI((String)nTriplesURI, (ValueFactory)this.getValueFactory());
    }

    public IRI registerSphericalType(float stripWidth, String unit, float latmin, float lonmin, float latmax, float lonmax) throws RepositoryException {
        String nTriplesURI = this.prepareHttpRepoClient().registerSphericalType(stripWidth, unit, latmin, lonmin, latmax, lonmax);
        return NTriplesUtil.parseURI((String)nTriplesURI, (ValueFactory)this.getValueFactory());
    }

    public IRI registerSphericalType(float stripWidth, String unit) throws RepositoryException {
        return this.registerSphericalType(stripWidth, unit, -90.0f, -180.0f, 90.0f, 180.0f);
    }

    public void registerPolygon(IRI polygon, List<Literal> points) throws RepositoryException {
        ArrayList<String> nTriplesPoints = new ArrayList<String>(points.size());
        for (Literal point : points) {
            nTriplesPoints.add(NTriplesUtil.toNTriplesString((Literal)point));
        }
        this.prepareHttpRepoClient().registerPolygon(NTriplesUtil.toNTriplesString((IRI)polygon), nTriplesPoints);
    }

    public RepositoryResult<Statement> getStatementsInBox(IRI type, IRI predicate, float xmin, float xmax, float ymin, float ymax, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGRDFHandler handler = new AGRDFHandler(this.prepareHttpRepoClient().getPreferredRDFFormat(), (RDFHandler)collector, this.getValueFactory(), this.prepareHttpRepoClient().getAllowExternalBlankNodeIds());
        this.prepareHttpRepoClient().getGeoBox(NTriplesUtil.toNTriplesString((IRI)type), NTriplesUtil.toNTriplesString((IRI)predicate), xmin, xmax, ymin, ymax, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getStatementsInCircle(IRI type, IRI predicate, float x, float y, float radius, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGRDFHandler handler = new AGRDFHandler(this.prepareHttpRepoClient().getPreferredRDFFormat(), (RDFHandler)collector, this.getValueFactory(), this.prepareHttpRepoClient().getAllowExternalBlankNodeIds());
        this.prepareHttpRepoClient().getGeoCircle(NTriplesUtil.toNTriplesString((IRI)type), NTriplesUtil.toNTriplesString((IRI)predicate), x, y, radius, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getGeoHaversine(IRI type, IRI predicate, float lat, float lon, float radius, String unit, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGRDFHandler handler = new AGRDFHandler(this.prepareHttpRepoClient().getPreferredRDFFormat(), (RDFHandler)collector, this.getValueFactory(), this.prepareHttpRepoClient().getAllowExternalBlankNodeIds());
        this.prepareHttpRepoClient().getGeoHaversine(NTriplesUtil.toNTriplesString((IRI)type), NTriplesUtil.toNTriplesString((IRI)predicate), lat, lon, radius, unit, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getStatementsInPolygon(IRI type, IRI predicate, IRI polygon, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGRDFHandler handler = new AGRDFHandler(this.prepareHttpRepoClient().getPreferredRDFFormat(), (RDFHandler)collector, this.getValueFactory(), this.prepareHttpRepoClient().getAllowExternalBlankNodeIds());
        this.prepareHttpRepoClient().getGeoPolygon(NTriplesUtil.toNTriplesString((IRI)type), NTriplesUtil.toNTriplesString((IRI)predicate), NTriplesUtil.toNTriplesString((IRI)polygon), limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public void registerSNAGenerator(String generator, List<IRI> objectOfs, List<IRI> subjectOfs, List<IRI> undirecteds, String query) throws RepositoryException {
        ArrayList<String> objOfs = new ArrayList<String>();
        if (objectOfs != null) {
            for (IRI objectOf : objectOfs) {
                objOfs.add(NTriplesUtil.toNTriplesString((IRI)objectOf));
            }
        }
        ArrayList<String> subjOfs = new ArrayList<String>();
        if (subjectOfs != null) {
            for (IRI subjectOf : subjectOfs) {
                subjOfs.add(NTriplesUtil.toNTriplesString((IRI)subjectOf));
            }
        }
        ArrayList<String> undirs = new ArrayList<String>();
        if (undirecteds != null) {
            for (IRI undirected : undirecteds) {
                undirs.add(NTriplesUtil.toNTriplesString((IRI)undirected));
            }
        }
        this.prepareHttpRepoClient().registerSNAGenerator(generator, objOfs, subjOfs, undirs, query);
    }

    public void registerSNANeighborMatrix(String matrix, String generator, List<IRI> group, int depth) throws RepositoryException {
        if (group == null || group.size() == 0) {
            throw new IllegalArgumentException("group must be non-empty.");
        }
        ArrayList<String> grp = new ArrayList<String>(3);
        for (IRI node : group) {
            grp.add(NTriplesUtil.toNTriplesString((IRI)node));
        }
        this.prepareHttpRepoClient().registerSNANeighborMatrix(matrix, generator, grp, depth);
    }

    public List<String> listIndices() throws RDF4JException {
        return this.prepareHttpRepoClient().listIndices(false);
    }

    public List<String> listValidIndices() throws RDF4JException {
        return this.prepareHttpRepoClient().listIndices(true);
    }

    public void addIndex(String type) throws RepositoryException {
        this.prepareHttpRepoClient().addIndex(type);
    }

    public void dropIndex(String type) throws RepositoryException {
        this.prepareHttpRepoClient().dropIndex(type);
    }

    public void sendRDFTransaction(InputStream rdftransaction) throws RepositoryException, RDFParseException, IOException {
        try {
            this.prepareHttpRepoClient().sendRDFTransaction(rdftransaction);
        }
        catch (AGMalformedDataException e) {
            throw new RDFParseException((Throwable)((Object)e));
        }
    }

    public void sendRDFTransaction(InputStream rdftransaction, JSONObject attributes) throws RepositoryException, RDFParseException, IOException {
        try {
            this.prepareHttpRepoClient().sendRDFTransaction(rdftransaction, attributes);
        }
        catch (AGMalformedDataException e) {
            throw new RDFParseException((Throwable)((Object)e));
        }
    }

    public void registerEncodableNamespace(String namespace, String format) throws RepositoryException {
        this.prepareHttpRepoClient().registerEncodableNamespace(namespace, format);
    }

    public void registerEncodableNamespaces(Iterable<? extends AGFormattedNamespace> formattedNamespaces) throws RepositoryException {
        JSONArray rows = new JSONArray();
        for (AGFormattedNamespace aGFormattedNamespace : formattedNamespaces) {
            JSONObject row = new JSONObject();
            try {
                row.put("prefix", (Object)aGFormattedNamespace.getNamespace());
                row.put("format", (Object)aGFormattedNamespace.getFormat());
            }
            catch (JSONException e) {
                throw new RepositoryException((Throwable)e);
            }
            rows.put((Object)row);
        }
        this.prepareHttpRepoClient().registerEncodableNamespaces(rows);
    }

    public List<AGFormattedNamespace> listEncodableNamespaces() throws RDF4JException {
        ArrayList<AGFormattedNamespace> result = new ArrayList<AGFormattedNamespace>();
        try (TupleQueryResult tqresult = this.prepareHttpRepoClient().getEncodableNamespaces();){
            while (tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value prefix = bindingSet.getValue("prefix");
                Value format = bindingSet.getValue("format");
                result.add(new AGFormattedNamespace(prefix.stringValue(), format.stringValue()));
            }
        }
        return result;
    }

    public void unregisterEncodableNamespace(String namespace) throws RepositoryException {
        this.prepareHttpRepoClient().unregisterEncodableNamespace(namespace);
    }

    public Object callStoredProc(String functionName, String moduleName, Object ... args) throws RepositoryException {
        return this.prepareHttpRepoClient().callStoredProc(functionName, moduleName, args);
    }

    public int getSessionLifetime() {
        return this.prepareHttpRepoClient().getSessionLifetime();
    }

    public void setSessionLifetime(int lifetimeInSeconds) {
        this.prepareHttpRepoClient().setSessionLifetime(lifetimeInSeconds);
    }

    public void setSessionLoadInitFile(boolean loadInitFile) {
        this.prepareHttpRepoClient().setSessionLoadInitFile(loadInitFile);
    }

    public void addSessionLoadScript(String scriptName) {
        this.prepareHttpRepoClient().addSessionLoadScript(scriptName);
    }

    public long getStoreID() throws RepositoryException {
        if (this.cachedStoreID == -1L) {
            this.cachedStoreID = this.prepareHttpRepoClient().getStoreID();
        }
        return this.cachedStoreID;
    }

    public void enableTripleCache(long size) throws RepositoryException {
        this.prepareHttpRepoClient().enableTripleCache(size);
    }

    public long getTripleCacheSize() throws RepositoryException {
        return this.prepareHttpRepoClient().getTripleCacheSize();
    }

    public void disableTripleCache() throws RepositoryException {
        this.prepareHttpRepoClient().disableTripleCache();
    }

    public int getUploadCommitPeriod() throws RepositoryException {
        return this.prepareHttpRepoClient().getUploadCommitPeriod();
    }

    public void setUploadCommitPeriod(int period) throws RepositoryException {
        this.prepareHttpRepoClient().setUploadCommitPeriod(period);
    }

    public void optimizeIndices(Boolean wait, int level) throws RepositoryException {
        this.prepareHttpRepoClient().optimizeIndices(wait, level);
    }

    public void optimizeIndices(Boolean wait) throws RepositoryException {
        this.prepareHttpRepoClient().optimizeIndices(wait);
    }

    public String getSpinFunction(String uri) throws RDF4JException {
        return this.prepareHttpRepoClient().getSpinFunction(uri);
    }

    public List<AGSpinFunction> listSpinFunctions() throws RDF4JException {
        try (TupleQueryResult list = this.prepareHttpRepoClient().listSpinFunctions();){
            ArrayList<AGSpinFunction> result = new ArrayList<AGSpinFunction>();
            while (list.hasNext()) {
                result.add(new AGSpinFunction((BindingSet)list.next()));
            }
            ArrayList<AGSpinFunction> arrayList = result;
            return arrayList;
        }
    }

    public void putSpinFunction(AGSpinFunction fn) throws RDF4JException {
        this.prepareHttpRepoClient().putSpinFunction(fn);
    }

    public void deleteSpinFunction(String uri) throws RDF4JException {
        this.prepareHttpRepoClient().deleteSpinFunction(uri);
    }

    public String getSpinMagicProperty(String uri) throws RDF4JException {
        return this.prepareHttpRepoClient().getSpinMagicProperty(uri);
    }

    public List<AGSpinMagicProperty> listSpinMagicProperties() throws RDF4JException {
        try (TupleQueryResult list = this.prepareHttpRepoClient().listSpinMagicProperties();){
            ArrayList<AGSpinMagicProperty> result = new ArrayList<AGSpinMagicProperty>();
            while (list.hasNext()) {
                result.add(new AGSpinMagicProperty((BindingSet)list.next()));
            }
            ArrayList<AGSpinMagicProperty> arrayList = result;
            return arrayList;
        }
    }

    public void deleteSpinMagicProperty(String uri) throws RDF4JException {
        this.prepareHttpRepoClient().deleteSpinMagicProperty(uri);
    }

    public void putSpinMagicProperty(AGSpinMagicProperty fn) throws RDF4JException {
        this.prepareHttpRepoClient().putSpinMagicProperty(fn);
    }

    public void deleteDuplicates(String comparisonMode) throws RepositoryException {
        this.prepareHttpRepoClient().deleteDuplicates(comparisonMode);
    }

    public RepositoryResult<Statement> getDuplicateStatements(String comparisonMode) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.prepareHttpRepoClient().getDuplicateStatements(comparisonMode, (RDFHandler)collector);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public long materialize(AGMaterializer materializer) throws RepositoryException {
        return this.prepareHttpRepoClient().materialize(materializer);
    }

    public long deleteMaterialized() throws RepositoryException {
        return this.deleteMaterialized((Resource)null);
    }

    public long deleteMaterialized(AGMaterializer materializer) throws RepositoryException {
        return this.deleteMaterialized(materializer.getInferredGraph());
    }

    public long deleteMaterialized(Resource inferredGraph) throws RepositoryException {
        return this.prepareHttpRepoClient().deleteMaterialized(inferredGraph);
    }

    public void setMasqueradeAsUser(String user) throws RepositoryException {
        this.prepareHttpRepoClient().setMasqueradeAsUser(user);
    }

    public void begin() throws RepositoryException {
        this.prepareHttpRepoClient().setAutoCommit(false);
    }

    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        return !this.prepareHttpRepoClient().isAutoCommit();
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        this.remove((Resource)null, (IRI)null, (Value)null, contexts);
    }

    public void deleteAttributeDefinition(String name) throws RepositoryException {
        this.prepareHttpRepoClient().deleteAttributeDefinition(name);
    }

    public JSONArray getAttributeDefinitions() throws RepositoryException, JSONException {
        return this.prepareHttpRepoClient().getAttributeDefinition();
    }

    public JSONArray getAttributeDefinition(String name) throws RepositoryException, JSONException {
        return this.prepareHttpRepoClient().getAttributeDefinition(name);
    }

    public String getStaticAttributeFilter() throws RepositoryException {
        return this.prepareHttpRepoClient().getStaticAttributeFilter();
    }

    public void setStaticAttributeFilter(String filter) throws RepositoryException {
        this.prepareHttpRepoClient().setStaticAttributeFilter(filter);
    }

    public void deleteStaticAttributeFilter() throws RepositoryException {
        this.prepareHttpRepoClient().deleteStaticAttributeFilter();
    }

    public boolean getNDGeospatialDatatypeAutomation() throws RepositoryException {
        return this.prepareHttpRepoClient().getNDGeospatialDatatypeAutomation();
    }

    public void enableNDGeospatialDatatypeAutomation() throws RepositoryException {
        this.prepareHttpRepoClient().enableNDGeospatialDatatypeAutomation();
    }

    public void disableNDGeospatialDatatypeAutomation() throws RepositoryException {
        this.prepareHttpRepoClient().disableNDGeospatialDatatypeAutomation();
    }

    public String getUserAttributes() {
        return this.prepareHttpRepoClient().getUserAttributes();
    }

    public void setUserAttributes(String value) {
        this.prepareHttpRepoClient().setUserAttributes(value);
    }

    public void setUserAttributes(JSONObject value) {
        this.setUserAttributes(value.toString());
    }

    public void setTransactionSettings(TransactionSettings transactionSettings) {
        this.prepareHttpRepoClient().setTransactionSettings(transactionSettings);
    }

    public Ctx transactionSettingsCtx(TransactionSettings transactionSettings) {
        TransactionSettings oldSettings = this.prepareHttpRepoClient().getTransactionSettings();
        this.setTransactionSettings(transactionSettings);
        return () -> this.setTransactionSettings(oldSettings);
    }

    public void setPool(AGConnPool pool) {
        this.pool = pool;
    }

    public void warmup() {
        this.getHttpRepoClientInternal().warmup();
    }

    public void warmup(WarmupConfig config) {
        this.getHttpRepoClientInternal().warmup(config);
    }

    public class AttributeDefinition {
        private String name;
        private List<String> allowedValues;
        private boolean ordered = false;
        private long minimum = -1L;
        private long maximum = -1L;

        public AttributeDefinition(String name) {
            this.name = name;
        }

        public AttributeDefinition allowedValues(List<String> values) {
            this.allowedValues = values;
            return this;
        }

        public AttributeDefinition allowedValue(String value) {
            if (this.allowedValues == null) {
                this.allowedValues = new ArrayList<String>(5);
                this.allowedValues.add(value);
            } else {
                this.allowedValues.add(value);
            }
            return this;
        }

        public AttributeDefinition ordered(boolean value) {
            this.ordered = value;
            return this;
        }

        public AttributeDefinition minimum(long value) throws Exception {
            if (value < 0L) {
                throw new Exception("minimum must be a non-negative integer.");
            }
            this.minimum = value;
            return this;
        }

        public AttributeDefinition maximum(long value) throws Exception {
            if (value < 0L) {
                throw new Exception("maximum must be greater than 0.");
            }
            this.maximum = value;
            return this;
        }

        public AttributeDefinition add() throws AGHttpException {
            AGRepositoryConnection.this.prepareHttpRepoClient().addAttributeDefinition(this.name, this.allowedValues, this.ordered, this.minimum, this.maximum);
            return this;
        }
    }
}

