/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class AGXid
implements Xid {
    private final int formatId;
    private final byte[] globalTransactionId;
    private final byte[] branchQualifier;

    public AGXid(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        this.formatId = formatId;
        this.globalTransactionId = Arrays.copyOf(globalTransactionId, globalTransactionId.length);
        this.branchQualifier = Arrays.copyOf(branchQualifier, branchQualifier.length);
    }

    public AGXid(Xid xid) {
        this(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public static AGXid AGXidFromString(String s) throws DecoderException {
        String[] parts = s.split(":");
        int formatId = Integer.parseInt(parts[0]);
        byte[] globalTransactionId = AGXid.decodeXidPart(parts[1]);
        byte[] branchQualifier = AGXid.decodeXidPart(parts[2]);
        return new AGXid(formatId, globalTransactionId, branchQualifier);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return Arrays.copyOf(this.globalTransactionId, this.globalTransactionId.length);
    }

    @Override
    public byte[] getBranchQualifier() {
        return Arrays.copyOf(this.branchQualifier, this.branchQualifier.length);
    }

    private static boolean isSafeASCII(byte b) {
        return b < 128 && (Character.isLetterOrDigit(b) || b == 46);
    }

    private static boolean isSafeASCII(byte[] arr) {
        if (arr.length >= 2 && arr[0] == 48 && arr[1] == 120) {
            return false;
        }
        for (byte b : arr) {
            if (AGXid.isSafeASCII(b)) continue;
            return false;
        }
        return true;
    }

    private static String byteArrayToString(byte[] array) {
        if (AGXid.isSafeASCII(array)) {
            return new String(array, StandardCharsets.US_ASCII);
        }
        return "0x" + Hex.encodeHexString((byte[])array);
    }

    private static byte[] hexStringToByteArray(String s) throws DecoderException {
        return Hex.decodeHex((char[])s.toCharArray());
    }

    private static byte[] decodeXidPart(String part) throws DecoderException {
        if (part.startsWith("0x")) {
            return AGXid.hexStringToByteArray(part.substring(2));
        }
        return part.getBytes(StandardCharsets.US_ASCII);
    }

    public String toString() {
        return Integer.toString(this.getFormatId()) + ":" + AGXid.byteArrayToString(this.getGlobalTransactionId()) + ":" + AGXid.byteArrayToString(this.getBranchQualifier());
    }
}

